\name{names.ggobi}
\alias{names.ggobi}
\title{Names of the datasets within a ggobi instance.}
\description{
 This returns the names of the datasets within 
the specified ggobi instance.
}
\usage{
names.ggobi(x)
}
\arguments{
  \item{x}{the ggobi instance whose datasets are to be queried.}
}
\details{
 The name of a dataset is dependent on the format of the file
from which it was read. In XML,
the name of the dataset can be supplied with each dataset.
In ASCII input,  the name of the dataset is the name of 
the file from which the data was read.
}
\value{
 A character vector containing the names of the datasets.
}
\references{\url{http://www.ggobi.org}}
\author{Duncan Temple Lang}


\seealso{
\code{\link{[.ggobi}}
\code{\link{getDatasetReference.ggobi}}
}

\examples{
   g <- ggobi(system.file("data", "flea.xml", package="Rggobi"), args="-noinit")
   names(g)
   g[names(g)[[1]]]
   g[[1]]
}
\concept{visualization}
\concept{interactive graphics}

\keyword{manip}
