#include "RSGGobi.h"
#include "RUtils.h"

#include <gtk/gtk.h>

#include "vars.h"

#include "R.h"

#include "display.h"
#include "parcoordsClass.h"
#include "scatterplotClass.h"


USER_OBJECT_
RS_GGOBI(createDisplay)(USER_OBJECT_ smissing, USER_OBJECT_ dataset, USER_OBJECT_  gobiId)
{
  ggobid *gg;
  datad *data = NULL;
  displayd *dpy;
  USER_OBJECT_ ans;


  data = resolveDatad(dataset, gobiId, &gg);

  dpy = gtk_type_new(GTK_TYPE_GGOBI_EMBEDDED_DISPLAY);
  display_set_values(dpy, data, gg);

  display_add(dpy, gg);

  ans = R_MakeExternalPtr(dpy, Rf_install("GtkGGobiDisplay"), NULL_USER_OBJECT);

  return(ans);
}


USER_OBJECT_
RS_GGOBI(createParcoordsPlot)(USER_OBJECT_ display, USER_OBJECT_ dims, USER_OBJECT_ ggobiId)
{
	ggobid *gg;
	displayd *dpy;
        gint w, h;
	splotd *plot;
	USER_OBJECT_ ans;
    
        w = INTEGER_DATA(dims)[0];
        h = INTEGER_DATA(dims)[1];

	dpy = GetDisplay(display, ggobiId, &gg);

	plot = gtk_parcoords_splot_new(dpy, w, h, gg);

	ans = R_MakeExternalPtr(plot, Rf_install("GtkParcoordsPlot"), NULL_USER_OBJECT);

	return(ans);
}



USER_OBJECT_
RS_GGOBI(createScatterPlot)(USER_OBJECT_ dims, USER_OBJECT_ display, USER_OBJECT_ ggobiId)
{
	ggobid *gg;
	displayd *dpy, *odpy;
	splotd *plot = NULL;
	datad *d;
	gint w, h;

	USER_OBJECT_ ans;
	gint els[] = {0,1};

	gg = GetGGobi(ggobiId);

	if(GET_LENGTH(display)) {
  	   odpy = GetDisplay(display, ggobiId, &gg);
	   d = odpy->d;
	} else
	   d = (datad *) gg->d->data;

        w = INTEGER_DATA(dims)[0];
        h = INTEGER_DATA(dims)[1];


	dpy = gtk_type_new(GTK_TYPE_GGOBI_EMBEDDED_DISPLAY);
	display_set_values(dpy, d, gg);
	display_add(dpy, gg);

	plot = gtk_type_new(GTK_TYPE_GGOBI_SCATTER_SPLOT);
	splot_init(plot, dpy, w, h, gg);

	createScatterplot(dpy, TRUE/*dpy->missing_p*/, plot, 2, els, dpy->d, gg);

/*	ans = R_MakeExternalPtr(plot, Rf_install("GtkScatterSPlot"), NULL_USER_OBJECT); */
	ans = R_MakeExternalPtr(dpy, Rf_install("GtkScatterSPlot"), NULL_USER_OBJECT);

	return(ans);
}
