/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#ifndef __CONFIGUREVISTA_H__
#define __CONFIGUREVISTA_H__

#include "configure.h"
#include "glade/glade.h"
#include "vista.h"

struct vistaconfig
{
	GtkWidget *upspin;
	GtkWidget *upcombo;
	GtkWidget *upentry;
	GtkWidget *uplist;
	GtkWidget *flipbutton;
	GtkWidget *zoomspin;
	GtkWidget *centerraentry;
	GtkWidget *centerdecentry;

	struct vista *oldview, *curview;
};

struct vistaconfig *newvistaconfig(GladeXML *configxml);
void deletevistaconfig(struct vistaconfig *vc);
void vistaconfigupdate(struct vistaconfig *vc);
void vistaconfigsetup(struct configurator *cfg);
void vistaconfigtry(struct configurator *cfg);
void vistaconfigrevert(struct configurator *cfg);
void vistaconfigrefresh(struct configurator *cfg);

#endif
