/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#ifndef __COORDSYS_H__
#define __COORDSYS_H__

#include <gtk/gtk.h>
#include "viewer.h"

#define EQUATORIALCOORDS	"Equatorial"
#define GALACTICCOORDS		"Galactic"
#define ECLIPTICCOORDS		"Ecliptic"

/* Not MT safe */
struct coordsys
{
	/* Basis vectors for coordinate system, in equatorial basis */
	double basisx[3];
	double basisy[3];
	double basisz[3];
	void (*calcbasis)(struct viewer *v);	// if coordinates are dynamic, call this
						// if not, this is null

	double unit1perradian;	// ie 12.0/PI for RA
	double uint2perradian;	// ie 180.0/PI for Dec

	gchar *name;		// ie "Equatorial"
	gchar *axis1name;	// ie "RA" or "Galactic longitude"
	gchar *axis2name;	// ie dec
	gchar *axis1units;	// ie "hours"
	gchar *axis2units;	// ie "degrees"
	gchar *npolename;	// ie "North Pole" or "North galactic pole"
	gchar *spolename;	// ie "South Pole"
	gchar *npolelabel;	// ie "N.P." or "N.G.P."
	gchar *spolelabel;
};

/* Settings for implementations of given coord systems. */
struct coordprops
{
	const struct coordsys *coords;
	
	struct viewer *v;
	gint gridvis, equvis, polesvis;
	gint gridlabelmode, equlabelmode, poleslabelmode;
	gchar gridrgb[3], equrgb[3], polesrgb[3];
	gint griddensitymode, equdensitymode;
	float griddegrees, equdegrees;
	gint gridnumber, equnumber;
};

void addcoordinatesystem(struct coordsys *cs);
void initcoordinates();
struct coordsys *getcoordsys(const gchar *name);
gint coordcombofill(GtkWidget *combo);

struct coordprops *newcoordprops(struct coordsys *cs);
GList *newcoordpropslist();
void deletecoordprops(struct coordprops *cp);
struct coordprops *copycoordprops(struct coordprops *cp);
void getcoordprops(struct coordprops *cpa, struct viewer *v);
void setcoordprops(struct viewer *v, struct coordprops *cpa);

void coordrenderpixmap(struct coordprops *cp, struct viewer *v);

#endif
