/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#include "print.h"

void printpshead(FILE *out)
{
	int i, j;

	double lut[] = {7.1, 6.6, 6.1, 5.6, 5.2, 4.8, 4.3, 3.9, 3.5, 3.1, 
		2.8, 2.5, 2.2, 2.0, 1.8, 1.6, 1.4, 1.2, 1.1, 1.0, 0.9,
		0.8, 0.7, 0.6, 0.5, 0.4};
	fprintf(out, "%%!PS-Adobe-2.0\n");
	fprintf(out, "%%%%Page: 1 1\n");
	for(j = 0; j < 9; j++) for(i = 0; i < 22; i++)
		fprintf(out, "/t64i%d { %3.1f 0 360 arc fill } def\n",
			j + 9*i, lut[i]);
	for(j = 0; j < 9; j++) for(i = 0; i < 4; i++)
		fprintf(out, "/t1i%d { %3.1f 0 360 arc fill } def\n",
			j + 9*i, lut[i+22]);
	for(j = 0; j < 9; j++) for(i = 4; i < 20; i++)
		fprintf(out, "/t1i%d { 0.3 0 360 arc fill } def\n",
			j + 9*i);
	fprintf(out, "/l192i0 { 0.5 setlinewidth } def\n");
	fprintf(out, "/l192i1 { 0.5 setlinewidth } def\n");
	fprintf(out, "/l193i0 { 0.5 setlinewidth } def\n");
	fprintf(out, "/l193i1 { 0.3 setlinewidth } def\n");
	fprintf(out, "/l194i0 { 0.5 setlinewidth } def\n");
	fprintf(out, "/l194i1 { 0.3 setlinewidth } def\n");
	fprintf(out, "/l195i0 { 0.5 setlinewidth } def\n");
	fprintf(out, "/l195i1 { 0.3 setlinewidth } def\n");
	fprintf(out, "1 setlinecap\n");
}

void printinit(FILE *out)
{
	fprintf(out, "0.5 setlinewidth 0 setgray\n");
}

void printpstail(FILE *out)
{
	fprintf(out, "showpage\n");
	fprintf(out, "%%%%Trailer\n");
}

void printview(GList *catalogs, struct viewer *v, 
	const char *filename)
{
	GList *l;
	double scale = 0.0;
	FILE *out;

	out = fopen(filename, "w");

	printpshead(out);

	for(l = catalogs; l != 0; l = l->next) if(l->data != 0)
	{
		printinit(out);
		render_ps((struct catalog *)(l->data), v, out, &scale);
	}	

	printpstail(out);

	fclose(out);
}


