/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#include <stdio.h>
#include <glib.h>
#include "vista.h"
#include "coordutils.h"

GList *vistareflist = 0;	/* list of up reference locations */

struct vista *newvista()
{
	struct vista *v;

	v = g_new(struct vista, 1);
	v->ra_center = PI/2.0;
	v->dec_center = PI/4.0;
	v->zoom = 2.0;
	v->uprotation = 0.0;
	v->uprefid = 0;
	v->fliplr = 0;

	return v;
}

void deletevista(struct vista *v)
{
	g_free(v);
}

struct vista *copyvista(const struct vista *view)
{
	struct vista *v;

	v = g_new(struct vista, 1);
	v->ra_center = view->ra_center;
	v->dec_center = view->dec_center;
	v->zoom = view->zoom;
	v->uprotation = view->uprotation;
	v->uprefid = view->uprefid;
	v->fliplr = view->fliplr;

	return v;
}


struct vistaref *newvistaref(const gchar *name,
	double x, double y, double z)
{
	struct vistaref *vr;

	vr = g_new(struct vistaref, 1);
	vr->name = g_strdup(name);
	vr->x[0] = x;
	vr->x[1] = y;
	vr->x[2] = z;

	return vr;
}

void deletevistaref(struct vistaref *vr)
{
	if(!vr)
	{
		fprintf(stderr, "Warning -- deleting null vistaref\n");
		return;
	}
	if(vr->name) g_free(vr->name);
	else fprintf(stderr, "Warning -- vista with null name\n");
	g_free(vr);
}

void addtovistareflist(const gchar *name, double x, double y, double z)
{
	vistareflist = g_list_append(vistareflist, 
		newvistaref(name, x, y, z));
}

gint getvistarefid(const gchar *name)
{
	GList *vrl;
	struct vistaref *vr;
	int i=0;

	for(vrl = vistareflist; vrl != 0; vrl = vrl->next)
	{
		vr = (struct vistaref *)(vrl->data);
		if(!vr) break;
		if(strcmp(vr->name, name) == 0) return i;
		i++;
	}
	fprintf(stderr, "Warning -- vistaref not found in list.\n");
	return -1;
}

double *getvistarefcoords(gint vistarefid)
{
	GList *vrl;
	struct vistaref *vr;
	int i=0;

	for(vrl = vistareflist; vrl != 0; vrl = vrl->next)
	{
		vr = (struct vistaref *)(vrl->data);
		if(!vr) break;
		if(i == vistarefid) return vr->x;
		i++;
	}
	fprintf(stderr, "Warning -- vistarefid out of range.\n");
	return 0;
}

const gchar *getvistarefname(gint vistarefid)
{
	GList *vrl;
	struct vistaref *vr;
	int i=0;

	for(vrl = vistareflist; vrl != 0; vrl = vrl->next)
	{
		vr = (struct vistaref *)(vrl->data);
		if(!vr) break;
		if(i == vistarefid) return vr->name;
		i++;
	}
	fprintf(stderr, "Warning -- vistarefid out of range.\n");
	return 0;
}

void initvistarefs()
{
	addtovistareflist("North Pole", 0.000000, 0.000000, 1.000000);
	addtovistareflist("South Pole", 0.000000, 0.000000,-1.000000);
	addtovistareflist("North Galactic Pole",-0.867666, 0.198076, 0.455984);
	addtovistareflist("South Galactic Pole", 0.867666,-0.198076,-0.455984);
	addtovistareflist("North Ecliptic Pole", 0.000000, 0.397777, 0.917482);
	addtovistareflist("South Ecliptic Pole", 0.000000,-0.397777,-0.917482);
	addtovistareflist("Zenith", 10.0, 10.0, 10.0);
	addtovistareflist("Nadir", 10.0, 10.0, 10.0);
}
