#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "../src/object.h"

#define PI 3.14159265358979

int numrl=0, numdl=0;

struct raline
{
	double ra, dec, ra0;
} ralines[3000];

struct decline
{
	double ra, dec, dec0;
} declines[3000];

int checkraline(double ra, double dec, double ra0)
{
	int i;
	int same;

	if(numrl > 0) for(i = 0; i < numrl; i++)
	{
		same = 0;
		if(dec == ralines[i].dec) same++;
		if((ra == ralines[i].ra && ra0 == ralines[i].ra0) ||
		   (ra0 == ralines[i].ra && ra == ralines[i].ra0)) same++;
		if(same == 2) return 0;
	}
	

	ralines[numrl].ra = ra;
	ralines[numrl].dec = dec;
	ralines[numrl].ra0 = ra0;
	numrl++;
	return 1;
}

int checkdecline(double ra, double dec, double dec0)
{
	int i;
	int same;

	if(numdl > 0) for(i = 0; i < numdl; i++)
	{
		same = 0;
		if(ra == declines[i].ra) same++;
		if((dec == declines[i].dec && dec0 == declines[i].dec0) ||
		   (dec0 == declines[i].dec && dec == declines[i].dec0)) same++;
		if(same == 2) return 0;
	}
	

	declines[numdl].ra = ra;
	declines[numdl].dec = dec;
	declines[numdl].dec0 = dec0;
	numdl++;
	return 1;
}

int drawobject(double ra, double dec, int icon, FILE *out)
{
	double x, y, z;
	static struct object obj;
	static int lasticon = 0;
	int w=0;

	if(lasticon == 255 && icon != 255) 
	{
		fwrite(&obj, 1, sizeof(obj), out);
		w++;
	}

	ra = -ra;
	x = cos(ra)*cos(dec);
	y = sin(ra)*cos(dec);
	z = sin(dec);

	obj.x = (long)(x*(double)(1<<30));
	obj.y = (long)(y*(double)(1<<30));
	obj.z = (long)(z*(double)(1<<30));
	obj.type = 192;
	obj.icon = icon;
	obj.mask = 0x0F;
	obj.mag  = 0;

	lasticon = icon;
	if(icon != 255) 
	{
		fwrite(&obj, 1, sizeof(obj), out);
		w++;
	}

	return w;
}

int startline(double ra, double dec, FILE *out)
{
	return drawobject(ra, dec ,255, out);
}

int drawlongitude(double ra, double dec, double dec0, FILE *out)
{
	int segs, i;
	int w = 0;
	double delta;	

	if(checkdecline(ra, dec, dec0) == 0)
		return startline(ra, dec, out);

	segs = (int)(fabs(dec-dec0)*36.0/PI + 0.5);
	if(segs < 1) segs = 1;
	delta = (dec - dec0)/(double)segs;

	for(i = 1; i <= segs; i++) 
		w+=drawobject(ra, dec0+delta*(double)i, 1, out);

	return w;	
}

int drawlatitude(double ra, double dec, double ra0, FILE *out)
{
	int segs, i;
	int w = 0;
	double delta, dra;	

	if(checkraline(ra, dec, ra0) == 0)
		return startline(ra, dec, out);

	if(ra-ra0 > PI) ra -= 2.0*PI;
	if(ra-ra0 < -PI) ra += 2.0*PI;

	dra = ra-ra0;
	segs = (int)(fabs(dra)*36.0/PI + 0.5);
	if(segs < 1) segs = 1;
	delta = (dra)/(double)segs;

	for(i = 1; i <= segs; i++) 
		w+=drawobject(ra0+delta*(double)i, dec, 1, out);

	return w;	
}

int main()
{
	FILE *in, *out;
	char line[1000];
	int n=0;
	char constel[100] = "", last[100] = "";

        double ra, dec, rah, decd;
	double ra0=-1, dec0=-1;


	in=fopen("../raw/constell.1875.data", "r");
	if(in == 0) 
	{
		printf("File not found\n");
		return 0;
	}
	out=fopen("borders.cat", "w");
	for(;;)
	{
		fgets(line, 999, in);
		if(feof(in)) break;

		line[8] = 0;  rah = atof(line);
		line[18] = 0;  decd = atof(line+10);
		if(line[9] == '-') decd = -decd;
		line[23] = 0;  strcpy(constel, line+19);

		ra = rah*PI/12.0;
		dec = decd*PI/180.0;

		if(strcmp(constel, last) != 0) n+=startline(ra, dec, out);
		else if(ra == ra0) n+=drawlongitude(ra, dec, dec0, out);
		else n+=drawlatitude(ra, dec, ra0, out);

		ra0 = ra;
		dec0 = dec;
		strcpy(last, constel);
	}

	fclose(in);
	fclose(out);
	printf("%d objects produced\n", n);

	return 0;
}
