#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "../src/object.h"

#define PI 3.14159265358979

struct bonus
{
	float maj, min, pa;
};

int main()
{
	FILE *in, *out;
	char line[4000];
	int n, magi;
	double ma, ratio, pa;
	double x, y, z;
	struct object obj;

	int rah, ram, decd, decm, decs;
        double ras, mag, ra, dec; 

	struct bonus b[30000];

	in=fopen("../raw/rc3.dat", "r");
	out=fopen("rc3_galaxy.cat", "w");
	for(n=0;;n++)
	{
		fgets(line, 999, in);
		if(feof(in)) break;

		line[16] = 0; decs = atoi(line+14);
		line[14] = 0; decm = atoi(line+12);
		line[12] = 0; decd = atoi(line+10);

                dec = fabs(decd) + (double)decm/60.0 + (double)decs/3600.0;
		if(line[9] == '-') dec = -dec;

		line[8] = 0; ras = atof(line+4);
		line[4] = 0; ram = atoi(line+2);
		line[2] = 0;  rah = atoi(line);

		ra  = (double)rah + (double)ram/60.0 + (double)ras/3600.0;

		line[155] = 0; ma = atof(line+151);
		line[165] = 0; ratio = atof(line+161);
		line[188] = 0; pa = atoi(line+185);

		if(ma == 0.0 && ratio == 0.0 && pa == 0)
		{
			b[n].maj = b[n].min = 0.0;
			b[n].pa = 0.0;
		}
		else
		{
			b[n].maj = pow(10.0, ma-1.0);
			b[n].min = b[n].maj*pow(10.0, -ratio);
			b[n].pa  = pa*PI/180.0;
		}

		line[205] = 0; mag = atof(line+200);
		if(mag == 0.0) mag = 23.5;
		obj.mag = (int)((mag+2.0)*10.0);

		ra = -ra*PI/12.0;
		dec = dec*PI/180.0;

		x = cos(ra)*cos(dec);
		y = sin(ra)*cos(dec);
		z = sin(dec);

		magi = (mag+2.0)*10.0;

		obj.x = (long)(x*(double)(1<<30));
                obj.y = (long)(y*(double)(1<<30));
                obj.z = (long)(z*(double)(1<<30));
		obj.type=226;
                obj.icon = 0;
		if(ra == 0.0 && dec == 0.0) obj.mask = 0x8F;
                else obj.mask = 0x0F;

		fwrite(&obj, 1, sizeof(obj), out);
	}

	fclose(in);

	fwrite(b, n, sizeof(struct bonus), out);
	fclose(out);
	printf("%d galaxies loaded\n", n);

	return 0;
}
