/*
   Copyright (C) 2000, 2001 SMARTDATA, http://www.smartdata.ch/

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/*

    PicoGUI Port. See http://pgui.sourceforge.net/ for more informations

*/

#include <stdlib.h>
#include <stdio.h>
#include <picogui.h>

enum ui_EventType {
  penUpEvent,
  penDownEvent,
  penMoveEvent,
  keyDownEvent,
  keyUpEvent,
  quitEvent,
  timerEvent
};

struct ui_Event {
  enum ui_EventType type;
  long x, y;
  guint code;
};


int handleMainWinEvent(struct ui_Event *event);
void drawMainWin();

void *hwr_init();

/*****************************************************************************/

#define HWR_BPP     32

#define HWR_WIDTH   160
#define HWR_HEIGHT  160

#define TITLE       "Waba"

/* Modifier keys */
#define MOD_LSHIFT  0x0001
#define MOD_RSHIFT  0x0002
#define MOD_SHIFT   0x0003
#define MOD_LCTRL   0x0040
#define MOD_RCTRL   0x0080
#define MOD_CTRL    0x00C0
#define MOD_LALT    0x0100
#define MOD_RALT    0x0200
#define MOD_ALT     0x0300
#define MOD_LMETA   0x0400
#define MOD_RMETA   0x0800
#define MOD_META    0x0C00
#define MOD_NUM     0x1000
#define MOD_CAPS    0x2000
#define MOD_MODE    0x4000


typedef uint32 devcolort;
typedef uint32 * devbmpt;

#define mkcolor(r,g,b) ((devcolort) (((r)<<16) | ((g)<<8) | (b)))
#define mkgray(v,m) mkcolor(v*255/m,v*255/m,v*255/m)

/*****************************************************************************/

typedef struct {
  unsigned char type;   /* Basic type of error */
  const char *msg;   /* Static error message detailing the situation */
} g_error;

/* Error types */
#define ERRT_NONE     0
#define ERRT_MEMORY   1
#define ERRT_IO       2
#define ERRT_NETWORK  3
#define ERRT_BADPARAM 4
#define ERRT_HANDLE   5
#define ERRT_INTERNAL 6
#define ERRT_BUSY     7

#define ERRT_NOREPLY  100    /* This special error type sends
				no reply packet- assumes that
				no reply is needed or that one
				will be sent seperately */

extern g_error sucess;

/****************************************************************************
                                   FONT RELATED
****************************************************************************/

#define ui_FontType pghandle

/****************************************************************************
                                   GRAPHICS RELATED
****************************************************************************/

#define ui_MainWindowType pghandle
#define ui_PixmapType pghandle
#define ui_GraphicsContextType pgcontext
typedef struct {
  gint32 x;
  gint32 y;
  gint32 width;
  gint32 height;
} ui_Rectangle;

/* as PicoGUI put text too high with PG_FSTYLE_FLUSH */
#define Y_OFFSET_DRAW_TEXT 2

/*****************************************************************************/

/*
   Local Variables:
   c-file-style: "smartdata"
   End:
*/
