/* ------------------------------------------------------------------------
 * $Id: InterTraxDevice.hh,v 1.3 2001/07/18 13:52:55 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-06-21 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _InterTraxDevice_hh_
#define _InterTraxDevice_hh_

// -- 3Dwm Includes
#include "Polhem/InputDevice.hh"

// -- Class Declarations

/**
 * Intersense InterTrax2 head tracker input device. Requires the use
 * of the itrax Linux kernel module that currently can be found at the
 * following adress:
 *
 * http://www.mip.informatik.uni-kiel.de/~evers/
 **/
class InterTraxDevice : public InputDevice {
public:
    
    /**
     * Constructor.
     *
     * @param eventQueue pointer to the event queue to use.
     **/
    InterTraxDevice(InputEventQueue *eventQueue);

    /**
     * Destructor.
     **/
    virtual ~InterTraxDevice();

    /**
     * Retrieve the device name.
     *
     * @return device name string.
     **/
    virtual std::string getDeviceName() const {
	return _name; 
    }

    /**
     * Handle input event processing. This loop is executed by the
     * thread responsible for the input device.
     **/
    void run();

private:
    int _tracker;
    std::string _name;
};

#endif /* InterTraxDevice.hh */
