/* ------------------------------------------------------------------------
 * $Id: PrimitiveImpl.hh,v 1.1 2001/08/01 15:08:59 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-07-31 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _PrimitiveImpl_hh_
#define _PrimitiveImpl_hh_

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Nobel/Types.hh"
#include "Nobel/Primitive.hh"

// -- Class Declarations

class PrimitiveImpl : public virtual POA_Nobel::Primitive,
		      public virtual PortableServer::RefCountServantBase {
public:
    
    /**
     * Constructor.
     *
     * @param mesh triangle mesh to use for representing the primitive.
     **/
    PrimitiveImpl(Nobel::TriangleMesh *mesh);
    
    /**
     * Destructor.
     **/
    virtual ~PrimitiveImpl();

    // IDL functions
    virtual Nobel::TriangleMesh *getMesh();
    
private:
    Mutex _mutex;
    Nobel::TriangleMesh *_mesh;
};
#endif /* PrimitiveImpl.hh */
