/**********************************************************************
 * aggregate.c                                               March 2001
 * Horms                                             horms@vergenet.net
 *
 * aggregate
 * CIDR network aggregation and filtering
 * Copyright (C) 2001  Horms
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 *
 **********************************************************************/


#include "cidr_net_list.h"
#include "log.h"
#include "options.h"
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

vanessa_logger_t *aggregate_vl;

int main(int argc, char **argv){
  ip_address_t ip1_dec;
  ip_address_t ip2_dec;
  prefix_t prefix_dec;
  char* ip1;
  char* ip2;
  cidr_net_list_t *net_list;
  int status;
  char *format;
  FILE *fh=stdin;

  extern int errno;
  extern options_t opt;

  if((aggregate_vl=vanessa_logger_openlog_filehandle(
    stderr, 
    "vanessa_logger_sample", 
    LOG_DEBUG,
    0
   ))==NULL){
    fprintf(stderr, "main: vanessa_logger_openlog_filehandle\n");
    exit(-1);
  }

  options(argc, argv);

  cidr_generate_pow_2_lookup();
  net_list=NULL;

  if((ip1=(char *)malloc(sizeof(char)*IP_STRING_LENGTH))==NULL){
    AGGREGATE_DEBUG_ERRNO("main: malloc: ip1", errno);
    return(-1);
  }
  if((ip2=(char *)malloc(sizeof(char)*IP_STRING_LENGTH))==NULL){
    AGGREGATE_DEBUG_ERRNO("main: malloc: ip2", errno);
    return(-1);
  }
  if((net_list=cidr_net_list_create(16))==NULL){
    AGGREGATE_DEBUG_ERRNO("main: new_cidr_net_list", errno);
    return(-1);
  }

  fscanf(fh, " ");
  if(opt.input_format==CIDR_ADDRESS_RANGE){
    format="%15[0-9.] - %15[0-9.] ";
    while((status=fscanf(fh, format, ip1, ip2))>0){
      if(status!=2){
        continue;
      }
      if(
        ip_address_dotted_quad_to_decimal(ip1, &ip1_dec) || 
        ip_address_dotted_quad_to_decimal(ip2, &ip2_dec)
      ){
        continue;
      }
      net_list=cidr_net_list_insert_range(ip1_dec, ip2_dec, net_list);
    }
  }
  if(opt.input_format==CIDR_NET_NETMASK){
    format="%15[0-9.]/%15[0-9.] ";
    while((status=fscanf(fh, format, ip1, ip2))>0){
      if(status<1 || status>2){
        continue;
      }
      if(ip_address_dotted_quad_to_decimal(ip1, &ip1_dec)){
        continue;
      }
      if(status==1){
        status=fscanf(fh, " ");
        prefix_dec=cidr_classful_prefix(ip1_dec);
        net_list=cidr_net_list_insert_raw(net_list, ip1_dec, prefix_dec);
      }
      else {
        if(ip_address_dotted_quad_to_decimal(ip2, &ip2_dec)){
          continue;
        }
        ip2_dec=ip1_dec+(~ip2_dec);
        net_list=cidr_net_list_insert_range(ip1_dec, ip2_dec, net_list);
      }
    }
  }
  else{
    format="%15[0-9.]/%2[0-9] ";
    while((status=fscanf(fh, format, ip1, ip2))>0){
      if(status<1 || status >2){
        continue;
      }
      if(ip_address_dotted_quad_to_decimal(ip1, &ip1_dec)){
        continue;
      }
      if(status==1){
        status=fscanf(fh, " ");
        prefix_dec=cidr_classful_prefix(ip1_dec);
      }
      else if(prefix_a_to_decimal(ip2, &prefix_dec)){
	continue;
      }
      net_list=cidr_net_list_insert_raw(net_list, ip1_dec, prefix_dec);
    }
  }

  cidr_net_list_assimilate(net_list);
  cidr_net_list_aggregate(net_list);
  cidr_net_list_display(
    net_list, 
    opt.minimum_prefix,  
    opt.maximum_prefix, 
    opt.output_format
  );

  vanessa_logger_closelog(aggregate_vl);

  return(0);
}
