# C.7 What causes the capitalist business cycle?

The business cycle is the term used to describe the boom and slump nature of
capitalism. Sometimes there is full employment, with workplaces producing more
and more goods and services, the economy grows and along with it wages.
However, as Proudhon argued, this happy situation does not last:

> _ "But industry, under the influence of property, does not proceed with such
regularity. . . As soon as a demand begins to be felt, the factories fill up,
and everybody goes to work. Then business is lively. . . Under the rule of
property, the flowers of industry are woven into none but funeral wreaths. The
labourer digs his own grave. . . [the capitalist] tries. . . to continue
production by lessening expenses. Then comes the lowering of wages; the
introduction of machinery; the employment of women and children . . . the
decreased cost creates a larger market. . . [but] the productive power tends
to more than ever outstrip consumption. . . To-day the factory is closed.
Tomorrow the people starve in the streets. . . In consequence of the cessation
of business and the extreme cheapness of merchandise. . . frightened creditors
hasten to withdraw their funds [and] Production is suspended, and labour comes
to a standstill."_ [**What is Property**, pp. 191-192]

Why does this happen? For anarchists, as Proudhon noted, it's to do with the
nature of capitalist production and the social relationships it creates (_"the
rule of property"_). The key to understanding the business cycle is to
understand that, to use Proudhon's words, _"Property sells products to the
labourer for more than it pays him for them; therefore it is impossible."_
[**Op. Cit.**, p. 194] In other words, the need for the capitalist to make a
profit from the workers they employ is the underlying cause of the business
cycle. If the capitalist class cannot make enough surplus value (profit,
interest, rent) then it will stop production, sack people, ruin lives and
communities until such time as enough can once again be extracted from working
class people. As Proudhon put it (using the term _"interest"_ to cover all
forms of surplus value):

> _ "The primary cause of commercial and industrial stagnations is, then,
interest on capital, -- that interest which the ancients with one accord
branded with the name of usury, whenever it was paid for the use of money, but
which they did not dare to condemn in the forms of house-rent, farm-rent, or
profit: as if the nature of the thing lent could ever warrant a charge for the
lending; that is, robbery."_ [**Op. Cit.**, p. 193]

So what influences the level of surplus value? There are two main classes of
pressure on surplus value production, what we will call the _**"subjective"**_
and _**"objective"**_ (we will use the term profits to cover surplus value
from now on as this is less cumbersome and other forms of surplus value depend
on the amount extracted from workers on the shopfloor). The "subjective"
pressures are to do with the nature of the social relationships created by
capitalism, the relations of domination and subjection which are the root of
exploitation and the resistance to them. In other words the subjective
pressures are the result of the fact that _"property is despotism"_ (to use
Proudhon's expression) and are a product of the class struggle. This will be
discussed in [section C.7.1](secC7.html#secc71). The objective pressures are
related to how capitalism works and fall into two processes. The first is the
way in which markets do not provide enough information to producers avoid
disproportionalities within the market. In other words, that the market
regularly produces situations where there is too much produced for specific
markets leading to slumps The second objective factor is related to the
process by which _"productive power tends more and more to outstrip
consumption"_ (to use Proudhon's words), i.e. over-investment or over-
accumulation. These are discussed in sections [C.7.2](secC7.html#secc72) and
[C.7.3](secC7.html#secc73), respectively.

Before continuing, we would like to stress here that all three factors operate
together in a real economy and we have divided them purely to help explain the
issues involved in each one. The class struggle, market "communication"
creating disproportionalities and over-investment all interact. Due to the
needs of the internal (class struggle) and external (inter-company)
competition, capitalists have to invest in new means of production. As
workers' power increases during a boom, capitalists innovate and invest in
order to try and counter it. Similarly, to get market advantage (and so
increased profits) over their competitors, a company invests in new machinery.
While this helps increase profits for individual companies in the short term,
it leads to collective over-investment and falling profits in the long term.
Moreover, due to lack of effective communication within the market caused by
the price mechanism firms rush to produce more goods and services in specific
boom markets, so leading to over-production and the resulting gluts result in
slumps. This process is accelerated by the incomplete information provided by
the interest rate, which results in investment becoming concentrated in
certain parts of the economy. Relative over-investment can occur, increasing
and compounding any existing tendencies for over-production and so creating
the possibility of crisis. In addition, the boom encourages new companies and
foreign competitors to try and get market share, so decreasing the _"degree of
monopoly"_ in an industry, and so reducing the mark-up and profits of big
business (which, in turn, can cause an increase in mergers and take-overs
towards the end of the boom).

Meanwhile, as unemployment falls workers' power, confidence and willingness to
stand up for their rights increases, causing profit margins to be eroded at
the point of production. This has the impact of reducing tendencies to over-
invest as workers resist the introduction of new technology and techniques.
The higher wages also maintain and even increase demand for the finished goods
and services produced, allowing firms to realise the potential profits their
workers have created. Rising wages, therefore, harms the potential for
**producing** profits by increasing costs yet it increases the possibility for
**realising** profits on the market as firms cannot make profits if there is
no demand for their goods and their inventories of unsold goods pile up. In
other words, wages are costs for any specific firm but the wages other
companies pay are a key factor in the demand for what it produces. This
contradictory effect of class struggle matches the contradictory effect of
investment. Just as investment causes crisis because it is useful, the class
struggle both hinders over-accumulation of capital and maintains aggregate
demand (so postponing the crisis) while at the same time eroding capitalist
power and so profit margins at the point of production (so accelerating it).

And we should note that these factors work in reverse during a slump, creating
the potential for a new boom. In terms of workers, rising unemployment empower
the capitalists who take advantage of the weakened position of their employees
to drive through wage cuts or increase productivity in order to improve the
profitability of their companies (i.e. increase surplus value). Labour will,
usually, accept the increased rate of exploitation this implies to remain in
work. This results in wages falling and so, potentially, allows profit margins
to rise. However, wage cuts result in falling demand for goods and services
and so, overall, the net effect of cutting wages may be an overall **drop** in
demand which would make the slump worse. There is a contradictory aspect to
the objective pressures as well during a slump. The price mechanism hinders
the spread of knowledge required for production and investment decisions to be
made. While collectively it makes sense for firms to start producing and
investing more, individual firms are isolated from each other. Their
expectations are negative, they expect the slump to continue and so will be
unwilling to start investing again. In the slump, many firms go out of
business so reducing the amount of fixed capital in the economy and so over-
investment is reduced. As overall investment falls, so the average rate of
profit in the economy can increase. Yet falling investment means that firms in
that sector of the economy will face stagnant demand and in the face of an
uncertain future will be a drag on other sectors. In addition, as firms go
under the _"degree of monopoly"_ of each industry increases which increases
the mark-up and profits of big business yet the overall market situation is
such that their goods cannot be sold.

Eventually, however, the slump will end (few anarchists accept the notion that
capitalism will self-destruct due to internal economic processes). The
increased surplus value production made possible by high unemployment is
enough relative to the (reduced) fixed capital stock to increase the rate of
profit. This encourages capitalists to start investing again and a boom begins
(a boom which contains the seeds of its own end). How long this process takes
cannot be predicted in advance (which is why Keynes stressed that in the long
run we are all dead). It depends on objective circumstances, how excessive the
preceding boom was, government policy and how willing working class people are
to pay the costs for the capitalist crisis.

Thus subjective and objective factors interact and counteract with each other,
but in the end a crisis will result simply because the system is based upon
wage labour and the producers are not producing for themselves. Ultimately, a
crisis is caused because capitalism is production for profit and when the
capitalist class does not (collectively) get a sufficient rate of profit for
whatever reason then a slump is the result. If workers produced for
themselves, this decisive factor would not be an issue as no capitalist class
would exist. Until that happens the business cycle will continue, driven by
"subjective" and "objective" pressures -- pressures that are related directly
to the nature of capitalist production and the wage labour on which it is
based. Which pressure will predominate in any given period will be dependent
on the relative power of classes. One way to look at it is that slumps can be
caused when working class people are "too strong" or "too weak." The former
means that we are able to reduce the rate of exploitation, squeezing the
profit rate by keeping an increased share of the surplus value we produce. The
later means we are too weak to stop income distribution being shifted in
favour of the capitalist class, which results in over-accumulation and
rendering the economy prone to a failure in aggregate demand. The 1960s and
1970s are the classic example of what happens when "subjective" pressures
predominate while the 1920s and 1930s show the "objective" ones at work.

Finally, it must be stressed that this analysis does **not** imply that
anarchists think that capitalism will self-destruct. In spite of crises being
inevitable and occurring frequently, revolution is not. Capitalism will only
be eliminated by working class revolution, when people see the need for social
transformation and not imposed on people as the by-product of an economic
collapse.

## C.7.1 What role does class struggle play in the business cycle?

At its most basic, the class struggle (the resistance to hierarchy in all its
forms) is the main cause of the business cycle. As we argued in sections
[B.1.2](secB1.html#secb12) and [C.2](secC2.html), capitalists in order to
exploit a worker must first oppress them. But where there is oppression, there
is resistance; where there is authority, there is the will to freedom. Hence
capitalism is marked by a continuous struggle between worker and boss at the
point of production as well as struggle outside of the workplace against other
forms of hierarchy.

This class struggle reflects a conflict between workers attempts at liberation
and self-empowerment and capital's attempts to turn the individual worker into
a small cog in a big machine. It reflects the attempts of the oppressed to try
to live a fully human life, when the _"worker claims his share in the riches
he produces; he claims his share in the management of production; and he
claims not only some additional well-being, but also his full rights in the
higher enjoyment of science and art."_ [Peter Kropotkin, **Anarchism**, pp.
48-49] As Errico Malatesta argued:

> _ "If [workers] succeed in getting what they demand, they will be better
off: they will earn more, work fewer hours and will have more time and energy
to reflect on things that matter to them, and will immediately make greater
demands and have greater needs . . . [T]here exists no natural law (law of
wages) which determines what part of a worker's labour should go to him [or
her] . . . Wages, hours and other conditions of employment are the result of
the struggle between bosses and workers. The former try and give the workers
as little as possible; the latter try, or should try to work as little, and
earn as much, as possible. Where workers accept any conditions, or even being
discontented, do not know how to put up effective resistance to the bosses
demands, they are soon reduced to bestial conditions of life. Where, instead,
they have ideas of how human beings should live and know how to join forces,
and through refusal to work or the latent and open threat of rebellion, to win
bosses respect, in such cases, they are treated in a relatively decent way . .
. Through struggle, by resistance against the bosses, therefore, workers can,
up to a certain point, prevent a worsening of their conditions as well as
obtaining real improvement."_ [**Errico Malatesta: His Life and Ideas**, pp.
191-2]

It is this struggle that determines wages and indirect income such as welfare,
education grants and so forth. This struggle also influences the concentration
of capital, as capital attempts to use technology to get an advantage against
their competitors by driving down prices by increasing the productivity of
labour (i.e., to extract the maximum surplus value possible from employees).
And, as will be discussed in [section D.10](secD10.html), increased capital
investment also reflects an attempt to increase the control of the worker by
capital (or to replace them with machinery that cannot say "no") **plus** the
transformation of the individual into "the mass worker" who can be fired and
replaced with little or no hassle. For example, Proudhon quotes an _"English
Manufacturer"_ who states that he invested in machinery precisely to replace
humans by machines because machines are easier to control:

> _ "The insubordination of our workforce has given us the idea of dispensing
with them. We have made and stimulated every imaginable effort of the mind to
replace the service of men by tools more docile, and we have achieved our
object. Machinery has delivered capital from the oppression of labour."_
[quoted by Proudhon, **System of Economical Contradictions**, p. 189]

(To which Proudhon replied _"[w]hat a misfortunate that machinery cannot also
deliver capital from the oppression of consumers!"_ The over-production and
reductions in demand caused by machinery replacing people soon destroys these
illusions of automatic production by a slump -- see [section
C.7.3](secC7.html#secc73)).

Therefore, class struggle influences both wages and capital investment, and so
the prices of commodities in the market. It also, more importantly, determines
profit levels and it is the rise and fall of profit levels that are the
ultimate cause of the business cycle. This is because, under capitalism,
production's _"only aim is to increase the profits of the capitalist. And we
have, therefore, -- the continuous fluctuations of industry, the crisis coming
periodically."_ [Kropotkin, **Op. Cit.**, p. 55]

A common capitalist myth, derived from neo-classical (and related) ideology,
is that free-market capitalism will result in a continuous boom. Since the
cause of slumps is allegedly state interference in the market (particularly in
credit and money), eliminating such meddling will obviously bring reality into
line with the textbooks and, consequently, eliminate such negative features of
"actually existing" capitalism as the business cycle. Let us assume, for a
moment, that this is the case (as will be discussed in [section
C.8](secC8.html), this is **not** the case). In the "boom economy" of
capitalist dreams there will be full employment yet while this helps
_"increase total demand, its fatal characteristic from the business view is
that it keeps the reserve army of the unemployed low, thereby protecting wage
levels and strengthening labour's bargaining power."_ [Edward S. Herman,
**Beyond Hypocrisy**, p. 93] This leads to the undermining of full employment
as profit margins are placed under pressure (which explains why bosses have
lead the fight against government full employment policies).

The process should be obvious enough. Full employment results in a situation
where workers are in a very strong position, a strength which can undermine
the system. This is because capitalism always proceeds along a tightrope. If a
boom is to continue smoothly, real wages must develop within a certain band.
If their growth is too low then capitalists will find it difficult to sell the
products their workers have produced and so, because of this, face what is
often called a _"realisation crisis"_ (i.e. the fact that capitalists cannot
make a profit if they cannot sell their products). If real wage growth is too
high then the conditions for producing profits are undermined as labour gets
more of the value it produces. This means that in periods of boom, when
unemployment is falling, the conditions for realisation improve as demand for
consumer goods increase, thus expanding markets and encouraging capitalists to
invest. However, such an increase in investment (and so employment) has an
adverse effect on the conditions for **producing** surplus value as labour can
assert itself at the point of production, increase its resistance to the
demands of management and, far more importantly, make its own.

If an industry or country experiences high unemployment, workers will put up
with longer hours, stagnating wages, worse conditions and new technology in
order to remain in work. This allows capital to extract a higher level of
profit from those workers, which in turn signals other capitalists to invest
in that area. As investment increases, unemployment falls. As the pool of
available labour runs dry, then wages will rise as employers bid for scare
resources and workers feel their power. As workers are in a better position
they can go from resisting capital's agenda to proposing their own (e.g.
demands for higher wages, better working conditions and even for workers'
control). As workers' power increases, the share of income going to capital
falls, as do profit rates, and capital experiences a profits squeeze and so
cuts down on investment and employment and/or wages. The cut in investment
increases unemployment in the capital goods sector of the economy, which in
turn reduces demand for consumption goods as jobless workers can no longer
afford to buy as much as before. This process accelerates as bosses fire
workers or cut their wages and the slump deepens and so unemployment
increases, which begins the cycle again. This can be called "subjective"
pressure on profit rates.

This interplay of profits and wages can be seen in most business cycles. As an
example, let us consider the crisis which ended post-war Keynesianism in the
early 1970's and paved the way for the neo-liberal reforms of Thatcher and
Reagan. This crisis, which started in 1973, had its roots in the 1960s boom
and the profits squeeze it produced. If we look at the USA we find that it
experienced continuous growth between 1961 and 1969 (the longest in its
history until then). From 1961 onwards, unemployment steadily fell,
effectively creating full employment. From 1963, the number of strikes and
total working time lost steadily increased (the number of strikes doubled from
1963 to 1970, with the number of wildcat strike rising from 22% of all strikes
in 1960 to 36.5% in 1966). By 1965 both the business profit shares and
business profit rates peaked. The fall in profit share and rate of profit
continued until 1970 (when unemployment started to increase), where it rose
slightly until the 1973 slump occurred. In addition, after 1965, inflation
started to accelerate as capitalist firms tried to maintain their profit
margins by passing cost increases to consumers (as we discuss [section
C.8.2](secC8.html#secc82), inflation has far more to do with capitalist
profits than it has with money supply or wages). This helped to reduce real
wage gains and maintain profitability over the 1968 to 1973 period above what
it otherwise would have been, which helped postpone, but not stop, a slump.

Looking at the wider picture, we find that for the advanced capital countries
as a whole, the product wage rose steadily between 1962 and 1971 while
productivity fell. The growth of the product wage (the real cost to the
employer of hiring workers) exceeded that of productivity growth in the late
1960s, slightly after the year in which profit share in national income and
the rate of profit peaked. From then on, productivity continued to fall while
the product wage continued to rise. This process, the result of falling
unemployment and rising workers' power (expressed, in part, by an explosion in
the number of strikes across Europe and elsewhere), helped to ensure that
workers keep an increasing share of the value they produced. The actual post-
tax real wages and productivity in the advanced capitalist countries increased
at about the same rate from 1960 to 1968 but between 1968 and 1973 the former
increased at a larger rate than the latter (hence the profits squeeze).
Moreover, increased international competition meant that many domestic
companies where limited in their responses to the profits squeeze as well as
facing a global decrease in demand for their products. This resulted in profit
shares and rates declining to around 80% of their previous peak levels across
the advanced capitalist nations. [Philip Armstrong, Andrew Glyn and John
Harrison, **Capitalism Since 1945**, pp. 178-80, pp. 182-4 and pp. 192-3]

It must be stressed that social struggle was not limited to the workplace. In
the 1960s a _"series of strong liberation movements emerged among women,
students and ethnic minorities. A crisis of social institutions was in
progress, and large social groups were questioning the very foundations of the
modern, hierarchical society: the patriarchal family, the authoritarian school
and university, the hierarchical workplace or office, the bureaucratic trade
union or party."_ [Takis Fotopoulos, _"The Nation-state and the Market,"_ pp.
37-80, **Society and Nature**, Vol. 2, No. 2, p. 58] In stark contrast to the
predictions of the right, state intervention within capitalism to maintain
full employment and provide social services like health care had **not**
resulted in a _"Road to Serfdom."_ The opposite occurred, with previously
marginalised sectors of the population resisting their oppression and
exploitation by questioning authority in more and more areas of life --
including, it must be stressed, within our own organisations as well (for
example, the rank and file of trade unions had to rebel just as much against
their own officials as they had against the bureaucracy of the capitalist
firm).

These social struggles resulted in an economic crisis as capital could no
longer oppress and exploit working class people sufficiently in order to
maintain a suitable profit rate. This crisis was then used to discipline the
working class and restore capitalist authority within and outside the
workplace (see [section C.8.2](secC8.html#secc82)). We should also note that
this process of social revolt in spite, or perhaps because of, the increase of
material wealth was predicted by Malatesta. In 1922 he argued that:

> _ "The fundamental error of the reformists is that of dreaming of
solidarity, a sincere collaboration, between masters and servants, between
proprietors and workers . . .  
>  _

>

> _"Those who envisage a society of well stuffed pigs which waddle contentedly
under the ferule of a small number of swineherd; who do not take into account
the need for freedom and the sentiment of human dignity . . . can also imagine
and aspire to a technical organisation of production which assures abundance
for all and at the same time materially advantageous both to bosses and the
workers. But in reality 'social peace' based on abundance for all will remain
a dream, so long as society is divided into antagonistic classes, that is
employers and employees. And there will be neither peace nor abundance. _

>

> _"The antagonism is spiritual rather than material. There will never be a
sincere understanding between bosses and workers for the better exploitation
[sic!] of the forces of nature in the interests of mankind, because the bosses
above all want to remain bosses and secure always more power at the expense of
the workers, as well as by competition with other bosses, whereas the workers
have had their fill of bosses and don't want more!"_ [**Op. Cit.**, pp. 78-79]

The experience of the post-war compromise and social democratic reform shows
that, ultimately, the social question is not poverty but rather freedom.
However, to return to the impact of class struggle on capitalism.

It is the awareness that full employment is bad for business which is the
basis of the so-called _"Non-Accelerating Inflation Rate of Unemployment"_
(NAIRU). As we will discuss in more detail in [section C.9](secC9.html), the
NAIRU is the rate of unemployment for an economy under which inflation, it is
claimed, starts to accelerate. While the basis of this "theory" is slim (the
NAIRU is an invisible, mobile rate and so the "theory" can explain every
historical event simply because you can prove anything when your datum cannot
be seen by mere mortals) it is very useful for justifying policies which aim
at attacking working people, their organisations and their activities. The
NAIRU is concerned with a _"wage-price"_ spiral caused by falling unemployment
and rising workers' rights and power. Of course, you never hear of an _
"interest-price"_ spiral or a _"rent-price"_ spiral or a _"profits-price"_
spiral even though these are also part of any price. It is always a _"wage-
price"_ spiral, simply because interest, rent and profits are income to
capital and so, by definition, above reproach. By accepting the logic of
NAIRU, the capitalist system implicitly acknowledges that it and full
employment are incompatible and so with it any claim that it allocates
resources efficiently or labour contracts benefit both parties equally.

For these reasons, anarchists argue that a continual "boom" economy is an
impossibility simply because capitalism is driven by profit considerations,
which, combined with the subjective pressure on profits due to the class
struggle between workers and capitalists, **necessarily** produces a
continuous boom-and-bust cycle. When it boils down to it, this is
unsurprising, as _"industry is directed, and will have to be directed, not
towards what is needed to satisfy the needs of all, but towards that which, at
a given moment, brings in the greatest temporary profit to a few. Of
necessity, the abundance of some will be based upon the poverty of others, and
the straitened circumstances of the greater number will have to be maintained
at all costs, that there may be hands to sell themselves for a part only of
that which they are capable of producing, without which private accumulation
of capital is impossible!"_ [Kropotkin, **Op. Cit.**, p. 128]

Of course, when such "subjective" pressures are felt on the system, when
private accumulation of capital is threatened by improved circumstances for
the many, the ruling class denounces working class "greed" and "selfishness."
When this occurs we should remember what Adam Smith had to say on this
subject:

> _ "In reality high profits tend much more to raise the price of work than
high wages . . . That part of the price of the commodity that resolved itself
into wages would . . . rise only in arithmetical proportion to the rise in
wages. But if profits of all the different employers of those working people
should be raised five per cent., that price of the commodity which resolved
itself into profit would . . . rise in geometrical proportion to this rise in
profit . . . Our merchants and master manufacturers complain of the bad
effects of high wages in raising the price and thereby lessening the sale of
their goods at home and abroad. They say nothing concerning the bad effects of
high profits. They are silent with regard to the pernicious effects of their
own gains. They complain only of those of other people."_ [**The Wealth of
Nations**, pp. 87-88]

As an aside, we must note that these days we would have to add economists to
Smith's _"merchants and master manufacturers."_ Not that this is surprising,
given that economic theory has progressed (or degenerated) from Smith's
disinterested analysis into apologetics for any action of the boss (a classic
example, we must add, of supply and demand, with the marketplace of ideas
responding to a demand for such work from _"our merchants and master
manufacturers"_). Any "theory" which blames capitalism's problems on "greedy"
workers will always be favoured over one that correctly places them in the
contradictions created by wage slavery. Ultimately, capitalist economics blame
every problem of capitalism on the working class refusing to kow-tow to the
bosses (for example, unemployment is caused by wages being too high rather
than bosses needing unemployment to maintain their power and profits -- see
[section C.9.2](secC9.html#secc92) on empirical evidence that indicates that
the first explanation is wrong).

Before concluding, one last point. While it may appear that our analysis of
the "subjective" pressures on capitalism is similar to that of mainstream
economics, this is not the case. This s because our analysis recognises that
such pressures are inherent in the system, have contradictory effects (and so
cannot be easily solved without making things worse before they get better)
and hold the potential for creating a free society. Our analysis recognises
that workers' power and resistance **is** bad for capitalism (as for any
hierarchical system), but it also indicates that there is nothing capitalism
can do about it without creating authoritarian regimes (such as Nazi Germany)
or by generating massive amounts of unemployment (as was the case in the early
1980s in both the USA and the UK, when right-wing governments mismanaged the
economy into deep recessions) and even this is no guarantee of eliminating
working class struggle as can be seen, for example, from 1930s America.

This means that our analysis shows the limitations and contradictions of the
system as well as its need for workers to be in a weak bargaining position in
order for it to "work" (which explodes the myth that capitalism is a free
society). Moreover, rather than portray working people as victims of the
system (as is the case in many Marxist analyses of capitalism) our analysis
recognises that we, both individually and collectively, have the power to
influence and **change** that system by our activity. We should be proud of
the fact that working people refuse to negate themselves or submit their
interests to that of others or play the role of order-takers required by the
system. Such expressions of the human spirit, of the struggle of freedom
against authority, should not be ignored or down-played, rather they should be
celebrated. That the struggle against authority causes the system so much
trouble is not an argument against social struggle, it is an argument against
a system based on hierarchy, oppression, exploitation and the denial of
freedom.

To sum up, in many ways, social struggle is the inner dynamic of the system,
and its most basic contradiction: while capitalism tries to turn the majority
of people into commodities (namely, bearers of labour power), it also has to
deal with the human responses to this process of objectification (namely, the
class struggle). However, it does not follow that cutting wages will solve a
crisis -- far from it, for, as we argue in [section C.9.1](secC9.html#secc91),
cutting wages will deepen any crisis, making things worse before they get
better. Nor does it follow that, if social struggle were eliminated,
capitalism would work fine. After all, if we assume that labour power is a
commodity like any other, its price will rise as demand increases relative to
supply (which will either produce inflation or a profits squeeze, probably
both). Therefore, even without the social struggle which accompanies the fact
that labour power cannot be separated from the individuals who sell it,
capitalism would still be faced with the fact that only surplus labour
(unemployment) ensures the creation of adequate amounts of surplus value.

Moreover, even assuming that individuals can be totally happy in a capitalist
economy, willing to sell their freedom and creativity for a little more money,
putting up, unquestioningly, with every demand and whim of their bosses (and
so negating their own personality and individuality in the process),
capitalism does have "objective" pressures limiting its development. So while
social struggle, as argued above, can have a decisive effect on the health of
the capitalist economy, it is not the only problem the system faces. This is
because there are objective pressures within the system beyond and above the
authoritarian social relations it produces and the resistance to them. These
pressures are discussed next, in sections [C.7.2](secC7.html#secc72) and
[C.7.3](secC7.html#secc73).

## C.7.2 What role does the market play in the business cycle?

A major problem with capitalism is the working of the capitalist market
itself. For the supporters of "free market" capitalism, the market provides
all the necessary information required to make investment and production
decisions. This means that a rise or fall in the price of a commodity acts as
a signal to everyone in the market, who then respond to that signal. These
responses will be co-ordinated by the market, resulting in a healthy economy.

This perspective is expressed well by right-liberal, Frederick von Hayek in
his _"The Uses of Knowledge in Society"_ (reprinted in **Individualism and
Economic Order**). Using the example of the tin market, he defends capitalism
against central planning on its ability to handle the division of knowledge
within society and its dynamic use of this dispersed knowledge when demand or
supply changes. _"Assume,"_ he argues, _"that somewhere in the world a new
opportunity for the use of some raw material, say tin, has arisen, or that one
of the sources of supply of tin has been eliminated. It does not matter for
our purpose and it is very significant that it does not matter which of these
two causes has made tin more scarce. All that the users of tin need to know is
that some of the tin they used to consume is now more profitably employed
elsewhere, and that in consequence they must economise tin. There is no need
for the great majority of them even to know where the more urgent need has
arisen, or in favour of what other uses they ought to husband the supply."_
The subsequent rise in its price will result in reduced consumption as many
users will economise on its use and so the information that tin has become
(relatively) scarcer spreads throughout the economy and influences not only
tin users, but also its substitutes and the substitutes of these substitutes
and so on. This will move the economy towards equilibrium without the people
informed knowing anything about the original causes for these changes. _"The
whole acts as one market, not because any of its members survey the whole
field, but because their limited individual fields of vision sufficiently
overlap so that through many intermediaries the relevant information is
communicated to all."_ (_"The use of knowledge in society,"_ pp. 519-30,
**American Economic Review**, Vol. 35, No. 4, , p. 526)

While it can be granted that this account of the market is not without
foundation, it is also clear that the price mechanism does not communicate all
the relevant information needed by companies or individuals. This means that
capitalism does not work in the way suggested in the economic textbooks. It is
the workings of the price mechanism itself which leads to booms and slumps in
economic activity and the resulting human and social costs they entail. This
can be seen if we investigate the actual processes hidden behind the workings
of the price mechanism.

The key problem with Hayek's account is that he does not discuss the
**collective** results of the individual decisions he highlights. It is true
that faced with a rise in the price of tin, individual firms will cut back on
its use. Yet there is no reason to suppose that the net result of these
actions will bring the demand and supply of tin back to equilibrium. In fact,
it is just as likely that the reduction in demand for tin is such that its
producers face falling sales and so cut back production even more. Similarly,
a rising demand for tin could easily result in all tin producers increasing
supply so much as to produce a glut on the market. Proudhon described this
process well in the 1840s:

> _ "A peasant who has harvested twenty sacks of wheat, which he with his
family proposes to consume, deems himself twice as rich as if he had harvested
only ten; likewise a housewife who has spun fifty yards of linen believes that
she is twice as rich as if she had spun but twenty-five. Relatively to the
household, both are right; looked at in their external relations, they may be
utterly mistaken. If the crop of wheat is double throughout the whole country,
twenty sacks will sell for less than ten would have sold for if it had been
but half as great; so, under similar circumstances, fifty yards of linen will
be worth less than twenty-five: so that value decreases as the production of
utility increases, and a producer may arrive at poverty by continually
enriching himself."_ [**System of Economical Contradictions**, pp. 77-78]

He argued that this occurred due to the _"contradiction"_ of _"the double
character of value"_ (i.e. between value in use and value in exchange). [**Op.
Cit.**, p. 78]

As John O'Neill argues (basing himself on Marx rather than Proudhon), when
producers _"make plans concerning future production, they are planning not
with respect of demand at the present moment . . . but with respect to
expected demand at some future moment . . . when their products reach the
market."_ The price mechanism provides information that indicates the
relationship between supply and demand **now** and while this information
**is** relevant to producers plans, it is not **all** the information that is
relevant or is required by those involved. It cannot provide information which
will allow producers to predict demand later. _"A major component of the
information required for such a prediction is that of the plans of other
producers which respond to that demand. This is information that the market,
as a competitive system, fails to distribute."_ It is this _"informational
restriction"_ which is one of the sources of why there is a business cycle.
This is because each producer _"responds to the same signal the change in
price. However, each agent acts independently of the response of other
producers and consumers."_ The result is _"an overproduction of goods in
relation to effective demand for them. Goods cannot be sold. There is a
realisation crisis: producers cannot realise the value of their products.
Given this overproduction, demand falls against supply. There is a slump. This
eventually leads to a rise in demand against supply, production expends
leading to another boom, and so on."_ [**The Market**, pp. 134-5]

This information cannot be supplied due to competition. Simply put, if A and B
are in competition, if A informs B of her activities and B does not
reciprocate, then B is in a position to compete more effectively than A. Hence
communication within the market is discouraged and each production unit is
isolated from the rest. In other words, each person or company responds to the
same signal (the change in price) but each acts independently of the response
of other producers and consumers. The result is often a slump in the market,
causing unemployment and economic disruption. Thus the market _"blocks the
communication of information and fails to co-ordinate plans for economic
action."_ [**Op. Cit.**, p. 137]

This, it should be noted, is not a problem of people making a series of
unrelated mistakes. _"Rather, it is that the market imparts the same
information to affected agents, and this information is such that the rational
strategy for all agents is to expand production or contract consumption, while
it is not rational for all agents to act in this manner collectively."_ In
other words, the information the market provides is not sufficient for
rational decision making and naturally results in disproportionalities in the
market. Thus the price mechanism actively encourages _"the suppression of the
mutual exchange of information concerning planned responses"_ to current
prices and this _"leads to over production."_ So it is **not** a question of
inaccurate prediction (although given that the future is unknowable and
unpredictable this is a factor). Instead, it is _"one of individually rational
responses to the same signal resulting in collectively irrational responses."_
[**Op. Cit.**, p. 135 and p. 197]

This means that prices in themselves do not provide adequate knowledge for
rational decision making as they are not at their long-run equilibrium levels.
This causes a problem for Hayek's account of the market process as he stresses
that actual prices never are at this (purely theoretical) price. As we discuss
in [section C.8](secC8.html), Hayek's own theory of the business cycle shows
the negative impact which the 'misinformation' conveyed by disequilibrium
prices can cause on the economy. In that analysis, the disequilibrium price
that leads to very substantial macroeconomic distortions is the rate of
interest but, obviously, the same argument applies for commodity prices as
well. This means that the market process, based on the reactions of profit-
maximising firms to the same (unsustainable) prices for a commodity can
generating mal-investment and subsequent market distributions on a wide level.
Simply put, the price mechanism may carry information regarding the terms on
which various commodities may currently be exchanged but it does not follow
that a knowledge of these exchange ratios enable agents to calculate the
future profitability of their production decisions (social usefulness is, of
course, of no concern).

It is this irrationality and lack of information which feed into the business
cycle. _"These local booms and slumps in production . . . are then amplified
into general crises precisely through the interconnections in the market that
Hayek highlights in his example of the production and consumption of tin."_
[O'Neill, **Op. Cit.**, p. 136] The negative effects of over-production in one
market will be passed on to those which supply it with goods in the shape of
decreased demand. These firms will now experience relative over-production
which, in turn, will affect their suppliers. Whatever benefits may accrue to
consumers of these goods in the shape of lower prices will be reduced as
demand for their products drops as more and more workers are made unemployed
or their wages are cut (which means that **real** wages remain constant as
prices are falling alongside money wages -- see [section
C.9.1](secC9.html#secc91) for details). Firms will also seek to hoard money,
leading to yet more falling demand for goods and so unemployed labour is
joined by under-utilisation of capacity.

Which brings us to the issue of money and its role in the business cycle.
"Free market" capitalist economics is based on Say's Law. This is the notion
that supply creates its own demand and so general gluts of goods and mass
unemployment are impossible. As we noted in [section
C.1.5](secC1.html#secc15), this vision of economic activity is only suited to
precapitalist economies or ones without money for money is considered as
nothing more than an aid to barter, a medium of exchange only. It ignores the
fact that money is a store of value and, as such, can be held onto precisely
for that reason. This means that Say's Law is invalid as its unity between
sale and purchase can be disturbed so causing the chain of contractual
relationships to be broken. Simply put, someone who sells a product need not
spend their income on another product at the same time. Unlike barter, the
sale of one commodity is an act distinct from the purchase of another. Money,
in other words, _"brings in time"_ into the market process and _"the
possibility of hoarding."_ Time _"because a good is usually sold some time
after it is made, running the risk that its sale price could fall below the
cost of production, wiping out the capitalist's expected profit."_ Hoarding
_"because income need not be spent but may merely be kept idle."_ [Doug
Henwood, **Wall Street**, p. 232]

This means that over-production becomes possible and bankruptcies and
unemployment can become widespread and so a slump can start. _"As any Marxian
or Keynesian crisis theorist can tell you,"_ Henwood summarises, _"the
separation of purchase and sale is one of the great flashpoints of capitalism;
an expected sale that goes unmade can drive a capitalist under, and can
unravel a chain of financial commitments. Multiply that by a thousand or two
and you have great potential mischief."_ Thus _"the presence of money as a
store of value, the possibility of keeping wealth in financial form rather
than spending it promptly on commodities, always introduces the possibility of
crisis."_ That is, the possibility _"of an excess of capital lacking a
profitable investment outlet, and an excess of goods that couldn't be sold
profitably on the open market."_ [**Op. Cit.**, pp. 93-4 and p. 94]

So when the market prices of goods fall far below their cost prices then
production and investment stagnate. This is because profits can only be
transformed into capital at a loss and so it lies idle in banks. Thus
unemployed labour is associated with unemployed capital, i.e. excess money.
This desire for capitalists to increase their demand for storing their wealth
in money rather than investing it is driven by the rate of profit in the
economy. Bad times result in increased hoarding and so a general fall in
aggregate demand. Lowering interest rates will not provoke a demand for such
money hoards, as claimed in "free market" capitalist theory, as few
capitalists will seek to invest in a recession as expected profits will be
lower than the interest rate.

However, it should be stressed that disproportionalities of production between
industries and the separation of production and sale do not **per se** result
in a general crisis. If that were the case the capitalism would be in a
constant state of crisis as markets are rarely in a state of equilibrium and
sales do not instantly result in purchases. This means that market
dislocations need not automatically produce a general crisis in the economy as
the problems associated with localised slumps can be handled when the overall
conditions within an economy are good. It simply provides the **potential**
for crisis and a means of transmitting and generalising local slumps when the
overall economic situation is weak. In other words, it is an accumulative
process in which small changes can build up on each other until the pressures
they exert become unstoppable. The key thing to remember is that capitalism is
an inherently dynamic system which consists of different aspects which develop
unevenly (i.e., disproportionately). Production, credit, finance markets,
circulation of money and goods, investment, wages, profits as well as specific
markets get out of step. An economic crisis occurs when this process gets too
far out of line.

This process also applies to investment as well. So far, we have assumed that
firms adjust to price changes without seeking new investment. This is, of
course, unlikely to always be the case. As we discuss in [section
C.8](secC8.html), this analysis of the market providing incomplete information
also applies to the market for credit and other forms of external financing.
This results in a situation where the problems associated with over-production
can be amplified by over-investment. This means that the problems associated
with markets creating disproportionalities are combined with the problems
resulting from increased productivity and capital investment which are
discussed in the [next section](secC7.html#secc73).

## C.7.3 What role does investment play in the business cycle?

Other problems for capitalism arise due to the increases in productivity which
occur as a result of capital investment or new working practices which aim to
increase short term profits for the company. The need to maximise profits
results in more and more investment in order to improve the productivity of
the workforce (i.e. to increase the amount of surplus value produced). A rise
in productivity, however, means that whatever profit is produced is spread
over an increasing number of commodities. This profit still needs to be
realised on the market but this may prove difficult as capitalists produce not
for existing markets but for expected ones. As individual firms cannot predict
what their competitors will do, it is rational for them to try to maximise
their market share by increasing production (by increasing investment). As the
market does not provide the necessary information to co-ordinate their
actions, this leads to supply exceeding demand and difficulties realising
sufficient profits. In other words, a period of over-production occurs due to
the over-accumulation of capital.

Due to the increased investment in the means of production, variable capital
(labour) uses a larger and larger constant capital (the means of production).
As labour is the source of surplus value, this means that in the short term
profits may be increased by the new investment, i.e. workers must produce
more, in relative terms, than before so reducing a firms production costs for
the commodities or services it produces. This allows increased profits to be
realised at the current market price (which reflects the old costs of
production). Exploitation of labour must increase in order for the return on
total (i.e. constant **and** variable) capital to increase or, at worse,
remain constant. However, while this is rational for one company, it is not
rational when all firms do it (which they must in order to remain in
business). As investment increases, the surplus value workers have to produce
must increase faster. As long as the rate of exploitation produced by the new
investments is high enough to counteract the increase in constant capital and
keep the profit rate from falling, then the boom will continue. If, however,
the mass of possible profits in the economy is too small compared to the total
capital invested (both in means of production, fixed, and labour, variable)
then the possibility exists for a general fall in the rate of profit (the
ratio of profit to investment in capital and labour). Unless exploitation
increases sufficiently, already produced surplus value earmarked for the
expansion of capital may not be realised on the market (i.e. goods may not be
sold). If this happens, then the surplus value will remain in its money form,
thus failing to act as capital. In other words, accumulation will grind to a
halt and a slump will start.

When this happens, over-investment has occurred. No new investments are made,
goods cannot be sold resulting in a general reduction of production and so
increased unemployment as companies fire workers or go out of business. This
removes more and more constant capital from the economy, increasing
unemployment which forces those with jobs to work harder, for longer so
allowing the mass of profits produced to be increased, resulting (eventually)
in an increase in the rate of profit. Once profit rates are high enough,
capitalists have the incentive to make new investments and slump turns to
boom. As we discuss in [section C.8](secC8.html), the notion that investment
will be helped by lowing interest rates in a slump fails to understand that
_"the rate of investment decisions is an increasing function of the difference
between the prospective rate of profit and the rate of interest."_ [Michal
Kalecki, quoted by Malcolm Sawyer, **The Economics of Michal Kalecki**, p. 98]
If profit rates are depressed due to over-investment then even the lowest
interest rates will have little effect. In other words, expectations of
capitalists and investors are a key issue and these are shaped by the general
state of the economy.

It could be argued that such an analysis is flawed as no company would invest
in machinery if it would reduce its rate of profit. But such an objection is
flawed, simply because (as we noted) such investment is perfectly sensible
(indeed, a necessity) for a specific firm. By investing they gain
(potentially) an edge in the market and so increased profits for a period.
This forces their competitors to act likewise and **they** invest in new
technology. Unfortunately, while this is individually sensible, collectively
it is not as the net result of these individual acts is over-investment in the
economy as a whole. Moreover, unlike the model of perfect competition, in a
real economy capitalists have no way of knowing the future, and so the results
of their own actions never mind the actions of their competitors. Thus over-
accumulation of capital is the natural result of competition simply because
even if we assume that the bosses of the firms are individually rational they
are driven to make decisions which are collectively irrational to remain in
business. The future is unknowable and so the capitalist has no idea what the
net result of their decisions will be nor the state of the economy when their
investment decisions are finally active. Both of these factors ensure that
firms act as they do, investing in machinery which, in the end, will result in
a crisis of over-accumulation.

The logic is simple and is rooted in the concept of _"the fallacy of
composition."_ To use an analogy, if you attend a rock concert and take a box
to stand on then you will get a better view. If others do the same, you will
be in exactly the same position as before. Worse, even, as it may be easier to
loose your balance and come crashing down in a heap (and, perhaps, bringing
others with you). This analogy shows why introducing new machinery, which is
profitable for an individual company, has such a potentially negative effect
on the economy as a whole. While it is profitable for an individual company in
the short term, its overall effect means that it is **not** profitable for all
in the long run. As Kalecki put it, the _"tragedy of investment is that it
causes crisis because it is useful. Doubtless many people will consider this
theory paradoxical. But it is not the theory which is paradoxical, but its
subject -- the capitalist economy."_ [quoted by Sawyer **Op. Cit.**, p. 156]
This paradox applies to the issue of wages as well:

> _ "What a system is that which leads a business man to think with delight
that society will soon be able to dispense with men! **Machinery has delivered
capital from the oppression of labour**! . . . Fool! though the workmen cost
you something, they are your customers: what will you do with your products,
when, driven away by you, they shall consume them no longer? Thus machinery,
after crushing the workmen, is not slow in dealing employers a counter-blow;
for, if production excludes consumption, it is soon obliged to stop itself.  
>  _

>

> _[. . .] _

>

> _"These failures were caused by over-production, -- that is, by an
inadequate market, or the distress of the people. What a pity that machinery
cannot also deliver capital from the oppression of consumers! What a
misfortune that machines do not buy the fabrics which they weave! The ideal
society will be reached when commerce, agriculture, and manufactures can
proceed without a man upon earth!"_ [Proudhon, **System of Economical
Contradictions**, pp. 189-90]

So, if the profit rate falls to a level that does not allow capital formation
to continue, a slump sets in. This general slump means that the rate of profit
over the whole economy falls due to excessive investment. When one industry
over-invests and over-produces, it cuts back production, introduces cost-
cutting measures, fires workers and so on in order to try and realise more
profits. These may spread if the overall economic is fragile as the reduced
demand for industries that supplied the affected industry impacts on the
**general** demand (via a fall in inputs as well as rising unemployment). The
related industries now face over-production themselves and the natural
response to the information supplied by the market is for individual companies
to reduce production, fire workers, etc., which again leads to declining
demand. This makes it even harder to realise profit on the market and leads to
more cost cutting, deepening the crisis. While individually this is rational,
collectively it is not and so soon all industries face the same problem. A
local slump is propagated through the economy.

Cycles of prosperity, followed by over-production and then depression are the
natural result of capitalism. Over-production is the result of over-
accumulation, and over-accumulation occurs because of the need to maximise
short-term profits in order to stay in business. So while the crisis appears
as a glut of commodities on the market, as there are more commodities in
circulation that can be purchased by the aggregate demand (_"Property sells
products to the labourer for more than it pays him for them,"_ to use
Proudhon's words), its roots are deeper. It lies in the nature of capitalist
production itself.

"Over-production," we should point out, exists only from the viewpoint of
capital, **not** of the working class:

> _ "What economists call over-production is but a production that is above
the purchasing power of the worker. . . this sort of over-production remains
fatally characteristic of the present capitalist production, because workers
cannot buy with their salaries what they have produced and at the same time
copiously nourish the swarm of idlers who live upon their work."_ [Kropotkin,
**Op. Cit.**, pp. 127-128]

In other words, over-production and under-consumption reciprocally imply each
other. There is no over production except in regard to a given level of
solvent demand. There is no deficiency in demand except in relation to a given
level of production. The goods "over-produced" may be required by consumers,
but the market price is too low to generate a profit and so existing goods
must be destroyed and production must be reduced in order to artificially
increase it. So, for example, the sight of food and other products being
destroyed while people are in need of them is a common one in depression
years.

So, while the crisis appears on the market as a _"commodity glut"_ (i.e. as a
reduction in effective demand) and is propagated through the economy by the
price mechanism, its roots lie in production. Until such time as profit levels
stabilise at an acceptable level, thus allowing renewed capital expansion, the
slump will continue. The social costs of the wage cutting this requires is yet
another "externality," to be bothered with only if they threaten capitalist
power and wealth.

There are means, of course, by which capitalism can postpone (but not stop) a
general crisis developing. The extension of credit by banks to both investors
and consumers is the traditional, and most common, way. Imperialism, by which
markets are increased and profits are extracted from less developed countries
and used to boost the imperialist countries profits, is another method (_"The
workman being unable to purchase with their wages the riches they are
producing, industry must search for markets elsewhere."_ [Kropotkin, **Op.
Cit.**, p. 55]). Another is state intervention in the economy (such as minimum
wages, the incorporation of trades unions into the system, arms production,
manipulating interest rates to maintain a _"natural"_ rate of unemployment to
keep workers on their toes, etc.). Another is state spending to increase
aggregate demand, which can increase consumption and so lessen the dangers of
over-production. However, these have (objective and subjective) limits and can
never succeed in stopping depressions from occurring as they ultimately flow
from capitalist production and the need to make profits.

A classic example of these "objective" pressures on capitalism is the "Roaring
Twenties" that preceded the Great Depression of the 1930s. After the 1921
slump, there was a rapid rise in investment in the USA with investment nearly
doubling between 1919 and 1927. Because of this investment in capital
equipment, manufacturing production grew by 8.0% per annum between 1919 and
1929 and labour productivity grew by an annual rate of 5.6% (this is including
the slump of 1921-22). With costs falling and prices comparatively stable,
profits increased which in turn lead to high levels of capital investment (the
production of capital goods increased at an average annual rate of 6.4%).
[William Lazonick, **Competitive Advantage on the Shop Floor**, p. 241] The
optimism felt by business as a result of higher profits was reflected in the
wealthy sections of America. In the 1920s prosperity was concentrated at the
top. One-tenth of the top 1% of families received as much income as the bottom
42% and only 2.3% of the population enjoyed incomes over $100,00 (60% of
families made less than $2,000 a year, 42% less than $1,000). While the
richest 1% owned 40% of the nation's wealth by 1929 (and the number of people
claiming half-million dollar incomes rose from 156 in 1920 to 1,489 in 1929)
the bottom 93% of the population experienced a 4% drop in real disposable per-
capita income between 1923 and 1929. However, in spite (or, perhaps, because)
of this, US capitalism was booming and belief in capitalism was at its peak.

But by 1929 all this had changed with the stock market crash -- followed by a
deep depression. What was its cause? Given our analysis presented in [section
C.7.1](secC7.html#secc71), it may have been expected to have been caused by
the "boom" decreasing unemployment, so increased working class power and
leading to a profits squeeze but this was not the case. This slump was **not**
the result of working class resistance, indeed the 1920s were marked by a
labour market which was continuously favourable to employers. This was for two
reasons. Firstly, the "Palmer Raids" at the end of the 1910s saw the state
root out radicals in the US labour movement and wider society. Secondly, the
deep depression of 1920-21 (during which national unemployment rates averaged
over 9%, the highest level over any two-year period since the 1890s) changed
the labour market from a seller's to a buyer's market. This allowed the bosses
to apply what became to be known as _"the American Plan,"_ namely firing
workers who belonged to a union and forcing them to sign _"yellow-dog"_
contracts (promises not to join a union) to gain or keep their jobs.
Reinforcing this was the use of legal injunctions by employers against work
protests and the use of industrial spies to identify and sack union members.
This class war from above made labour weak, which is reflected in the
influence and size of unions falling across the country. As union membership
declined, the number of strilkes reached their lowest level since the early
1880s, falling to just over 700 per year between 1927 to 1930 (compared to
3,500 per year between 1916 and 1921). [Lazonick, **Op. Cit.**, pp. 249-251]
The key thing to remember is that the impact of unemployment is not limited to
the current year's figures. High unemployment rates have a sustained impact on
the organisations, morale, and bargaining power of workers even if
unemployment rates fall afterwards. This was the situation in the 1920s, with
workers remembering the two years of record unemployment rates of 1921 and
1922 (in fact, the unemployment rate for manufacturing workers was close to
the overall rate in 1933).

During the post-1922 boom, this position did not change. The national 3.3%
unemployment rate hid the fact that non-farm unemployment averaged 5.5%
between 1923 and 1929. Across all industries, the growth of manufacturing
output did not increase the demand for labour. Between 1919 and 1929,
employment of production workers fell by 1% and non-production employment fell
by about 6% (during the 1923 to 29 boom, production employment only increased
by 2%, and non-production employment remained constant). This was due to the
introduction of labour saving machinery and the rise in the capital stock. In
addition, the numbers seeking work were boosted by new immigrants and the
unwillingness of existing ones to return home due to difficulties returning to
America. Lastly, the greatest source of industrial labour supply came from the
American farm -- there was a flood of rural workers into the urban labour
market over the 1920s. [Lazonick, **Op. Cit.**, pp. 252-5] It is interesting
to note that even **with** a labour market favourable to employers for over 5
years, unemployment was still high. This suggests that the neo-classical
"argument" (assertion would be more correct) that unemployment within
capitalism is caused by strong unions or high real wages is somewhat flawed to
say the least (see [section C.9](secC9.html)).

Facing high unemployment, workers' quit rates fell due to fear of loosing jobs
(particularly those workers with relatively higher wages). This, combined with
the steady decline of the unions and the very low number of strikes, indicates
that labour was weak. This is reflected in the share of total manufacturing
income going to wages fell from 57.5% in 1923-24 to 52.6% in 1928/29 (between
1920 and 1929, it fell by 5.7%). Productivity increased from an annual rate of
1.2% between 1909 and 1919 to 5.6% between 1919 and 1929. This increase in
productivity was reflected in the fact that over the post-1922 boom, the share
of manufacturing income paid in salaries rose from 17% to 18.3% and the share
to capital rose from 25.5% to 29.1%. Managerial salaries rose by 21.9% and
firm surplus by 62.6% between 1920 and 1929. [Lazonick, **Op. Cit.**, pp.
241-2] Any notion that the 1929 crash was the result of a rebellious working
class is not applicable.

The key to understanding what happened lies in the contradictory nature of
capitalist production. The "boom" conditions were the result of capital
investment, which increased productivity thereby reducing costs and increasing
profits. The large and increasing investment in capital goods was the
principal device by which profits were spent. In addition, those sectors of
the economy marked by big business (i.e. oligopoly, a market dominated by a
few firms) placed pressures upon the more competitive ones. As big business,
as usual, received a higher share of profits due to their market position (see
[section C.5](secC5.html)), this lead to many firms in the more competitive
sectors of the economy facing a profitability crisis during the 1920s.

The increase in investment, while directly squeezing profits in the more
competitive sectors of the economy, also eventually caused the rate of profit
to stagnate, and then fall, over the economy as a whole. While the mass of
available profits in the economy grew, it eventually became too small compared
to the total capital invested. Moreover, with the fall in the share of income
going to labour and the rise of inequality, aggregate demand for goods could
not keep up with production leading to unsold goods (which is another way of
expressing the process of over-investment leading to over-production, as over-
production implies under-consumption and vice versa). As expected returns
(profitability) on investments hesitated, a decline in investment demand
occurred and so a slump began (rising predominantly from the capital stock
rising faster than profits). Investment flattened out in 1928 and turned down
in 1929. With the stagnation in investment, a great speculative orgy occurred
in 1928 and 1929 in an attempt to enhance profitability. This unsurprisingly
failed and in October 1929 the stock market crashed, paving the way for the
Great Depression of the 1930s.

This process of over-investment relative to consumption is based on rising
labour productivity combined with stagnant wages or relative slow wage growth.
This implies inadequate workers' consumption but rising profit rates. This is
possible as long as aggregate demand remains sufficient, which it can as long
as high profit rates stimulate investment (i.e., money is not saved or
sufficient credit is generated to ensure that investment spending does not lag
consumption). Investment creates new capacity and that implies the need for
further increases in investment, capitalist luxury consumption, and credit-
based consumption to maintain aggregate demand. This profit-led growth is hard
to sustain as high profits rates are difficult to maintain due to low working
class income as both investment and capitalist luxury consumption are more
unstable. Investment is more volatile than consumption, so the average degree
of instability increases which, in turn, means that the probability of a slump
rises. Further, this type of growth creates imbalances between sectors of the
economy as firms rush to invest in profitable sections leading to relative
over-production and over-investment in those areas (see [last
section](secC7.html#secc72)). With the rise in unstable forms of demand, an
economy becomes increasingly fragile and so increasingly vulnerable to
"shocks." The stock market crash of 1929 was such a shock and the resulting
panic and reduced demand for luxury goods and investment that it produced
exposed the underlying weakness of the economy. After the Crash, restrictive
fiscal and monetary policies and falling demand interacted to break this
unstable prosperity and to accelerate the slump. This was reinforced by wage-
cut induced under-consumption as well as debt deflation making over-investment
worse in relation to over demand within the economy. So US prosperity was
fragile long before late 1929, due to the process of over-investment relative
to demand which lead the economy to be reliant on unstable forms of demand
such as luxury consumption and investment.

The crash of 1929 indicates the "objective" limits of capitalism. Even with a
very weak position of labour crisis still occurred and prosperity turned to
"hard times." In contradiction to neo-classical economic theory, the events of
the 1920s indicate that even if the capitalist assumption that labour is a
commodity like all others **is** approximated in real life, capitalism is
still subject to crisis (ironically, a militant union movement in the 1920s
would have postponed crisis by shifting income from capital to labour,
increasing aggregate demand, reducing investment and supporting the more
competitive sectors of the economy!). Therefore, any neo-classical "blame
labour" arguments for crisis (which were so popular in the 1930s and 1970s)
only tells half the story (if that). Even if workers **do** act in a servile
way to capitalist authority, capitalism will still be marked by boom and bust
(as shown by the 1920s and 1980/90s).

To conclude, capitalism will suffer from a boom-and-bust cycle due to the
above-mentioned objective pressures on profit production, even if we ignore
the subjective revolt against authority by workers, explained earlier. In
other words, even if the capitalist assumption that workers are not human
beings but only "variable capital" **were** true, it would not mean that
capitalism would be a crisis free system. However, for most anarchists, such a
discussion is somewhat academic for human beings are not commodities, the
labour "market" is not like the iron market, and the subjective revolt against
capitalist domination will exist as long as capitalism does.

[‹ C.6 Can market dominance by Big Business change?](/afaq/secC6.html "Go to
previous page" ) [up](/afaq/secCcon.html "Go to parent page" ) [C.8 Is state
control of credit the cause of the business cycle? ›](/afaq/secC8.html "Go to
next page" )

