// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloud9

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateEnvironmentEC2 = "CreateEnvironmentEC2"

// CreateEnvironmentEC2Request generates a "aws/request.Request" representing the
// client's request for the CreateEnvironmentEC2 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEnvironmentEC2 for more information on using the CreateEnvironmentEC2
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEnvironmentEC2Request method.
//    req, resp := client.CreateEnvironmentEC2Request(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/CreateEnvironmentEC2
func (c *Cloud9) CreateEnvironmentEC2Request(input *CreateEnvironmentEC2Input) (req *request.Request, output *CreateEnvironmentEC2Output) {
	op := &request.Operation{
		Name:       opCreateEnvironmentEC2,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEnvironmentEC2Input{}
	}

	output = &CreateEnvironmentEC2Output{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEnvironmentEC2 API operation for AWS Cloud9.
//
// Creates an AWS Cloud9 development environment, launches an Amazon Elastic
// Compute Cloud (Amazon EC2) instance, and then connects from the instance
// to the environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud9's
// API operation CreateEnvironmentEC2 for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The target request is invalid.
//
//   * ErrCodeConflictException "ConflictException"
//   A conflict occurred.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The target resource cannot be found.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   An access permissions issue occurred.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Too many service requests were made over the given time period.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A service limit was exceeded.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal server error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/CreateEnvironmentEC2
func (c *Cloud9) CreateEnvironmentEC2(input *CreateEnvironmentEC2Input) (*CreateEnvironmentEC2Output, error) {
	req, out := c.CreateEnvironmentEC2Request(input)
	return out, req.Send()
}

// CreateEnvironmentEC2WithContext is the same as CreateEnvironmentEC2 with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEnvironmentEC2 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Cloud9) CreateEnvironmentEC2WithContext(ctx aws.Context, input *CreateEnvironmentEC2Input, opts ...request.Option) (*CreateEnvironmentEC2Output, error) {
	req, out := c.CreateEnvironmentEC2Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEnvironmentMembership = "CreateEnvironmentMembership"

// CreateEnvironmentMembershipRequest generates a "aws/request.Request" representing the
// client's request for the CreateEnvironmentMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEnvironmentMembership for more information on using the CreateEnvironmentMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEnvironmentMembershipRequest method.
//    req, resp := client.CreateEnvironmentMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/CreateEnvironmentMembership
func (c *Cloud9) CreateEnvironmentMembershipRequest(input *CreateEnvironmentMembershipInput) (req *request.Request, output *CreateEnvironmentMembershipOutput) {
	op := &request.Operation{
		Name:       opCreateEnvironmentMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEnvironmentMembershipInput{}
	}

	output = &CreateEnvironmentMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEnvironmentMembership API operation for AWS Cloud9.
//
// Adds an environment member to an AWS Cloud9 development environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud9's
// API operation CreateEnvironmentMembership for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The target request is invalid.
//
//   * ErrCodeConflictException "ConflictException"
//   A conflict occurred.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The target resource cannot be found.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   An access permissions issue occurred.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Too many service requests were made over the given time period.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A service limit was exceeded.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal server error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/CreateEnvironmentMembership
func (c *Cloud9) CreateEnvironmentMembership(input *CreateEnvironmentMembershipInput) (*CreateEnvironmentMembershipOutput, error) {
	req, out := c.CreateEnvironmentMembershipRequest(input)
	return out, req.Send()
}

// CreateEnvironmentMembershipWithContext is the same as CreateEnvironmentMembership with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEnvironmentMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Cloud9) CreateEnvironmentMembershipWithContext(ctx aws.Context, input *CreateEnvironmentMembershipInput, opts ...request.Option) (*CreateEnvironmentMembershipOutput, error) {
	req, out := c.CreateEnvironmentMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEnvironment = "DeleteEnvironment"

// DeleteEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEnvironment for more information on using the DeleteEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEnvironmentRequest method.
//    req, resp := client.DeleteEnvironmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DeleteEnvironment
func (c *Cloud9) DeleteEnvironmentRequest(input *DeleteEnvironmentInput) (req *request.Request, output *DeleteEnvironmentOutput) {
	op := &request.Operation{
		Name:       opDeleteEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEnvironmentInput{}
	}

	output = &DeleteEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEnvironment API operation for AWS Cloud9.
//
// Deletes an AWS Cloud9 development environment. If an Amazon EC2 instance
// is connected to the environment, also terminates the instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud9's
// API operation DeleteEnvironment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The target request is invalid.
//
//   * ErrCodeConflictException "ConflictException"
//   A conflict occurred.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The target resource cannot be found.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   An access permissions issue occurred.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Too many service requests were made over the given time period.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A service limit was exceeded.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal server error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DeleteEnvironment
func (c *Cloud9) DeleteEnvironment(input *DeleteEnvironmentInput) (*DeleteEnvironmentOutput, error) {
	req, out := c.DeleteEnvironmentRequest(input)
	return out, req.Send()
}

// DeleteEnvironmentWithContext is the same as DeleteEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Cloud9) DeleteEnvironmentWithContext(ctx aws.Context, input *DeleteEnvironmentInput, opts ...request.Option) (*DeleteEnvironmentOutput, error) {
	req, out := c.DeleteEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEnvironmentMembership = "DeleteEnvironmentMembership"

// DeleteEnvironmentMembershipRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEnvironmentMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEnvironmentMembership for more information on using the DeleteEnvironmentMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEnvironmentMembershipRequest method.
//    req, resp := client.DeleteEnvironmentMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DeleteEnvironmentMembership
func (c *Cloud9) DeleteEnvironmentMembershipRequest(input *DeleteEnvironmentMembershipInput) (req *request.Request, output *DeleteEnvironmentMembershipOutput) {
	op := &request.Operation{
		Name:       opDeleteEnvironmentMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEnvironmentMembershipInput{}
	}

	output = &DeleteEnvironmentMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEnvironmentMembership API operation for AWS Cloud9.
//
// Deletes an environment member from an AWS Cloud9 development environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud9's
// API operation DeleteEnvironmentMembership for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The target request is invalid.
//
//   * ErrCodeConflictException "ConflictException"
//   A conflict occurred.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The target resource cannot be found.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   An access permissions issue occurred.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Too many service requests were made over the given time period.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A service limit was exceeded.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal server error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DeleteEnvironmentMembership
func (c *Cloud9) DeleteEnvironmentMembership(input *DeleteEnvironmentMembershipInput) (*DeleteEnvironmentMembershipOutput, error) {
	req, out := c.DeleteEnvironmentMembershipRequest(input)
	return out, req.Send()
}

// DeleteEnvironmentMembershipWithContext is the same as DeleteEnvironmentMembership with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEnvironmentMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Cloud9) DeleteEnvironmentMembershipWithContext(ctx aws.Context, input *DeleteEnvironmentMembershipInput, opts ...request.Option) (*DeleteEnvironmentMembershipOutput, error) {
	req, out := c.DeleteEnvironmentMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEnvironmentMemberships = "DescribeEnvironmentMemberships"

// DescribeEnvironmentMembershipsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEnvironmentMemberships operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEnvironmentMemberships for more information on using the DescribeEnvironmentMemberships
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEnvironmentMembershipsRequest method.
//    req, resp := client.DescribeEnvironmentMembershipsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DescribeEnvironmentMemberships
func (c *Cloud9) DescribeEnvironmentMembershipsRequest(input *DescribeEnvironmentMembershipsInput) (req *request.Request, output *DescribeEnvironmentMembershipsOutput) {
	op := &request.Operation{
		Name:       opDescribeEnvironmentMemberships,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEnvironmentMembershipsInput{}
	}

	output = &DescribeEnvironmentMembershipsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEnvironmentMemberships API operation for AWS Cloud9.
//
// Gets information about environment members for an AWS Cloud9 development
// environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud9's
// API operation DescribeEnvironmentMemberships for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The target request is invalid.
//
//   * ErrCodeConflictException "ConflictException"
//   A conflict occurred.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The target resource cannot be found.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   An access permissions issue occurred.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Too many service requests were made over the given time period.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A service limit was exceeded.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal server error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DescribeEnvironmentMemberships
func (c *Cloud9) DescribeEnvironmentMemberships(input *DescribeEnvironmentMembershipsInput) (*DescribeEnvironmentMembershipsOutput, error) {
	req, out := c.DescribeEnvironmentMembershipsRequest(input)
	return out, req.Send()
}

// DescribeEnvironmentMembershipsWithContext is the same as DescribeEnvironmentMemberships with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEnvironmentMemberships for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Cloud9) DescribeEnvironmentMembershipsWithContext(ctx aws.Context, input *DescribeEnvironmentMembershipsInput, opts ...request.Option) (*DescribeEnvironmentMembershipsOutput, error) {
	req, out := c.DescribeEnvironmentMembershipsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEnvironmentMembershipsPages iterates over the pages of a DescribeEnvironmentMemberships operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEnvironmentMemberships method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEnvironmentMemberships operation.
//    pageNum := 0
//    err := client.DescribeEnvironmentMembershipsPages(params,
//        func(page *DescribeEnvironmentMembershipsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Cloud9) DescribeEnvironmentMembershipsPages(input *DescribeEnvironmentMembershipsInput, fn func(*DescribeEnvironmentMembershipsOutput, bool) bool) error {
	return c.DescribeEnvironmentMembershipsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEnvironmentMembershipsPagesWithContext same as DescribeEnvironmentMembershipsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Cloud9) DescribeEnvironmentMembershipsPagesWithContext(ctx aws.Context, input *DescribeEnvironmentMembershipsInput, fn func(*DescribeEnvironmentMembershipsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEnvironmentMembershipsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEnvironmentMembershipsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*DescribeEnvironmentMembershipsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opDescribeEnvironmentStatus = "DescribeEnvironmentStatus"

// DescribeEnvironmentStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEnvironmentStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEnvironmentStatus for more information on using the DescribeEnvironmentStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEnvironmentStatusRequest method.
//    req, resp := client.DescribeEnvironmentStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DescribeEnvironmentStatus
func (c *Cloud9) DescribeEnvironmentStatusRequest(input *DescribeEnvironmentStatusInput) (req *request.Request, output *DescribeEnvironmentStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeEnvironmentStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEnvironmentStatusInput{}
	}

	output = &DescribeEnvironmentStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEnvironmentStatus API operation for AWS Cloud9.
//
// Gets status information for an AWS Cloud9 development environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud9's
// API operation DescribeEnvironmentStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The target request is invalid.
//
//   * ErrCodeConflictException "ConflictException"
//   A conflict occurred.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The target resource cannot be found.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   An access permissions issue occurred.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Too many service requests were made over the given time period.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A service limit was exceeded.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal server error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DescribeEnvironmentStatus
func (c *Cloud9) DescribeEnvironmentStatus(input *DescribeEnvironmentStatusInput) (*DescribeEnvironmentStatusOutput, error) {
	req, out := c.DescribeEnvironmentStatusRequest(input)
	return out, req.Send()
}

// DescribeEnvironmentStatusWithContext is the same as DescribeEnvironmentStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEnvironmentStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Cloud9) DescribeEnvironmentStatusWithContext(ctx aws.Context, input *DescribeEnvironmentStatusInput, opts ...request.Option) (*DescribeEnvironmentStatusOutput, error) {
	req, out := c.DescribeEnvironmentStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEnvironments = "DescribeEnvironments"

// DescribeEnvironmentsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEnvironments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEnvironments for more information on using the DescribeEnvironments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEnvironmentsRequest method.
//    req, resp := client.DescribeEnvironmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DescribeEnvironments
func (c *Cloud9) DescribeEnvironmentsRequest(input *DescribeEnvironmentsInput) (req *request.Request, output *DescribeEnvironmentsOutput) {
	op := &request.Operation{
		Name:       opDescribeEnvironments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEnvironmentsInput{}
	}

	output = &DescribeEnvironmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEnvironments API operation for AWS Cloud9.
//
// Gets information about AWS Cloud9 development environments.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud9's
// API operation DescribeEnvironments for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The target request is invalid.
//
//   * ErrCodeConflictException "ConflictException"
//   A conflict occurred.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The target resource cannot be found.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   An access permissions issue occurred.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Too many service requests were made over the given time period.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A service limit was exceeded.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal server error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/DescribeEnvironments
func (c *Cloud9) DescribeEnvironments(input *DescribeEnvironmentsInput) (*DescribeEnvironmentsOutput, error) {
	req, out := c.DescribeEnvironmentsRequest(input)
	return out, req.Send()
}

// DescribeEnvironmentsWithContext is the same as DescribeEnvironments with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEnvironments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Cloud9) DescribeEnvironmentsWithContext(ctx aws.Context, input *DescribeEnvironmentsInput, opts ...request.Option) (*DescribeEnvironmentsOutput, error) {
	req, out := c.DescribeEnvironmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEnvironments = "ListEnvironments"

// ListEnvironmentsRequest generates a "aws/request.Request" representing the
// client's request for the ListEnvironments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEnvironments for more information on using the ListEnvironments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEnvironmentsRequest method.
//    req, resp := client.ListEnvironmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/ListEnvironments
func (c *Cloud9) ListEnvironmentsRequest(input *ListEnvironmentsInput) (req *request.Request, output *ListEnvironmentsOutput) {
	op := &request.Operation{
		Name:       opListEnvironments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEnvironmentsInput{}
	}

	output = &ListEnvironmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEnvironments API operation for AWS Cloud9.
//
// Gets a list of AWS Cloud9 development environment identifiers.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud9's
// API operation ListEnvironments for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The target request is invalid.
//
//   * ErrCodeConflictException "ConflictException"
//   A conflict occurred.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The target resource cannot be found.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   An access permissions issue occurred.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Too many service requests were made over the given time period.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A service limit was exceeded.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal server error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/ListEnvironments
func (c *Cloud9) ListEnvironments(input *ListEnvironmentsInput) (*ListEnvironmentsOutput, error) {
	req, out := c.ListEnvironmentsRequest(input)
	return out, req.Send()
}

// ListEnvironmentsWithContext is the same as ListEnvironments with the addition of
// the ability to pass a context and additional request options.
//
// See ListEnvironments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Cloud9) ListEnvironmentsWithContext(ctx aws.Context, input *ListEnvironmentsInput, opts ...request.Option) (*ListEnvironmentsOutput, error) {
	req, out := c.ListEnvironmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEnvironmentsPages iterates over the pages of a ListEnvironments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEnvironments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListEnvironments operation.
//    pageNum := 0
//    err := client.ListEnvironmentsPages(params,
//        func(page *ListEnvironmentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Cloud9) ListEnvironmentsPages(input *ListEnvironmentsInput, fn func(*ListEnvironmentsOutput, bool) bool) error {
	return c.ListEnvironmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEnvironmentsPagesWithContext same as ListEnvironmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Cloud9) ListEnvironmentsPagesWithContext(ctx aws.Context, input *ListEnvironmentsInput, fn func(*ListEnvironmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEnvironmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEnvironmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	cont := true
	for p.Next() && cont {
		cont = fn(p.Page().(*ListEnvironmentsOutput), !p.HasNextPage())
	}
	return p.Err()
}

const opUpdateEnvironment = "UpdateEnvironment"

// UpdateEnvironmentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEnvironment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEnvironment for more information on using the UpdateEnvironment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEnvironmentRequest method.
//    req, resp := client.UpdateEnvironmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/UpdateEnvironment
func (c *Cloud9) UpdateEnvironmentRequest(input *UpdateEnvironmentInput) (req *request.Request, output *UpdateEnvironmentOutput) {
	op := &request.Operation{
		Name:       opUpdateEnvironment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEnvironmentInput{}
	}

	output = &UpdateEnvironmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEnvironment API operation for AWS Cloud9.
//
// Changes the settings of an existing AWS Cloud9 development environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud9's
// API operation UpdateEnvironment for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The target request is invalid.
//
//   * ErrCodeConflictException "ConflictException"
//   A conflict occurred.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The target resource cannot be found.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   An access permissions issue occurred.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Too many service requests were made over the given time period.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A service limit was exceeded.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal server error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/UpdateEnvironment
func (c *Cloud9) UpdateEnvironment(input *UpdateEnvironmentInput) (*UpdateEnvironmentOutput, error) {
	req, out := c.UpdateEnvironmentRequest(input)
	return out, req.Send()
}

// UpdateEnvironmentWithContext is the same as UpdateEnvironment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEnvironment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Cloud9) UpdateEnvironmentWithContext(ctx aws.Context, input *UpdateEnvironmentInput, opts ...request.Option) (*UpdateEnvironmentOutput, error) {
	req, out := c.UpdateEnvironmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEnvironmentMembership = "UpdateEnvironmentMembership"

// UpdateEnvironmentMembershipRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEnvironmentMembership operation. The "output" return
// value will be populated with the request's response once the request completes
// successfuly.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEnvironmentMembership for more information on using the UpdateEnvironmentMembership
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEnvironmentMembershipRequest method.
//    req, resp := client.UpdateEnvironmentMembershipRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/UpdateEnvironmentMembership
func (c *Cloud9) UpdateEnvironmentMembershipRequest(input *UpdateEnvironmentMembershipInput) (req *request.Request, output *UpdateEnvironmentMembershipOutput) {
	op := &request.Operation{
		Name:       opUpdateEnvironmentMembership,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEnvironmentMembershipInput{}
	}

	output = &UpdateEnvironmentMembershipOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEnvironmentMembership API operation for AWS Cloud9.
//
// Changes the settings of an existing environment member for an AWS Cloud9
// development environment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud9's
// API operation UpdateEnvironmentMembership for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeBadRequestException "BadRequestException"
//   The target request is invalid.
//
//   * ErrCodeConflictException "ConflictException"
//   A conflict occurred.
//
//   * ErrCodeNotFoundException "NotFoundException"
//   The target resource cannot be found.
//
//   * ErrCodeForbiddenException "ForbiddenException"
//   An access permissions issue occurred.
//
//   * ErrCodeTooManyRequestsException "TooManyRequestsException"
//   Too many service requests were made over the given time period.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   A service limit was exceeded.
//
//   * ErrCodeInternalServerErrorException "InternalServerErrorException"
//   An internal server error occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/cloud9-2017-09-23/UpdateEnvironmentMembership
func (c *Cloud9) UpdateEnvironmentMembership(input *UpdateEnvironmentMembershipInput) (*UpdateEnvironmentMembershipOutput, error) {
	req, out := c.UpdateEnvironmentMembershipRequest(input)
	return out, req.Send()
}

// UpdateEnvironmentMembershipWithContext is the same as UpdateEnvironmentMembership with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEnvironmentMembership for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Cloud9) UpdateEnvironmentMembershipWithContext(ctx aws.Context, input *UpdateEnvironmentMembershipInput, opts ...request.Option) (*UpdateEnvironmentMembershipOutput, error) {
	req, out := c.UpdateEnvironmentMembershipRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateEnvironmentEC2Input struct {
	_ struct{} `type:"structure"`

	// The number of minutes until the running instance is shut down after the environment
	// has last been used.
	AutomaticStopTimeMinutes *int64 `locationName:"automaticStopTimeMinutes" type:"integer"`

	// A unique, case-sensitive string that helps AWS Cloud9 to ensure this operation
	// completes no more than one time.
	//
	// For more information, see Client Tokens (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html)
	// in the Amazon EC2 API Reference.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string"`

	// The description of the environment to create.
	Description *string `locationName:"description" type:"string"`

	// The type of instance to connect to the environment (for example, t2.micro).
	//
	// InstanceType is a required field
	InstanceType *string `locationName:"instanceType" min:"5" type:"string" required:"true"`

	// The name of the environment to create.
	//
	// This name is visible to other AWS IAM users in the same AWS account.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the environment owner. This ARN can be
	// the ARN of any AWS IAM principal. If this value is not specified, the ARN
	// defaults to this environment's creator.
	OwnerArn *string `locationName:"ownerArn" type:"string"`

	// The ID of the subnet in Amazon VPC that AWS Cloud9 will use to communicate
	// with the Amazon EC2 instance.
	SubnetId *string `locationName:"subnetId" min:"5" type:"string"`
}

// String returns the string representation
func (s CreateEnvironmentEC2Input) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEnvironmentEC2Input) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEnvironmentEC2Input) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEnvironmentEC2Input"}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.InstanceType != nil && len(*s.InstanceType) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceType", 5))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SubnetId != nil && len(*s.SubnetId) < 5 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetId", 5))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutomaticStopTimeMinutes sets the AutomaticStopTimeMinutes field's value.
func (s *CreateEnvironmentEC2Input) SetAutomaticStopTimeMinutes(v int64) *CreateEnvironmentEC2Input {
	s.AutomaticStopTimeMinutes = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateEnvironmentEC2Input) SetClientRequestToken(v string) *CreateEnvironmentEC2Input {
	s.ClientRequestToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateEnvironmentEC2Input) SetDescription(v string) *CreateEnvironmentEC2Input {
	s.Description = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *CreateEnvironmentEC2Input) SetInstanceType(v string) *CreateEnvironmentEC2Input {
	s.InstanceType = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEnvironmentEC2Input) SetName(v string) *CreateEnvironmentEC2Input {
	s.Name = &v
	return s
}

// SetOwnerArn sets the OwnerArn field's value.
func (s *CreateEnvironmentEC2Input) SetOwnerArn(v string) *CreateEnvironmentEC2Input {
	s.OwnerArn = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *CreateEnvironmentEC2Input) SetSubnetId(v string) *CreateEnvironmentEC2Input {
	s.SubnetId = &v
	return s
}

type CreateEnvironmentEC2Output struct {
	_ struct{} `type:"structure"`

	// The ID of the environment that was created.
	EnvironmentId *string `locationName:"environmentId" type:"string"`
}

// String returns the string representation
func (s CreateEnvironmentEC2Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEnvironmentEC2Output) GoString() string {
	return s.String()
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateEnvironmentEC2Output) SetEnvironmentId(v string) *CreateEnvironmentEC2Output {
	s.EnvironmentId = &v
	return s
}

type CreateEnvironmentMembershipInput struct {
	_ struct{} `type:"structure"`

	// The ID of the environment that contains the environment member you want to
	// add.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`

	// The type of environment member permissions you want to associate with this
	// environment member. Available values include:
	//
	//    * read-only: Has read-only access to the environment.
	//
	//    * read-write: Has read-write access to the environment.
	//
	// Permissions is a required field
	Permissions *string `locationName:"permissions" type:"string" required:"true" enum:"MemberPermissions"`

	// The Amazon Resource Name (ARN) of the environment member you want to add.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateEnvironmentMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEnvironmentMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEnvironmentMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEnvironmentMembershipInput"}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.Permissions == nil {
		invalidParams.Add(request.NewErrParamRequired("Permissions"))
	}
	if s.UserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *CreateEnvironmentMembershipInput) SetEnvironmentId(v string) *CreateEnvironmentMembershipInput {
	s.EnvironmentId = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateEnvironmentMembershipInput) SetPermissions(v string) *CreateEnvironmentMembershipInput {
	s.Permissions = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *CreateEnvironmentMembershipInput) SetUserArn(v string) *CreateEnvironmentMembershipInput {
	s.UserArn = &v
	return s
}

type CreateEnvironmentMembershipOutput struct {
	_ struct{} `type:"structure"`

	// Information about the environment member that was added.
	Membership *EnvironmentMember `locationName:"membership" type:"structure"`
}

// String returns the string representation
func (s CreateEnvironmentMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEnvironmentMembershipOutput) GoString() string {
	return s.String()
}

// SetMembership sets the Membership field's value.
func (s *CreateEnvironmentMembershipOutput) SetMembership(v *EnvironmentMember) *CreateEnvironmentMembershipOutput {
	s.Membership = v
	return s
}

type DeleteEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// The ID of the environment to delete.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEnvironmentInput"}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DeleteEnvironmentInput) SetEnvironmentId(v string) *DeleteEnvironmentInput {
	s.EnvironmentId = &v
	return s
}

type DeleteEnvironmentMembershipInput struct {
	_ struct{} `type:"structure"`

	// The ID of the environment to delete the environment member from.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the environment member to delete from the
	// environment.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEnvironmentMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEnvironmentMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEnvironmentMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEnvironmentMembershipInput"}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.UserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DeleteEnvironmentMembershipInput) SetEnvironmentId(v string) *DeleteEnvironmentMembershipInput {
	s.EnvironmentId = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *DeleteEnvironmentMembershipInput) SetUserArn(v string) *DeleteEnvironmentMembershipInput {
	s.UserArn = &v
	return s
}

type DeleteEnvironmentMembershipOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEnvironmentMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEnvironmentMembershipOutput) GoString() string {
	return s.String()
}

type DeleteEnvironmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEnvironmentOutput) GoString() string {
	return s.String()
}

type DescribeEnvironmentMembershipsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the environment to get environment member information about.
	EnvironmentId *string `locationName:"environmentId" type:"string"`

	// The maximum number of environment members to get information about.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// During a previous call, if there are more than 25 items in the list, only
	// the first 25 items are returned, along with a unique string called a next
	// token. To get the next batch of items in the list, call this operation again,
	// adding the next token to the call. To get all of the items in the list, keep
	// calling this operation with each subsequent next token that is returned,
	// until no more next tokens are returned.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The type of environment member permissions to get information about. Available
	// values include:
	//
	//    * owner: Owns the environment.
	//
	//    * read-only: Has read-only access to the environment.
	//
	//    * read-write: Has read-write access to the environment.
	//
	// If no value is specified, information about all environment members are returned.
	Permissions []*string `locationName:"permissions" type:"list"`

	// The Amazon Resource Name (ARN) of an individual environment member to get
	// information about. If no value is specified, information about all environment
	// members are returned.
	UserArn *string `locationName:"userArn" type:"string"`
}

// String returns the string representation
func (s DescribeEnvironmentMembershipsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentMembershipsInput) GoString() string {
	return s.String()
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DescribeEnvironmentMembershipsInput) SetEnvironmentId(v string) *DescribeEnvironmentMembershipsInput {
	s.EnvironmentId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeEnvironmentMembershipsInput) SetMaxResults(v int64) *DescribeEnvironmentMembershipsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEnvironmentMembershipsInput) SetNextToken(v string) *DescribeEnvironmentMembershipsInput {
	s.NextToken = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *DescribeEnvironmentMembershipsInput) SetPermissions(v []*string) *DescribeEnvironmentMembershipsInput {
	s.Permissions = v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *DescribeEnvironmentMembershipsInput) SetUserArn(v string) *DescribeEnvironmentMembershipsInput {
	s.UserArn = &v
	return s
}

type DescribeEnvironmentMembershipsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the environment members for the environment.
	Memberships []*EnvironmentMember `locationName:"memberships" type:"list"`

	// If there are more than 25 items in the list, only the first 25 items are
	// returned, along with a unique string called a next token. To get the next
	// batch of items in the list, call this operation again, adding the next token
	// to the call.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s DescribeEnvironmentMembershipsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentMembershipsOutput) GoString() string {
	return s.String()
}

// SetMemberships sets the Memberships field's value.
func (s *DescribeEnvironmentMembershipsOutput) SetMemberships(v []*EnvironmentMember) *DescribeEnvironmentMembershipsOutput {
	s.Memberships = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEnvironmentMembershipsOutput) SetNextToken(v string) *DescribeEnvironmentMembershipsOutput {
	s.NextToken = &v
	return s
}

type DescribeEnvironmentStatusInput struct {
	_ struct{} `type:"structure"`

	// The ID of the environment to get status information about.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeEnvironmentStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEnvironmentStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEnvironmentStatusInput"}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *DescribeEnvironmentStatusInput) SetEnvironmentId(v string) *DescribeEnvironmentStatusInput {
	s.EnvironmentId = &v
	return s
}

type DescribeEnvironmentStatusOutput struct {
	_ struct{} `type:"structure"`

	// Any informational message about the status of the environment.
	Message *string `locationName:"message" type:"string"`

	// The status of the environment. Available values include:
	//
	//    * connecting: The environment is connecting.
	//
	//    * creating: The environment is being created.
	//
	//    * deleting: The environment is being deleted.
	//
	//    * error: The environment is in an error state.
	//
	//    * ready: The environment is ready.
	//
	//    * stopped: The environment is stopped.
	//
	//    * stopping: The environment is stopping.
	Status *string `locationName:"status" type:"string" enum:"EnvironmentStatus"`
}

// String returns the string representation
func (s DescribeEnvironmentStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentStatusOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *DescribeEnvironmentStatusOutput) SetMessage(v string) *DescribeEnvironmentStatusOutput {
	s.Message = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeEnvironmentStatusOutput) SetStatus(v string) *DescribeEnvironmentStatusOutput {
	s.Status = &v
	return s
}

type DescribeEnvironmentsInput struct {
	_ struct{} `type:"structure"`

	// The IDs of individual environments to get information about.
	//
	// EnvironmentIds is a required field
	EnvironmentIds []*string `locationName:"environmentIds" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeEnvironmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEnvironmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEnvironmentsInput"}
	if s.EnvironmentIds == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentIds"))
	}
	if s.EnvironmentIds != nil && len(s.EnvironmentIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EnvironmentIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentIds sets the EnvironmentIds field's value.
func (s *DescribeEnvironmentsInput) SetEnvironmentIds(v []*string) *DescribeEnvironmentsInput {
	s.EnvironmentIds = v
	return s
}

type DescribeEnvironmentsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the environments that are returned.
	Environments []*Environment `locationName:"environments" type:"list"`
}

// String returns the string representation
func (s DescribeEnvironmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEnvironmentsOutput) GoString() string {
	return s.String()
}

// SetEnvironments sets the Environments field's value.
func (s *DescribeEnvironmentsOutput) SetEnvironments(v []*Environment) *DescribeEnvironmentsOutput {
	s.Environments = v
	return s
}

// Information about an AWS Cloud9 development environment.
type Environment struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the environment.
	Arn *string `locationName:"arn" type:"string"`

	// The description for the environment.
	Description *string `locationName:"description" type:"string"`

	// The ID of the environment.
	Id *string `locationName:"id" type:"string"`

	// The name of the environment.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the environment owner.
	OwnerArn *string `locationName:"ownerArn" type:"string"`

	// The type of environment. Valid values include the following:
	//
	//    * ec2: An Amazon Elastic Compute Cloud (Amazon EC2) instance connects
	//    to the environment.
	//
	//    * ssh: Your own server connects to the environment.
	Type *string `locationName:"type" type:"string" enum:"EnvironmentType"`
}

// String returns the string representation
func (s Environment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Environment) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Environment) SetArn(v string) *Environment {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Environment) SetDescription(v string) *Environment {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Environment) SetId(v string) *Environment {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Environment) SetName(v string) *Environment {
	s.Name = &v
	return s
}

// SetOwnerArn sets the OwnerArn field's value.
func (s *Environment) SetOwnerArn(v string) *Environment {
	s.OwnerArn = &v
	return s
}

// SetType sets the Type field's value.
func (s *Environment) SetType(v string) *Environment {
	s.Type = &v
	return s
}

// Information about an environment member for an AWS Cloud9 development environment.
type EnvironmentMember struct {
	_ struct{} `type:"structure"`

	// The ID of the environment for the environment member.
	EnvironmentId *string `locationName:"environmentId" type:"string"`

	// The time, expressed in epoch time format, when the environment member last
	// opened the environment.
	LastAccess *time.Time `locationName:"lastAccess" type:"timestamp" timestampFormat:"unix"`

	// The type of environment member permissions associated with this environment
	// member. Available values include:
	//
	//    * owner: Owns the environment.
	//
	//    * read-only: Has read-only access to the environment.
	//
	//    * read-write: Has read-write access to the environment.
	Permissions *string `locationName:"permissions" type:"string" enum:"Permissions"`

	// The Amazon Resource Name (ARN) of the environment member.
	UserArn *string `locationName:"userArn" type:"string"`

	// The user ID in AWS Identity and Access Management (AWS IAM) of the environment
	// member.
	UserId *string `locationName:"userId" type:"string"`
}

// String returns the string representation
func (s EnvironmentMember) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvironmentMember) GoString() string {
	return s.String()
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *EnvironmentMember) SetEnvironmentId(v string) *EnvironmentMember {
	s.EnvironmentId = &v
	return s
}

// SetLastAccess sets the LastAccess field's value.
func (s *EnvironmentMember) SetLastAccess(v time.Time) *EnvironmentMember {
	s.LastAccess = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *EnvironmentMember) SetPermissions(v string) *EnvironmentMember {
	s.Permissions = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *EnvironmentMember) SetUserArn(v string) *EnvironmentMember {
	s.UserArn = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *EnvironmentMember) SetUserId(v string) *EnvironmentMember {
	s.UserId = &v
	return s
}

type ListEnvironmentsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of environments to get identifiers for.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// During a previous call, if there are more than 25 items in the list, only
	// the first 25 items are returned, along with a unique string called a next
	// token. To get the next batch of items in the list, call this operation again,
	// adding the next token to the call. To get all of the items in the list, keep
	// calling this operation with each subsequent next token that is returned,
	// until no more next tokens are returned.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListEnvironmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEnvironmentsInput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEnvironmentsInput) SetMaxResults(v int64) *ListEnvironmentsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentsInput) SetNextToken(v string) *ListEnvironmentsInput {
	s.NextToken = &v
	return s
}

type ListEnvironmentsOutput struct {
	_ struct{} `type:"structure"`

	// The list of environment identifiers.
	EnvironmentIds []*string `locationName:"environmentIds" type:"list"`

	// If there are more than 25 items in the list, only the first 25 items are
	// returned, along with a unique string called a next token. To get the next
	// batch of items in the list, call this operation again, adding the next token
	// to the call.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListEnvironmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEnvironmentsOutput) GoString() string {
	return s.String()
}

// SetEnvironmentIds sets the EnvironmentIds field's value.
func (s *ListEnvironmentsOutput) SetEnvironmentIds(v []*string) *ListEnvironmentsOutput {
	s.EnvironmentIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEnvironmentsOutput) SetNextToken(v string) *ListEnvironmentsOutput {
	s.NextToken = &v
	return s
}

type UpdateEnvironmentInput struct {
	_ struct{} `type:"structure"`

	// Any new or replacement description for the environment.
	Description *string `locationName:"description" type:"string"`

	// The ID of the environment to change settings.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`

	// A replacement name for the environment.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateEnvironmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEnvironmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEnvironmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEnvironmentInput"}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateEnvironmentInput) SetDescription(v string) *UpdateEnvironmentInput {
	s.Description = &v
	return s
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateEnvironmentInput) SetEnvironmentId(v string) *UpdateEnvironmentInput {
	s.EnvironmentId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateEnvironmentInput) SetName(v string) *UpdateEnvironmentInput {
	s.Name = &v
	return s
}

type UpdateEnvironmentMembershipInput struct {
	_ struct{} `type:"structure"`

	// The ID of the environment for the environment member whose settings you want
	// to change.
	//
	// EnvironmentId is a required field
	EnvironmentId *string `locationName:"environmentId" type:"string" required:"true"`

	// The replacement type of environment member permissions you want to associate
	// with this environment member. Available values include:
	//
	//    * read-only: Has read-only access to the environment.
	//
	//    * read-write: Has read-write access to the environment.
	//
	// Permissions is a required field
	Permissions *string `locationName:"permissions" type:"string" required:"true" enum:"MemberPermissions"`

	// The Amazon Resource Name (ARN) of the environment member whose settings you
	// want to change.
	//
	// UserArn is a required field
	UserArn *string `locationName:"userArn" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateEnvironmentMembershipInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEnvironmentMembershipInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEnvironmentMembershipInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEnvironmentMembershipInput"}
	if s.EnvironmentId == nil {
		invalidParams.Add(request.NewErrParamRequired("EnvironmentId"))
	}
	if s.Permissions == nil {
		invalidParams.Add(request.NewErrParamRequired("Permissions"))
	}
	if s.UserArn == nil {
		invalidParams.Add(request.NewErrParamRequired("UserArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentId sets the EnvironmentId field's value.
func (s *UpdateEnvironmentMembershipInput) SetEnvironmentId(v string) *UpdateEnvironmentMembershipInput {
	s.EnvironmentId = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *UpdateEnvironmentMembershipInput) SetPermissions(v string) *UpdateEnvironmentMembershipInput {
	s.Permissions = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *UpdateEnvironmentMembershipInput) SetUserArn(v string) *UpdateEnvironmentMembershipInput {
	s.UserArn = &v
	return s
}

type UpdateEnvironmentMembershipOutput struct {
	_ struct{} `type:"structure"`

	// Information about the environment member whose settings were changed.
	Membership *EnvironmentMember `locationName:"membership" type:"structure"`
}

// String returns the string representation
func (s UpdateEnvironmentMembershipOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEnvironmentMembershipOutput) GoString() string {
	return s.String()
}

// SetMembership sets the Membership field's value.
func (s *UpdateEnvironmentMembershipOutput) SetMembership(v *EnvironmentMember) *UpdateEnvironmentMembershipOutput {
	s.Membership = v
	return s
}

type UpdateEnvironmentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateEnvironmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEnvironmentOutput) GoString() string {
	return s.String()
}

const (
	// EnvironmentStatusError is a EnvironmentStatus enum value
	EnvironmentStatusError = "error"

	// EnvironmentStatusCreating is a EnvironmentStatus enum value
	EnvironmentStatusCreating = "creating"

	// EnvironmentStatusConnecting is a EnvironmentStatus enum value
	EnvironmentStatusConnecting = "connecting"

	// EnvironmentStatusReady is a EnvironmentStatus enum value
	EnvironmentStatusReady = "ready"

	// EnvironmentStatusStopping is a EnvironmentStatus enum value
	EnvironmentStatusStopping = "stopping"

	// EnvironmentStatusStopped is a EnvironmentStatus enum value
	EnvironmentStatusStopped = "stopped"

	// EnvironmentStatusDeleting is a EnvironmentStatus enum value
	EnvironmentStatusDeleting = "deleting"
)

const (
	// EnvironmentTypeSsh is a EnvironmentType enum value
	EnvironmentTypeSsh = "ssh"

	// EnvironmentTypeEc2 is a EnvironmentType enum value
	EnvironmentTypeEc2 = "ec2"
)

const (
	// MemberPermissionsReadWrite is a MemberPermissions enum value
	MemberPermissionsReadWrite = "read-write"

	// MemberPermissionsReadOnly is a MemberPermissions enum value
	MemberPermissionsReadOnly = "read-only"
)

const (
	// PermissionsOwner is a Permissions enum value
	PermissionsOwner = "owner"

	// PermissionsReadWrite is a Permissions enum value
	PermissionsReadWrite = "read-write"

	// PermissionsReadOnly is a Permissions enum value
	PermissionsReadOnly = "read-only"
)
