# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class Create(AAZCommand):
    """Create a load balancer.

    :example: Create a basic load balancer.
        az network lb create -g MyResourceGroup -n MyLb --sku Basic

    :example: Create a basic load balancer on a specific virtual network and subnet If a virtual network with the same name is found in the same resource group, the load balancer will utilize this virtual network.  If one is not found a new one will be created.
        az network lb create -g MyResourceGroup -n MyLb --sku Basic --vnet-name MyVnet --subnet MySubnet

    :example: Create a basic load balancer on a subnet of a pre-existing virtual network. The subnet can be in arbitary resource group or subscription by providing the ID of the subnet.
        az network lb create -g MyResourceGroup -n MyLb --sku Basic --subnet {subnetID}

    :example: Create a basic zone flavored internal load balancer, through provisioning a zonal public ip.
        az network lb create -g MyResourceGroup -n MyLb --sku Basic --public-ip-zone 2

    :example: Create a standard zone flavored public-facing load balancer, through provisioning a zonal frontend ip configuration and Vnet.
        az etwork lb create -g MyResourceGroup -n MyLb --sku Standard --frontend-ip-zone 1 --vnet-name MyVnet --subnet MySubnet
    """

    _aaz_info = {
        "version": "2022-05-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/loadbalancers/{}", "2022-05-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="The load balancer name.",
            required=True,
            id_part="name",
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )

        # define Arg Group "Parameters"

        _args_schema = cls._args_schema
        _args_schema.extended_location = AAZObjectArg(
            options=["--extended-location"],
            arg_group="Parameters",
            help="The extended location of the load balancer.",
        )
        cls._build_args_extended_location_create(_args_schema.extended_location)
        _args_schema.id = AAZResourceIdArg(
            options=["--id"],
            arg_group="Parameters",
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/loadBalancers/{}",
            ),
        )
        _args_schema.location = AAZResourceLocationArg(
            arg_group="Parameters",
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _args_schema.sku = AAZObjectArg(
            options=["--sku"],
            arg_group="Parameters",
            help="The load balancer SKU.",
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            arg_group="Parameters",
            help="Resource tags.",
        )

        sku = cls._args_schema.sku
        sku.name = AAZStrArg(
            options=["name"],
            help="Name of a load balancer SKU.",
            enum={"Basic": "Basic", "Gateway": "Gateway", "Standard": "Standard"},
        )
        sku.tier = AAZStrArg(
            options=["tier"],
            help="Tier of a load balancer SKU.",
            enum={"Global": "Global", "Regional": "Regional"},
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg()

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.backend_address_pools = AAZListArg(
            options=["--backend-address-pools"],
            arg_group="Properties",
            help="Collection of backend address pools used by a load balancer.",
        )
        _args_schema.frontend_ip_configurations = AAZListArg(
            options=["--frontend-ip-configurations"],
            arg_group="Properties",
            help="Object representing the frontend IPs to be used for the load balancer.",
        )
        _args_schema.inbound_nat_pools = AAZListArg(
            options=["--inbound-nat-pools"],
            arg_group="Properties",
            help="Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.",
        )
        _args_schema.inbound_nat_rules = AAZListArg(
            options=["--inbound-nat-rules"],
            arg_group="Properties",
            help="Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.",
        )
        _args_schema.load_balancing_rules = AAZListArg(
            options=["--load-balancing-rules"],
            arg_group="Properties",
            help="Object collection representing the load balancing rules Gets the provisioning.",
        )
        _args_schema.outbound_rules = AAZListArg(
            options=["--outbound-rules"],
            arg_group="Properties",
            help="The outbound rules.",
        )
        _args_schema.probes = AAZListArg(
            options=["--probes"],
            arg_group="Properties",
            help="Collection of probe objects used in the load balancer.",
        )

        backend_address_pools = cls._args_schema.backend_address_pools
        backend_address_pools.Element = AAZObjectArg()

        _element = cls._args_schema.backend_address_pools.Element
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/loadBalancers/{}/backendAddressPools/{}",
            ),
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within the set of backend address pools used by the load balancer. This name can be used to access the resource.",
        )
        _element.drain_period_in_seconds = AAZIntArg(
            options=["drain-period-in-seconds"],
            help="Amount of seconds Load Balancer waits for before sending RESET to client and backend address.",
        )
        _element.load_balancer_backend_addresses = AAZListArg(
            options=["load-balancer-backend-addresses"],
            help="An array of backend addresses.",
        )
        _element.location = AAZStrArg(
            options=["location"],
            help="The location of the backend address pool.",
        )
        _element.tunnel_interfaces = AAZListArg(
            options=["tunnel-interfaces"],
            help="An array of gateway load balancer tunnel interfaces.",
        )

        load_balancer_backend_addresses = cls._args_schema.backend_address_pools.Element.load_balancer_backend_addresses
        load_balancer_backend_addresses.Element = AAZObjectArg()

        _element = cls._args_schema.backend_address_pools.Element.load_balancer_backend_addresses.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the backend address.",
        )
        _element.admin_state = AAZStrArg(
            options=["admin-state"],
            help="A list of administrative states which once set can override health probe so that Load Balancer will always forward new connections to backend, or deny new connections and reset existing connections.",
            enum={"Down": "Down", "Drain": "Drain", "None": "None", "Up": "Up"},
        )
        _element.ip_address = AAZStrArg(
            options=["ip-address"],
            help="IP Address belonging to the referenced virtual network.",
        )
        _element.load_balancer_frontend_ip_configuration = AAZObjectArg(
            options=["load-balancer-frontend-ip-configuration"],
            help="Reference to the frontend ip address configuration defined in regional loadbalancer.",
        )
        cls._build_args_sub_resource_create(_element.load_balancer_frontend_ip_configuration)
        _element.subnet = AAZObjectArg(
            options=["subnet"],
            help="Reference to an existing subnet.",
        )
        cls._build_args_sub_resource_create(_element.subnet)
        _element.virtual_network = AAZObjectArg(
            options=["virtual-network"],
            help="Reference to an existing virtual network.",
        )
        cls._build_args_sub_resource_create(_element.virtual_network)

        tunnel_interfaces = cls._args_schema.backend_address_pools.Element.tunnel_interfaces
        tunnel_interfaces.Element = AAZObjectArg()

        _element = cls._args_schema.backend_address_pools.Element.tunnel_interfaces.Element
        _element.identifier = AAZIntArg(
            options=["identifier"],
            help="Identifier of gateway load balancer tunnel interface.",
        )
        _element.port = AAZIntArg(
            options=["port"],
            help="Port of gateway load balancer tunnel interface.",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="Protocol of gateway load balancer tunnel interface.",
            enum={"Native": "Native", "None": "None", "VXLAN": "VXLAN"},
        )
        _element.type = AAZStrArg(
            options=["type"],
            help="Traffic type of gateway load balancer tunnel interface.",
            enum={"External": "External", "Internal": "Internal", "None": "None"},
        )

        frontend_ip_configurations = cls._args_schema.frontend_ip_configurations
        frontend_ip_configurations.Element = AAZObjectArg()

        _element = cls._args_schema.frontend_ip_configurations.Element
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/loadBalancers/{}/frontendIPConfigurations/{}",
            ),
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within the set of frontend IP configurations used by the load balancer. This name can be used to access the resource.",
        )
        _element.gateway_load_balancer = AAZObjectArg(
            options=["gateway-load-balancer"],
            help="The reference to gateway load balancer frontend IP.",
        )
        cls._build_args_sub_resource_create(_element.gateway_load_balancer)
        _element.private_ip_address = AAZStrArg(
            options=["private-ip-address"],
            help="The private IP address of the IP configuration.",
        )
        _element.private_ip_address_version = AAZStrArg(
            options=["private-ip-address-version"],
            help="Whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.",
            enum={"IPv4": "IPv4", "IPv6": "IPv6"},
        )
        _element.private_ip_allocation_method = AAZStrArg(
            options=["private-ip-allocation-method"],
            help="The Private IP allocation method.",
            enum={"Dynamic": "Dynamic", "Static": "Static"},
        )
        _element.public_ip_address = AAZObjectArg(
            options=["public-ip-address"],
            help="The reference to the Public IP resource.",
        )
        _element.public_ip_prefix = AAZObjectArg(
            options=["public-ip-prefix"],
            help="The reference to the Public IP Prefix resource.",
        )
        cls._build_args_sub_resource_create(_element.public_ip_prefix)
        _element.subnet = AAZObjectArg(
            options=["subnet"],
            help="The reference to the subnet resource.",
        )
        _element.zones = AAZListArg(
            options=["zones"],
            help="A list of availability zones denoting the IP allocated for the resource needs to come from.",
        )

        public_ip_address = cls._args_schema.frontend_ip_configurations.Element.public_ip_address
        public_ip_address.extended_location = AAZObjectArg(
            options=["extended-location"],
            help="The extended location of the public ip address.",
        )
        cls._build_args_extended_location_create(public_ip_address.extended_location)
        public_ip_address.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/publicIPAddresses/{}",
            ),
        )
        public_ip_address.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        public_ip_address.ddos_settings = AAZObjectArg(
            options=["ddos-settings"],
            help="The DDoS protection custom policy associated with the public IP address.",
        )
        public_ip_address.delete_option = AAZStrArg(
            options=["delete-option"],
            help="Specify what happens to the public IP address when the VM using it is deleted",
            enum={"Delete": "Delete", "Detach": "Detach"},
        )
        public_ip_address.dns_settings = AAZObjectArg(
            options=["dns-settings"],
            help="The FQDN of the DNS record associated with the public IP address.",
        )
        public_ip_address.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout-in-minutes"],
            help="The idle timeout of the public IP address.",
        )
        public_ip_address.ip_address = AAZStrArg(
            options=["ip-address"],
            help="The IP address associated with the public IP address resource.",
        )
        public_ip_address.ip_tags = AAZListArg(
            options=["ip-tags"],
            help="The list of tags associated with the public IP address.",
        )
        public_ip_address.migration_phase = AAZStrArg(
            options=["migration-phase"],
            help="Migration phase of Public IP Address.",
            enum={"Abort": "Abort", "Commit": "Commit", "Committed": "Committed", "None": "None", "Prepare": "Prepare"},
        )
        public_ip_address.nat_gateway = AAZObjectArg(
            options=["nat-gateway"],
            help="The NatGateway for the Public IP address.",
        )
        public_ip_address.public_ip_address_version = AAZStrArg(
            options=["public-ip-address-version"],
            help="The public IP address version.",
            enum={"IPv4": "IPv4", "IPv6": "IPv6"},
        )
        public_ip_address.public_ip_allocation_method = AAZStrArg(
            options=["public-ip-allocation-method"],
            help="The public IP address allocation method.",
            enum={"Dynamic": "Dynamic", "Static": "Static"},
        )
        public_ip_address.public_ip_prefix = AAZObjectArg(
            options=["public-ip-prefix"],
            help="The Public IP Prefix this Public IP Address should be allocated from.",
        )
        public_ip_address.sku = AAZObjectArg(
            options=["sku"],
            help="The public IP address SKU.",
        )
        public_ip_address.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )
        public_ip_address.zones = AAZListArg(
            options=["zones"],
            help="A list of availability zones denoting the IP allocated for the resource needs to come from.",
        )

        ddos_settings = cls._args_schema.frontend_ip_configurations.Element.public_ip_address.ddos_settings
        ddos_settings.ddos_protection_plan = AAZObjectArg(
            options=["ddos-protection-plan"],
            help="The DDoS protection plan associated with the public IP. Can only be set if ProtectionMode is Enabled",
        )
        ddos_settings.protection_mode = AAZStrArg(
            options=["protection-mode"],
            help="The DDoS protection mode of the public IP",
            enum={"Disabled": "Disabled", "Enabled": "Enabled", "VirtualNetworkInherited": "VirtualNetworkInherited"},
        )

        ddos_protection_plan = cls._args_schema.frontend_ip_configurations.Element.public_ip_address.ddos_settings.ddos_protection_plan
        ddos_protection_plan.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )

        dns_settings = cls._args_schema.frontend_ip_configurations.Element.public_ip_address.dns_settings
        dns_settings.domain_name_label = AAZStrArg(
            options=["domain-name-label"],
            help="The domain name label. The concatenation of the domain name label and the regionalized DNS zone make up the fully qualified domain name associated with the public IP address. If a domain name label is specified, an A DNS record is created for the public IP in the Microsoft Azure DNS system.",
        )
        dns_settings.fqdn = AAZStrArg(
            options=["fqdn"],
            help="The Fully Qualified Domain Name of the A DNS record associated with the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.",
        )
        dns_settings.reverse_fqdn = AAZStrArg(
            options=["reverse-fqdn"],
            help="The reverse FQDN. A user-visible, fully qualified domain name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.",
        )

        ip_tags = cls._args_schema.frontend_ip_configurations.Element.public_ip_address.ip_tags
        ip_tags.Element = AAZObjectArg()

        _element = cls._args_schema.frontend_ip_configurations.Element.public_ip_address.ip_tags.Element
        _element.ip_tag_type = AAZStrArg(
            options=["ip-tag-type"],
            help="The IP tag type. Example: FirstPartyUsage.",
        )
        _element.tag = AAZStrArg(
            options=["tag"],
            help="The value of the IP tag associated with the public IP. Example: SQL.",
        )

        nat_gateway = cls._args_schema.frontend_ip_configurations.Element.public_ip_address.nat_gateway
        nat_gateway.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/natGateways/{}",
            ),
        )
        nat_gateway.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        nat_gateway.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout-in-minutes"],
            help="The idle timeout of the nat gateway.",
        )
        nat_gateway.public_ip_addresses = AAZListArg(
            options=["public-ip-addresses"],
            help="An array of public ip addresses associated with the nat gateway resource.",
        )
        nat_gateway.public_ip_prefixes = AAZListArg(
            options=["public-ip-prefixes"],
            help="An array of public ip prefixes associated with the nat gateway resource.",
        )
        nat_gateway.sku = AAZObjectArg(
            options=["sku"],
            help="The nat gateway SKU.",
        )
        nat_gateway.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )
        nat_gateway.zones = AAZListArg(
            options=["zones"],
            help="A list of availability zones denoting the zone in which Nat Gateway should be deployed.",
        )

        public_ip_addresses = cls._args_schema.frontend_ip_configurations.Element.public_ip_address.nat_gateway.public_ip_addresses
        public_ip_addresses.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(public_ip_addresses.Element)

        public_ip_prefixes = cls._args_schema.frontend_ip_configurations.Element.public_ip_address.nat_gateway.public_ip_prefixes
        public_ip_prefixes.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(public_ip_prefixes.Element)

        sku = cls._args_schema.frontend_ip_configurations.Element.public_ip_address.nat_gateway.sku
        sku.name = AAZStrArg(
            options=["name"],
            help="Name of Nat Gateway SKU.",
            enum={"Standard": "Standard"},
        )

        tags = cls._args_schema.frontend_ip_configurations.Element.public_ip_address.nat_gateway.tags
        tags.Element = AAZStrArg()

        zones = cls._args_schema.frontend_ip_configurations.Element.public_ip_address.nat_gateway.zones
        zones.Element = AAZStrArg()

        public_ip_prefix = cls._args_schema.frontend_ip_configurations.Element.public_ip_address.public_ip_prefix
        public_ip_prefix.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )

        sku = cls._args_schema.frontend_ip_configurations.Element.public_ip_address.sku
        sku.name = AAZStrArg(
            options=["name"],
            help="Name of a public IP address SKU.",
            enum={"Basic": "Basic", "Standard": "Standard"},
        )
        sku.tier = AAZStrArg(
            options=["tier"],
            help="Tier of a public IP address SKU.",
            enum={"Global": "Global", "Regional": "Regional"},
        )

        tags = cls._args_schema.frontend_ip_configurations.Element.public_ip_address.tags
        tags.Element = AAZStrArg()

        zones = cls._args_schema.frontend_ip_configurations.Element.public_ip_address.zones
        zones.Element = AAZStrArg()

        subnet = cls._args_schema.frontend_ip_configurations.Element.subnet
        subnet.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/virtualNetworks/{}/subnets/{}",
            ),
        )
        subnet.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        subnet.address_prefix = AAZStrArg(
            options=["address-prefix"],
            help="The address prefix for the subnet.",
        )
        subnet.address_prefixes = AAZListArg(
            options=["address-prefixes"],
            help="List of address prefixes for the subnet.",
        )
        subnet.application_gateway_ip_configurations = AAZListArg(
            options=["application-gateway-ip-configurations"],
            help="Application gateway IP configurations of virtual network resource.",
        )
        subnet.delegations = AAZListArg(
            options=["delegations"],
            help="An array of references to the delegations on the subnet.",
        )
        subnet.ip_allocations = AAZListArg(
            options=["ip-allocations"],
            help="Array of IpAllocation which reference this subnet.",
        )
        subnet.nat_gateway = AAZObjectArg(
            options=["nat-gateway"],
            help="Nat gateway associated with this subnet.",
        )
        cls._build_args_sub_resource_create(subnet.nat_gateway)
        subnet.network_security_group = AAZObjectArg(
            options=["network-security-group"],
            help="The reference to the NetworkSecurityGroup resource.",
        )
        subnet.private_endpoint_network_policies = AAZStrArg(
            options=["private-endpoint-network-policies"],
            help="Enable or Disable apply network policies on private end point in the subnet.",
            default="Disabled",
            enum={"Disabled": "Disabled", "Enabled": "Enabled"},
        )
        subnet.private_link_service_network_policies = AAZStrArg(
            options=["private-link-service-network-policies"],
            help="Enable or Disable apply network policies on private link service in the subnet.",
            default="Enabled",
            enum={"Disabled": "Disabled", "Enabled": "Enabled"},
        )
        subnet.route_table = AAZObjectArg(
            options=["route-table"],
            help="The reference to the RouteTable resource.",
        )
        subnet.service_endpoint_policies = AAZListArg(
            options=["service-endpoint-policies"],
            help="An array of service endpoint policies.",
        )
        subnet.service_endpoints = AAZListArg(
            options=["service-endpoints"],
            help="An array of service endpoints.",
        )
        subnet.type = AAZStrArg(
            options=["type"],
            help="Resource type.",
        )

        address_prefixes = cls._args_schema.frontend_ip_configurations.Element.subnet.address_prefixes
        address_prefixes.Element = AAZStrArg()

        application_gateway_ip_configurations = cls._args_schema.frontend_ip_configurations.Element.subnet.application_gateway_ip_configurations
        application_gateway_ip_configurations.Element = AAZObjectArg()

        _element = cls._args_schema.frontend_ip_configurations.Element.subnet.application_gateway_ip_configurations.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="Name of the IP configuration that is unique within an Application Gateway.",
        )
        _element.subnet = AAZObjectArg(
            options=["subnet"],
            help="Reference to the subnet resource. A subnet from where application gateway gets its private address.",
        )
        cls._build_args_sub_resource_create(_element.subnet)

        delegations = cls._args_schema.frontend_ip_configurations.Element.subnet.delegations
        delegations.Element = AAZObjectArg()

        _element = cls._args_schema.frontend_ip_configurations.Element.subnet.delegations.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a subnet. This name can be used to access the resource.",
        )
        _element.service_name = AAZStrArg(
            options=["service-name"],
            help="The name of the service to whom the subnet should be delegated (e.g. Microsoft.Sql/servers).",
        )
        _element.type = AAZStrArg(
            options=["type"],
            help="Resource type.",
        )

        ip_allocations = cls._args_schema.frontend_ip_configurations.Element.subnet.ip_allocations
        ip_allocations.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(ip_allocations.Element)

        network_security_group = cls._args_schema.frontend_ip_configurations.Element.subnet.network_security_group
        network_security_group.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/networkSecurityGroups/{}",
            ),
        )
        network_security_group.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        network_security_group.flush_connection = AAZBoolArg(
            options=["flush-connection"],
            help="When enabled, flows created from Network Security Group connections will be re-evaluated when rules are updates. Initial enablement will trigger re-evaluation.",
        )
        network_security_group.security_rules = AAZListArg(
            options=["security-rules"],
            help="A collection of security rules of the network security group.",
        )
        network_security_group.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        security_rules = cls._args_schema.frontend_ip_configurations.Element.subnet.network_security_group.security_rules
        security_rules.Element = AAZObjectArg()

        _element = cls._args_schema.frontend_ip_configurations.Element.subnet.network_security_group.security_rules.Element
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        _element.access = AAZStrArg(
            options=["access"],
            help="The network traffic is allowed or denied.",
            enum={"Allow": "Allow", "Deny": "Deny"},
        )
        _element.description = AAZStrArg(
            options=["description"],
            help="A description for this rule. Restricted to 140 chars.",
        )
        _element.destination_address_prefix = AAZStrArg(
            options=["destination-address-prefix"],
            help="The destination address prefix. CIDR or destination IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.",
        )
        _element.destination_address_prefixes = AAZListArg(
            options=["destination-address-prefixes"],
            help="The destination address prefixes. CIDR or destination IP ranges.",
        )
        _element.destination_application_security_groups = AAZListArg(
            options=["destination-application-security-groups"],
            help="The application security group specified as destination.",
        )
        _element.destination_port_range = AAZStrArg(
            options=["destination-port-range"],
            help="The destination port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.",
        )
        _element.destination_port_ranges = AAZListArg(
            options=["destination-port-ranges"],
            help="The destination port ranges.",
        )
        _element.direction = AAZStrArg(
            options=["direction"],
            help="The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic.",
            enum={"Inbound": "Inbound", "Outbound": "Outbound"},
        )
        _element.priority = AAZIntArg(
            options=["priority"],
            help="The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="Network protocol this rule applies to.",
            enum={"*": "*", "Ah": "Ah", "Esp": "Esp", "Icmp": "Icmp", "Tcp": "Tcp", "Udp": "Udp"},
        )
        _element.source_address_prefix = AAZStrArg(
            options=["source-address-prefix"],
            help="The CIDR or source IP range. Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from.",
        )
        _element.source_address_prefixes = AAZListArg(
            options=["source-address-prefixes"],
            help="The CIDR or source IP ranges.",
        )
        _element.source_application_security_groups = AAZListArg(
            options=["source-application-security-groups"],
            help="The application security group specified as source.",
        )
        _element.source_port_range = AAZStrArg(
            options=["source-port-range"],
            help="The source port or range. Integer or range between 0 and 65535. Asterisk '*' can also be used to match all ports.",
        )
        _element.source_port_ranges = AAZListArg(
            options=["source-port-ranges"],
            help="The source port ranges.",
        )
        _element.type = AAZStrArg(
            options=["type"],
            help="The type of the resource.",
        )

        destination_address_prefixes = cls._args_schema.frontend_ip_configurations.Element.subnet.network_security_group.security_rules.Element.destination_address_prefixes
        destination_address_prefixes.Element = AAZStrArg()

        destination_application_security_groups = cls._args_schema.frontend_ip_configurations.Element.subnet.network_security_group.security_rules.Element.destination_application_security_groups
        destination_application_security_groups.Element = AAZObjectArg()
        cls._build_args_application_security_group_create(destination_application_security_groups.Element)

        destination_port_ranges = cls._args_schema.frontend_ip_configurations.Element.subnet.network_security_group.security_rules.Element.destination_port_ranges
        destination_port_ranges.Element = AAZStrArg()

        source_address_prefixes = cls._args_schema.frontend_ip_configurations.Element.subnet.network_security_group.security_rules.Element.source_address_prefixes
        source_address_prefixes.Element = AAZStrArg()

        source_application_security_groups = cls._args_schema.frontend_ip_configurations.Element.subnet.network_security_group.security_rules.Element.source_application_security_groups
        source_application_security_groups.Element = AAZObjectArg()
        cls._build_args_application_security_group_create(source_application_security_groups.Element)

        source_port_ranges = cls._args_schema.frontend_ip_configurations.Element.subnet.network_security_group.security_rules.Element.source_port_ranges
        source_port_ranges.Element = AAZStrArg()

        tags = cls._args_schema.frontend_ip_configurations.Element.subnet.network_security_group.tags
        tags.Element = AAZStrArg()

        route_table = cls._args_schema.frontend_ip_configurations.Element.subnet.route_table
        route_table.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/routeTables/{}",
            ),
        )
        route_table.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        route_table.disable_bgp_route_propagation = AAZBoolArg(
            options=["disable-bgp-route-propagation"],
            help="Whether to disable the routes learned by BGP on that route table. True means disable.",
        )
        route_table.routes = AAZListArg(
            options=["routes"],
            help="Collection of routes contained within a route table.",
        )
        route_table.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        routes = cls._args_schema.frontend_ip_configurations.Element.subnet.route_table.routes
        routes.Element = AAZObjectArg()

        _element = cls._args_schema.frontend_ip_configurations.Element.subnet.route_table.routes.Element
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/routeTables/{}/routes/{}",
            ),
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        _element.address_prefix = AAZStrArg(
            options=["address-prefix"],
            help="The destination CIDR to which the route applies.",
        )
        _element.has_bgp_override = AAZBoolArg(
            options=["has-bgp-override"],
            help="A value indicating whether this route overrides overlapping BGP routes regardless of LPM.",
        )
        _element.next_hop_ip_address = AAZStrArg(
            options=["next-hop-ip-address"],
            help="The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop type is VirtualAppliance.",
        )
        _element.next_hop_type = AAZStrArg(
            options=["next-hop-type"],
            help="The type of Azure hop the packet should be sent to.",
            enum={"Internet": "Internet", "None": "None", "VirtualAppliance": "VirtualAppliance", "VirtualNetworkGateway": "VirtualNetworkGateway", "VnetLocal": "VnetLocal"},
        )
        _element.type = AAZStrArg(
            options=["type"],
            help="The type of the resource.",
        )

        tags = cls._args_schema.frontend_ip_configurations.Element.subnet.route_table.tags
        tags.Element = AAZStrArg()

        service_endpoint_policies = cls._args_schema.frontend_ip_configurations.Element.subnet.service_endpoint_policies
        service_endpoint_policies.Element = AAZObjectArg()

        _element = cls._args_schema.frontend_ip_configurations.Element.subnet.service_endpoint_policies.Element
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/serviceEndpointPolicies/{}",
            ),
        )
        _element.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _element.contextual_service_endpoint_policies = AAZListArg(
            options=["contextual-service-endpoint-policies"],
            help="A collection of contextual service endpoint policy.",
        )
        _element.service_alias = AAZStrArg(
            options=["service-alias"],
            help="The alias indicating if the policy belongs to a service",
        )
        _element.service_endpoint_policy_definitions = AAZListArg(
            options=["service-endpoint-policy-definitions"],
            help="A collection of service endpoint policy definitions of the service endpoint policy.",
        )
        _element.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        contextual_service_endpoint_policies = cls._args_schema.frontend_ip_configurations.Element.subnet.service_endpoint_policies.Element.contextual_service_endpoint_policies
        contextual_service_endpoint_policies.Element = AAZStrArg()

        service_endpoint_policy_definitions = cls._args_schema.frontend_ip_configurations.Element.subnet.service_endpoint_policies.Element.service_endpoint_policy_definitions
        service_endpoint_policy_definitions.Element = AAZObjectArg()

        _element = cls._args_schema.frontend_ip_configurations.Element.subnet.service_endpoint_policies.Element.service_endpoint_policy_definitions.Element
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/serviceEndpointPolicies/{}/serviceEndpointPolicyDefinitions/{}",
            ),
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        _element.description = AAZStrArg(
            options=["description"],
            help="A description for this rule. Restricted to 140 chars.",
        )
        _element.service = AAZStrArg(
            options=["service"],
            help="Service endpoint name.",
        )
        _element.service_resources = AAZListArg(
            options=["service-resources"],
            help="A list of service resources.",
        )
        _element.type = AAZStrArg(
            options=["type"],
            help="The type of the resource.",
        )

        service_resources = cls._args_schema.frontend_ip_configurations.Element.subnet.service_endpoint_policies.Element.service_endpoint_policy_definitions.Element.service_resources
        service_resources.Element = AAZStrArg()

        tags = cls._args_schema.frontend_ip_configurations.Element.subnet.service_endpoint_policies.Element.tags
        tags.Element = AAZStrArg()

        service_endpoints = cls._args_schema.frontend_ip_configurations.Element.subnet.service_endpoints
        service_endpoints.Element = AAZObjectArg()

        _element = cls._args_schema.frontend_ip_configurations.Element.subnet.service_endpoints.Element
        _element.locations = AAZListArg(
            options=["locations"],
            help="A list of locations.",
        )
        _element.service = AAZStrArg(
            options=["service"],
            help="The type of the endpoint service.",
        )

        locations = cls._args_schema.frontend_ip_configurations.Element.subnet.service_endpoints.Element.locations
        locations.Element = AAZStrArg()

        zones = cls._args_schema.frontend_ip_configurations.Element.zones
        zones.Element = AAZStrArg()

        inbound_nat_pools = cls._args_schema.inbound_nat_pools
        inbound_nat_pools.Element = AAZObjectArg()

        _element = cls._args_schema.inbound_nat_pools.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within the set of inbound NAT pools used by the load balancer. This name can be used to access the resource.",
        )
        _element.backend_port = AAZIntArg(
            options=["backend-port"],
            help="The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.",
        )
        _element.enable_floating_ip = AAZBoolArg(
            options=["enable-floating-ip"],
            help="Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.",
        )
        _element.enable_tcp_reset = AAZBoolArg(
            options=["enable-tcp-reset"],
            help="Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.",
        )
        _element.frontend_ip_configuration = AAZObjectArg(
            options=["frontend-ip-configuration"],
            help="A reference to frontend IP addresses.",
        )
        cls._build_args_sub_resource_create(_element.frontend_ip_configuration)
        _element.frontend_port_range_end = AAZIntArg(
            options=["frontend-port-range-end"],
            help="The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535.",
        )
        _element.frontend_port_range_start = AAZIntArg(
            options=["frontend-port-range-start"],
            help="The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534.",
        )
        _element.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout-in-minutes"],
            help="The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="The reference to the transport protocol used by the inbound NAT pool.",
            enum={"All": "All", "Tcp": "Tcp", "Udp": "Udp"},
        )

        inbound_nat_rules = cls._args_schema.inbound_nat_rules
        inbound_nat_rules.Element = AAZObjectArg()

        _element = cls._args_schema.inbound_nat_rules.Element
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/loadBalancers/{}/inboundNatRules/{}",
            ),
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name can be used to access the resource.",
        )
        _element.backend_address_pool = AAZObjectArg(
            options=["backend-address-pool"],
            help="A reference to backendAddressPool resource.",
        )
        cls._build_args_sub_resource_create(_element.backend_address_pool)
        _element.backend_port = AAZIntArg(
            options=["backend-port"],
            help="The port used for the internal endpoint. Acceptable values range from 1 to 65535.",
        )
        _element.enable_floating_ip = AAZBoolArg(
            options=["enable-floating-ip"],
            help="Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.",
        )
        _element.enable_tcp_reset = AAZBoolArg(
            options=["enable-tcp-reset"],
            help="Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.",
        )
        _element.frontend_ip_configuration = AAZObjectArg(
            options=["frontend-ip-configuration"],
            help="A reference to frontend IP addresses.",
        )
        cls._build_args_sub_resource_create(_element.frontend_ip_configuration)
        _element.frontend_port = AAZIntArg(
            options=["frontend-port"],
            help="The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.",
        )
        _element.frontend_port_range_end = AAZIntArg(
            options=["frontend-port-range-end"],
            help="The port range end for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeStart. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.",
        )
        _element.frontend_port_range_start = AAZIntArg(
            options=["frontend-port-range-start"],
            help="The port range start for the external endpoint. This property is used together with BackendAddressPool and FrontendPortRangeEnd. Individual inbound NAT rule port mappings will be created for each backend address from BackendAddressPool. Acceptable values range from 1 to 65534.",
        )
        _element.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout-in-minutes"],
            help="The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="The reference to the transport protocol used by the load balancing rule.",
            enum={"All": "All", "Tcp": "Tcp", "Udp": "Udp"},
        )

        load_balancing_rules = cls._args_schema.load_balancing_rules
        load_balancing_rules.Element = AAZObjectArg()

        _element = cls._args_schema.load_balancing_rules.Element
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/loadBalancers/{}/loadBalancingRules/{}",
            ),
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within the set of load balancing rules used by the load balancer. This name can be used to access the resource.",
        )
        _element.backend_address_pool = AAZObjectArg(
            options=["backend-address-pool"],
            help="A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.",
        )
        cls._build_args_sub_resource_create(_element.backend_address_pool)
        _element.backend_address_pools = AAZListArg(
            options=["backend-address-pools"],
            help="An array of references to pool of DIPs.",
        )
        _element.backend_port = AAZIntArg(
            options=["backend-port"],
            help="The port used for internal connections on the endpoint. Acceptable values are between 0 and 65535. Note that value 0 enables \"Any Port\".",
        )
        _element.disable_outbound_snat = AAZBoolArg(
            options=["disable-outbound-snat"],
            help="Configures SNAT for the VMs in the backend pool to use the publicIP address specified in the frontend of the load balancing rule.",
        )
        _element.enable_floating_ip = AAZBoolArg(
            options=["enable-floating-ip"],
            help="Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.",
        )
        _element.enable_tcp_reset = AAZBoolArg(
            options=["enable-tcp-reset"],
            help="Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.",
        )
        _element.frontend_ip_configuration = AAZObjectArg(
            options=["frontend-ip-configuration"],
            help="A reference to frontend IP addresses.",
        )
        cls._build_args_sub_resource_create(_element.frontend_ip_configuration)
        _element.frontend_port = AAZIntArg(
            options=["frontend-port"],
            help="The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0 enables \"Any Port\".",
        )
        _element.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout-in-minutes"],
            help="The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.",
        )
        _element.load_distribution = AAZStrArg(
            options=["load-distribution"],
            help="The load distribution policy for this rule.",
            enum={"Default": "Default", "SourceIP": "SourceIP", "SourceIPProtocol": "SourceIPProtocol"},
        )
        _element.probe = AAZObjectArg(
            options=["probe"],
            help="The reference to the load balancer probe used by the load balancing rule.",
        )
        cls._build_args_sub_resource_create(_element.probe)
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="The reference to the transport protocol used by the load balancing rule.",
            enum={"All": "All", "Tcp": "Tcp", "Udp": "Udp"},
        )

        backend_address_pools = cls._args_schema.load_balancing_rules.Element.backend_address_pools
        backend_address_pools.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(backend_address_pools.Element)

        outbound_rules = cls._args_schema.outbound_rules
        outbound_rules.Element = AAZObjectArg()

        _element = cls._args_schema.outbound_rules.Element
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/loadBalancers/{}/outboundRules/{}",
            ),
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within the set of outbound rules used by the load balancer. This name can be used to access the resource.",
        )
        _element.allocated_outbound_ports = AAZIntArg(
            options=["allocated-outbound-ports"],
            help="The number of outbound ports to be used for NAT.",
        )
        _element.backend_address_pool = AAZObjectArg(
            options=["backend-address-pool"],
            help="A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.",
        )
        cls._build_args_sub_resource_create(_element.backend_address_pool)
        _element.enable_tcp_reset = AAZBoolArg(
            options=["enable-tcp-reset"],
            help="Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.",
        )
        _element.frontend_ip_configurations = AAZListArg(
            options=["frontend-ip-configurations"],
            help="The Frontend IP addresses of the load balancer.",
        )
        _element.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout-in-minutes"],
            help="The timeout for the TCP idle connection.",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="The protocol for the outbound rule in load balancer.",
            enum={"All": "All", "Tcp": "Tcp", "Udp": "Udp"},
        )

        frontend_ip_configurations = cls._args_schema.outbound_rules.Element.frontend_ip_configurations
        frontend_ip_configurations.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(frontend_ip_configurations.Element)

        probes = cls._args_schema.probes
        probes.Element = AAZObjectArg()

        _element = cls._args_schema.probes.Element
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/loadBalancers/{}/probes/{}",
            ),
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within the set of probes used by the load balancer. This name can be used to access the resource.",
        )
        _element.interval_in_seconds = AAZIntArg(
            options=["interval-in-seconds"],
            help="The interval, in seconds, for how frequently to probe the endpoint for health status. Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5.",
        )
        _element.number_of_probes = AAZIntArg(
            options=["number-of-probes"],
            help="The number of probes where if no response, will result in stopping further traffic from being delivered to the endpoint. This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure.",
        )
        _element.port = AAZIntArg(
            options=["port"],
            help="The port for communicating the probe. Possible values range from 1 to 65535, inclusive.",
        )
        _element.probe_threshold = AAZIntArg(
            options=["probe-threshold"],
            help="The number of consecutive successful or failed probes in order to allow or deny traffic from being delivered to this endpoint. After failing the number of consecutive probes equal to this value, the endpoint will be taken out of rotation and require the same number of successful consecutive probes to be placed back in rotation.",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="The protocol of the end point. If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful.",
            enum={"Http": "Http", "Https": "Https", "Tcp": "Tcp"},
        )
        _element.request_path = AAZStrArg(
            options=["request-path"],
            help="The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed. There is no default value.",
        )
        return cls._args_schema

    _args_application_security_group_create = None

    @classmethod
    def _build_args_application_security_group_create(cls, _schema):
        if cls._args_application_security_group_create is not None:
            _schema.location = cls._args_application_security_group_create.location
            _schema.tags = cls._args_application_security_group_create.tags
            return

        cls._args_application_security_group_create = AAZObjectArg()

        application_security_group_create = cls._args_application_security_group_create
        application_security_group_create.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        application_security_group_create.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        tags = cls._args_application_security_group_create.tags
        tags.Element = AAZStrArg()

        _schema.location = cls._args_application_security_group_create.location
        _schema.tags = cls._args_application_security_group_create.tags

    _args_extended_location_create = None

    @classmethod
    def _build_args_extended_location_create(cls, _schema):
        if cls._args_extended_location_create is not None:
            _schema.name = cls._args_extended_location_create.name
            _schema.type = cls._args_extended_location_create.type
            return

        cls._args_extended_location_create = AAZObjectArg()

        extended_location_create = cls._args_extended_location_create
        extended_location_create.name = AAZStrArg(
            options=["name"],
            help="The name of the extended location.",
        )
        extended_location_create.type = AAZStrArg(
            options=["type"],
            help="The type of the extended location.",
            enum={"EdgeZone": "EdgeZone"},
        )

        _schema.name = cls._args_extended_location_create.name
        _schema.type = cls._args_extended_location_create.type

    _args_sub_resource_create = None

    @classmethod
    def _build_args_sub_resource_create(cls, _schema):
        if cls._args_sub_resource_create is not None:
            _schema.id = cls._args_sub_resource_create.id
            return

        cls._args_sub_resource_create = AAZObjectArg()

        sub_resource_create = cls._args_sub_resource_create
        sub_resource_create.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )

        _schema.id = cls._args_sub_resource_create.id

    def _execute_operations(self):
        self.pre_operations()
        yield self.LoadBalancersCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class LoadBalancersCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "loadBalancerName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2022-05-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _build_schema_extended_location_create(_builder.set_prop("extendedLocation", AAZObjectType, ".extended_location"))
            _builder.set_prop("id", AAZStrType, ".id")
            _builder.set_prop("location", AAZStrType, ".location")
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("sku", AAZObjectType, ".sku")
            _builder.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("backendAddressPools", AAZListType, ".backend_address_pools")
                properties.set_prop("frontendIPConfigurations", AAZListType, ".frontend_ip_configurations")
                properties.set_prop("inboundNatPools", AAZListType, ".inbound_nat_pools")
                properties.set_prop("inboundNatRules", AAZListType, ".inbound_nat_rules")
                properties.set_prop("loadBalancingRules", AAZListType, ".load_balancing_rules")
                properties.set_prop("outboundRules", AAZListType, ".outbound_rules")
                properties.set_prop("probes", AAZListType, ".probes")

            backend_address_pools = _builder.get(".properties.backendAddressPools")
            if backend_address_pools is not None:
                backend_address_pools.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.backendAddressPools[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.backendAddressPools[].properties")
            if properties is not None:
                properties.set_prop("drainPeriodInSeconds", AAZIntType, ".drain_period_in_seconds")
                properties.set_prop("loadBalancerBackendAddresses", AAZListType, ".load_balancer_backend_addresses")
                properties.set_prop("location", AAZStrType, ".location")
                properties.set_prop("tunnelInterfaces", AAZListType, ".tunnel_interfaces")

            load_balancer_backend_addresses = _builder.get(".properties.backendAddressPools[].properties.loadBalancerBackendAddresses")
            if load_balancer_backend_addresses is not None:
                load_balancer_backend_addresses.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.backendAddressPools[].properties.loadBalancerBackendAddresses[]")
            if _elements is not None:
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.backendAddressPools[].properties.loadBalancerBackendAddresses[].properties")
            if properties is not None:
                properties.set_prop("adminState", AAZStrType, ".admin_state")
                properties.set_prop("ipAddress", AAZStrType, ".ip_address")
                _build_schema_sub_resource_create(properties.set_prop("loadBalancerFrontendIPConfiguration", AAZObjectType, ".load_balancer_frontend_ip_configuration"))
                _build_schema_sub_resource_create(properties.set_prop("subnet", AAZObjectType, ".subnet"))
                _build_schema_sub_resource_create(properties.set_prop("virtualNetwork", AAZObjectType, ".virtual_network"))

            tunnel_interfaces = _builder.get(".properties.backendAddressPools[].properties.tunnelInterfaces")
            if tunnel_interfaces is not None:
                tunnel_interfaces.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.backendAddressPools[].properties.tunnelInterfaces[]")
            if _elements is not None:
                _elements.set_prop("identifier", AAZIntType, ".identifier")
                _elements.set_prop("port", AAZIntType, ".port")
                _elements.set_prop("protocol", AAZStrType, ".protocol")
                _elements.set_prop("type", AAZStrType, ".type")

            frontend_ip_configurations = _builder.get(".properties.frontendIPConfigurations")
            if frontend_ip_configurations is not None:
                frontend_ip_configurations.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.frontendIPConfigurations[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                _elements.set_prop("zones", AAZListType, ".zones")

            properties = _builder.get(".properties.frontendIPConfigurations[].properties")
            if properties is not None:
                _build_schema_sub_resource_create(properties.set_prop("gatewayLoadBalancer", AAZObjectType, ".gateway_load_balancer"))
                properties.set_prop("privateIPAddress", AAZStrType, ".private_ip_address")
                properties.set_prop("privateIPAddressVersion", AAZStrType, ".private_ip_address_version")
                properties.set_prop("privateIPAllocationMethod", AAZStrType, ".private_ip_allocation_method")
                properties.set_prop("publicIPAddress", AAZObjectType, ".public_ip_address")
                _build_schema_sub_resource_create(properties.set_prop("publicIPPrefix", AAZObjectType, ".public_ip_prefix"))
                properties.set_prop("subnet", AAZObjectType, ".subnet")

            public_ip_address = _builder.get(".properties.frontendIPConfigurations[].properties.publicIPAddress")
            if public_ip_address is not None:
                _build_schema_extended_location_create(public_ip_address.set_prop("extendedLocation", AAZObjectType, ".extended_location"))
                public_ip_address.set_prop("id", AAZStrType, ".id")
                public_ip_address.set_prop("location", AAZStrType, ".location")
                public_ip_address.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                public_ip_address.set_prop("sku", AAZObjectType, ".sku")
                public_ip_address.set_prop("tags", AAZDictType, ".tags")
                public_ip_address.set_prop("zones", AAZListType, ".zones")

            properties = _builder.get(".properties.frontendIPConfigurations[].properties.publicIPAddress.properties")
            if properties is not None:
                properties.set_prop("ddosSettings", AAZObjectType, ".ddos_settings")
                properties.set_prop("deleteOption", AAZStrType, ".delete_option")
                properties.set_prop("dnsSettings", AAZObjectType, ".dns_settings")
                properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
                properties.set_prop("ipAddress", AAZStrType, ".ip_address")
                properties.set_prop("ipTags", AAZListType, ".ip_tags")
                properties.set_prop("migrationPhase", AAZStrType, ".migration_phase")
                properties.set_prop("natGateway", AAZObjectType, ".nat_gateway")
                properties.set_prop("publicIPAddressVersion", AAZStrType, ".public_ip_address_version")
                properties.set_prop("publicIPAllocationMethod", AAZStrType, ".public_ip_allocation_method")
                properties.set_prop("publicIPPrefix", AAZObjectType, ".public_ip_prefix")

            ddos_settings = _builder.get(".properties.frontendIPConfigurations[].properties.publicIPAddress.properties.ddosSettings")
            if ddos_settings is not None:
                ddos_settings.set_prop("ddosProtectionPlan", AAZObjectType, ".ddos_protection_plan")
                ddos_settings.set_prop("protectionMode", AAZStrType, ".protection_mode")

            ddos_protection_plan = _builder.get(".properties.frontendIPConfigurations[].properties.publicIPAddress.properties.ddosSettings.ddosProtectionPlan")
            if ddos_protection_plan is not None:
                ddos_protection_plan.set_prop("id", AAZStrType, ".id")

            dns_settings = _builder.get(".properties.frontendIPConfigurations[].properties.publicIPAddress.properties.dnsSettings")
            if dns_settings is not None:
                dns_settings.set_prop("domainNameLabel", AAZStrType, ".domain_name_label")
                dns_settings.set_prop("fqdn", AAZStrType, ".fqdn")
                dns_settings.set_prop("reverseFqdn", AAZStrType, ".reverse_fqdn")

            ip_tags = _builder.get(".properties.frontendIPConfigurations[].properties.publicIPAddress.properties.ipTags")
            if ip_tags is not None:
                ip_tags.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.frontendIPConfigurations[].properties.publicIPAddress.properties.ipTags[]")
            if _elements is not None:
                _elements.set_prop("ipTagType", AAZStrType, ".ip_tag_type")
                _elements.set_prop("tag", AAZStrType, ".tag")

            nat_gateway = _builder.get(".properties.frontendIPConfigurations[].properties.publicIPAddress.properties.natGateway")
            if nat_gateway is not None:
                nat_gateway.set_prop("id", AAZStrType, ".id")
                nat_gateway.set_prop("location", AAZStrType, ".location")
                nat_gateway.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                nat_gateway.set_prop("sku", AAZObjectType, ".sku")
                nat_gateway.set_prop("tags", AAZDictType, ".tags")
                nat_gateway.set_prop("zones", AAZListType, ".zones")

            properties = _builder.get(".properties.frontendIPConfigurations[].properties.publicIPAddress.properties.natGateway.properties")
            if properties is not None:
                properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
                properties.set_prop("publicIpAddresses", AAZListType, ".public_ip_addresses")
                properties.set_prop("publicIpPrefixes", AAZListType, ".public_ip_prefixes")

            public_ip_addresses = _builder.get(".properties.frontendIPConfigurations[].properties.publicIPAddress.properties.natGateway.properties.publicIpAddresses")
            if public_ip_addresses is not None:
                _build_schema_sub_resource_create(public_ip_addresses.set_elements(AAZObjectType, "."))

            public_ip_prefixes = _builder.get(".properties.frontendIPConfigurations[].properties.publicIPAddress.properties.natGateway.properties.publicIpPrefixes")
            if public_ip_prefixes is not None:
                _build_schema_sub_resource_create(public_ip_prefixes.set_elements(AAZObjectType, "."))

            sku = _builder.get(".properties.frontendIPConfigurations[].properties.publicIPAddress.properties.natGateway.sku")
            if sku is not None:
                sku.set_prop("name", AAZStrType, ".name")

            tags = _builder.get(".properties.frontendIPConfigurations[].properties.publicIPAddress.properties.natGateway.tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            zones = _builder.get(".properties.frontendIPConfigurations[].properties.publicIPAddress.properties.natGateway.zones")
            if zones is not None:
                zones.set_elements(AAZStrType, ".")

            public_ip_prefix = _builder.get(".properties.frontendIPConfigurations[].properties.publicIPAddress.properties.publicIPPrefix")
            if public_ip_prefix is not None:
                public_ip_prefix.set_prop("id", AAZStrType, ".id")

            sku = _builder.get(".properties.frontendIPConfigurations[].properties.publicIPAddress.sku")
            if sku is not None:
                sku.set_prop("name", AAZStrType, ".name")
                sku.set_prop("tier", AAZStrType, ".tier")

            tags = _builder.get(".properties.frontendIPConfigurations[].properties.publicIPAddress.tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            zones = _builder.get(".properties.frontendIPConfigurations[].properties.publicIPAddress.zones")
            if zones is not None:
                zones.set_elements(AAZStrType, ".")

            subnet = _builder.get(".properties.frontendIPConfigurations[].properties.subnet")
            if subnet is not None:
                subnet.set_prop("id", AAZStrType, ".id")
                subnet.set_prop("name", AAZStrType, ".name")
                subnet.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                subnet.set_prop("type", AAZStrType, ".type")

            properties = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties")
            if properties is not None:
                properties.set_prop("addressPrefix", AAZStrType, ".address_prefix")
                properties.set_prop("addressPrefixes", AAZListType, ".address_prefixes")
                properties.set_prop("applicationGatewayIpConfigurations", AAZListType, ".application_gateway_ip_configurations")
                properties.set_prop("delegations", AAZListType, ".delegations")
                properties.set_prop("ipAllocations", AAZListType, ".ip_allocations")
                _build_schema_sub_resource_create(properties.set_prop("natGateway", AAZObjectType, ".nat_gateway"))
                properties.set_prop("networkSecurityGroup", AAZObjectType, ".network_security_group")
                properties.set_prop("privateEndpointNetworkPolicies", AAZStrType, ".private_endpoint_network_policies")
                properties.set_prop("privateLinkServiceNetworkPolicies", AAZStrType, ".private_link_service_network_policies")
                properties.set_prop("routeTable", AAZObjectType, ".route_table")
                properties.set_prop("serviceEndpointPolicies", AAZListType, ".service_endpoint_policies")
                properties.set_prop("serviceEndpoints", AAZListType, ".service_endpoints")

            address_prefixes = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.addressPrefixes")
            if address_prefixes is not None:
                address_prefixes.set_elements(AAZStrType, ".")

            application_gateway_ip_configurations = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.applicationGatewayIpConfigurations")
            if application_gateway_ip_configurations is not None:
                application_gateway_ip_configurations.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.applicationGatewayIpConfigurations[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.applicationGatewayIpConfigurations[].properties")
            if properties is not None:
                _build_schema_sub_resource_create(properties.set_prop("subnet", AAZObjectType, ".subnet"))

            delegations = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.delegations")
            if delegations is not None:
                delegations.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.delegations[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                _elements.set_prop("type", AAZStrType, ".type")

            properties = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.delegations[].properties")
            if properties is not None:
                properties.set_prop("serviceName", AAZStrType, ".service_name")

            ip_allocations = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.ipAllocations")
            if ip_allocations is not None:
                _build_schema_sub_resource_create(ip_allocations.set_elements(AAZObjectType, "."))

            network_security_group = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.networkSecurityGroup")
            if network_security_group is not None:
                network_security_group.set_prop("id", AAZStrType, ".id")
                network_security_group.set_prop("location", AAZStrType, ".location")
                network_security_group.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                network_security_group.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.networkSecurityGroup.properties")
            if properties is not None:
                properties.set_prop("flushConnection", AAZBoolType, ".flush_connection")
                properties.set_prop("securityRules", AAZListType, ".security_rules")

            security_rules = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.networkSecurityGroup.properties.securityRules")
            if security_rules is not None:
                security_rules.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.networkSecurityGroup.properties.securityRules[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                _elements.set_prop("type", AAZStrType, ".type")

            properties = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.networkSecurityGroup.properties.securityRules[].properties")
            if properties is not None:
                properties.set_prop("access", AAZStrType, ".access", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("description", AAZStrType, ".description")
                properties.set_prop("destinationAddressPrefix", AAZStrType, ".destination_address_prefix")
                properties.set_prop("destinationAddressPrefixes", AAZListType, ".destination_address_prefixes")
                properties.set_prop("destinationApplicationSecurityGroups", AAZListType, ".destination_application_security_groups")
                properties.set_prop("destinationPortRange", AAZStrType, ".destination_port_range")
                properties.set_prop("destinationPortRanges", AAZListType, ".destination_port_ranges")
                properties.set_prop("direction", AAZStrType, ".direction", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("priority", AAZIntType, ".priority")
                properties.set_prop("protocol", AAZStrType, ".protocol", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("sourceAddressPrefix", AAZStrType, ".source_address_prefix")
                properties.set_prop("sourceAddressPrefixes", AAZListType, ".source_address_prefixes")
                properties.set_prop("sourceApplicationSecurityGroups", AAZListType, ".source_application_security_groups")
                properties.set_prop("sourcePortRange", AAZStrType, ".source_port_range")
                properties.set_prop("sourcePortRanges", AAZListType, ".source_port_ranges")

            destination_address_prefixes = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.networkSecurityGroup.properties.securityRules[].properties.destinationAddressPrefixes")
            if destination_address_prefixes is not None:
                destination_address_prefixes.set_elements(AAZStrType, ".")

            destination_application_security_groups = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.networkSecurityGroup.properties.securityRules[].properties.destinationApplicationSecurityGroups")
            if destination_application_security_groups is not None:
                _build_schema_application_security_group_create(destination_application_security_groups.set_elements(AAZObjectType, "."))

            destination_port_ranges = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.networkSecurityGroup.properties.securityRules[].properties.destinationPortRanges")
            if destination_port_ranges is not None:
                destination_port_ranges.set_elements(AAZStrType, ".")

            source_address_prefixes = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.networkSecurityGroup.properties.securityRules[].properties.sourceAddressPrefixes")
            if source_address_prefixes is not None:
                source_address_prefixes.set_elements(AAZStrType, ".")

            source_application_security_groups = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.networkSecurityGroup.properties.securityRules[].properties.sourceApplicationSecurityGroups")
            if source_application_security_groups is not None:
                _build_schema_application_security_group_create(source_application_security_groups.set_elements(AAZObjectType, "."))

            source_port_ranges = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.networkSecurityGroup.properties.securityRules[].properties.sourcePortRanges")
            if source_port_ranges is not None:
                source_port_ranges.set_elements(AAZStrType, ".")

            tags = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.networkSecurityGroup.tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            route_table = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.routeTable")
            if route_table is not None:
                route_table.set_prop("id", AAZStrType, ".id")
                route_table.set_prop("location", AAZStrType, ".location")
                route_table.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                route_table.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.routeTable.properties")
            if properties is not None:
                properties.set_prop("disableBgpRoutePropagation", AAZBoolType, ".disable_bgp_route_propagation")
                properties.set_prop("routes", AAZListType, ".routes")

            routes = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.routeTable.properties.routes")
            if routes is not None:
                routes.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.routeTable.properties.routes[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                _elements.set_prop("type", AAZStrType, ".type")

            properties = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.routeTable.properties.routes[].properties")
            if properties is not None:
                properties.set_prop("addressPrefix", AAZStrType, ".address_prefix")
                properties.set_prop("hasBgpOverride", AAZBoolType, ".has_bgp_override")
                properties.set_prop("nextHopIpAddress", AAZStrType, ".next_hop_ip_address")
                properties.set_prop("nextHopType", AAZStrType, ".next_hop_type", typ_kwargs={"flags": {"required": True}})

            tags = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.routeTable.tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            service_endpoint_policies = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.serviceEndpointPolicies")
            if service_endpoint_policies is not None:
                service_endpoint_policies.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.serviceEndpointPolicies[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("location", AAZStrType, ".location")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                _elements.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.serviceEndpointPolicies[].properties")
            if properties is not None:
                properties.set_prop("contextualServiceEndpointPolicies", AAZListType, ".contextual_service_endpoint_policies")
                properties.set_prop("serviceAlias", AAZStrType, ".service_alias")
                properties.set_prop("serviceEndpointPolicyDefinitions", AAZListType, ".service_endpoint_policy_definitions")

            contextual_service_endpoint_policies = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.serviceEndpointPolicies[].properties.contextualServiceEndpointPolicies")
            if contextual_service_endpoint_policies is not None:
                contextual_service_endpoint_policies.set_elements(AAZStrType, ".")

            service_endpoint_policy_definitions = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.serviceEndpointPolicies[].properties.serviceEndpointPolicyDefinitions")
            if service_endpoint_policy_definitions is not None:
                service_endpoint_policy_definitions.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.serviceEndpointPolicies[].properties.serviceEndpointPolicyDefinitions[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
                _elements.set_prop("type", AAZStrType, ".type")

            properties = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.serviceEndpointPolicies[].properties.serviceEndpointPolicyDefinitions[].properties")
            if properties is not None:
                properties.set_prop("description", AAZStrType, ".description")
                properties.set_prop("service", AAZStrType, ".service")
                properties.set_prop("serviceResources", AAZListType, ".service_resources")

            service_resources = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.serviceEndpointPolicies[].properties.serviceEndpointPolicyDefinitions[].properties.serviceResources")
            if service_resources is not None:
                service_resources.set_elements(AAZStrType, ".")

            tags = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.serviceEndpointPolicies[].tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            service_endpoints = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.serviceEndpoints")
            if service_endpoints is not None:
                service_endpoints.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.serviceEndpoints[]")
            if _elements is not None:
                _elements.set_prop("locations", AAZListType, ".locations")
                _elements.set_prop("service", AAZStrType, ".service")

            locations = _builder.get(".properties.frontendIPConfigurations[].properties.subnet.properties.serviceEndpoints[].locations")
            if locations is not None:
                locations.set_elements(AAZStrType, ".")

            zones = _builder.get(".properties.frontendIPConfigurations[].zones")
            if zones is not None:
                zones.set_elements(AAZStrType, ".")

            inbound_nat_pools = _builder.get(".properties.inboundNatPools")
            if inbound_nat_pools is not None:
                inbound_nat_pools.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.inboundNatPools[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.inboundNatPools[].properties")
            if properties is not None:
                properties.set_prop("backendPort", AAZIntType, ".backend_port", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("enableFloatingIP", AAZBoolType, ".enable_floating_ip")
                properties.set_prop("enableTcpReset", AAZBoolType, ".enable_tcp_reset")
                _build_schema_sub_resource_create(properties.set_prop("frontendIPConfiguration", AAZObjectType, ".frontend_ip_configuration"))
                properties.set_prop("frontendPortRangeEnd", AAZIntType, ".frontend_port_range_end", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("frontendPortRangeStart", AAZIntType, ".frontend_port_range_start", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
                properties.set_prop("protocol", AAZStrType, ".protocol", typ_kwargs={"flags": {"required": True}})

            inbound_nat_rules = _builder.get(".properties.inboundNatRules")
            if inbound_nat_rules is not None:
                inbound_nat_rules.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.inboundNatRules[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.inboundNatRules[].properties")
            if properties is not None:
                _build_schema_sub_resource_create(properties.set_prop("backendAddressPool", AAZObjectType, ".backend_address_pool"))
                properties.set_prop("backendPort", AAZIntType, ".backend_port")
                properties.set_prop("enableFloatingIP", AAZBoolType, ".enable_floating_ip")
                properties.set_prop("enableTcpReset", AAZBoolType, ".enable_tcp_reset")
                _build_schema_sub_resource_create(properties.set_prop("frontendIPConfiguration", AAZObjectType, ".frontend_ip_configuration"))
                properties.set_prop("frontendPort", AAZIntType, ".frontend_port")
                properties.set_prop("frontendPortRangeEnd", AAZIntType, ".frontend_port_range_end")
                properties.set_prop("frontendPortRangeStart", AAZIntType, ".frontend_port_range_start")
                properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
                properties.set_prop("protocol", AAZStrType, ".protocol")

            load_balancing_rules = _builder.get(".properties.loadBalancingRules")
            if load_balancing_rules is not None:
                load_balancing_rules.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.loadBalancingRules[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.loadBalancingRules[].properties")
            if properties is not None:
                _build_schema_sub_resource_create(properties.set_prop("backendAddressPool", AAZObjectType, ".backend_address_pool"))
                properties.set_prop("backendAddressPools", AAZListType, ".backend_address_pools")
                properties.set_prop("backendPort", AAZIntType, ".backend_port")
                properties.set_prop("disableOutboundSnat", AAZBoolType, ".disable_outbound_snat")
                properties.set_prop("enableFloatingIP", AAZBoolType, ".enable_floating_ip")
                properties.set_prop("enableTcpReset", AAZBoolType, ".enable_tcp_reset")
                _build_schema_sub_resource_create(properties.set_prop("frontendIPConfiguration", AAZObjectType, ".frontend_ip_configuration"))
                properties.set_prop("frontendPort", AAZIntType, ".frontend_port", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
                properties.set_prop("loadDistribution", AAZStrType, ".load_distribution")
                _build_schema_sub_resource_create(properties.set_prop("probe", AAZObjectType, ".probe"))
                properties.set_prop("protocol", AAZStrType, ".protocol", typ_kwargs={"flags": {"required": True}})

            backend_address_pools = _builder.get(".properties.loadBalancingRules[].properties.backendAddressPools")
            if backend_address_pools is not None:
                _build_schema_sub_resource_create(backend_address_pools.set_elements(AAZObjectType, "."))

            outbound_rules = _builder.get(".properties.outboundRules")
            if outbound_rules is not None:
                outbound_rules.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.outboundRules[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.outboundRules[].properties")
            if properties is not None:
                properties.set_prop("allocatedOutboundPorts", AAZIntType, ".allocated_outbound_ports")
                _build_schema_sub_resource_create(properties.set_prop("backendAddressPool", AAZObjectType, ".backend_address_pool", typ_kwargs={"flags": {"required": True}}))
                properties.set_prop("enableTcpReset", AAZBoolType, ".enable_tcp_reset")
                properties.set_prop("frontendIPConfigurations", AAZListType, ".frontend_ip_configurations", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
                properties.set_prop("protocol", AAZStrType, ".protocol", typ_kwargs={"flags": {"required": True}})

            frontend_ip_configurations = _builder.get(".properties.outboundRules[].properties.frontendIPConfigurations")
            if frontend_ip_configurations is not None:
                _build_schema_sub_resource_create(frontend_ip_configurations.set_elements(AAZObjectType, "."))

            probes = _builder.get(".properties.probes")
            if probes is not None:
                probes.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.probes[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.probes[].properties")
            if properties is not None:
                properties.set_prop("intervalInSeconds", AAZIntType, ".interval_in_seconds")
                properties.set_prop("numberOfProbes", AAZIntType, ".number_of_probes")
                properties.set_prop("port", AAZIntType, ".port", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("probeThreshold", AAZIntType, ".probe_threshold")
                properties.set_prop("protocol", AAZStrType, ".protocol", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("requestPath", AAZStrType, ".request_path")

            sku = _builder.get(".sku")
            if sku is not None:
                sku.set_prop("name", AAZStrType, ".name")
                sku.set_prop("tier", AAZStrType, ".tier")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()

            _schema_on_200_201 = cls._schema_on_200_201
            _schema_on_200_201.etag = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.extended_location = AAZObjectType(
                serialized_name="extendedLocation",
            )
            _build_schema_extended_location_read(_schema_on_200_201.extended_location)
            _schema_on_200_201.id = AAZStrType()
            _schema_on_200_201.location = AAZStrType()
            _schema_on_200_201.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200_201.sku = AAZObjectType()
            _schema_on_200_201.tags = AAZDictType()
            _schema_on_200_201.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties
            properties.backend_address_pools = AAZListType(
                serialized_name="backendAddressPools",
            )
            properties.frontend_ip_configurations = AAZListType(
                serialized_name="frontendIPConfigurations",
            )
            properties.inbound_nat_pools = AAZListType(
                serialized_name="inboundNatPools",
            )
            properties.inbound_nat_rules = AAZListType(
                serialized_name="inboundNatRules",
            )
            properties.load_balancing_rules = AAZListType(
                serialized_name="loadBalancingRules",
            )
            properties.outbound_rules = AAZListType(
                serialized_name="outboundRules",
            )
            properties.probes = AAZListType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.resource_guid = AAZStrType(
                serialized_name="resourceGuid",
                flags={"read_only": True},
            )

            backend_address_pools = cls._schema_on_200_201.properties.backend_address_pools
            backend_address_pools.Element = AAZObjectType()
            _build_schema_backend_address_pool_read(backend_address_pools.Element)

            frontend_ip_configurations = cls._schema_on_200_201.properties.frontend_ip_configurations
            frontend_ip_configurations.Element = AAZObjectType()
            _build_schema_frontend_ip_configuration_read(frontend_ip_configurations.Element)

            inbound_nat_pools = cls._schema_on_200_201.properties.inbound_nat_pools
            inbound_nat_pools.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.inbound_nat_pools.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.inbound_nat_pools.Element.properties
            properties.backend_port = AAZIntType(
                serialized_name="backendPort",
                flags={"required": True},
            )
            properties.enable_floating_ip = AAZBoolType(
                serialized_name="enableFloatingIP",
            )
            properties.enable_tcp_reset = AAZBoolType(
                serialized_name="enableTcpReset",
            )
            properties.frontend_ip_configuration = AAZObjectType(
                serialized_name="frontendIPConfiguration",
            )
            _build_schema_sub_resource_read(properties.frontend_ip_configuration)
            properties.frontend_port_range_end = AAZIntType(
                serialized_name="frontendPortRangeEnd",
                flags={"required": True},
            )
            properties.frontend_port_range_start = AAZIntType(
                serialized_name="frontendPortRangeStart",
                flags={"required": True},
            )
            properties.idle_timeout_in_minutes = AAZIntType(
                serialized_name="idleTimeoutInMinutes",
            )
            properties.protocol = AAZStrType(
                flags={"required": True},
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )

            inbound_nat_rules = cls._schema_on_200_201.properties.inbound_nat_rules
            inbound_nat_rules.Element = AAZObjectType()
            _build_schema_inbound_nat_rule_read(inbound_nat_rules.Element)

            load_balancing_rules = cls._schema_on_200_201.properties.load_balancing_rules
            load_balancing_rules.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.load_balancing_rules.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.load_balancing_rules.Element.properties
            properties.backend_address_pool = AAZObjectType(
                serialized_name="backendAddressPool",
            )
            _build_schema_sub_resource_read(properties.backend_address_pool)
            properties.backend_address_pools = AAZListType(
                serialized_name="backendAddressPools",
            )
            properties.backend_port = AAZIntType(
                serialized_name="backendPort",
            )
            properties.disable_outbound_snat = AAZBoolType(
                serialized_name="disableOutboundSnat",
            )
            properties.enable_floating_ip = AAZBoolType(
                serialized_name="enableFloatingIP",
            )
            properties.enable_tcp_reset = AAZBoolType(
                serialized_name="enableTcpReset",
            )
            properties.frontend_ip_configuration = AAZObjectType(
                serialized_name="frontendIPConfiguration",
            )
            _build_schema_sub_resource_read(properties.frontend_ip_configuration)
            properties.frontend_port = AAZIntType(
                serialized_name="frontendPort",
                flags={"required": True},
            )
            properties.idle_timeout_in_minutes = AAZIntType(
                serialized_name="idleTimeoutInMinutes",
            )
            properties.load_distribution = AAZStrType(
                serialized_name="loadDistribution",
            )
            properties.probe = AAZObjectType()
            _build_schema_sub_resource_read(properties.probe)
            properties.protocol = AAZStrType(
                flags={"required": True},
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )

            backend_address_pools = cls._schema_on_200_201.properties.load_balancing_rules.Element.properties.backend_address_pools
            backend_address_pools.Element = AAZObjectType()
            _build_schema_sub_resource_read(backend_address_pools.Element)

            outbound_rules = cls._schema_on_200_201.properties.outbound_rules
            outbound_rules.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.outbound_rules.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.outbound_rules.Element.properties
            properties.allocated_outbound_ports = AAZIntType(
                serialized_name="allocatedOutboundPorts",
            )
            properties.backend_address_pool = AAZObjectType(
                serialized_name="backendAddressPool",
                flags={"required": True},
            )
            _build_schema_sub_resource_read(properties.backend_address_pool)
            properties.enable_tcp_reset = AAZBoolType(
                serialized_name="enableTcpReset",
            )
            properties.frontend_ip_configurations = AAZListType(
                serialized_name="frontendIPConfigurations",
                flags={"required": True},
            )
            properties.idle_timeout_in_minutes = AAZIntType(
                serialized_name="idleTimeoutInMinutes",
            )
            properties.protocol = AAZStrType(
                flags={"required": True},
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )

            frontend_ip_configurations = cls._schema_on_200_201.properties.outbound_rules.Element.properties.frontend_ip_configurations
            frontend_ip_configurations.Element = AAZObjectType()
            _build_schema_sub_resource_read(frontend_ip_configurations.Element)

            probes = cls._schema_on_200_201.properties.probes
            probes.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.probes.Element
            _element.etag = AAZStrType(
                flags={"read_only": True},
            )
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _element.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties.probes.Element.properties
            properties.interval_in_seconds = AAZIntType(
                serialized_name="intervalInSeconds",
            )
            properties.load_balancing_rules = AAZListType(
                serialized_name="loadBalancingRules",
                flags={"read_only": True},
            )
            properties.number_of_probes = AAZIntType(
                serialized_name="numberOfProbes",
            )
            properties.port = AAZIntType(
                flags={"required": True},
            )
            properties.probe_threshold = AAZIntType(
                serialized_name="probeThreshold",
            )
            properties.protocol = AAZStrType(
                flags={"required": True},
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            properties.request_path = AAZStrType(
                serialized_name="requestPath",
            )

            load_balancing_rules = cls._schema_on_200_201.properties.probes.Element.properties.load_balancing_rules
            load_balancing_rules.Element = AAZObjectType()
            _build_schema_sub_resource_read(load_balancing_rules.Element)

            sku = cls._schema_on_200_201.sku
            sku.name = AAZStrType()
            sku.tier = AAZStrType()

            tags = cls._schema_on_200_201.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200_201


def _build_schema_application_security_group_create(_builder):
    if _builder is None:
        return
    _builder.set_prop("location", AAZStrType, ".location")
    _builder.set_prop("tags", AAZDictType, ".tags")

    tags = _builder.get(".tags")
    if tags is not None:
        tags.set_elements(AAZStrType, ".")


def _build_schema_extended_location_create(_builder):
    if _builder is None:
        return
    _builder.set_prop("name", AAZStrType, ".name")
    _builder.set_prop("type", AAZStrType, ".type")


def _build_schema_sub_resource_create(_builder):
    if _builder is None:
        return
    _builder.set_prop("id", AAZStrType, ".id")


_schema_application_security_group_read = None


def _build_schema_application_security_group_read(_schema):
    global _schema_application_security_group_read
    if _schema_application_security_group_read is not None:
        _schema.etag = _schema_application_security_group_read.etag
        _schema.id = _schema_application_security_group_read.id
        _schema.location = _schema_application_security_group_read.location
        _schema.name = _schema_application_security_group_read.name
        _schema.properties = _schema_application_security_group_read.properties
        _schema.tags = _schema_application_security_group_read.tags
        _schema.type = _schema_application_security_group_read.type
        return

    _schema_application_security_group_read = AAZObjectType()

    application_security_group_read = _schema_application_security_group_read
    application_security_group_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    application_security_group_read.id = AAZStrType()
    application_security_group_read.location = AAZStrType()
    application_security_group_read.name = AAZStrType(
        flags={"read_only": True},
    )
    application_security_group_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    application_security_group_read.tags = AAZDictType()
    application_security_group_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_application_security_group_read.properties
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )

    tags = _schema_application_security_group_read.tags
    tags.Element = AAZStrType()

    _schema.etag = _schema_application_security_group_read.etag
    _schema.id = _schema_application_security_group_read.id
    _schema.location = _schema_application_security_group_read.location
    _schema.name = _schema_application_security_group_read.name
    _schema.properties = _schema_application_security_group_read.properties
    _schema.tags = _schema_application_security_group_read.tags
    _schema.type = _schema_application_security_group_read.type


_schema_backend_address_pool_read = None


def _build_schema_backend_address_pool_read(_schema):
    global _schema_backend_address_pool_read
    if _schema_backend_address_pool_read is not None:
        _schema.etag = _schema_backend_address_pool_read.etag
        _schema.id = _schema_backend_address_pool_read.id
        _schema.name = _schema_backend_address_pool_read.name
        _schema.properties = _schema_backend_address_pool_read.properties
        _schema.type = _schema_backend_address_pool_read.type
        return

    _schema_backend_address_pool_read = AAZObjectType()

    backend_address_pool_read = _schema_backend_address_pool_read
    backend_address_pool_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    backend_address_pool_read.id = AAZStrType()
    backend_address_pool_read.name = AAZStrType()
    backend_address_pool_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    backend_address_pool_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_backend_address_pool_read.properties
    properties.backend_ip_configurations = AAZListType(
        serialized_name="backendIPConfigurations",
        flags={"read_only": True},
    )
    properties.drain_period_in_seconds = AAZIntType(
        serialized_name="drainPeriodInSeconds",
    )
    properties.inbound_nat_rules = AAZListType(
        serialized_name="inboundNatRules",
        flags={"read_only": True},
    )
    properties.load_balancer_backend_addresses = AAZListType(
        serialized_name="loadBalancerBackendAddresses",
    )
    properties.load_balancing_rules = AAZListType(
        serialized_name="loadBalancingRules",
        flags={"read_only": True},
    )
    properties.location = AAZStrType()
    properties.outbound_rule = AAZObjectType(
        serialized_name="outboundRule",
    )
    _build_schema_sub_resource_read(properties.outbound_rule)
    properties.outbound_rules = AAZListType(
        serialized_name="outboundRules",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.tunnel_interfaces = AAZListType(
        serialized_name="tunnelInterfaces",
    )

    backend_ip_configurations = _schema_backend_address_pool_read.properties.backend_ip_configurations
    backend_ip_configurations.Element = AAZObjectType()
    _build_schema_network_interface_ip_configuration_read(backend_ip_configurations.Element)

    inbound_nat_rules = _schema_backend_address_pool_read.properties.inbound_nat_rules
    inbound_nat_rules.Element = AAZObjectType()
    _build_schema_sub_resource_read(inbound_nat_rules.Element)

    load_balancer_backend_addresses = _schema_backend_address_pool_read.properties.load_balancer_backend_addresses
    load_balancer_backend_addresses.Element = AAZObjectType()

    _element = _schema_backend_address_pool_read.properties.load_balancer_backend_addresses.Element
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )

    properties = _schema_backend_address_pool_read.properties.load_balancer_backend_addresses.Element.properties
    properties.admin_state = AAZStrType(
        serialized_name="adminState",
    )
    properties.inbound_nat_rules_port_mapping = AAZListType(
        serialized_name="inboundNatRulesPortMapping",
        flags={"read_only": True},
    )
    properties.ip_address = AAZStrType(
        serialized_name="ipAddress",
    )
    properties.load_balancer_frontend_ip_configuration = AAZObjectType(
        serialized_name="loadBalancerFrontendIPConfiguration",
    )
    _build_schema_sub_resource_read(properties.load_balancer_frontend_ip_configuration)
    properties.network_interface_ip_configuration = AAZObjectType(
        serialized_name="networkInterfaceIPConfiguration",
    )
    _build_schema_sub_resource_read(properties.network_interface_ip_configuration)
    properties.subnet = AAZObjectType()
    _build_schema_sub_resource_read(properties.subnet)
    properties.virtual_network = AAZObjectType(
        serialized_name="virtualNetwork",
    )
    _build_schema_sub_resource_read(properties.virtual_network)

    inbound_nat_rules_port_mapping = _schema_backend_address_pool_read.properties.load_balancer_backend_addresses.Element.properties.inbound_nat_rules_port_mapping
    inbound_nat_rules_port_mapping.Element = AAZObjectType()

    _element = _schema_backend_address_pool_read.properties.load_balancer_backend_addresses.Element.properties.inbound_nat_rules_port_mapping.Element
    _element.backend_port = AAZIntType(
        serialized_name="backendPort",
    )
    _element.frontend_port = AAZIntType(
        serialized_name="frontendPort",
    )
    _element.inbound_nat_rule_name = AAZStrType(
        serialized_name="inboundNatRuleName",
    )

    load_balancing_rules = _schema_backend_address_pool_read.properties.load_balancing_rules
    load_balancing_rules.Element = AAZObjectType()
    _build_schema_sub_resource_read(load_balancing_rules.Element)

    outbound_rules = _schema_backend_address_pool_read.properties.outbound_rules
    outbound_rules.Element = AAZObjectType()
    _build_schema_sub_resource_read(outbound_rules.Element)

    tunnel_interfaces = _schema_backend_address_pool_read.properties.tunnel_interfaces
    tunnel_interfaces.Element = AAZObjectType()

    _element = _schema_backend_address_pool_read.properties.tunnel_interfaces.Element
    _element.identifier = AAZIntType()
    _element.port = AAZIntType()
    _element.protocol = AAZStrType()
    _element.type = AAZStrType()

    _schema.etag = _schema_backend_address_pool_read.etag
    _schema.id = _schema_backend_address_pool_read.id
    _schema.name = _schema_backend_address_pool_read.name
    _schema.properties = _schema_backend_address_pool_read.properties
    _schema.type = _schema_backend_address_pool_read.type


_schema_extended_location_read = None


def _build_schema_extended_location_read(_schema):
    global _schema_extended_location_read
    if _schema_extended_location_read is not None:
        _schema.name = _schema_extended_location_read.name
        _schema.type = _schema_extended_location_read.type
        return

    _schema_extended_location_read = AAZObjectType()

    extended_location_read = _schema_extended_location_read
    extended_location_read.name = AAZStrType()
    extended_location_read.type = AAZStrType()

    _schema.name = _schema_extended_location_read.name
    _schema.type = _schema_extended_location_read.type


_schema_frontend_ip_configuration_read = None


def _build_schema_frontend_ip_configuration_read(_schema):
    global _schema_frontend_ip_configuration_read
    if _schema_frontend_ip_configuration_read is not None:
        _schema.etag = _schema_frontend_ip_configuration_read.etag
        _schema.id = _schema_frontend_ip_configuration_read.id
        _schema.name = _schema_frontend_ip_configuration_read.name
        _schema.properties = _schema_frontend_ip_configuration_read.properties
        _schema.type = _schema_frontend_ip_configuration_read.type
        _schema.zones = _schema_frontend_ip_configuration_read.zones
        return

    _schema_frontend_ip_configuration_read = AAZObjectType()

    frontend_ip_configuration_read = _schema_frontend_ip_configuration_read
    frontend_ip_configuration_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    frontend_ip_configuration_read.id = AAZStrType()
    frontend_ip_configuration_read.name = AAZStrType()
    frontend_ip_configuration_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    frontend_ip_configuration_read.type = AAZStrType(
        flags={"read_only": True},
    )
    frontend_ip_configuration_read.zones = AAZListType()

    properties = _schema_frontend_ip_configuration_read.properties
    properties.gateway_load_balancer = AAZObjectType(
        serialized_name="gatewayLoadBalancer",
    )
    _build_schema_sub_resource_read(properties.gateway_load_balancer)
    properties.inbound_nat_pools = AAZListType(
        serialized_name="inboundNatPools",
        flags={"read_only": True},
    )
    properties.inbound_nat_rules = AAZListType(
        serialized_name="inboundNatRules",
        flags={"read_only": True},
    )
    properties.load_balancing_rules = AAZListType(
        serialized_name="loadBalancingRules",
        flags={"read_only": True},
    )
    properties.outbound_rules = AAZListType(
        serialized_name="outboundRules",
        flags={"read_only": True},
    )
    properties.private_ip_address = AAZStrType(
        serialized_name="privateIPAddress",
    )
    properties.private_ip_address_version = AAZStrType(
        serialized_name="privateIPAddressVersion",
    )
    properties.private_ip_allocation_method = AAZStrType(
        serialized_name="privateIPAllocationMethod",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.public_ip_address = AAZObjectType(
        serialized_name="publicIPAddress",
    )
    _build_schema_public_ip_address_read(properties.public_ip_address)
    properties.public_ip_prefix = AAZObjectType(
        serialized_name="publicIPPrefix",
    )
    _build_schema_sub_resource_read(properties.public_ip_prefix)
    properties.subnet = AAZObjectType()
    _build_schema_subnet_read(properties.subnet)

    inbound_nat_pools = _schema_frontend_ip_configuration_read.properties.inbound_nat_pools
    inbound_nat_pools.Element = AAZObjectType()
    _build_schema_sub_resource_read(inbound_nat_pools.Element)

    inbound_nat_rules = _schema_frontend_ip_configuration_read.properties.inbound_nat_rules
    inbound_nat_rules.Element = AAZObjectType()
    _build_schema_sub_resource_read(inbound_nat_rules.Element)

    load_balancing_rules = _schema_frontend_ip_configuration_read.properties.load_balancing_rules
    load_balancing_rules.Element = AAZObjectType()
    _build_schema_sub_resource_read(load_balancing_rules.Element)

    outbound_rules = _schema_frontend_ip_configuration_read.properties.outbound_rules
    outbound_rules.Element = AAZObjectType()
    _build_schema_sub_resource_read(outbound_rules.Element)

    zones = _schema_frontend_ip_configuration_read.zones
    zones.Element = AAZStrType()

    _schema.etag = _schema_frontend_ip_configuration_read.etag
    _schema.id = _schema_frontend_ip_configuration_read.id
    _schema.name = _schema_frontend_ip_configuration_read.name
    _schema.properties = _schema_frontend_ip_configuration_read.properties
    _schema.type = _schema_frontend_ip_configuration_read.type
    _schema.zones = _schema_frontend_ip_configuration_read.zones


_schema_ip_configuration_read = None


def _build_schema_ip_configuration_read(_schema):
    global _schema_ip_configuration_read
    if _schema_ip_configuration_read is not None:
        _schema.etag = _schema_ip_configuration_read.etag
        _schema.id = _schema_ip_configuration_read.id
        _schema.name = _schema_ip_configuration_read.name
        _schema.properties = _schema_ip_configuration_read.properties
        return

    _schema_ip_configuration_read = AAZObjectType()

    ip_configuration_read = _schema_ip_configuration_read
    ip_configuration_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    ip_configuration_read.id = AAZStrType()
    ip_configuration_read.name = AAZStrType()
    ip_configuration_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )

    properties = _schema_ip_configuration_read.properties
    properties.private_ip_address = AAZStrType(
        serialized_name="privateIPAddress",
    )
    properties.private_ip_allocation_method = AAZStrType(
        serialized_name="privateIPAllocationMethod",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.public_ip_address = AAZObjectType(
        serialized_name="publicIPAddress",
    )
    _build_schema_public_ip_address_read(properties.public_ip_address)
    properties.subnet = AAZObjectType()
    _build_schema_subnet_read(properties.subnet)

    _schema.etag = _schema_ip_configuration_read.etag
    _schema.id = _schema_ip_configuration_read.id
    _schema.name = _schema_ip_configuration_read.name
    _schema.properties = _schema_ip_configuration_read.properties


_schema_inbound_nat_rule_read = None


def _build_schema_inbound_nat_rule_read(_schema):
    global _schema_inbound_nat_rule_read
    if _schema_inbound_nat_rule_read is not None:
        _schema.etag = _schema_inbound_nat_rule_read.etag
        _schema.id = _schema_inbound_nat_rule_read.id
        _schema.name = _schema_inbound_nat_rule_read.name
        _schema.properties = _schema_inbound_nat_rule_read.properties
        _schema.type = _schema_inbound_nat_rule_read.type
        return

    _schema_inbound_nat_rule_read = AAZObjectType()

    inbound_nat_rule_read = _schema_inbound_nat_rule_read
    inbound_nat_rule_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    inbound_nat_rule_read.id = AAZStrType()
    inbound_nat_rule_read.name = AAZStrType()
    inbound_nat_rule_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    inbound_nat_rule_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_inbound_nat_rule_read.properties
    properties.backend_address_pool = AAZObjectType(
        serialized_name="backendAddressPool",
    )
    _build_schema_sub_resource_read(properties.backend_address_pool)
    properties.backend_ip_configuration = AAZObjectType(
        serialized_name="backendIPConfiguration",
    )
    _build_schema_network_interface_ip_configuration_read(properties.backend_ip_configuration)
    properties.backend_port = AAZIntType(
        serialized_name="backendPort",
    )
    properties.enable_floating_ip = AAZBoolType(
        serialized_name="enableFloatingIP",
    )
    properties.enable_tcp_reset = AAZBoolType(
        serialized_name="enableTcpReset",
    )
    properties.frontend_ip_configuration = AAZObjectType(
        serialized_name="frontendIPConfiguration",
    )
    _build_schema_sub_resource_read(properties.frontend_ip_configuration)
    properties.frontend_port = AAZIntType(
        serialized_name="frontendPort",
    )
    properties.frontend_port_range_end = AAZIntType(
        serialized_name="frontendPortRangeEnd",
    )
    properties.frontend_port_range_start = AAZIntType(
        serialized_name="frontendPortRangeStart",
    )
    properties.idle_timeout_in_minutes = AAZIntType(
        serialized_name="idleTimeoutInMinutes",
    )
    properties.protocol = AAZStrType()
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    _schema.etag = _schema_inbound_nat_rule_read.etag
    _schema.id = _schema_inbound_nat_rule_read.id
    _schema.name = _schema_inbound_nat_rule_read.name
    _schema.properties = _schema_inbound_nat_rule_read.properties
    _schema.type = _schema_inbound_nat_rule_read.type


_schema_network_interface_ip_configuration_read = None


def _build_schema_network_interface_ip_configuration_read(_schema):
    global _schema_network_interface_ip_configuration_read
    if _schema_network_interface_ip_configuration_read is not None:
        _schema.etag = _schema_network_interface_ip_configuration_read.etag
        _schema.id = _schema_network_interface_ip_configuration_read.id
        _schema.name = _schema_network_interface_ip_configuration_read.name
        _schema.properties = _schema_network_interface_ip_configuration_read.properties
        _schema.type = _schema_network_interface_ip_configuration_read.type
        return

    _schema_network_interface_ip_configuration_read = AAZObjectType()

    network_interface_ip_configuration_read = _schema_network_interface_ip_configuration_read
    network_interface_ip_configuration_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_ip_configuration_read.id = AAZStrType()
    network_interface_ip_configuration_read.name = AAZStrType()
    network_interface_ip_configuration_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    network_interface_ip_configuration_read.type = AAZStrType()

    properties = _schema_network_interface_ip_configuration_read.properties
    properties.application_gateway_backend_address_pools = AAZListType(
        serialized_name="applicationGatewayBackendAddressPools",
    )
    properties.application_security_groups = AAZListType(
        serialized_name="applicationSecurityGroups",
    )
    properties.gateway_load_balancer = AAZObjectType(
        serialized_name="gatewayLoadBalancer",
    )
    _build_schema_sub_resource_read(properties.gateway_load_balancer)
    properties.load_balancer_backend_address_pools = AAZListType(
        serialized_name="loadBalancerBackendAddressPools",
    )
    properties.load_balancer_inbound_nat_rules = AAZListType(
        serialized_name="loadBalancerInboundNatRules",
    )
    properties.primary = AAZBoolType()
    properties.private_ip_address = AAZStrType(
        serialized_name="privateIPAddress",
    )
    properties.private_ip_address_version = AAZStrType(
        serialized_name="privateIPAddressVersion",
    )
    properties.private_ip_allocation_method = AAZStrType(
        serialized_name="privateIPAllocationMethod",
    )
    properties.private_link_connection_properties = AAZObjectType(
        serialized_name="privateLinkConnectionProperties",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.public_ip_address = AAZObjectType(
        serialized_name="publicIPAddress",
    )
    _build_schema_public_ip_address_read(properties.public_ip_address)
    properties.subnet = AAZObjectType()
    _build_schema_subnet_read(properties.subnet)
    properties.virtual_network_taps = AAZListType(
        serialized_name="virtualNetworkTaps",
    )

    application_gateway_backend_address_pools = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools
    application_gateway_backend_address_pools.Element = AAZObjectType()

    _element = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties
    properties.backend_addresses = AAZListType(
        serialized_name="backendAddresses",
    )
    properties.backend_ip_configurations = AAZListType(
        serialized_name="backendIPConfigurations",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    backend_addresses = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties.backend_addresses
    backend_addresses.Element = AAZObjectType()

    _element = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties.backend_addresses.Element
    _element.fqdn = AAZStrType()
    _element.ip_address = AAZStrType(
        serialized_name="ipAddress",
    )

    backend_ip_configurations = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties.backend_ip_configurations
    backend_ip_configurations.Element = AAZObjectType()
    _build_schema_network_interface_ip_configuration_read(backend_ip_configurations.Element)

    application_security_groups = _schema_network_interface_ip_configuration_read.properties.application_security_groups
    application_security_groups.Element = AAZObjectType()
    _build_schema_application_security_group_read(application_security_groups.Element)

    load_balancer_backend_address_pools = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools
    load_balancer_backend_address_pools.Element = AAZObjectType()
    _build_schema_backend_address_pool_read(load_balancer_backend_address_pools.Element)

    load_balancer_inbound_nat_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules
    load_balancer_inbound_nat_rules.Element = AAZObjectType()
    _build_schema_inbound_nat_rule_read(load_balancer_inbound_nat_rules.Element)

    private_link_connection_properties = _schema_network_interface_ip_configuration_read.properties.private_link_connection_properties
    private_link_connection_properties.fqdns = AAZListType(
        flags={"read_only": True},
    )
    private_link_connection_properties.group_id = AAZStrType(
        serialized_name="groupId",
        flags={"read_only": True},
    )
    private_link_connection_properties.required_member_name = AAZStrType(
        serialized_name="requiredMemberName",
        flags={"read_only": True},
    )

    fqdns = _schema_network_interface_ip_configuration_read.properties.private_link_connection_properties.fqdns
    fqdns.Element = AAZStrType()

    virtual_network_taps = _schema_network_interface_ip_configuration_read.properties.virtual_network_taps
    virtual_network_taps.Element = AAZObjectType()
    _build_schema_virtual_network_tap_read(virtual_network_taps.Element)

    _schema.etag = _schema_network_interface_ip_configuration_read.etag
    _schema.id = _schema_network_interface_ip_configuration_read.id
    _schema.name = _schema_network_interface_ip_configuration_read.name
    _schema.properties = _schema_network_interface_ip_configuration_read.properties
    _schema.type = _schema_network_interface_ip_configuration_read.type


_schema_network_interface_tap_configuration_read = None


def _build_schema_network_interface_tap_configuration_read(_schema):
    global _schema_network_interface_tap_configuration_read
    if _schema_network_interface_tap_configuration_read is not None:
        _schema.etag = _schema_network_interface_tap_configuration_read.etag
        _schema.id = _schema_network_interface_tap_configuration_read.id
        _schema.name = _schema_network_interface_tap_configuration_read.name
        _schema.properties = _schema_network_interface_tap_configuration_read.properties
        _schema.type = _schema_network_interface_tap_configuration_read.type
        return

    _schema_network_interface_tap_configuration_read = AAZObjectType()

    network_interface_tap_configuration_read = _schema_network_interface_tap_configuration_read
    network_interface_tap_configuration_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_tap_configuration_read.id = AAZStrType()
    network_interface_tap_configuration_read.name = AAZStrType()
    network_interface_tap_configuration_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    network_interface_tap_configuration_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_tap_configuration_read.properties
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.virtual_network_tap = AAZObjectType(
        serialized_name="virtualNetworkTap",
    )
    _build_schema_virtual_network_tap_read(properties.virtual_network_tap)

    _schema.etag = _schema_network_interface_tap_configuration_read.etag
    _schema.id = _schema_network_interface_tap_configuration_read.id
    _schema.name = _schema_network_interface_tap_configuration_read.name
    _schema.properties = _schema_network_interface_tap_configuration_read.properties
    _schema.type = _schema_network_interface_tap_configuration_read.type


_schema_network_interface_read = None


def _build_schema_network_interface_read(_schema):
    global _schema_network_interface_read
    if _schema_network_interface_read is not None:
        _schema.etag = _schema_network_interface_read.etag
        _schema.extended_location = _schema_network_interface_read.extended_location
        _schema.id = _schema_network_interface_read.id
        _schema.location = _schema_network_interface_read.location
        _schema.name = _schema_network_interface_read.name
        _schema.properties = _schema_network_interface_read.properties
        _schema.tags = _schema_network_interface_read.tags
        _schema.type = _schema_network_interface_read.type
        return

    _schema_network_interface_read = AAZObjectType()

    network_interface_read = _schema_network_interface_read
    network_interface_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_read.extended_location = AAZObjectType(
        serialized_name="extendedLocation",
    )
    _build_schema_extended_location_read(network_interface_read.extended_location)
    network_interface_read.id = AAZStrType()
    network_interface_read.location = AAZStrType()
    network_interface_read.name = AAZStrType(
        flags={"read_only": True},
    )
    network_interface_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    network_interface_read.tags = AAZDictType()
    network_interface_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_read.properties
    properties.auxiliary_mode = AAZStrType(
        serialized_name="auxiliaryMode",
    )
    properties.disable_tcp_state_tracking = AAZBoolType(
        serialized_name="disableTcpStateTracking",
    )
    properties.dns_settings = AAZObjectType(
        serialized_name="dnsSettings",
    )
    properties.dscp_configuration = AAZObjectType(
        serialized_name="dscpConfiguration",
    )
    _build_schema_sub_resource_read(properties.dscp_configuration)
    properties.enable_accelerated_networking = AAZBoolType(
        serialized_name="enableAcceleratedNetworking",
    )
    properties.enable_ip_forwarding = AAZBoolType(
        serialized_name="enableIPForwarding",
    )
    properties.hosted_workloads = AAZListType(
        serialized_name="hostedWorkloads",
        flags={"read_only": True},
    )
    properties.ip_configurations = AAZListType(
        serialized_name="ipConfigurations",
    )
    properties.mac_address = AAZStrType(
        serialized_name="macAddress",
        flags={"read_only": True},
    )
    properties.migration_phase = AAZStrType(
        serialized_name="migrationPhase",
    )
    properties.network_security_group = AAZObjectType(
        serialized_name="networkSecurityGroup",
    )
    _build_schema_network_security_group_read(properties.network_security_group)
    properties.nic_type = AAZStrType(
        serialized_name="nicType",
    )
    properties.primary = AAZBoolType(
        flags={"read_only": True},
    )
    properties.private_endpoint = AAZObjectType(
        serialized_name="privateEndpoint",
    )
    _build_schema_private_endpoint_read(properties.private_endpoint)
    properties.private_link_service = AAZObjectType(
        serialized_name="privateLinkService",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.tap_configurations = AAZListType(
        serialized_name="tapConfigurations",
        flags={"read_only": True},
    )
    properties.virtual_machine = AAZObjectType(
        serialized_name="virtualMachine",
    )
    _build_schema_sub_resource_read(properties.virtual_machine)
    properties.vnet_encryption_supported = AAZBoolType(
        serialized_name="vnetEncryptionSupported",
        flags={"read_only": True},
    )
    properties.workload_type = AAZStrType(
        serialized_name="workloadType",
    )

    dns_settings = _schema_network_interface_read.properties.dns_settings
    dns_settings.applied_dns_servers = AAZListType(
        serialized_name="appliedDnsServers",
        flags={"read_only": True},
    )
    dns_settings.dns_servers = AAZListType(
        serialized_name="dnsServers",
    )
    dns_settings.internal_dns_name_label = AAZStrType(
        serialized_name="internalDnsNameLabel",
    )
    dns_settings.internal_domain_name_suffix = AAZStrType(
        serialized_name="internalDomainNameSuffix",
        flags={"read_only": True},
    )
    dns_settings.internal_fqdn = AAZStrType(
        serialized_name="internalFqdn",
        flags={"read_only": True},
    )

    applied_dns_servers = _schema_network_interface_read.properties.dns_settings.applied_dns_servers
    applied_dns_servers.Element = AAZStrType()

    dns_servers = _schema_network_interface_read.properties.dns_settings.dns_servers
    dns_servers.Element = AAZStrType()

    hosted_workloads = _schema_network_interface_read.properties.hosted_workloads
    hosted_workloads.Element = AAZStrType()

    ip_configurations = _schema_network_interface_read.properties.ip_configurations
    ip_configurations.Element = AAZObjectType()
    _build_schema_network_interface_ip_configuration_read(ip_configurations.Element)

    private_link_service = _schema_network_interface_read.properties.private_link_service
    private_link_service.etag = AAZStrType(
        flags={"read_only": True},
    )
    private_link_service.extended_location = AAZObjectType(
        serialized_name="extendedLocation",
    )
    _build_schema_extended_location_read(private_link_service.extended_location)
    private_link_service.id = AAZStrType()
    private_link_service.location = AAZStrType()
    private_link_service.name = AAZStrType(
        flags={"read_only": True},
    )
    private_link_service.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    private_link_service.tags = AAZDictType()
    private_link_service.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_read.properties.private_link_service.properties
    properties.alias = AAZStrType(
        flags={"read_only": True},
    )
    properties.auto_approval = AAZObjectType(
        serialized_name="autoApproval",
    )
    properties.enable_proxy_protocol = AAZBoolType(
        serialized_name="enableProxyProtocol",
    )
    properties.fqdns = AAZListType()
    properties.ip_configurations = AAZListType(
        serialized_name="ipConfigurations",
    )
    properties.load_balancer_frontend_ip_configurations = AAZListType(
        serialized_name="loadBalancerFrontendIpConfigurations",
    )
    properties.network_interfaces = AAZListType(
        serialized_name="networkInterfaces",
        flags={"read_only": True},
    )
    properties.private_endpoint_connections = AAZListType(
        serialized_name="privateEndpointConnections",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.visibility = AAZObjectType()

    auto_approval = _schema_network_interface_read.properties.private_link_service.properties.auto_approval
    auto_approval.subscriptions = AAZListType()

    subscriptions = _schema_network_interface_read.properties.private_link_service.properties.auto_approval.subscriptions
    subscriptions.Element = AAZStrType()

    fqdns = _schema_network_interface_read.properties.private_link_service.properties.fqdns
    fqdns.Element = AAZStrType()

    ip_configurations = _schema_network_interface_read.properties.private_link_service.properties.ip_configurations
    ip_configurations.Element = AAZObjectType()

    _element = _schema_network_interface_read.properties.private_link_service.properties.ip_configurations.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_read.properties.private_link_service.properties.ip_configurations.Element.properties
    properties.primary = AAZBoolType()
    properties.private_ip_address = AAZStrType(
        serialized_name="privateIPAddress",
    )
    properties.private_ip_address_version = AAZStrType(
        serialized_name="privateIPAddressVersion",
    )
    properties.private_ip_allocation_method = AAZStrType(
        serialized_name="privateIPAllocationMethod",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.subnet = AAZObjectType()
    _build_schema_subnet_read(properties.subnet)

    load_balancer_frontend_ip_configurations = _schema_network_interface_read.properties.private_link_service.properties.load_balancer_frontend_ip_configurations
    load_balancer_frontend_ip_configurations.Element = AAZObjectType()
    _build_schema_frontend_ip_configuration_read(load_balancer_frontend_ip_configurations.Element)

    network_interfaces = _schema_network_interface_read.properties.private_link_service.properties.network_interfaces
    network_interfaces.Element = AAZObjectType()
    _build_schema_network_interface_read(network_interfaces.Element)

    private_endpoint_connections = _schema_network_interface_read.properties.private_link_service.properties.private_endpoint_connections
    private_endpoint_connections.Element = AAZObjectType()

    _element = _schema_network_interface_read.properties.private_link_service.properties.private_endpoint_connections.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_interface_read.properties.private_link_service.properties.private_endpoint_connections.Element.properties
    properties.link_identifier = AAZStrType(
        serialized_name="linkIdentifier",
        flags={"read_only": True},
    )
    properties.private_endpoint = AAZObjectType(
        serialized_name="privateEndpoint",
    )
    _build_schema_private_endpoint_read(properties.private_endpoint)
    properties.private_link_service_connection_state = AAZObjectType(
        serialized_name="privateLinkServiceConnectionState",
    )
    _build_schema_private_link_service_connection_state_read(properties.private_link_service_connection_state)
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    visibility = _schema_network_interface_read.properties.private_link_service.properties.visibility
    visibility.subscriptions = AAZListType()

    subscriptions = _schema_network_interface_read.properties.private_link_service.properties.visibility.subscriptions
    subscriptions.Element = AAZStrType()

    tags = _schema_network_interface_read.properties.private_link_service.tags
    tags.Element = AAZStrType()

    tap_configurations = _schema_network_interface_read.properties.tap_configurations
    tap_configurations.Element = AAZObjectType()
    _build_schema_network_interface_tap_configuration_read(tap_configurations.Element)

    tags = _schema_network_interface_read.tags
    tags.Element = AAZStrType()

    _schema.etag = _schema_network_interface_read.etag
    _schema.extended_location = _schema_network_interface_read.extended_location
    _schema.id = _schema_network_interface_read.id
    _schema.location = _schema_network_interface_read.location
    _schema.name = _schema_network_interface_read.name
    _schema.properties = _schema_network_interface_read.properties
    _schema.tags = _schema_network_interface_read.tags
    _schema.type = _schema_network_interface_read.type


_schema_network_security_group_read = None


def _build_schema_network_security_group_read(_schema):
    global _schema_network_security_group_read
    if _schema_network_security_group_read is not None:
        _schema.etag = _schema_network_security_group_read.etag
        _schema.id = _schema_network_security_group_read.id
        _schema.location = _schema_network_security_group_read.location
        _schema.name = _schema_network_security_group_read.name
        _schema.properties = _schema_network_security_group_read.properties
        _schema.tags = _schema_network_security_group_read.tags
        _schema.type = _schema_network_security_group_read.type
        return

    _schema_network_security_group_read = AAZObjectType()

    network_security_group_read = _schema_network_security_group_read
    network_security_group_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    network_security_group_read.id = AAZStrType()
    network_security_group_read.location = AAZStrType()
    network_security_group_read.name = AAZStrType(
        flags={"read_only": True},
    )
    network_security_group_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    network_security_group_read.tags = AAZDictType()
    network_security_group_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_security_group_read.properties
    properties.default_security_rules = AAZListType(
        serialized_name="defaultSecurityRules",
        flags={"read_only": True},
    )
    properties.flow_logs = AAZListType(
        serialized_name="flowLogs",
        flags={"read_only": True},
    )
    properties.flush_connection = AAZBoolType(
        serialized_name="flushConnection",
    )
    properties.network_interfaces = AAZListType(
        serialized_name="networkInterfaces",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.security_rules = AAZListType(
        serialized_name="securityRules",
    )
    properties.subnets = AAZListType(
        flags={"read_only": True},
    )

    default_security_rules = _schema_network_security_group_read.properties.default_security_rules
    default_security_rules.Element = AAZObjectType()
    _build_schema_security_rule_read(default_security_rules.Element)

    flow_logs = _schema_network_security_group_read.properties.flow_logs
    flow_logs.Element = AAZObjectType()

    _element = _schema_network_security_group_read.properties.flow_logs.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.location = AAZStrType()
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.tags = AAZDictType()
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_network_security_group_read.properties.flow_logs.Element.properties
    properties.enabled = AAZBoolType()
    properties.flow_analytics_configuration = AAZObjectType(
        serialized_name="flowAnalyticsConfiguration",
    )
    properties.format = AAZObjectType()
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.retention_policy = AAZObjectType(
        serialized_name="retentionPolicy",
    )
    properties.storage_id = AAZStrType(
        serialized_name="storageId",
        flags={"required": True},
    )
    properties.target_resource_guid = AAZStrType(
        serialized_name="targetResourceGuid",
        flags={"read_only": True},
    )
    properties.target_resource_id = AAZStrType(
        serialized_name="targetResourceId",
        flags={"required": True},
    )

    flow_analytics_configuration = _schema_network_security_group_read.properties.flow_logs.Element.properties.flow_analytics_configuration
    flow_analytics_configuration.network_watcher_flow_analytics_configuration = AAZObjectType(
        serialized_name="networkWatcherFlowAnalyticsConfiguration",
    )

    network_watcher_flow_analytics_configuration = _schema_network_security_group_read.properties.flow_logs.Element.properties.flow_analytics_configuration.network_watcher_flow_analytics_configuration
    network_watcher_flow_analytics_configuration.enabled = AAZBoolType()
    network_watcher_flow_analytics_configuration.traffic_analytics_interval = AAZIntType(
        serialized_name="trafficAnalyticsInterval",
    )
    network_watcher_flow_analytics_configuration.workspace_id = AAZStrType(
        serialized_name="workspaceId",
    )
    network_watcher_flow_analytics_configuration.workspace_region = AAZStrType(
        serialized_name="workspaceRegion",
    )
    network_watcher_flow_analytics_configuration.workspace_resource_id = AAZStrType(
        serialized_name="workspaceResourceId",
    )

    format = _schema_network_security_group_read.properties.flow_logs.Element.properties.format
    format.type = AAZStrType()
    format.version = AAZIntType()

    retention_policy = _schema_network_security_group_read.properties.flow_logs.Element.properties.retention_policy
    retention_policy.days = AAZIntType()
    retention_policy.enabled = AAZBoolType()

    tags = _schema_network_security_group_read.properties.flow_logs.Element.tags
    tags.Element = AAZStrType()

    network_interfaces = _schema_network_security_group_read.properties.network_interfaces
    network_interfaces.Element = AAZObjectType()
    _build_schema_network_interface_read(network_interfaces.Element)

    security_rules = _schema_network_security_group_read.properties.security_rules
    security_rules.Element = AAZObjectType()
    _build_schema_security_rule_read(security_rules.Element)

    subnets = _schema_network_security_group_read.properties.subnets
    subnets.Element = AAZObjectType()
    _build_schema_subnet_read(subnets.Element)

    tags = _schema_network_security_group_read.tags
    tags.Element = AAZStrType()

    _schema.etag = _schema_network_security_group_read.etag
    _schema.id = _schema_network_security_group_read.id
    _schema.location = _schema_network_security_group_read.location
    _schema.name = _schema_network_security_group_read.name
    _schema.properties = _schema_network_security_group_read.properties
    _schema.tags = _schema_network_security_group_read.tags
    _schema.type = _schema_network_security_group_read.type


_schema_private_endpoint_read = None


def _build_schema_private_endpoint_read(_schema):
    global _schema_private_endpoint_read
    if _schema_private_endpoint_read is not None:
        _schema.etag = _schema_private_endpoint_read.etag
        _schema.extended_location = _schema_private_endpoint_read.extended_location
        _schema.id = _schema_private_endpoint_read.id
        _schema.location = _schema_private_endpoint_read.location
        _schema.name = _schema_private_endpoint_read.name
        _schema.properties = _schema_private_endpoint_read.properties
        _schema.tags = _schema_private_endpoint_read.tags
        _schema.type = _schema_private_endpoint_read.type
        return

    _schema_private_endpoint_read = AAZObjectType()

    private_endpoint_read = _schema_private_endpoint_read
    private_endpoint_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    private_endpoint_read.extended_location = AAZObjectType(
        serialized_name="extendedLocation",
    )
    _build_schema_extended_location_read(private_endpoint_read.extended_location)
    private_endpoint_read.id = AAZStrType()
    private_endpoint_read.location = AAZStrType()
    private_endpoint_read.name = AAZStrType(
        flags={"read_only": True},
    )
    private_endpoint_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    private_endpoint_read.tags = AAZDictType()
    private_endpoint_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_private_endpoint_read.properties
    properties.application_security_groups = AAZListType(
        serialized_name="applicationSecurityGroups",
    )
    properties.custom_dns_configs = AAZListType(
        serialized_name="customDnsConfigs",
    )
    properties.custom_network_interface_name = AAZStrType(
        serialized_name="customNetworkInterfaceName",
    )
    properties.ip_configurations = AAZListType(
        serialized_name="ipConfigurations",
    )
    properties.manual_private_link_service_connections = AAZListType(
        serialized_name="manualPrivateLinkServiceConnections",
    )
    properties.network_interfaces = AAZListType(
        serialized_name="networkInterfaces",
        flags={"read_only": True},
    )
    properties.private_link_service_connections = AAZListType(
        serialized_name="privateLinkServiceConnections",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.subnet = AAZObjectType()
    _build_schema_subnet_read(properties.subnet)

    application_security_groups = _schema_private_endpoint_read.properties.application_security_groups
    application_security_groups.Element = AAZObjectType()
    _build_schema_application_security_group_read(application_security_groups.Element)

    custom_dns_configs = _schema_private_endpoint_read.properties.custom_dns_configs
    custom_dns_configs.Element = AAZObjectType()

    _element = _schema_private_endpoint_read.properties.custom_dns_configs.Element
    _element.fqdn = AAZStrType()
    _element.ip_addresses = AAZListType(
        serialized_name="ipAddresses",
    )

    ip_addresses = _schema_private_endpoint_read.properties.custom_dns_configs.Element.ip_addresses
    ip_addresses.Element = AAZStrType()

    ip_configurations = _schema_private_endpoint_read.properties.ip_configurations
    ip_configurations.Element = AAZObjectType()

    _element = _schema_private_endpoint_read.properties.ip_configurations.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_private_endpoint_read.properties.ip_configurations.Element.properties
    properties.group_id = AAZStrType(
        serialized_name="groupId",
    )
    properties.member_name = AAZStrType(
        serialized_name="memberName",
    )
    properties.private_ip_address = AAZStrType(
        serialized_name="privateIPAddress",
    )

    manual_private_link_service_connections = _schema_private_endpoint_read.properties.manual_private_link_service_connections
    manual_private_link_service_connections.Element = AAZObjectType()
    _build_schema_private_link_service_connection_read(manual_private_link_service_connections.Element)

    network_interfaces = _schema_private_endpoint_read.properties.network_interfaces
    network_interfaces.Element = AAZObjectType()
    _build_schema_network_interface_read(network_interfaces.Element)

    private_link_service_connections = _schema_private_endpoint_read.properties.private_link_service_connections
    private_link_service_connections.Element = AAZObjectType()
    _build_schema_private_link_service_connection_read(private_link_service_connections.Element)

    tags = _schema_private_endpoint_read.tags
    tags.Element = AAZStrType()

    _schema.etag = _schema_private_endpoint_read.etag
    _schema.extended_location = _schema_private_endpoint_read.extended_location
    _schema.id = _schema_private_endpoint_read.id
    _schema.location = _schema_private_endpoint_read.location
    _schema.name = _schema_private_endpoint_read.name
    _schema.properties = _schema_private_endpoint_read.properties
    _schema.tags = _schema_private_endpoint_read.tags
    _schema.type = _schema_private_endpoint_read.type


_schema_private_link_service_connection_state_read = None


def _build_schema_private_link_service_connection_state_read(_schema):
    global _schema_private_link_service_connection_state_read
    if _schema_private_link_service_connection_state_read is not None:
        _schema.actions_required = _schema_private_link_service_connection_state_read.actions_required
        _schema.description = _schema_private_link_service_connection_state_read.description
        _schema.status = _schema_private_link_service_connection_state_read.status
        return

    _schema_private_link_service_connection_state_read = AAZObjectType()

    private_link_service_connection_state_read = _schema_private_link_service_connection_state_read
    private_link_service_connection_state_read.actions_required = AAZStrType(
        serialized_name="actionsRequired",
    )
    private_link_service_connection_state_read.description = AAZStrType()
    private_link_service_connection_state_read.status = AAZStrType()

    _schema.actions_required = _schema_private_link_service_connection_state_read.actions_required
    _schema.description = _schema_private_link_service_connection_state_read.description
    _schema.status = _schema_private_link_service_connection_state_read.status


_schema_private_link_service_connection_read = None


def _build_schema_private_link_service_connection_read(_schema):
    global _schema_private_link_service_connection_read
    if _schema_private_link_service_connection_read is not None:
        _schema.etag = _schema_private_link_service_connection_read.etag
        _schema.id = _schema_private_link_service_connection_read.id
        _schema.name = _schema_private_link_service_connection_read.name
        _schema.properties = _schema_private_link_service_connection_read.properties
        _schema.type = _schema_private_link_service_connection_read.type
        return

    _schema_private_link_service_connection_read = AAZObjectType()

    private_link_service_connection_read = _schema_private_link_service_connection_read
    private_link_service_connection_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    private_link_service_connection_read.id = AAZStrType()
    private_link_service_connection_read.name = AAZStrType()
    private_link_service_connection_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    private_link_service_connection_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_private_link_service_connection_read.properties
    properties.group_ids = AAZListType(
        serialized_name="groupIds",
    )
    properties.private_link_service_connection_state = AAZObjectType(
        serialized_name="privateLinkServiceConnectionState",
    )
    _build_schema_private_link_service_connection_state_read(properties.private_link_service_connection_state)
    properties.private_link_service_id = AAZStrType(
        serialized_name="privateLinkServiceId",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.request_message = AAZStrType(
        serialized_name="requestMessage",
    )

    group_ids = _schema_private_link_service_connection_read.properties.group_ids
    group_ids.Element = AAZStrType()

    _schema.etag = _schema_private_link_service_connection_read.etag
    _schema.id = _schema_private_link_service_connection_read.id
    _schema.name = _schema_private_link_service_connection_read.name
    _schema.properties = _schema_private_link_service_connection_read.properties
    _schema.type = _schema_private_link_service_connection_read.type


_schema_public_ip_address_read = None


def _build_schema_public_ip_address_read(_schema):
    global _schema_public_ip_address_read
    if _schema_public_ip_address_read is not None:
        _schema.etag = _schema_public_ip_address_read.etag
        _schema.extended_location = _schema_public_ip_address_read.extended_location
        _schema.id = _schema_public_ip_address_read.id
        _schema.location = _schema_public_ip_address_read.location
        _schema.name = _schema_public_ip_address_read.name
        _schema.properties = _schema_public_ip_address_read.properties
        _schema.sku = _schema_public_ip_address_read.sku
        _schema.tags = _schema_public_ip_address_read.tags
        _schema.type = _schema_public_ip_address_read.type
        _schema.zones = _schema_public_ip_address_read.zones
        return

    _schema_public_ip_address_read = AAZObjectType()

    public_ip_address_read = _schema_public_ip_address_read
    public_ip_address_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    public_ip_address_read.extended_location = AAZObjectType(
        serialized_name="extendedLocation",
    )
    _build_schema_extended_location_read(public_ip_address_read.extended_location)
    public_ip_address_read.id = AAZStrType()
    public_ip_address_read.location = AAZStrType()
    public_ip_address_read.name = AAZStrType(
        flags={"read_only": True},
    )
    public_ip_address_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    public_ip_address_read.sku = AAZObjectType()
    public_ip_address_read.tags = AAZDictType()
    public_ip_address_read.type = AAZStrType(
        flags={"read_only": True},
    )
    public_ip_address_read.zones = AAZListType()

    properties = _schema_public_ip_address_read.properties
    properties.ddos_settings = AAZObjectType(
        serialized_name="ddosSettings",
    )
    properties.delete_option = AAZStrType(
        serialized_name="deleteOption",
    )
    properties.dns_settings = AAZObjectType(
        serialized_name="dnsSettings",
    )
    properties.idle_timeout_in_minutes = AAZIntType(
        serialized_name="idleTimeoutInMinutes",
    )
    properties.ip_address = AAZStrType(
        serialized_name="ipAddress",
    )
    properties.ip_configuration = AAZObjectType(
        serialized_name="ipConfiguration",
    )
    _build_schema_ip_configuration_read(properties.ip_configuration)
    properties.ip_tags = AAZListType(
        serialized_name="ipTags",
    )
    properties.linked_public_ip_address = AAZObjectType(
        serialized_name="linkedPublicIPAddress",
    )
    _build_schema_public_ip_address_read(properties.linked_public_ip_address)
    properties.migration_phase = AAZStrType(
        serialized_name="migrationPhase",
    )
    properties.nat_gateway = AAZObjectType(
        serialized_name="natGateway",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.public_ip_address_version = AAZStrType(
        serialized_name="publicIPAddressVersion",
    )
    properties.public_ip_allocation_method = AAZStrType(
        serialized_name="publicIPAllocationMethod",
    )
    properties.public_ip_prefix = AAZObjectType(
        serialized_name="publicIPPrefix",
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.service_public_ip_address = AAZObjectType(
        serialized_name="servicePublicIPAddress",
    )
    _build_schema_public_ip_address_read(properties.service_public_ip_address)

    ddos_settings = _schema_public_ip_address_read.properties.ddos_settings
    ddos_settings.ddos_protection_plan = AAZObjectType(
        serialized_name="ddosProtectionPlan",
    )
    ddos_settings.protection_mode = AAZStrType(
        serialized_name="protectionMode",
    )

    ddos_protection_plan = _schema_public_ip_address_read.properties.ddos_settings.ddos_protection_plan
    ddos_protection_plan.id = AAZStrType()

    dns_settings = _schema_public_ip_address_read.properties.dns_settings
    dns_settings.domain_name_label = AAZStrType(
        serialized_name="domainNameLabel",
    )
    dns_settings.fqdn = AAZStrType()
    dns_settings.reverse_fqdn = AAZStrType(
        serialized_name="reverseFqdn",
    )

    ip_tags = _schema_public_ip_address_read.properties.ip_tags
    ip_tags.Element = AAZObjectType()

    _element = _schema_public_ip_address_read.properties.ip_tags.Element
    _element.ip_tag_type = AAZStrType(
        serialized_name="ipTagType",
    )
    _element.tag = AAZStrType()

    nat_gateway = _schema_public_ip_address_read.properties.nat_gateway
    nat_gateway.etag = AAZStrType(
        flags={"read_only": True},
    )
    nat_gateway.id = AAZStrType()
    nat_gateway.location = AAZStrType()
    nat_gateway.name = AAZStrType(
        flags={"read_only": True},
    )
    nat_gateway.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    nat_gateway.sku = AAZObjectType()
    nat_gateway.tags = AAZDictType()
    nat_gateway.type = AAZStrType(
        flags={"read_only": True},
    )
    nat_gateway.zones = AAZListType()

    properties = _schema_public_ip_address_read.properties.nat_gateway.properties
    properties.idle_timeout_in_minutes = AAZIntType(
        serialized_name="idleTimeoutInMinutes",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.public_ip_addresses = AAZListType(
        serialized_name="publicIpAddresses",
    )
    properties.public_ip_prefixes = AAZListType(
        serialized_name="publicIpPrefixes",
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.subnets = AAZListType(
        flags={"read_only": True},
    )

    public_ip_addresses = _schema_public_ip_address_read.properties.nat_gateway.properties.public_ip_addresses
    public_ip_addresses.Element = AAZObjectType()
    _build_schema_sub_resource_read(public_ip_addresses.Element)

    public_ip_prefixes = _schema_public_ip_address_read.properties.nat_gateway.properties.public_ip_prefixes
    public_ip_prefixes.Element = AAZObjectType()
    _build_schema_sub_resource_read(public_ip_prefixes.Element)

    subnets = _schema_public_ip_address_read.properties.nat_gateway.properties.subnets
    subnets.Element = AAZObjectType()
    _build_schema_sub_resource_read(subnets.Element)

    sku = _schema_public_ip_address_read.properties.nat_gateway.sku
    sku.name = AAZStrType()

    tags = _schema_public_ip_address_read.properties.nat_gateway.tags
    tags.Element = AAZStrType()

    zones = _schema_public_ip_address_read.properties.nat_gateway.zones
    zones.Element = AAZStrType()

    public_ip_prefix = _schema_public_ip_address_read.properties.public_ip_prefix
    public_ip_prefix.id = AAZStrType()

    sku = _schema_public_ip_address_read.sku
    sku.name = AAZStrType()
    sku.tier = AAZStrType()

    tags = _schema_public_ip_address_read.tags
    tags.Element = AAZStrType()

    zones = _schema_public_ip_address_read.zones
    zones.Element = AAZStrType()

    _schema.etag = _schema_public_ip_address_read.etag
    _schema.extended_location = _schema_public_ip_address_read.extended_location
    _schema.id = _schema_public_ip_address_read.id
    _schema.location = _schema_public_ip_address_read.location
    _schema.name = _schema_public_ip_address_read.name
    _schema.properties = _schema_public_ip_address_read.properties
    _schema.sku = _schema_public_ip_address_read.sku
    _schema.tags = _schema_public_ip_address_read.tags
    _schema.type = _schema_public_ip_address_read.type
    _schema.zones = _schema_public_ip_address_read.zones


_schema_security_rule_read = None


def _build_schema_security_rule_read(_schema):
    global _schema_security_rule_read
    if _schema_security_rule_read is not None:
        _schema.etag = _schema_security_rule_read.etag
        _schema.id = _schema_security_rule_read.id
        _schema.name = _schema_security_rule_read.name
        _schema.properties = _schema_security_rule_read.properties
        _schema.type = _schema_security_rule_read.type
        return

    _schema_security_rule_read = AAZObjectType()

    security_rule_read = _schema_security_rule_read
    security_rule_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    security_rule_read.id = AAZStrType()
    security_rule_read.name = AAZStrType()
    security_rule_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    security_rule_read.type = AAZStrType()

    properties = _schema_security_rule_read.properties
    properties.access = AAZStrType(
        flags={"required": True},
    )
    properties.description = AAZStrType()
    properties.destination_address_prefix = AAZStrType(
        serialized_name="destinationAddressPrefix",
    )
    properties.destination_address_prefixes = AAZListType(
        serialized_name="destinationAddressPrefixes",
    )
    properties.destination_application_security_groups = AAZListType(
        serialized_name="destinationApplicationSecurityGroups",
    )
    properties.destination_port_range = AAZStrType(
        serialized_name="destinationPortRange",
    )
    properties.destination_port_ranges = AAZListType(
        serialized_name="destinationPortRanges",
    )
    properties.direction = AAZStrType(
        flags={"required": True},
    )
    properties.priority = AAZIntType()
    properties.protocol = AAZStrType(
        flags={"required": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.source_address_prefix = AAZStrType(
        serialized_name="sourceAddressPrefix",
    )
    properties.source_address_prefixes = AAZListType(
        serialized_name="sourceAddressPrefixes",
    )
    properties.source_application_security_groups = AAZListType(
        serialized_name="sourceApplicationSecurityGroups",
    )
    properties.source_port_range = AAZStrType(
        serialized_name="sourcePortRange",
    )
    properties.source_port_ranges = AAZListType(
        serialized_name="sourcePortRanges",
    )

    destination_address_prefixes = _schema_security_rule_read.properties.destination_address_prefixes
    destination_address_prefixes.Element = AAZStrType()

    destination_application_security_groups = _schema_security_rule_read.properties.destination_application_security_groups
    destination_application_security_groups.Element = AAZObjectType()
    _build_schema_application_security_group_read(destination_application_security_groups.Element)

    destination_port_ranges = _schema_security_rule_read.properties.destination_port_ranges
    destination_port_ranges.Element = AAZStrType()

    source_address_prefixes = _schema_security_rule_read.properties.source_address_prefixes
    source_address_prefixes.Element = AAZStrType()

    source_application_security_groups = _schema_security_rule_read.properties.source_application_security_groups
    source_application_security_groups.Element = AAZObjectType()
    _build_schema_application_security_group_read(source_application_security_groups.Element)

    source_port_ranges = _schema_security_rule_read.properties.source_port_ranges
    source_port_ranges.Element = AAZStrType()

    _schema.etag = _schema_security_rule_read.etag
    _schema.id = _schema_security_rule_read.id
    _schema.name = _schema_security_rule_read.name
    _schema.properties = _schema_security_rule_read.properties
    _schema.type = _schema_security_rule_read.type


_schema_sub_resource_read = None


def _build_schema_sub_resource_read(_schema):
    global _schema_sub_resource_read
    if _schema_sub_resource_read is not None:
        _schema.id = _schema_sub_resource_read.id
        return

    _schema_sub_resource_read = AAZObjectType()

    sub_resource_read = _schema_sub_resource_read
    sub_resource_read.id = AAZStrType()

    _schema.id = _schema_sub_resource_read.id


_schema_subnet_read = None


def _build_schema_subnet_read(_schema):
    global _schema_subnet_read
    if _schema_subnet_read is not None:
        _schema.etag = _schema_subnet_read.etag
        _schema.id = _schema_subnet_read.id
        _schema.name = _schema_subnet_read.name
        _schema.properties = _schema_subnet_read.properties
        _schema.type = _schema_subnet_read.type
        return

    _schema_subnet_read = AAZObjectType()

    subnet_read = _schema_subnet_read
    subnet_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    subnet_read.id = AAZStrType()
    subnet_read.name = AAZStrType()
    subnet_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    subnet_read.type = AAZStrType()

    properties = _schema_subnet_read.properties
    properties.address_prefix = AAZStrType(
        serialized_name="addressPrefix",
    )
    properties.address_prefixes = AAZListType(
        serialized_name="addressPrefixes",
    )
    properties.application_gateway_ip_configurations = AAZListType(
        serialized_name="applicationGatewayIpConfigurations",
    )
    properties.delegations = AAZListType()
    properties.ip_allocations = AAZListType(
        serialized_name="ipAllocations",
    )
    properties.ip_configuration_profiles = AAZListType(
        serialized_name="ipConfigurationProfiles",
        flags={"read_only": True},
    )
    properties.ip_configurations = AAZListType(
        serialized_name="ipConfigurations",
        flags={"read_only": True},
    )
    properties.nat_gateway = AAZObjectType(
        serialized_name="natGateway",
    )
    _build_schema_sub_resource_read(properties.nat_gateway)
    properties.network_security_group = AAZObjectType(
        serialized_name="networkSecurityGroup",
    )
    _build_schema_network_security_group_read(properties.network_security_group)
    properties.private_endpoint_network_policies = AAZStrType(
        serialized_name="privateEndpointNetworkPolicies",
    )
    properties.private_endpoints = AAZListType(
        serialized_name="privateEndpoints",
        flags={"read_only": True},
    )
    properties.private_link_service_network_policies = AAZStrType(
        serialized_name="privateLinkServiceNetworkPolicies",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.purpose = AAZStrType(
        flags={"read_only": True},
    )
    properties.resource_navigation_links = AAZListType(
        serialized_name="resourceNavigationLinks",
        flags={"read_only": True},
    )
    properties.route_table = AAZObjectType(
        serialized_name="routeTable",
    )
    properties.service_association_links = AAZListType(
        serialized_name="serviceAssociationLinks",
        flags={"read_only": True},
    )
    properties.service_endpoint_policies = AAZListType(
        serialized_name="serviceEndpointPolicies",
    )
    properties.service_endpoints = AAZListType(
        serialized_name="serviceEndpoints",
    )

    address_prefixes = _schema_subnet_read.properties.address_prefixes
    address_prefixes.Element = AAZStrType()

    application_gateway_ip_configurations = _schema_subnet_read.properties.application_gateway_ip_configurations
    application_gateway_ip_configurations.Element = AAZObjectType()

    _element = _schema_subnet_read.properties.application_gateway_ip_configurations.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subnet_read.properties.application_gateway_ip_configurations.Element.properties
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.subnet = AAZObjectType()
    _build_schema_sub_resource_read(properties.subnet)

    delegations = _schema_subnet_read.properties.delegations
    delegations.Element = AAZObjectType()

    _element = _schema_subnet_read.properties.delegations.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType()

    properties = _schema_subnet_read.properties.delegations.Element.properties
    properties.actions = AAZListType(
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.service_name = AAZStrType(
        serialized_name="serviceName",
    )

    actions = _schema_subnet_read.properties.delegations.Element.properties.actions
    actions.Element = AAZStrType()

    ip_allocations = _schema_subnet_read.properties.ip_allocations
    ip_allocations.Element = AAZObjectType()
    _build_schema_sub_resource_read(ip_allocations.Element)

    ip_configuration_profiles = _schema_subnet_read.properties.ip_configuration_profiles
    ip_configuration_profiles.Element = AAZObjectType()

    _element = _schema_subnet_read.properties.ip_configuration_profiles.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subnet_read.properties.ip_configuration_profiles.Element.properties
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.subnet = AAZObjectType()
    _build_schema_subnet_read(properties.subnet)

    ip_configurations = _schema_subnet_read.properties.ip_configurations
    ip_configurations.Element = AAZObjectType()
    _build_schema_ip_configuration_read(ip_configurations.Element)

    private_endpoints = _schema_subnet_read.properties.private_endpoints
    private_endpoints.Element = AAZObjectType()
    _build_schema_private_endpoint_read(private_endpoints.Element)

    resource_navigation_links = _schema_subnet_read.properties.resource_navigation_links
    resource_navigation_links.Element = AAZObjectType()

    _element = _schema_subnet_read.properties.resource_navigation_links.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType(
        flags={"read_only": True},
    )
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subnet_read.properties.resource_navigation_links.Element.properties
    properties.link = AAZStrType()
    properties.linked_resource_type = AAZStrType(
        serialized_name="linkedResourceType",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    route_table = _schema_subnet_read.properties.route_table
    route_table.etag = AAZStrType(
        flags={"read_only": True},
    )
    route_table.id = AAZStrType()
    route_table.location = AAZStrType()
    route_table.name = AAZStrType(
        flags={"read_only": True},
    )
    route_table.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    route_table.tags = AAZDictType()
    route_table.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subnet_read.properties.route_table.properties
    properties.disable_bgp_route_propagation = AAZBoolType(
        serialized_name="disableBgpRoutePropagation",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.routes = AAZListType()
    properties.subnets = AAZListType(
        flags={"read_only": True},
    )

    routes = _schema_subnet_read.properties.route_table.properties.routes
    routes.Element = AAZObjectType()

    _element = _schema_subnet_read.properties.route_table.properties.routes.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType()

    properties = _schema_subnet_read.properties.route_table.properties.routes.Element.properties
    properties.address_prefix = AAZStrType(
        serialized_name="addressPrefix",
    )
    properties.has_bgp_override = AAZBoolType(
        serialized_name="hasBgpOverride",
    )
    properties.next_hop_ip_address = AAZStrType(
        serialized_name="nextHopIpAddress",
    )
    properties.next_hop_type = AAZStrType(
        serialized_name="nextHopType",
        flags={"required": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    subnets = _schema_subnet_read.properties.route_table.properties.subnets
    subnets.Element = AAZObjectType()
    _build_schema_subnet_read(subnets.Element)

    tags = _schema_subnet_read.properties.route_table.tags
    tags.Element = AAZStrType()

    service_association_links = _schema_subnet_read.properties.service_association_links
    service_association_links.Element = AAZObjectType()

    _element = _schema_subnet_read.properties.service_association_links.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subnet_read.properties.service_association_links.Element.properties
    properties.allow_delete = AAZBoolType(
        serialized_name="allowDelete",
    )
    properties.link = AAZStrType()
    properties.linked_resource_type = AAZStrType(
        serialized_name="linkedResourceType",
    )
    properties.locations = AAZListType()
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )

    locations = _schema_subnet_read.properties.service_association_links.Element.properties.locations
    locations.Element = AAZStrType()

    service_endpoint_policies = _schema_subnet_read.properties.service_endpoint_policies
    service_endpoint_policies.Element = AAZObjectType()

    _element = _schema_subnet_read.properties.service_endpoint_policies.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.kind = AAZStrType(
        flags={"read_only": True},
    )
    _element.location = AAZStrType()
    _element.name = AAZStrType(
        flags={"read_only": True},
    )
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.tags = AAZDictType()
    _element.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_subnet_read.properties.service_endpoint_policies.Element.properties
    properties.contextual_service_endpoint_policies = AAZListType(
        serialized_name="contextualServiceEndpointPolicies",
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )
    properties.service_alias = AAZStrType(
        serialized_name="serviceAlias",
    )
    properties.service_endpoint_policy_definitions = AAZListType(
        serialized_name="serviceEndpointPolicyDefinitions",
    )
    properties.subnets = AAZListType(
        flags={"read_only": True},
    )

    contextual_service_endpoint_policies = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.contextual_service_endpoint_policies
    contextual_service_endpoint_policies.Element = AAZStrType()

    service_endpoint_policy_definitions = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions
    service_endpoint_policy_definitions.Element = AAZObjectType()

    _element = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element
    _element.etag = AAZStrType(
        flags={"read_only": True},
    )
    _element.id = AAZStrType()
    _element.name = AAZStrType()
    _element.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    _element.type = AAZStrType()

    properties = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element.properties
    properties.description = AAZStrType()
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.service = AAZStrType()
    properties.service_resources = AAZListType(
        serialized_name="serviceResources",
    )

    service_resources = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element.properties.service_resources
    service_resources.Element = AAZStrType()

    subnets = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.subnets
    subnets.Element = AAZObjectType()
    _build_schema_subnet_read(subnets.Element)

    tags = _schema_subnet_read.properties.service_endpoint_policies.Element.tags
    tags.Element = AAZStrType()

    service_endpoints = _schema_subnet_read.properties.service_endpoints
    service_endpoints.Element = AAZObjectType()

    _element = _schema_subnet_read.properties.service_endpoints.Element
    _element.locations = AAZListType()
    _element.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    _element.service = AAZStrType()

    locations = _schema_subnet_read.properties.service_endpoints.Element.locations
    locations.Element = AAZStrType()

    _schema.etag = _schema_subnet_read.etag
    _schema.id = _schema_subnet_read.id
    _schema.name = _schema_subnet_read.name
    _schema.properties = _schema_subnet_read.properties
    _schema.type = _schema_subnet_read.type


_schema_virtual_network_tap_read = None


def _build_schema_virtual_network_tap_read(_schema):
    global _schema_virtual_network_tap_read
    if _schema_virtual_network_tap_read is not None:
        _schema.etag = _schema_virtual_network_tap_read.etag
        _schema.id = _schema_virtual_network_tap_read.id
        _schema.location = _schema_virtual_network_tap_read.location
        _schema.name = _schema_virtual_network_tap_read.name
        _schema.properties = _schema_virtual_network_tap_read.properties
        _schema.tags = _schema_virtual_network_tap_read.tags
        _schema.type = _schema_virtual_network_tap_read.type
        return

    _schema_virtual_network_tap_read = AAZObjectType()

    virtual_network_tap_read = _schema_virtual_network_tap_read
    virtual_network_tap_read.etag = AAZStrType(
        flags={"read_only": True},
    )
    virtual_network_tap_read.id = AAZStrType()
    virtual_network_tap_read.location = AAZStrType()
    virtual_network_tap_read.name = AAZStrType(
        flags={"read_only": True},
    )
    virtual_network_tap_read.properties = AAZObjectType(
        flags={"client_flatten": True},
    )
    virtual_network_tap_read.tags = AAZDictType()
    virtual_network_tap_read.type = AAZStrType(
        flags={"read_only": True},
    )

    properties = _schema_virtual_network_tap_read.properties
    properties.destination_load_balancer_front_end_ip_configuration = AAZObjectType(
        serialized_name="destinationLoadBalancerFrontEndIPConfiguration",
    )
    _build_schema_frontend_ip_configuration_read(properties.destination_load_balancer_front_end_ip_configuration)
    properties.destination_network_interface_ip_configuration = AAZObjectType(
        serialized_name="destinationNetworkInterfaceIPConfiguration",
    )
    _build_schema_network_interface_ip_configuration_read(properties.destination_network_interface_ip_configuration)
    properties.destination_port = AAZIntType(
        serialized_name="destinationPort",
    )
    properties.network_interface_tap_configurations = AAZListType(
        serialized_name="networkInterfaceTapConfigurations",
        flags={"read_only": True},
    )
    properties.provisioning_state = AAZStrType(
        serialized_name="provisioningState",
        flags={"read_only": True},
    )
    properties.resource_guid = AAZStrType(
        serialized_name="resourceGuid",
        flags={"read_only": True},
    )

    network_interface_tap_configurations = _schema_virtual_network_tap_read.properties.network_interface_tap_configurations
    network_interface_tap_configurations.Element = AAZObjectType()
    _build_schema_network_interface_tap_configuration_read(network_interface_tap_configurations.Element)

    tags = _schema_virtual_network_tap_read.tags
    tags.Element = AAZStrType()

    _schema.etag = _schema_virtual_network_tap_read.etag
    _schema.id = _schema_virtual_network_tap_read.id
    _schema.location = _schema_virtual_network_tap_read.location
    _schema.name = _schema_virtual_network_tap_read.name
    _schema.properties = _schema_virtual_network_tap_read.properties
    _schema.tags = _schema_virtual_network_tap_read.tags
    _schema.type = _schema_virtual_network_tap_read.type


__all__ = ["Create"]
