/**
 * ***** BEGIN GPL LICENSE BLOCK *****
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * The Original Code is Copyright (C) 2001-2002 by NaN Holding BV.
 * All rights reserved.
 *
 * The Original Code is: all of this file.
 *
 * Contributor(s): none yet.
 *
 * ***** END GPL LICENSE BLOCK *****
 */

#ifndef __GLUTMOUSEMANAGER_H__
#define __GLUTMOUSEMANAGER_H__

#include "MEM_NonCopyable.h"
#include "MEM_SmartPtr.h"
#include "GHOST_Types.h"

class GHOST_IWindow;

class GlutMouseHandler {
public :

	virtual		
		void
	ButtonUp(
		GHOST_IWindow * window,
		GHOST_TButtonMask button_mask,
		int x,
		int y
	) = 0;

	virtual		
		void
	ButtonDown(
		GHOST_IWindow * window,
		GHOST_TButtonMask button_mask,
		int x,
		int y
	) = 0;


	virtual
		void
	Motion(
		GHOST_IWindow * window,
		int x,
		int y
	) = 0;

	virtual 
	~GlutMouseHandler(
	){};		
};

class GlutMouseManager : public MEM_NonCopyable{

public :

	static
		GlutMouseManager *
	Instance(
	);

	static
		void
	ButtonUp(
		GHOST_IWindow * window,
		GHOST_TButtonMask button_mask,
		int x,
		int y
	);

	static
		void
	ButtonDown(
		GHOST_IWindow * window,
		GHOST_TButtonMask button_mask,
		int x,
		int y
	);

	static
		void
	Motion(
		GHOST_IWindow * window,
		int x,
		int y
	);

		void
	InstallHandler(
		GlutMouseHandler *
	);

		void
	ReleaseHandler(
	);

	~GlutMouseManager(
	);

private :

	GlutMouseManager (
	) :
		m_handler (0)
	{
	};
	
	GlutMouseHandler * m_handler;

	static MEM_SmartPtr<GlutMouseManager> m_s_instance;
};	


#endif

