dnl README-Users.m4 - Will become top-level README in disks-<arch>.
dnl
dnl Use [] for quotes so that in the emacsen, `forward-sexp' and
dnl `backward-sexp' along with paren highlighting will help find nesting
dnl errors.
dnl
changequote([,])dnl
dnl
dnl Most platforms have sub-architectures, define them here.
dnl
dnl FIXME: This should be defined in the top-level Makefile
dnl        and passed in by way of `release.sh', which is where
dnl        this file gets run through `m4'.
dnl
ifelse(ARCHITECTURE, sparc,   [define(SUBARCHES, [sun4cdm, sun4u, sun4dm-pci])],
       ARCHITECTURE, m68k,    [define(SUBARCHES, [amiga, atari, mac, mvme16x, bvme6000])],
       ARCHITECTURE, powerpc, [define(SUBARCHES, [apus, chrp, powermac, new-powermac, prep])],
       ARCHITECTURE, alpha,   [define(SUBARCHES, [jensen, nautilus])],
       ARCHITECTURE, mips,    [define(SUBARCHES, [r4k-ip22])],
       ARCHITECTURE, hppa,    [define(SUBARCHES, [32, 64])])[]dnl
dnl
dnl A few platforms have flavors, define them here.
dnl
dnl FIXME: Perhaps this should be defined in the top-level Makefile (?)
dnl
dnl If you need to add to this list, please see to it that it will be
dnl formatted nicely where it is expanded below by putting a line break
dnl and a 6 space indent in the right place inside the definition of
dnl FLAVORS.
dnl
dnl For that reason, it might not be the right thing to define this from
dnl the Makefile.
dnl
ifelse(ARCHITECTURE, i386, [define(FLAVORS, [`compact', 'idepci',
      and `ide'])])[]dnl
dnl
dnl Some, but not all, platforms have several sizes of diskette images.
dnl
ifelse(ARCHITECTURE, i386,    [define(SIZES,t)],
       ARCHITECTURE, sparc,   [undefine(SIZES)],
       ARCHITECTURE, m68k,    [define(SIZES,t)],
       ARCHITECTURE, powerpc, [undefine(SIZES)],
       ARCHITECTURE, alpha,   [undefine(SIZES)])[]dnl
dnl
dnl
dnl See the comment in "utilities/dbootstrap/main.c:setup_image_names()"
dnl for information about the directory layout expected by `dbootstrap'.
dnl
dnl          <debian>/${subarch}${images_size}${flavor}
dnl

		    The Debian Installation System
                    ==============================

                             Orientation

  This README is to acquaint you with the contents of the Debian
  installation system, and where to go for more information.

  If you wish to return to this directory you should go to

    <debian>/dists/RELNAME/main/disks-ARCHITECTURE/current/

  where the word `<debian>' may indicate a Debian web mirror, an FTP
  area, or official Debian CD-ROM.  All the files required for
  installation can be found beneath this directory.

  Complete documentation for the Debian installation system is located
  within the `doc/' subdirectory.  Documentation is available in
  several formats and languages.  You may also wish to consult
  <URL:http://www.debian.org/releases/RELNAME/> for errata, security
  alerts, and other updated information.

  For the impatient, quick install instructions are provided here.
  However, the reader is *strongly* encouraged to read the full
  documentation found in the `doc/' subdirectory, especially in the
  event of difficulties.



                   Quick Installation Instructions
                   ===============================

  Even though the Debian Installation System is also called the
  `boot-floppies', this name is something of an historical artifact.
  It is possible, even desirable, to install Debian without the use of
  floppies at all.  For instance, you may be able to install Debian
  from an official Debian bootable CD-ROM, from the network, or from
  another operating system.


  CD-ROM Install
  -------------

  The recommended installation method is the official Debian CD-ROM.
  These may be procured anywhere fine GNU/Linux distributions are
  sold, or online <URL:http://www.debian.org/distrib/vendors>.

  Those who have a CD burner and an adventurous disposition may try
  creating their own CD-ROM image <URL:http://cdimage.debian.org/>.

  Installation from CD-ROM is usually very easy and requires you to
  type only a single command after booting and CD insertion. If your
  machine has SRM (i.e. no menues system at the beginning) simply
  type `boot xxx -fl 0` where xxx is your CD-ROM drive in SRM
  notation. Run `show dev` to find out the name in your machine. For
  a complete description check out the installation manual.

  If your machine has ARC or AlphaBIOS, see below in the MILO section
  for details.


  Installation from Floppies
  --------------------------

  If you either do not have a CD-ROM or you have a computer that
  cannot boot from a CD-ROM then you will have to use the floppy
  images located beneath this directory.  Floppy images are named
  `*.bin'.  You will generally need the `rescue.bin' and `root.bin'
  images, and often the `driver-*.bin' images as well.

  Note that there are various sets of these rescue, root, and driver
  images, depending on which architecture you are on.  You will have
  to choose a set with which to install.  See below for a detailed
  description of the various subdirectories which contain these floppy
  images.

  The `driver-*.bin' files contain extra hardware drivers not
  contained in the kernel in the `rescue.bin' image.  It is not always
  required to create floppies from which to load these drivers, e.g.,
  in cases where the installation is able to get the drivers from
  non-floppy media.  It's basically a question of how much hardware
  support the kernel itself contains.

  If you do not create the `driver-*.bin' floppies, later during the
  installation you will need a copy `rescue.bin' and `drivers.tgz' to
  be available from non-floppy media.  You will be prompted for the
  operating system and modules, and you cannot tell the system to use
  floppies, obviously, since you did not create the driver floppies.
  Direct the installer to get this data off the CD-ROM, local hard
  disk, or wherever the installation files were downloaded.

  You *cannot* create floppies from *.bin files by just copying the
  *.bin files over.  You need to do a low-level sector copy of the
  data onto the floppy.  The method you must use to create floppies
  from the *.bin files varies based on what operating system you have
  access to.  Descriptions below cover creating floppies from *.bin
  files in Unix and from DOS.

  It is recommended that you always use fresh new floppies, because
  used ones can contain errors and cause failures in booting.

  - Creating Floppies from Floppy Images in Unix

    Use the GNU `dd' command to create a floppy disk from a .bin file:

        dd of=/dev/fd0 if=<file> bs=1024

    Your floppy device may be something other than `/dev/fd0'.

    If you are naturally suspicious, you can make sure the image was
    successfully written:

        cmp /dev/fd0 <file>

  - Creating Floppies from Floppy Images in DOS

    Change directory (`cd') to the directory containing the *.bin
    files that you want.  Use the DOS utility `rawrite2.exe' in the
    `dosutils' subdirectory to create the image, for instance:

		..\dosutils\rawrite2 -f rescue.bin -d a

     where `a' refers to the first floppy drive on your computer, and
     `rescue.bin' represents the *.bin file from which you want to 
     create a floppy.
ifelse(ARCHITECTURE, i386, [dnl


  Installing From Within DOS
  --------------------------

  If you do not have an official CD-ROM, and are running DOS or
  Windows, there is an alternative to creating floppies.  You may run
  the DOS batch file `install.bat' from one of the top-level
  subdirectories.

  See below for detailed description of the various subdirectories
  which contain 'install.bat'.
])
ifelse(ARCHITECTURE, hppa, [dnl


  Installing From The Network
  ---------------------------

  Another option for HPPA is to install from the network.  To do this
  you need to boot the 'lifimage' file.  Most HPPA machines will use
  bootp to boot over the network, although some older ones (e.g. 715/75)
  use rbootd instead.
])
ifelse(ARCHITECTURE, mips, [dnl


  Installing From The Network
  ---------------------------

  Another option for MIPS is to install from the network.  To do this
  you need to boot the 'linux.bin' file.  Most MIPS machines will use
  bootp to boot over the network.
])



                   Layout Of The Installation Files
                   ================================

  The general organization of files in this directory is described
  below.  If you are copying a subset of these files to local disk or
  what have you, you should retain the internal directory structure,
  since the installation system will be looking for files in these
  locations.

  doc/

      The Debian GNU/Linux Installation Manual, the Beginner's Guide for
      `dselect', and the Release Notes may be found here in several
      computer readable and printable formats.  Please, Read The Fine
      Manual (RTFM) before you begin!
dnl
ifdef([SUBARCHES], [dnl

  <subarch>/

      Installation files for a subdivision of the ARCHITECTURE architecture;
      you will need to look under here to find your boot, root, and
      drivers disks.  This architecture has the following <subarch>'s:

           SUBARCHES
dnl
ifelse(ARCHITECTURE, sparc, [dnl

     sun4cdm .... This is used for most non-Ultra systems. This includes
                  SPARCStation 1, 2, ELC, IPC, IPX, 5, 10, 20 as well as
                  SPARC Classics.

     sun4dm-pci . Same as the above kernel but with PCI support for use
                  with systems that have a PCI bus and/or ps2 mouse and
		  keyboard

     sun4u ...... This includes the entire UltraSPARC class of systems,
                  including IDE systems such as UltraSPARC 5. Only the
                  rescue and drivers are different from sun4cdm. The root
                  and base image is the same.

],dnl
ARCHITECTURE, mips, [dnl

     r4k-ip22.... This is used for R4X00 based SGI Indys and Indigo2s

     Please note that other big endian MIPS subarches are currently 
     not supported. For little endian MIPS support look at the mipsel
     architecture.

],dnl
ARCHITECTURE, alpha, [dnl

      In general, on Alpha, you should use the generic rescue and
      drivers images, which reside in the top-level images-1.44
      directory.  If you boot from CD, these will be used by default.

      When booting from floppy on the SRM console (we recommend you
      use SRM for new installs - see the installation manual), you
      should always use these (except on the 'jensen' subarchitecture).
      To boot from the rescue floppy disk from the SRM console, type
      `boot dva0 -fl 0' at the SRM console prompt.

      If you are booting from a floppy using MILO, you will also need
      a MILO disk containing MILO and LINLOAD.EXE images, as detailed
      below.

      The Nautilus platform (the UP1000 motherboard) uses APB.  On
      these systems, power up the Alpha, insert the Nautilus rescue
      disk, and enter `apb.exe' as the Boot File in the AlphaBIOS `OS
      Selection Setup' menu, or run `apb.exe' from the `Utility/Run
      Maintenance Program' menu.  Then, at the APB prompt, type `boot
      debian_install'.

  MILO/

      Contains MILO boot loader floppy images and binaries for certain
      platforms.  These are used for booting on ARC and AlphaBIOS
      systems.

      To boot on one of these from CD, find your subarchitecture from
      the table in the documentation, then enter `\milo\linload.exe'
      as the boot loader and `\milo\<subarch>' (where <subarch> is the
      proper subarchitecture name) as the OS Path in the `OS Selection
      Setup' menu.

      To boot one of these from floppy, create a floppy as described
      above from the milo_<subarch>.bin file.  Power on your Alpha,
      insert this disk, then enter the `OS Selection Setup' menu in
      ARC or AlphaBIOS.  Set the boot device to the floppy drive, the
      OS Loader to `\linload.exe', and the OS Path to `milo'.  Then,
      at the MILO prompt, insert the rescue disk and enter the command
      `boot fd0:'.  Note Ruffians do things slightly different, see
      the installation manual for details.

      The MILO disks are also bootable from the SRM console, though
      for installation purposes the rescue floppy should be used
      directly if you have a SRM console.

  APB/

      Contains the APB boot loader and associated files for the UP1000
      motherboard.  These are used when booting from CD on the UP1000.
      To boot on this platform, run '\apb\apb.exe' from the
      `Utility/Run Maintenance Program' menu, and type `boot
      debian_install' at the APB prompt.
]dnl,
dnl ARCHITECTURE, XXX, [
dnl This probably ought to be filled in more by the maintainers who know
dnl what to say here for their architecture's subarch's.
dnl]
)[]dnl ifelse(ARCHITECTURE, ...)
])[]dnl ifdef([SUBARCHES], ...)
dnl
ifdef([FLAVORS], [dnl

  ifdef([SUBARCHES],[<subarch>/])<flavor>/

      There are several `flavors' of installation disk available.  In
      some cases the images contain a Linux kernel compiled with
      certain options that make it work better on some hardware.  See
      below for information about why you might need to use a flavor.

      Also in this directory are files for a particular flavor which
      are not disk images, but may be helpful for network
      installations or installations from another operating system.

      During a network, NFS, or CD-ROM install, the install software
      knows how to find these files, once you have indicated the
      <debian> directory.  If you plan to copy these files to a spot
      on your hard drive in anticipation of using the installer's
      "from a mounted partition" option, you do not need to duplicate
      the directory structure of the <debian> archive, but you do need
      to make sure you get a matched set of images, all of the same
      <flavor>, or things probably won't work correctly.

      The flavors available for this architecture are FLAVORS.
dnl
ifelse(ARCHITECTURE, i386, [dnl

      compact .... A Linux kernel with some non-critical device
                   drivers removed, and a few of the more common PCI
                   device drivers compiled into the kernel itself.
                   See images-1.44/compact/README.txt

      idepci ....  Similar to compact, but even more PCI device drivers
                   are compiled into the kernel, and SCSI is removed.
                   See images-1.44/idepci/README.txt

      ide    ..... Specialized kernel for those who require the UDMA66
                   IDE patch.  This may be needed if you have a
                   Promise Ultra66 IDE controller, among others.
                   See images-1.44/ide/README.txt
]dnl,
dnl ARCHITECTURE, XXX, [dnl
dnl   Other arch with flavor info goes here.
dnl]
)dnl
])[]dnl
dnl
ifdef([SIZES], [dnl

  ifdef([SUBARCHES],[<subarch>/])images-<size>/ifdef([FLAVORS],[<flavor>/])

      Disk images of size <size>.  Choose the size that will fit on the
      media from which you intend to bootstrap the installation, and
      follow the instructions below under "Writing Image Files to
      Floppies".
])[]dnl


  ** Specific Files of Interest

  Using the descriptions above, you need to select the directory
  containing the set of files which is appropriate to the installation
  you are doing.  You will need all of the following `.bin' images,
  unless marked otherwise.

  .../rescue.bin

      Rescue disk image, containing the kernel and a boot loader.

  .../root.bin

      Root disk image, containing the root file system.  Not required
      unless are you are installing from floppies.

  .../driver-#.bin

      Device driver disk images, containing kernel modules you can
      load for hardware for which there is not a driver built into the
      kernel.  For instance, you can use this to install a driver for
      your network adapter; once you have installed that driver, you
      can install the rest of the system over the network.  Other
      modules include PPP, parallel support, etc.  Not required unless
      are you are installing from floppies.

  .../drivers.tgz

      A compressed tar archive containing the same modules as the
      above disk images.  These are used when installation kernel and
      drivers from local disk or CD rather than from floppies.  Use
      the file from the appropriate subdirectory based on the
      ifdef([SUBARCHES],subarchitecture)[]ifdef([FLAVORS],flavor) you are using, if any.

dnl
ifelse(ARCHITECTURE, sparc, [dnl

  .../tftpboot.img

      Subarch specific TFTP bootable images.  These images contain the
      kernel and root.bin for booting completely from a TFTP server using
      the PROM "boot net" command.  See docs for details.

  root.tar.gz

      An NFS mountable root tarball.  This is exactly the same as the
      root.bin, but in a tar [format] so as to be extracted on a net
      server for installing systems via an NFS root.  See docs for
      details.

],dnl
ARCHITECTURE, hppa, [dnl

   lifimage

      A network bootable image containing root.bin, along with 32 and
      64 bit kernels.  This is the file you need to boot in order to
      do a network based install.

],dnl
ARCHITECTURE, mips, [dnl

  root.tar.gz

      An NFS mountable root tarball.  This is exactly the same as the
      root.bin, but in a tar [format] so as to be extracted on a net
      server for installing systems via an NFS root.  See docs for
      details.

],dnl
ARCHITECTURE, alpha, [dnl

  .../linload.exe

      ARC console executable that is needed to load MILO

  .../apb.exe

      Alpha Processor Bootloader, an ARC console executable that is
      used to boot Linux on the UP1000 motherboard from Alpha
      Processor, Inc.

  .../up1000.pal

      PALCode (Privileged Architecture Library code) for the UP1000
      motherboard.

  tftpboot.img

      TFTP bootable image. This image contains the kernel and root.bin
      for booting completely from a TFTP server using the SRM console.
      See the installation manual for full details.

  root.tar.gz

      An NFS mountable root tarball.  This is exactly the same as the
      root.bin, but in a tar [format] so as to be extracted on a net
      server for installing systems via an NFS root.  See docs for
      details.

])[]dnl
dnl
ifdef([ADDONS_TGZ], [dnl

  ADDONS_TGZ

      A compressed tar archive containing additional garbage being foisted
      upon you by the folks who made this CD-ROM.  It might be just
      about any kind of cruft you can imagine some breakaway up-start
      thinks makes his CDs better than the official Debian version.

])[]dnl
dnl
ifelse(ARCHITECTURE, i386, [dnl

  .../install.bat

      DOS batch script for booting into the installation system from
      DOS.  A different version of this batch file is available for
      each flavor.

  .../linux.bin

      A Linux kernel image, used by the batch script above.

])[]dnl
dnl
  md5sum.txt

      A file containing MD5 sums for installation files.  This can be
      used to verify that downloaded files have not been corrupted.

dnl
dnl Local Variables:
dnl compile-command: "m4 --define=RELNAME=woody --define=ARCHITECTURE=i386 README-Users.m4"
dnl fill-prefix: "  "
dnl End:
dnl LocalWords:  sparc SUBARCHES cdm amiga atari mac mvme bvme powerpc chrp sh
dnl LocalWords:  powermac alcor avanti idepci udma undefine dbootstrap debian doc
dnl LocalWords:  subarch dselect RTFM ifdef SPARCStation ELC IPC IPX UltraSPARC
dnl LocalWords:  IDE SRM jensen subarchitecture dva fl MILO LINLOAD APB apb milo
dnl LocalWords:  AlphaBIOS linload fd XXX subarch's installer's PCI PPP TGZ TFTP
dnl LocalWords:  PROM Bootloader PALCode tftpboot img ADDONS CDs basecont txt
dnl LocalWords:  linux dd bs cmp tgz dnl emacsen sexp paren changequote FIXME
dnl LocalWords:  ifelse dm pci ps EXE exe docs tarball rawrite













