#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include "dbootstrap.h"
#include "lang.h"

int interactive_shell(void) {
  chdir("/");
  boxSuspend();
  printf(CLEAR);
  printf(_("You are running \"ash\", a Bourne-shell clone. The root filesystem is a\nRAM disk or floppy. The hard disk filesystems are mounted on \"/target\".\nThe editor available to you on this floppy is \"nano-tiny\". It's very small\nand easy to figure out - sorry but \"vi\" and \"emacs\" wouldn't fit.\nTo get an idea of what Unix utilities are available to you, run \"ls /bin\n/sbin /usr/bin /usr/sbin\". Use the \"exit\" command to return to the\ninstallation menu.\n"));
  system("/bin/sh");
  boxResume();
  chdir("/");
  return 0;
}

#ifdef _TESTING_
/*
 * To test, compile using: make interactive_shell_test
 */
int main(void) {
  LOAD_TRMFILE("test.trm");
  get_kver();
  boxInit();

  problemBox("Push ENTER to open an interactive shell.","Info");
  interactive_shell();
  problemBox("Here we are again. Push ENTER to exit.","Info");
  
  boxFinished();

  exit (0);
}
#endif
