#!	/bin/bash
# Root Disk maker. Bruce Perens, December 1995
# Dale Scheetz, Sven Rudolph 1996, 1997
# Enrique Zanardi 1998
# Hartmut Koptein, 1998  [powerpc support]
# Matej Vela, 1998       [non-ISO-8859-1 charset support]
# Marcin Owsiany, 2000,1 [LANGUAGE_CHOOSER integration]
# Adam Di Carlo, 2001    [maintenance]
# This is free software under the GNU General Public License.

. ./common.sh

export LANG=C

export devtarball=`pwd`/devtarball.tgz

# FIXME -- should be a runtime parameter
charset=${charset:-latin1}

# vflag is for the '-v' flag, set conditionally
if [ ${debug} ]; then
    vflag=-v
fi

umask 022

if [ $# -lt 6 ]; then
    echo "Usage: $0 revision-extension archive blocks debian-version system language [font sfont]" 1>&2
    cat 1>&2 << EOF

        revision-extension: the revision extension of the kernel
        archive: the directory where Debian binary packages will be downloaded
        blocks: the size of the floppy in 1K blocks; use 720, 1200, or 1440
        debian-version: version of the Debian release
        system: name of the target system
        language: language for the release notes
        font: name of the preloaded font, if any
        sfont: name of the font loaded by syslinux, if any
EOF

    exit -1
fi

revext=$1

# Set this to the location of the package archive.
archive=$2

# Set to the number of blocks per floppy.
blocks=$3

# Set this to the Debian version
debianversion=$4

# Set this to the system
system=$5

# Set this to the language for the release notes.
language=$6

# Set this to the font loaded before dbootstrap, if any.
font=$7

# Set this to the font loaded by syslinux, if any.
sfont=$8

# This is the directory containing fonts.
fontsdir=usr/share/consolefonts

# Set this to the block device for the floppy disk.
floppy=$(tempfile --directory ${tmpdir} -p root_ -s .bin)

mnt=${tmpdir}/boot-floppies/mnt.rootdisk

if [ ! -d $archive/. ]; then
    error "$archive not a directory"
fi

ROOT_IS_I18N=false

# turn LC on for kernels with framebuffer support
if [ "$USE_LANGUAGE_CHOOSER" = "true" ]; then
#    if [ "$arch" = "i386" ] && \
#       [ "$revext" != "compact" -a "$revext" != "idepci" -a "$revext" != "bf2.4-compact" -a "$revext" != "bf2.4" ]; then
#        info "single locale mode forced for flavor '$revext', no FB console support"
#    elif [ "$arch" = "i386" -o "$arch" = "arm" -o "$arch" = "powerpc" -o "$arch" = "alpha" ]; then
        info "internationalized mode enabled"
        ROOT_IS_I18N=true
    # add other arch support here, some arches may need to disable it
#    else
#        info "internationalization mode disabled on this architecture"
#    fi
#else
#    info "single locale mode (USE_LANGUAGE_CHOOSER = false)"
fi

# must be root
testroot

ro_poss=0

case "$arch" in
    alpha)
	export ldlib=ld-linux.so.2
	libcso=libc.so.6.1
	libcver=2.2.5
    ;;
    m68k)
	export ldlib=ld.so.1
	libcso=libc.so.6
	libcver=2.2.5
    ;;
    powerpc)
	export ldlib=ld.so.1
	libcso=libc.so.6
	libcver=2.2.5
    ;;
    sparc)
	export ldlib=ld-linux.so.2
	libcso=libc.so.6
	libcver=2.2.5
	ro_poss=1
    ;;
    i386)
	export ldlib=ld-linux.so.2
	libcso=libc.so.6
	libcver=2.2.5
    ;;
    arm)
	export ldlib=ld-linux.so.2
	libcso=libc.so.6
	libcver=2.2.5
	ro_poss=1
    ;;
    hppa)
	export ldlib=ld.so.1
	libcso=libc.so.6
	libcver=2.2.5
    ;;
    ia64)
	export ldlib=ld-linux-ia64.so.2
	libcso=libc.so.6.1
	libcver=2.2.5
    ;;
    mips)
         export ldlib=ld.so.1
         libcso=libc.so.6
         libcver=2.2.5
    ;;
    mipsel)
         export ldlib=ld.so.1
         libcso=libc.so.6
         libcver=2.2.5
     ;;
    s390)
         export ldlib=ld.so.1
         libcso=libc.so.6
         libcver=2.2.5
     ;;
esac
info "ld.so on this architecture is $ldlib"

# stupidly, the libc6 we have installed locally with must be 
# the same as the one we are building this rootdisk with;
# therefore compare early...
if [ ! -f /lib/libc-${libcver}.so ]; then
    error "expected to find /lib/libc-${libcver}.so; upgrade local libc to ${libcver}"
fi

if [ "$ROOT_IS_I18N" = "true" ]; then
    info "i18n mode, building with addl languages $langs_root"
   if [ -n "$i18n_low_space" ] ; then
      info "warning: low space, using a reduced list of languages"
      if [ "$langs_root_few" = "" ]; then
         error "expected langs_root_few to be set but it was not"
      fi
      langs_root=$langs_root_few
   else
      if [ "$langs_root" = "" ]; then
         error "expected langs_root to be set but it was not"
      fi
   fi
    info "i18n mode, increasing available blocks and inodes"
    blocks=$[$blocks+3200]
    inodes=$[$inodes+200]
fi

# temporary directories
E=${tmpdir}/boot-floppies/extract-tmp-$$
R=${tmpdir}/boot-floppies/root-tmp-$$

# home of the scripts used by this script
scripts=`pwd`/scripts/rootdisk

# ensure our extract list files are there
exit=false
for i in \
	$scripts/EXTRACT_LIST_all \
	$scripts/EXTRACT_LIST_${arch} \
	$scripts/SMALL_BASE_LIST_all \
	$scripts/SMALL_BASE_LIST_${arch}
do
	if [ ! -f $i ]; then
		warn "can't open $i"
		exit=true
	fi
done
if $exit; then
	exit -1
fi


# expand list of required packages
if [ -f $scripts/EXTRACT_LIST_${arch}_${system} ]; then
    extract_list="$scripts/EXTRACT_LIST_all $scripts/EXTRACT_LIST_${arch}_${system}"
elif [ -f $scripts/EXTRACT_LIST_${arch}_${revext} ]; then
    extract_list="$scripts/EXTRACT_LIST_all $scripts/EXTRACT_LIST_${arch}_${revext}"
else
    extract_list="$scripts/EXTRACT_LIST_all $scripts/EXTRACT_LIST_${arch}"
fi
if [ "$LINGUA" != "C" -a -e $scripts/EXTRACT_LIST_${LINGUA} ]; then
    extract_list="$extract_list $scripts/EXTRACT_LIST_${LINGUA}"
fi
if [ "$ROOT_IS_I18N" = "true" ];then
    if [ -f $scripts/EXTRACT_LIST_${arch}_i18n ]; then
        extract_list="$extract_list $scripts/EXTRACT_LIST_${arch}_i18n"
    else
        extract_list="$extract_list $scripts/EXTRACT_LIST_i18n"
    fi
else
    # packages for non-i18n builds only
    
    # a special case for non-i18n build on i386 -- we need some unusual
    #  i18n stuff because it's a mixed build of i18n and non-i18n
    if [ "$arch" = "i386" -a "$USE_LANGUAGE_CHOOSER" = "true" ]; then
	extract_list="$extract_list $scripts/EXTRACT_LIST_${arch}_non-i18n-mixed-build"
    elif [ -f $scripts/EXTRACT_LIST_${arch}_non-i18n ]; then
        extract_list="$extract_list $scripts/EXTRACT_LIST_${arch}_non-i18n"
    else
        extract_list="$extract_list $scripts/EXTRACT_LIST_non-i18n"
    fi
fi
info "downloading required packages from files $extract_list"
debug `cat $extract_list`

PACKAGE_PATHS=$(grab_paths $(sed -e 's/ .*//' $extract_list))


(cat $extract_list |  while read a b; do
	[ "$b" != "" ] || continue
	for c in $PACKAGE_PATHS; do
		d=${c##*/}
		if [ "${d%%_*}" = "$a" ]; then
		    	v=`dpkg -f $c Version`
			if dpkg --compare-versions "$v" lt "$b"; then
         error "Bad version of $a ($v << $b) in the download directory!"
				exit 1
			fi
			info "$a $b $v okay"
		fi
	done
done) || exit 1

[ ! -d $E ] || rm -rf $E
relax

make_tmpdir $E
make_tmpdir $R

info "extracting packages (EXTRACT_LIST) into extract area, '$E'"
for i in $PACKAGE_PATHS; do
    debug extracting $i
    dpkg-deb --extract $i $E
done

if [ -e $E/sbin/cfdisk-utf8 ] ; then
   if [ "$USE_LANGUAGE_CHOOSER" = "true" ]; then
      rm -f $E/sbin/cfdisk
      ln $E/sbin/cfdisk-utf8 $E/sbin/cfdisk
   else
      rm -f $E/sbin/cfdisk-utf8
      ln $E/sbin/cfdisk $E/sbin/cfdisk-utf8
   fi
fi

info "stripping executables in extract area"
$scripts/strip_executables.sh $E/bin/* $E/usr/bin/* $E/sbin/* $E/usr/sbin/* $E/lib/* $E/usr/lib/*

##
## device creation
##  note that we don't generally use generic, since it's a hog
##

info "making devices in root area, '$R'"

if [ -f "$devtarball" ] ; then
   (cd $R ; tar zxf $devtarball)
else
   # what the hell is this for?
   mkdir -p $R/dev/inet

   # some standard devices, over and above generic ones (see MAKEDEV)
   ##
   ## FIXME: introduced generic, but haven't worked it through non-sparc arches
   ##         will this work? Will it be too much?  not sure...
   ##
   ttydevs="tty1 tty2 tty3 tty4"
   idedevs="hdc hdd hde hdf hdg hdh"
   scsidevs="sde sdf sdg sdh scd2 scd3"
   miscdevs="initrd lp md input"
   alldevs="generic $ttydevs $idedevs $scsidevs $miscdevs"

   # add devices for japanese installer and LANGUAGE_CHOOSER
   if [ "$LINGUA" = "ja" -o "$ROOT_IS_I18N" = 'true' ] ; then
   alldevs="$alldevs fb0 ptyp ptyq ptyr ptys"
   fi

   case "$arch" in
      alpha)
   boot_floppies_dev="$alldevs fd0 fd1"
      ;;
      i386)
   boot_floppies_dev="$alldevs fd0 fd1 xda xdb eda edb sonycd \
                              mcd mcdx cdu535 lmscd sbpcd aztcd bpcd optcd \
                              sjcd gscd cm206cd dac960.0 ida.0 ida.1 ataraid.0 ataraid.1 cciss.0 cciss.1"
      ;;
      m68k)
   boot_floppies_dev="$alldevs fd0 fd1 adb adc add ade adf fb"
      ;;
      powerpc)
   boot_floppies_dev="$alldevs fd0-bare fd1-bare busmice fb nvram"
      ;;
      sparc)
   boot_floppies_dev="$alldevs"
      ;;
      arm)
   boot_floppies_dev="std $alldevs fd0 fd1 fb busmice"
      ;;
      s390)
   boot_floppies_dev="std loop"
      ;;
      *)
   boot_floppies_dev="$alldevs"
      ;;
   esac

   if [ -n "$GRAPHICAL" ]; then
       boot_floppies_dev="$boot_floppies_dev busmice fb0"
   fi
   debug "device list is $boot_floppies_dev"
   ( cd $R/dev && /sbin/MAKEDEV $boot_floppies_dev )
   testexit

   if [ "$arch" = i386 ]; then
      # remove some extra dac960 devices
      rm -f $R/dev/rd/c?d[456789]p* $R/dev/rd/c?d??p*
      # remove some extra ida devices
      rm -f $R/dev/ida/c?d[456789]p* $R/dev/ida/c?d??p*
      # workaround MAKEDEV Bug#74781
      mknod $R/dev/pcd0 b 46 0
      # Add in User Mode Linux support, so people can test
      # the boot floppies under UML  -- works fine for me...
      for i in 0 1 2 3 4 5 6 7; do mknod $R/dev/ubd$i b 98 $i; done
   fi

   (cd $R ; tar zcf $devtarball dev)
fi

T=${tmpdir}/boot-floppies/prototype-tmp-$$
info "making prototype filesystem, '$T'"
mkdir $T
( cd $scripts/prototype && \
  tar clf - . --exclude CVS --exclude '.#*' --exclude .tar-place-holder ) \
  | tar xlpf - -C $T $vflag
testexit

if [ "$arch" = "s390" ]; then
    info "copying s390 specific files to root disk"
    cp s390-specials/inittab $T/etc/inittab
    cp s390-specials/inittab.install $T/etc/inittab.install
    cp s390-specials/services $T/etc/services
    cp s390-specials/issue $T/etc/issue
    chmod 644 $T/etc/inittab $T/etc/inittab.install $T/etc/services $T/etc/issue
    cp s390-specials/root.profile $T/root/.profile
    cp s390-specials/rcS.s390 $T/etc/init.d/rcS.s390
    cp s390-specials/netsetup.sh $T/sbin/netsetup
    chmod 755 $T/root/.profile $T/etc/init.d/rcS.s390 $T/sbin/netsetup
    mkdir -p $T/usr/share/netsetup $T/usr/lib/netsetup
    cp s390-specials/netsetup/*.sh $T/usr/share/netsetup/
    cp s390-specials/netsetupcalc $T/usr/lib/netsetup/
    cp s390-specials/changrep $T/usr/lib/netsetup/
    cp s390-specials/login $T/bin/login
    chmod 755 $T/usr/share/netsetup/* $T/usr/lib/netsetup/* $T/bin/login
fi

if [ "$LINGUA" = "ja" ]; then
    info "modifying init script for Japanese installer"
    sed -e 's/\/sbin\/dbootstrap/\/usr\/bin\/jfbterm -e \/sbin\/dbootstrap/' \
	< $scripts/prototype/etc/inittab > $T/etc/inittab
fi

if [ "$ROOT_IS_I18N" = "true" ]
then
	info "modifying init script for LANGUAGE_CHOOSER"
	sed -e 's,/sbin/dbootstrap,/sbin/udbootstrap,' \
		< $scripts/prototype/etc/inittab > $T/etc/inittab
	cat <<EOF >> $T/sbin/udbootstrap
#!/bin/sh
if (</dev/fb0) 2>/dev/null && \
	! grep -q console=ttyS /proc/cmdline 2> /dev/null && \
	! grep -q nolangchooser /proc/cmdline 2> /dev/null ; then
LC_CTYPE=C@utf-8
export LC_CTYPE
exec /usr/bin/bterm -f /unifont-reduced.bgf /sbin/dbootstrap
fi
TERM=vt102
export TERM
exec /sbin/dbootstrap
EOF
	chmod a+rx $T/sbin/udbootstrap
	info "including font for bterm"
        if [ ! -f utilities/bogl/unifont-reduced.bgf ]; then
            make -C utilities/bogl unifont-reduced.bgf
        fi
	cp utilities/bogl/unifont-reduced.bgf $T/
	info "including C@utf-8 locale"
	mkdir -p $T/usr/lib/locale
	localedef -i "utilities/bogl/C-at-utf-8.in" -f "UTF-8" \
			"$T/usr/lib/locale/C@utf-8"
#	cp -a /usr/lib/locale/en_IN $T/usr/lib/locale
fi

info "modifying init script, /etc/init.d/rcS"
str=
if [ -n "$font" ]; then
	str="[ -f /$fontsdir/$font ] \&\& loadfont < /$fontsdir/$font"
fi
sed -e "s+__LOADFONT__+$str+g" \
    < $scripts/prototype/etc/init.d/rcS > $T/etc/init.d/rcS
    
if [ "$arch" = "s390" ]; then
info "modifying scripts for s390: /etc/init.d/rcS /etc/profile"
sed -e "/\/sbin\/syslogd -m 0/a\\
\\
if [ -x \/etc\/init.d\/rcS.s390 ]; then\\
  . \/etc\/init.d\/rcS.s390\\
fi"\
    < $T/etc/init.d/rcS > $T/etc/init.d/rcS.new
mv $T/etc/init.d/rcS.new $T/etc/init.d/rcS
chmod 755 $T/etc/init.d/rcS
# disable virtual console references
sed -e "s/The key combination//" < $scripts/prototype/etc/profile > $T/etc/profile.tmp
sed -e "/Alt-F1 switches to the first console window, and Alt-F2 switches to the/d" < $T/etc/profile.tmp > $T/etc/profile
sed -e "/second one./d" < $T/etc/profile > $T/etc/profile.tmp
mv $T/etc/profile.tmp $T/etc/profile
chmod 755 $T/etc/profile
echo "if [ -r /etc/issue ]; then" >> $T/etc/profile
echo "  cat /etc/issue" >> $T/etc/profile
echo "fi" >> $T/etc/profile 
fi

# ensure that lazybox is executable (in case it is not in the source tree)
info "making lazybox links"
chmod a+x $T/bin/lazybox
# create symlinks in tempdir (cvs doesn't preserve symlinks)
ln -sf ../bin/lazybox $T/sbin/lilo
ln -sf ../../bin/lazybox $T/usr/bin/emacs
ln -sf ../../bin/lazybox $T/usr/bin/mformat    # superformat calls mformat automatically
ln -sf ../../bin/lazybox $T/usr/bin/ae	       # we don't carry ae anymore, give compat warning
ln -sf ../../bin/lazybox $T/usr/bin/vi
ln -sf ../../bin/lazybox $T/usr/bin/man
ln -sf ../bin/lazybox $T/bin/fgrep
ln -sf ../bin/lazybox $T/bin/fuser
ln -sf ../bin/lazybox $T/bin/netstat

ln -sf ../tmp $T/var/
ln -sf ../proc/mounts $T/etc/mtab

info "moving prototype area to root staging area"
( cd $T && tar clf - . ) | tar xlpf - -C $R $vflag
testexit
rm -rf $T

info "moving extracted files (SMALL_BASE_LIST) from extract area to root area"
base_list_files=$scripts/SMALL_BASE_LIST_all
if [ -f $scripts/SMALL_BASE_LIST_${arch}_${system} ]; then
    base_list_files="$base_list_files $scripts/SMALL_BASE_LIST_${arch}_${system}"
elif [ -f $scripts/SMALL_BASE_LIST_${arch}_${revext} ]; then
    base_list_files="$base_list_files $scripts/SMALL_BASE_LIST_${arch}_${revext}"
else
    base_list_files="$base_list_files $scripts/SMALL_BASE_LIST_${arch}"
fi
if [ "$LINGUA" != "C" -a -e $scripts/SMALL_BASE_LIST_${LINGUA} ]; then
    base_list_files="$base_list_files $scripts/SMALL_BASE_LIST_${LINGUA}"
fi
if [ "$ROOT_IS_I18N" = "true" ]; then
    base_list_files="$base_list_files $scripts/SMALL_BASE_LIST_i18n"
fi

for file in $base_list_files; do
    debug "using $file"
    # use tar to do the copying because it preserves hard links
    ( cd $E && tar cf - --files-from=$file ) | \
        tar xlpf - -C $R $vflag
    testexit
    # ensure the file exists
    for f in `cat $file`; do
        if [ ! -f $R/$f ]; then
            error "failed to extract $f into $R from $E"
        fi
    done
done

if [ -e $R/sbin/cfdisk-utf8 ] ; then
   if [ "$USE_LANGUAGE_CHOOSER" = "true" ]; then
      rm -f $R/sbin/cfdisk
      ln $R/sbin/cfdisk-utf8 $R/sbin/cfdisk
   else
      rm -f $R/sbin/cfdisk-utf8
      ln $R/sbin/cfdisk $R/sbin/cfdisk-utf8
   fi
fi

# clean up multiple terminfo locations
info "canonicalising terminfo directories"

termdirs="usr/lib/terminfo"
if [ -d $R/usr/share/terminfo ]; then
    termdirs="$termdirs usr/share/terminfo"
fi
if [ -e $R/etc/terminfo ]; then
    mv $R/etc/terminfo $R/etc/terminfo.1
    termdirs="$termdirs etc/terminfo.1"
fi

mkdir $R/etc/terminfo
for term in $(cd $R; find $termdirs -type f); do
    baseterm=$(echo $term | sed 's:.*/::')
    termdir=$(echo $baseterm | sed 's:\(.\).*:\1:')
    if [ ! -e $R/etc/terminfo/$termdir ]; then
        ln -sf . $R/etc/terminfo/$termdir
    fi
    mv $R/$term $R/etc/terminfo/$baseterm
done
rm -rf $R/etc/terminfo.1

# tweak for Japanese
if [ "$LINGUA" = "ja" ] ; then
	info "copying jfbterm.conf into root area"
	sed -e '/.*GB2312.*/d' -e '/.*KSX1001.*/d' -e '/utmp/s/1/0/' \
		$E/etc/jfbterm.conf > $R/etc/jfbterm.conf
fi

info "copying fonts, passwd, group, modules.conf into root area"
# add the font if neccessary
if [ -n "$font" ]; then
	for fonttest in $E/$fontsdir/$font $scripts/consolefonts/$font; do
		[ -f "$fonttest" -o -f "$fonttest.gz" ] && fontfound=$fonttest
	done
	if [ "$fontfound" ]; then
		mkdir -p $R/$fontsdir
		gzip -cdf $fontfound > $R/$fontsdir/$font
	fi
fi

if [ -n "$sfont" ]; then
	for fonttest in $E/$fontsdir/$sfont $scripts/consolefonts/$sfont; do
		[ -f "$fonttest" -o -f "$fonttest.gz" ] && sfontfound=$fonttest
	done
	if [ "$sfontfound" ]; then
		if [ `gzip -cdf $sfontfound | wc -c` = 4096 ]; then
			printf '\x36\x04\x00\x10' > $sfont
			gzip -cdf $sfontfound >> $sfont
		else
			gzip -cdf $sfontfound | psfstriptable $sfontfound $sfont
		fi
	fi
fi

# Create passwd and group from base-passwd master files
cp $E/usr/share/base-passwd/passwd.master $R/etc/passwd 
cp $E/usr/share/base-passwd/group.master $R/etc/group

# Create modules.conf (Code "stolen" from update-modules)
CFGFILE=$R/etc/modules.conf
HEADER="### This file is automatically generated by update-modules"
CONF=$E/etc/modutils/arch/$arch
if [ "$arch" = m68k ]; then
    CONF=${CONF}.$system
    if [ ! -f $CONF ]; then
         CONF=$E/etc/modutils/arch/m68k.generic
    fi
fi
if [ ! -f $CONF ]; then
    CONF=$E/etc/modutils/arch/generic
fi
echo $HEADER > $CFGFILE
cat <<EOF >> $CFGFILE
#
# Please do not edit this file directly. If you want to change or add
# anything please take a look at the files in /etc/modutils and read
# the manpage for update-modules.
#
EOF
for cfg in $E/etc/modutils/* $CONF ; do
    if [ -f $cfg ]; then 
        cat $cfg >> $CFGFILE
    fi
done

if [ "$system" = bvme6000 -o "$system" = mvme16x -o "$system" = mvme147 ]; then
	# superformat doesn't work with SCSI floppies.  Remove it (and ask for
	# formatted medium to create the rescue disk).
	rm -f $R/usr/bin/superformat
fi

##
## copy the required libraries
##
info "determining set of required libraries"
LIBRARIES=""
EXECUTABLES="$R/bin/* $R/sbin/* $R/usr/bin/*"

if [ "$USE_LANGUAGE_CHOOSER" = "true" ]; then
   EXECUTABLES="$EXECUTABLES ./utilities/dbootstrap/dbootstrap-lc"
else
   EXECUTABLES="$EXECUTABLES ./utilities/dbootstrap/dbootstrap"
fi

#   ldconfig is statically linked
EXECUTABLES=`echo $EXECUTABLES | sed s%$R/sbin/ldconfig%%g`

#   look for the required libraries under $E
TMP=`( for i in $EXECUTABLES; do $E/lib/$ldlib --library-path $E/lib:$E/usr/lib --list $i 2>/dev/null; done ) | \
	awk -v E="^$E" -v L="/lib/$ldlib" -- '$3=="not" {print $1; next}; \
		($3!~E) && ($1!~L) {print $3}' | grep -v "dynamic" | \
	sort -u`

#   ld-linux.so.2 is always linked with its full path, so ldd won't look
#   for it under $E. We have to do it 'by hand'
if [ ! -f $E/lib/$ldlib ]; then
    TMP="$TMP /lib/$ldlib"
fi

if [ ! -z "$TMP" ]; then
    error "the following required libraries weren't extracted: $TMP"
fi

# add to library path based on 'ldd' of our executables
TMP=`LD_LIBRARY_PATH=$E/lib:$E/usr/lib ldd $EXECUTABLES 2>/dev/null | \
        awk -- '{print $3}' | fgrep -v "dynamic" | sort -u`
for i in $TMP; do 
    j=`echo $i | sed -e "s%^$E%.%g" -e "s%^/%./%" `
    LIBRARIES="$LIBRARIES $j" 
    if [ -L $i ]; then
        j=`ls -l $i |awk -v J=\`dirname $i\` -- '{print J"/"$NF}' | \
              sed -e "s%^$E%.%g" -e "s%^/%./%" `
        LIBRARIES="$LIBRARIES $j"
    fi
done

# check that we're not empty so far
if [ -z "$LIBRARIES" ]; then
    error "no libraries identified dynamically, bailing out
Is your local libc6 different from the libc6 we're building with perhaps?"
fi

# add the resolver and DNS libraries
LIBCMAJOR=`echo $libcver | cut -c1`
if [ "$arch" = "alpha" ]; then
    # Alpha's libraries are stupidly numbered.  We blame Red Hat
    EXTRA_LIBRARIES="./lib/libresolv-$libcver.so ./lib/libresolv.so.$LIBCMAJOR.1 ./lib/libnss_dns-$libcver.so ./lib/libnss_dns.so.$LIBCMAJOR"
else
    EXTRA_LIBRARIES="./lib/libresolv-$libcver.so ./lib/libresolv.so.$LIBCMAJOR ./lib/libnss_dns-$libcver.so ./lib/libnss_dns.so.$LIBCMAJOR"
fi
debug "library list is $LIBRARIES, extra libraries are: $EXTRA_LIBRARIES"

# check that all these libraries are actually there
for lib in $LIBRARIES $EXTRA_LIBRARIES; do
    [ -f $E/$lib ] || error "no such library '$E/$lib'"
done

info "copying required extra libraries from extract area to root area"
( cd $E && tar -cf - $EXTRA_LIBRARIES ) | tar xlpf - -C $R $vflag
testexit

mkdir -p $R/etc
if [ "$ROOT_IS_I18N" = "true" ]; then
    if [ ! -f utilities/dbootstrap/dbootstrap-lc ]; then
        # oh why doesn't make dependancies work reliably?
        make utilities/dbootstrap/dbootstrap-lc
    fi

    info "adding dbootstrap-lc and messages"
    cp utilities/dbootstrap/dbootstrap-lc $R/sbin/dbootstrap

    if [ ! -f utilities/dbootstrap/po/utf/en.trm ]; then
        # oh why doesn't make dependancies work reliably?
        make utilities/dbootstrap/po/all-utf
    fi
    for lang in $langs_root; do
        cp utilities/dbootstrap/po/utf/$lang.trm $R/etc/messages.$lang
    done
else
    info "adding dbootstrap and messages"
    cp utilities/dbootstrap/build/dbootstrap $R/sbin/
    [ -f utilities/dbootstrap/po/$language.trm ] || make -C utilities/dbootstrap/po $language.trm
    cp utilities/dbootstrap/po/$language.trm $R/etc/messages.trm
fi

# do library reduction for platforms where it works
if [ "$arch" != "hppa" -a "$arch" != "ia64" -a "$arch" != "mipsel" -a "$arch" != "mips" ]; then

    EXECUTABLES=$(find $R/{bin,sbin,lib,usr/bin,usr/sbin,usr/lib} -maxdepth 1 -type f)
    # ldconfig is statically linked
    EXECUTABLES=`echo $EXECUTABLES | sed s%$R/sbin/ldconfig%%g`

    # mklibs.sh blindly copies libraries from it's library path
    # (defaults to /lib:/usr/lib) when there is no -pic version.  This
    # behavior will cause binaries to be mismatched with older
    # libraries if b-f is built againt unstable on a testing system
    # (it also prevents us from getting small libs from say
    # e2fsprogs-bf).  That is why we must specify extract area lib
    # directories ahead of system lib directories to mklibs.sh.  We
    # still need system directories so it can find the -pic libs.

    # FIXME: true for mklibs.py ?  yes appears so --eb

    if [ "$arch" = "alpha" -o "$arch" = "arm" -o "$arch" = "i386" -o "$arch" = "powerpc" -o "$arch" = "s390" ]; then
	mklibs=$scripts/mklibs.py
    else
	mklibs=$scripts/mklibs.sh
    fi
    info "doing library reduction with $mklibs"
    $mklibs $vflag -L $E/lib:$E/usr/lib:/lib:/usr/lib --dest-dir $R/lib $EXECUTABLES
    /usr/sbin/chroot $R /sbin/ldconfig $vflag
else
    info "skipping library reduction on this platform"
    info "copying required and extra libraries from extract area to root area"
    ( cd $E && tar -cf - $LIBRARIES $EXTRA_LIBRARIES) | tar xlpf - -C $R $vflag
    testexit
fi


info "adding busybox links"
mount -t proc proc $R/proc      # busybox needs /proc
chroot $R /bin/busybox --install
umount $R/proc

# no keymaps for BVME and MVME
if [ "$system" != bvme6000 -a "$system" != mvme16x -a "$system" != mvme147 ]; then
	cp keymaps.tgz $R/etc/
else
	info "skipping keymaps for system type $system"
fi

# some friendly symlinks
ln -sf ash $R/bin/sh
ln -sf nano-tiny $R/bin/edit

# FIXME: this link is already in the sparc libc6 package [bug?]
# BC: glibc 2.1 does this. More than likely it can be removed since
#     m68k is now at glibc 2.1 along with all other archs
if [ ! -f $R/lib/$ldlib ]; then
    ln -sf `thelast ld-$libcver.so` $R/lib/$ldlib
fi

if [ -z "$MAINTAINER" ]; then
    MAINTAINER=`dpkg-parsechangelog | \
		awk -- '/^Maintainer/ {$1="" ; print $0}'|sed 's/^ *//'`
fi

info "installing release notes"
if [ "$ROOT_IS_I18N" = "true" ]; then
    # looks like we are trying to build the stuff with language chooser enabled
    # This means the release notes are to be in UTF.

    m4 $scripts/messages/C/release_notes \
        -D__debianversion__=$debianversion \
        -D__date__="`date +%Y-%m-%d`" \
        -D__floppyversion__="`dpkg-parsechangelog | \
                awk -- '/^Version/ {print $2}'`" \
        -D__username__="${MAINTAINER}" \
        >$R/release_notes.en

    for lang in $langs_root; do
        if [ "$lang" = en ]; then
            continue
        fi
        if [ ! -f $scripts/messages/$lang/release_notes ]; then
            warn "skipping release notes for $lang, $scripts/messages/$lang/release_notes doesn't exist"
            continue
        fi
        m4 $scripts/messages/$lang/release_notes \
            -D__debianversion__=$debianversion \
            -D__date__="`date +%Y-%m-%d`" \
            -D__floppyversion__="`dpkg-parsechangelog | awk -- '/^Version/ {print $2}'`" \
            -D__username__="${MAINTAINER}" |
        iconv -f `grep "^$lang " $scripts/messages/languages | awk '{ print $2 }'` -t utf-8 > $R/release_notes.$lang
    done
else
    m4 $scripts/messages/$language/release_notes \
        -D__debianversion__=$debianversion \
        -D__date__="`date +%Y-%m-%d`" \
        -D__floppyversion__="`dpkg-parsechangelog | \
                awk -- '/^Version/ {print $2}'`" \
        -D__username__="${MAINTAINER}" \
        >$R/release_notes
fi

# some platforms need an fdisk wrapper
# FIXME: Kludge - remove when this is fixed
if [ "$arch" = "m68k" ]; then
	cp $scripts/fdisk-m68k $R/sbin/fdisk
elif [ "$arch" = "powerpc" ]; then
	cp $scripts/fdisk-powerpc $R/sbin/fdisk
elif [ "$arch" = "s390" ]; then
	ln -fs fdasd $R/sbin/fdisk
fi

# powermac needs a ybin wrapper.  Should this be somewhere else?
case "$arch/$system" in
    powerpc/*pmac)
	cp $scripts/ybinwrapper $R/usr/sbin/ybin
	ln $R/usr/sbin/ybin $R/usr/sbin/mkofboot
	ln $R/usr/sbin/ybin $R/usr/sbin/yabootconfig
	ln -s /target/usr/lib/yaboot $R/usr/lib/yaboot
    ;;
esac

# don't rm -rf extract area until AFTER mklibs.sh otherwise we get
# bogus libs
info "removing extract area"
rm -rf "$E"

# Some files are not needed until the modules are installed (ifport,
# cardmgr,... ). They will come in the drivers disk, freeing up some
# space in the root disk. But we have to take them into account while
# building the stripped libraries. So, let's include them in the
# rootdisk, generate the libraries, and then remove them before building
# the disk image.
if [ -f $scripts/SMALL_REMOVE_LIST_${arch}_${system} ]; then
    files_to_remove=`cat $scripts/SMALL_REMOVE_LIST_all $scripts/SMALL_REMOVE_LIST_${arch}_${system}`
else
    files_to_remove=`cat $scripts/SMALL_REMOVE_LIST_all $scripts/SMALL_REMOVE_LIST_$arch`
fi
if [ ! -z "$files_to_remove" ]; then
    info "removing files according to $scripts/SMALL_REMOVE_LIST_{all,${arch},${arch}_${system}}"
    for f in $files_to_remove; do
        rm $R/$f
    done
fi

info "stripping executables in root area"
$scripts/strip_executables.sh $R/bin/* $R/usr/bin/* $R/sbin/* $R/usr/sbin/*

# replace symbolic links on the floppy with hard links
#  --  this saves one block per link
info "replacing symlinks with hard links in root area"
(cd $R && find . -type l -printf "(
	cd %h
	if [ ! -d $R/%l -a ! -d %l ]; then
		rm -f %f;
		if ln %l %f 2>/dev/null; then
			true
		elif ln $R/%l %f 2>/dev/null; then
			true
		else
			[ ${verbose}${debug} ] && echo 'W: backing out to symlink for %f' 1>&2
			ln -s %l %f
		fi
	fi
)\n" | sh)
testexit

echo "root">$R/type.txt

# try to unmount anything that should not be mounted
($ROOTCMD umount $mnt; $ROOTCMD umount $floppy; true)2>/dev/null >/dev/null

make_tmpdir $mnt

inodes=$(find $R | wc -l)

info "making disk image loop filesystem, size ${blocks}k, inodes $inodes"

# zero the entire disk, so that when we compress the raw disk image,
# unused blocks will compress well
dd if=/dev/zero of=$floppy bs=1k count=${blocks}

# make an ext2 filesystem
mke2fs -O none -F -q -N $inodes -m 0 $floppy

grep -q loop /proc/devices || insmod loop 

info "mounting loop file $floppy on '$mnt'"
$ROOTCMD mount -t ext2 -o loop $floppy $mnt

# get more space on ext2 fs
rmdir $mnt/lost+found

# compress devices.tar.gz better, saves about 4kb
(cd $R/usr/lib/debootstrap ; mv devices.tar.gz _devices.tar.gz ; zcat _devices.tar.gz|gzip -9>devices.tar.gz ; rm _devices.tar.gz)

info "copying root area into loop filesystem"
(cd $R && tar cf - .) | tar xpf - $vflag -C $mnt
testexit

info "removing root area, we're done with it"
rm -rf $R

if [ "$arch" = alpha ]; then
    # on alpha we try to build only one rootdisk
    # FIXME: use root_for_rescue in make/rescue instead
    info "symlinking modules${arch}_generic.tgz to modules.tgz, why is alpha so wierd?"
    ln -sf modulesgeneric.tgz modules.tgz
fi

prep_modules () {
    # we can either use the revext or the system name to set this;
    # honestly, I don't know why we're messing with system here... I
    # think the invokation of rootdisk.sh might be wrong

    if [ -f "modules$revext.tgz" ]; then
        modball=modules$revext.tgz
    elif [ -f "modules$system.tgz" ]; then
        modball=modules$system.tgz
    else
        error "attempted to grab a kernel module from unlocatable modules tarball, neither modules$revext.tgz nor modules$system.tgz"
    fi
    all_modules_list=$(tar tzf $modball)
}

include_module () {
    local module=$1
    local mf=""
    if [ -z $module ]; then
        error "include_module invoked incorrectly, needs module path as argument"
    fi
    local basemodule=$(basename $module)

    mf=$(echo $all_modules_list | tr \  \\n | grep /$basemodule 2>/dev/null)
    # FIXME: should check for matches > 1
    if [ ${mf} ] ; then
        info "including kernel module '$mf' from '$modball'"
        mkdir -p `dirname $module`
        tar xOzf $modball $mf > $module
        return 0
    else
        info "search for module '$basemodule' in '$modball' found nothing"
        return 1
    fi
}

prep_modules

include_module $mnt/lib/modules/misc/unix.o || true

if ! include_module $mnt/lib/modules/misc/af_packet.o ; then
    # some arches need to fail if we don't have this critical module
    if [ "$arch" = i386 ] && \
       [ "$revext" != "bf2.4" ]; then
        error "failure getting af_packet.o"
    fi
fi

if [ "$arch" = arm ]; then
    if [ "$system" = netwinder -o "$system" = "riscpc" ]; then
        include_module $mnt/lib/modules/block/loop.o
        include_module $mnt/lib/modules/block/ide-cd.o
        include_module $mnt/lib/modules/cdrom/cdrom.o
        include_module $mnt/lib/modules/fs/isofs.o
        include_module $mnt/lib/modules/block/floppy.o
        include_module $mnt/lib/modules/fs/adfs.o
    fi
    if [ "$system" = netwinder ]; then
        include_module $mnt/lib/modules/net/8390.o
        include_module $mnt/lib/modules/net/ne2k-pci.o
        include_module $mnt/lib/modules/net/tulip.o
    elif [ "$system" = riscpc ]; then
	include_module $mnt/lib/modules/net/8390.o
        include_module $mnt/lib/modules/net/ether1.o
        include_module $mnt/lib/modules/net/ether3.o
        include_module $mnt/lib/modules/net/etherh.o
	include_module $mnt/lib/modules/scsi/scsi_mod.o
	include_module $mnt/lib/modules/scsi/sd_mod.o
	include_module $mnt/lib/modules/scsi/sr_mod.o
	include_module $mnt/lib/modules/scsi/cumana_1.o
	include_module $mnt/lib/modules/scsi/cumana_2.o
	include_module $mnt/lib/modules/scsi/oak.o
	include_module $mnt/lib/modules/scsi/powertec.o
	include_module $mnt/lib/modules/scsi/eesox.o
	include_module $mnt/lib/modules/scsi/acornscsi_mod.o
	include_module $mnt/lib/modules/scsi/arxescsi.o
	include_module $mnt/lib/modules/scsi/fas216.o
	include_module $mnt/lib/modules/scsi/queue.o
	include_module $mnt/lib/modules/scsi/msgqueue.o
    fi
elif [ "$arch" = s390 ]; then
	include_module $mnt/lib/modules/drivers/s390/net/lcs.o
	include_module $mnt/lib/modules/drivers/s390/net/ctc.o 
	include_module $mnt/lib/modules/drivers/s390/net/netiucv.o 
	include_module $mnt/lib/modules/drivers/s390/char/tape390.o
	include_module $mnt/lib/modules/drivers/block/loop.o
	include_module $mnt/lib/modules/net/sunrpc/sunrpc.o
	include_module $mnt/lib/modules/fs/lockd/lockd.o
	include_module $mnt/lib/modules/fs/nfs/nfs.o
  
elif  [ "$arch" = i386 -a "$revext" = "bf2.4" ]; then
  kver=`echo -n 2.4; grep kver_24 config | cut -f3 -d4`
  include_module $mnt/lib/modules/$kver-bf2.4/kernel/drivers/usb/usbcore.o
  include_module $mnt/lib/modules/$kver-bf2.4/kernel/drivers/usb/usb-uhci.o
  include_module $mnt/lib/modules/$kver-bf2.4/kernel/drivers/usb/usb-ohci.o
  include_module $mnt/lib/modules/$kver-bf2.4/kernel/drivers/usb/usbkbd.o
#  include_module $mnt/lib/modules/$kver-bf2.4/kernel/drivers/usb/usb-storage.o
  include_module $mnt/lib/modules/$kver-bf2.4/kernel/drivers/input/input.o || true
  include_module $mnt/lib/modules/$kver-bf2.4/kernel/drivers/input/keybdev.o
fi

if [ $ro_poss  = 1 ]; then
    info "making modifications for read-only root filesystem support"
  ( mv $mnt/var $mnt/tmp/ && \
    ln -s tmp/var $mnt/var && \
    ln -s ../tmp/resolv.conf $mnt/etc/resolv.conf && \
    ln -s ../../target/usr/bin/whiptail $mnt/usr/bin/whiptail && \
    mv $mnt/lib/modules $mnt/tmp/modules && \
    ln -s ../tmp/modules $mnt/lib/modules )
    ln -s ../tmp/log $mnt/dev/log

    testexit
fi

info "adjusting owner and permissions in loop filesystem"
find $mnt/ \( -type f -o -type d -o -type l \) | xargs chown root.root
find $mnt/ \( -type f -o -type d \) | xargs chmod og=rX

# Umount the floppy and copy it to a compressed raw disk image file.
info "making raw disk image file"
df $mnt || true
df -i $mnt || true

info "waiting for sync"
relax
relax

$ROOTCMD umount $mnt
rmdir $mnt

# FIXME: this should not be specialized for powerpc
if [ "$arch" = powerpc ]; then
    info "compressing root image, root$system.bin"
    rm -f root$system.bin || true
    gzip -9c < $floppy > root$system.bin
    ls -l root$system.bin
else
    info "compressing root image, root$revext$system.bin"
    rm -f root$revext$system.bin || true
    if [ -n "$i18n_low_space" ] ; then
       info "lowspace flag is set, using rootmini.bin as rootfs image"
       revext=mini
       system=""
    fi
    gzip -9c < $floppy > root$revext$system.bin
    ls -l root$revext$system.bin
fi

rm -f $floppy
exit 0

