/***************************************************************************
                          Interface_callbacks_samples.cpp  -  description
                             -------------------
    begin                : Sat Jan 20 2001
    copyright            : (C) 2001 by c0del4rvi4
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface.h"

void Interface::on_spinbutton_samples_base_note_changed() {

	if (selected_sample_updating_in_progress) return;

	song->get_sample(selected_sample)->data.note_offset=spinbutton_samples_base_note->get_value_as_int()-48;
	entry_samples_base_note.set_text(editor.get_single_note_string(song->get_sample(selected_sample)->data.note_offset+48));

        realtime_keyboard.sample_adjust_latest_key();
}

void Interface::on_spinbutton_samples_finetune_changed() {

	if (selected_sample_updating_in_progress) return;

	song->get_sample(selected_sample)->data.finetune=spinbutton_samples_finetune->get_value_as_int();

        realtime_keyboard.sample_adjust_latest_key();

}

gint Interface::on_samples_piano_enabled_widgets_key_pressed(GdkEventKey* event) {

        bool alt = event->state & GDK_MOD1_MASK;

	if (! ((event->keyval>='a' && event->keyval<='z') ||
   	    (event->keyval>='A' && event->keyval<='Z') ||
	    (event->keyval>='0' && event->keyval<='9')) ) return 1;


        if (alt) {

		switch (event->keyval) {

			case 'A': {

				on_popup_sample_edit_clicked(Popup_Sample_Utils::OPTION_CHANGE_SIGN);
			} break;
			case 'B': {

				on_popup_sample_edit_clicked(Popup_Sample_Utils::OPTION_PRE_LOOP_CUT);
			} break;
			case 'C': {

				//??
			} break;
			case 'D': {

				on_popup_sample_edit_clicked(Popup_Sample_Utils::OPTION_DELETE);
			} break;
			case 'E': {

				on_popup_sample_edit_clicked(Popup_Sample_Utils::OPTION_RESIZE_INTERP);
			} break;
			case 'F': {

				on_popup_sample_edit_clicked(Popup_Sample_Utils::OPTION_RESIZE_NONINTERP);
			} break;
			case 'G': {

				on_popup_sample_edit_clicked(Popup_Sample_Utils::OPTION_REVERSE);
			} break;
			case 'H': {

				on_popup_sample_edit_clicked(Popup_Sample_Utils::OPTION_CENTRALIZE);
			} break;
			case 'L': {

				on_popup_sample_edit_clicked(Popup_Sample_Utils::OPTION_POST_LOOP_CUT);
			} break;
			case 'M': {

				on_popup_sample_edit_clicked(Popup_Sample_Utils::OPTION_AMPLIFY);
			} break;
			case 'Q': {

				on_popup_sample_edit_clicked(Popup_Sample_Utils::OPTION_TOGGLE_QUALITY);
			} break;
		}		

		 return 1;
	}
	

	if (!xlib_key_is_pressed(event->keyval)) return 1;

        if (event->keyval>='a' && event->keyval<='z') event->keyval-=('a'-'A');

	int pressed_note=editor.get_note_from_key(event->keyval);

	if (pressed_note!=255) realtime_keyboard.sample_press_key(pressed_note);

	return 1;

}
gint Interface::on_samples_piano_enabled_widgets_key_released(GdkEventKey* event) {

	if (! ((event->keyval>='a' && event->keyval<='z') ||
   	    (event->keyval>='A' && event->keyval<='Z') ||
	    (event->keyval>='0' && event->keyval<='9')) ) return 1;

	if (xlib_key_is_pressed(event->keyval)) return 1;

        if (event->keyval>='a' && event->keyval<='z') event->keyval-=('a'-'A');

	int pressed_note=editor.get_note_from_key(event->keyval);

	if (pressed_note!=255) realtime_keyboard.sample_stop_key(pressed_note);

	return 1;
}

void Interface::on_entry_samples_loop_type_changed() {

	if (selected_sample_updating_in_progress) return;

	string aux_text;	

	aux_text=combo_samples_loop_type.get_entry()->get_text();

	if (aux_text=="|None|") {


		song->get_sample(selected_sample)->data.loop_on=false;
		song->get_sample(selected_sample)->data.pingpong_loop=false;


	} else if (aux_text=="|Forward->") {

		song->get_sample(selected_sample)->data.loop_on=true;
		song->get_sample(selected_sample)->data.pingpong_loop=false;


	} else {

		song->get_sample(selected_sample)->data.loop_on=true;
		song->get_sample(selected_sample)->data.pingpong_loop=true;
	}


}

void Interface::on_entry_samples_sustain_loop_type_changed() {

	if (selected_sample_updating_in_progress) return;

	string aux_text;	

	aux_text=combo_samples_loop_type.get_entry()->get_text();

	if (aux_text=="|None|") {


		song->get_sample(selected_sample)->data.loop_on=false;
		song->get_sample(selected_sample)->data.pingpong_loop=false;


	} else if (aux_text=="|Forward->") {

		song->get_sample(selected_sample)->data.loop_on=true;
		song->get_sample(selected_sample)->data.pingpong_loop=false;


	} else {

		song->get_sample(selected_sample)->data.loop_on=true;
		song->get_sample(selected_sample)->data.pingpong_loop=true;
	}


}


void Interface::on_entry_samples_samplename_changed() {

	if (selected_sample_updating_in_progress) return;

	song->get_sample(selected_sample)->name=entry_samples_samplename.get_text();
        clist_samples_list.set_text(selected_sample,2,song->get_sample(selected_sample)->name);
	update_main_editing_entries();

}

void Interface::on_clist_samples_list_select_row(gint row, gint column, GdkEvent *event) {

	if (selected_sample_updating_in_progress) return;	

	selected_sample=row;
	update_selected_sample_info();

       	if (!song->variables.use_instruments) {

		editor.set_instrument_mask_value(row);
	} else {

		editor.set_instrument_mask_value(song->find_sample_in_instrument(row));
	}

	update_main_editing_entries();
}



void Interface::on_checkbutton_samples_def_pan_clicked() {

	if (selected_sample_updating_in_progress) return;

	song->get_sample(selected_sample)->def_panning_on=checkbutton_samples_def_pan.get_active();
}

void Interface::on_radiobutton_samples_waveform_saw_clicked() {

	if (selected_sample_updating_in_progress) return;

	song->get_sample(selected_sample)->vibrato_type=0;	

}

void Interface::on_radiobutton_samples_waveform_sine_clicked() {

	if (selected_sample_updating_in_progress) return;

	song->get_sample(selected_sample)->vibrato_type=1;	

}

void Interface::on_radiobutton_samples_waveform_square_clicked() {

	if (selected_sample_updating_in_progress) return;

	song->get_sample(selected_sample)->vibrato_type=2;	

}

void Interface::on_radiobutton_samples_waveform_random_clicked() {

	if (selected_sample_updating_in_progress) return;

	song->get_sample(selected_sample)->vibrato_type=3;	

}

void Interface::on_button_samples_edit_clicked(){

	//anyone wanna code a nice sample editor? :D
       	sample_utils_popup.sample_menu.popup(1,0);
}


void Interface::on_button_samples_play_clicked()
{
}

void Interface::on_spinbutton_samples_def_volume_changed() {

	if (selected_sample_updating_in_progress) return;

	song->get_sample(selected_sample)->def_volume=spinbutton_samples_def_volume->get_value_as_int();

}
void Interface::on_spinbutton_samples_glb_volume_changed() {

	if (selected_sample_updating_in_progress) return;

	song->get_sample(selected_sample)->glb_volume=spinbutton_samples_glb_volume->get_value_as_int();
}
void Interface::on_spinbutton_samples_def_pan_changed() {

	if (selected_sample_updating_in_progress) return;

	song->get_sample(selected_sample)->def_panning=spinbutton_samples_def_pan->get_value_as_int();

}
void Interface::on_spinbutton_samples_vibrato_speed_changed() {

	if (selected_sample_updating_in_progress) return;

	song->get_sample(selected_sample)->vibrato_speed=spinbutton_samples_vibrato_speed->get_value_as_int();
}

void Interface::on_spinbutton_samples_vibrato_depth_changed() {



	if (selected_sample_updating_in_progress) return;

	song->get_sample(selected_sample)->vibrato_depth=spinbutton_samples_vibrato_depth->get_value_as_int();
}
void Interface::on_spinbutton_samples_vibrato_rate_changed() {

	if (selected_sample_updating_in_progress) return;

	song->get_sample(selected_sample)->vibrato_rate=spinbutton_samples_vibrato_rate->get_value_as_int();
}

void Interface::on_spinbutton_samples_speed_changed() {

	if (selected_sample_updating_in_progress) return;
}

#define SET_SPIN_MAX(spinbtn,maxval) tmp_adjustment=spinbtn->get_adjustment(); tmp_adjustment->set_upper(maxval); spinbtn->set_adjustment(tmp_adjustment)
#define SET_SPIN_MIN(spinbtn,maxval) tmp_adjustment=spinbtn->get_adjustment(); tmp_adjustment->set_lower(maxval); spinbtn->set_adjustment(tmp_adjustment)

void Interface::on_spinbutton_samples_loop_begin_changed() {

	if (selected_sample_updating_in_progress) return;

	int i=selected_sample;
	Gtk::Adjustment *tmp_adjustment;

	song->get_sample(i)->data.loop_begin=spinbutton_samples_loop_begin->get_value_as_int();

	SET_SPIN_MIN(spinbutton_samples_loop_end,song->get_sample(i)->data.loop_begin+1);

	sample_view_samples_current.set_redraw_all();
	sample_view_samples_current.queue_draw();

}
void Interface::on_spinbutton_samples_loop_end_changed() {

	if (selected_sample_updating_in_progress) return;

	int i=selected_sample;
	Gtk::Adjustment *tmp_adjustment;

	song->get_sample(i)->data.loop_end=spinbutton_samples_loop_end->get_value_as_int();
	SET_SPIN_MAX(spinbutton_samples_loop_begin,song->get_sample(i)->data.loop_end-1);

	sample_view_samples_current.set_redraw_all();
	sample_view_samples_current.queue_draw();

}
void Interface::on_spinbutton_samples_susloop_begin_changed() {

	if (selected_sample_updating_in_progress) return;

	int i=selected_sample;
	Gtk::Adjustment *tmp_adjustment;

	song->get_sample(i)->data.sustain_loop_begin=spinbutton_samples_susloop_begin->get_value_as_int();

	SET_SPIN_MIN(spinbutton_samples_susloop_end,song->get_sample(i)->data.sustain_loop_begin+1);

	sample_view_samples_current.set_redraw_all();
	sample_view_samples_current.queue_draw();

}
void Interface::on_spinbutton_samples_susloop_end_changed() {

	if (selected_sample_updating_in_progress) return;

	int i=selected_sample;
	Gtk::Adjustment *tmp_adjustment;

	song->get_sample(i)->data.sustain_loop_end=spinbutton_samples_susloop_end->get_value_as_int();
	SET_SPIN_MAX(spinbutton_samples_susloop_begin,song->get_sample(i)->data.sustain_loop_end-1);

	sample_view_samples_current.set_redraw_all();
	sample_view_samples_current.queue_draw();

}

void Interface::on_popup_sample_edit_clicked(int option) {

	sample_view_samples_current.set_redraw_all();

	realtime_keyboard.instrument_stop_all();
	realtime_keyboard.sample_stop_all();
      	player->play_stop();		
	
	variables_lock->grab();

	switch (option) {

		case Popup_Sample_Utils::OPTION_COPY: {

			sample_clipboard=*song->get_sample(selected_sample);
			clipboard_sample_index=selected_sample;

		} break;
		case Popup_Sample_Utils::OPTION_PASTE: {

			if (clipboard_sample_index==-1) break;
			*song->get_sample(selected_sample)=sample_clipboard;
	
		} break;
		case Popup_Sample_Utils::OPTION_PASTE_EXCHANGE: {

			if (clipboard_sample_index==-1) break;

			sample_clipboard=*song->get_sample(selected_sample);
			*song->get_sample(selected_sample)=*song->get_sample(clipboard_sample_index);
			*song->get_sample(clipboard_sample_index)=sample_clipboard;
		} break;
		case Popup_Sample_Utils::OPTION_PASTE_EXCHANGE_SONG: {

			if (clipboard_sample_index==-1) break;

			sample_clipboard=*song->get_sample(selected_sample);
			*song->get_sample(selected_sample)=*song->get_sample(clipboard_sample_index);
			*song->get_sample(clipboard_sample_index)=sample_clipboard;
		} break;
		case Popup_Sample_Utils::OPTION_DELETE: {

			song->get_sample(selected_sample)->reset();

		} break;

		case Popup_Sample_Utils::OPTION_REVERSE: {

			if (!song->get_sample(selected_sample)->in_use) break;

			song->get_sample(selected_sample)->data.reverse();

		} break;
		case Popup_Sample_Utils::OPTION_POST_LOOP_CUT: {

			if (!song->get_sample(selected_sample)->in_use) break;

			song->get_sample(selected_sample)->data.post_loop_cut();

		} break;
		case Popup_Sample_Utils::OPTION_PRE_LOOP_CUT: {

			if (!song->get_sample(selected_sample)->in_use) break;

			song->get_sample(selected_sample)->data.pre_loop_cut();

		} break;
		case Popup_Sample_Utils::OPTION_CHANGE_SIGN: {

			if (!song->get_sample(selected_sample)->in_use) break;

			song->get_sample(selected_sample)->data.change_sign();

		} break;
		case Popup_Sample_Utils::OPTION_TOGGLE_QUALITY: {

			if (!song->get_sample(selected_sample)->in_use) break;

			song->get_sample(selected_sample)->data.toggle_quality();

		} break;
		case Popup_Sample_Utils::OPTION_CENTRALIZE: {

			if (!song->get_sample(selected_sample)->in_use) break;

			song->get_sample(selected_sample)->data.centralize();

		} break;
		case Popup_Sample_Utils::OPTION_AMPLIFY: {

			if (!song->get_sample(selected_sample)->in_use) break;

                        input_value_popup=new Dialog_Enter_Value("Scale Volume %",song->get_sample(selected_sample)->data.get_value_to_normalize(),0,400,*kit);

			if (input_value_popup->get_action()==Dialog_Enter_Value::PRESS) {

				song->get_sample(selected_sample)->data.amplify(input_value_popup->get_value());
			}

			delete input_value_popup;

		} break;
		case Popup_Sample_Utils::OPTION_RESIZE_NONINTERP: {

			if (!song->get_sample(selected_sample)->in_use) break;

                        input_value_popup=new Dialog_Enter_Value("New Size (Samples)",song->get_sample(selected_sample)->data.size,1,8000000,*kit);

			if (input_value_popup->get_action()==Dialog_Enter_Value::PRESS) {

				song->get_sample(selected_sample)->data.resize(input_value_popup->get_value());
			}

			delete input_value_popup;

		} break;
		case Popup_Sample_Utils::OPTION_RESIZE_INTERP: {

			if (!song->get_sample(selected_sample)->in_use) break;

                        input_value_popup=new Dialog_Enter_Value("New Size (Samples)",song->get_sample(selected_sample)->data.size,1,8000000,*kit);

			if (input_value_popup->get_action()==Dialog_Enter_Value::PRESS) {

				song->get_sample(selected_sample)->data.resize_interpolated(input_value_popup->get_value());
			}

			delete input_value_popup;

		} break;
		case Popup_Sample_Utils::OPTION_LOAD: {

			variables_lock->release();
	                load_sample();
			variables_lock->grab();

		} break;
		case Popup_Sample_Utils::OPTION_SAVE: {

			variables_lock->release();
	                save_sample();
			variables_lock->grab();

		} break;		

	}

	variables_lock->release();


        update_clist_samples_list();
	update_selected_sample_info();
}


