/***************************************************************************
                          interface_widget_equivtable.h  -  description
                             -------------------
    begin                : Sun Apr 8 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INTERFACE_WIDGET_EQUIVTABLE_H
#define INTERFACE_WIDGET_EQUIVTABLE_H


#include <gtk--/widget.h>
#include "instrument.h"
#include "editor.h"
/**
  *@author Juan Linietsky
  */

/******************************
 interface_widget_equivtable.h
 ----------

This edits the note -> note/sample
relation in an instrument
********************************/


class Equivalence_Table : public Gtk::Widget {

	static int Orderlist_Colors[];

       	enum _Colormap {

		Col_BackGround,
		Col_ForeGround,
		Col_Cursor,
		Col_BeingPlayed,
		Col_Separator,
		Colormap_max_Colors
	};

	Gdk_Color colors[Colormap_max_Colors];
        Gdk_GC bgcol, fgcol, cursorcol, playcol, sepcol;
	void allocate_colormap ();

	int get_font_width();
	int get_font_height();
	void draw_single_mode();
	void draw_single_cursor();

	int column_offset, row_offset;
	int cursor_x,cursor_y;
        int sample_mask;

	Gdk_Font font;

	Instrument *instrument; //songptr!	
	Editor *editor;
public:


        bool im_focused; //dirty hack! -- VERY dirty actually.  but i just didnt get has_focus() to work even when using grab_focus() so...

	Gdk_Window window;
	void realize_impl();
	gint do_expose_event(GdkEventExpose* p0);

	void draw_impl(GdkRectangle* p0){

		draw_single_mode();
	
	}
	
	gint button_press_event_impl(GdkEventButton* p0);
	gint focus_out_event_impl(GdkEventFocus* p0);

	void MoveUp();
	void MoveDown();
	void MoveLeft();
	void MoveRight();
	void PageUp();
	void PageDown();

	void InsertValue(int number);
	void AddSeparator();
	void ClearOrder();
        void InsertBlank();
	void DeleteRow();
	void InsertRepeat();

	void link_to_instrument(Instrument *p_instrument);
	void link_to_editor(Editor *p_editor);


	Equivalence_Table();
	~Equivalence_Table();

};

#endif
