/***************************************************************************
                          loader.h  -  description
                             -------------------
    begin                : Sun Jan 21 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LOADER_H
#define LOADER_H


/**Base Loader Class
  *@author Juan Linietsky
  */

#include "file_reader.h"
#include "song.h"
/******************************
 loader.h
 ----------

Abstract base class of a lodered.
The class that loads samples/songs/
instruments/etcetera.
********************************/

class Loader {

protected:

	File_Reader file_read;

        int abort_load(int p_cause);

	Song *song;
        string aux_filename;
        string format_name;
public:
        enum errors {

		SUCCESS,
		LOADER_IN_USE,
		CANNOT_OPEN_FILE,
		FILE_ERROR,
		FILE_FORMAT_NOT_RECOGNIZED,
		HEADER_CORRUPT,
		MAX_ERRORS
	};

	static const char * error_string[MAX_ERRORS];

	virtual int load(char *p_filename,bool p_load_patterns)=0;
        virtual bool test(char *p_filename) =0;


	/* Compute Sample Info */
	virtual int get_amount_of_samples() =0;	
	virtual Sample_Data *get_sample_data(int p_sample_index) =0;	
	virtual string get_sample_name(int p_sample_index)=0;	
	virtual void add_sample_to_song(int p_sample_index,int p_dest_index,bool create_instrument)=0;	
	virtual int load_sample(char *p_filename,int p_dest_index) =0;
	virtual int load_samples_from_instrument(char *p_filename) =0;

	/* Compute Instrument Info */
	virtual int load_instrument(char *p_filename,int p_dest_index)=0;

	virtual void transfer_data_to_song() =0;

	virtual void free_info(bool free_sampledata=false) {};

	void set_song(Song *p_song) { song=p_song; };
	string get_format_name() { return format_name; }

	Loader();
	virtual ~Loader();
};

#endif
