/***************************************************************************
                          nsf_export.cpp  -  description
                             -------------------
    begin                : Sun Jan 20 2002
    copyright            : (C) 2002 by red
    email                : red@server
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "nsf_export.h"
#include <stdio.h>

void NSF_Export::write_header() {

	//header
	writer.store_byte_array((Uint8*)"NESM",4);
	writer.store_byte(0x1A);
	
	writer.store_byte(1); //version
	writer.store_byte(1); //songs
	writer.store_byte(1); //starting song
	
	writer.store_word(0x8000); //load address of data
	writer.store_word(0x8000); //load address of player
	writer.store_word(0x806D); //load address of play address	
	
	writer.store_byte_array((Uint8*)"Nobody\0                                            ",32);	
	writer.store_byte_array((Uint8*)"Nobody\0                                            ",32);	
	writer.store_byte_array((Uint8*)"Nobody\0                                            ",32);	
	writer.store_word(0x411A); //60hz  NTSC
	
	writer.store_byte(0);  //bank info
	writer.store_byte(1);
	writer.store_byte(1);
	writer.store_byte(1);
	writer.store_byte(1);
	writer.store_byte(1);
	writer.store_byte(1);
	writer.store_byte(1);
	
	writer.store_word(0x411A); //60hz  PAL TOO!	
	
	writer.store_byte(0); //no weird flags
	
	writer.store_byte(0); //expansion
	writer.store_byte(0);
	writer.store_byte(0);
	writer.store_byte(0);
	writer.store_byte(0);
	
	
}
void NSF_Export::write_byte(Uint8 p_byte) {

	writer.store_byte(p_byte);
	pos_counter++;
	

}

void NSF_Export::write_address(Uint16 p_register_addr,Uint8 p_byte) {

	write_byte(0xA9); write_byte(p_byte); // LDA #p_byte
	write_byte(0x8d); write_byte(p_register_addr&0xFF); write_byte(p_register_addr >> 8); // STA $p_register_addr
}

void NSF_Export::update_voice_data(Uint8 p_voice, bool write_chunk=false) {

	if ((p_voice<2) || (p_voice==3)) {
	
		Uint8 val;
		Uint16 reg;
		val=0;
		val|=voice[p_voice].volume;
		val|=16; //no envelope
		val|=32; //no
		val|=voice[p_voice].duty << 6;
		reg=0x4000+4*p_voice;
		if (write_chunk) {
		
			write_byte(4*p_voice);
			write_byte(val);
		} else {
			write_address(reg,val);
		}
	} else if (p_voice==2) {
	
			write_byte(4*p_voice);
			write_byte(0xFF);
			write_byte(0x15);						
			if (voice[p_voice].volume==0) {
			
				write_byte(251);			
			} else {
			
				write_byte(255);						
			}
	
	}

}

void NSF_Export::update_voice_freq(Uint8 p_voice) {

	if (p_voice<4) {
	
		Uint16 val;
		Uint16 reg;

		if (p_voice!=3) {
		
			val=(voice[p_voice].freq>>8)&0x7;
			reg=3+4*p_voice;		
			write_byte(reg);
			write_byte(val);
		
		}
		
		if (p_voice!=3) val=(voice[p_voice].freq&0xFF);
		else val=(voice[p_voice].freq&0xF)&128;
		reg=2+4*p_voice;		
		write_byte(reg);
		write_byte(val);
		

	}
}


void NSF_Export::compare_and_branch_if_min(Uint16 address1,Uint16 address2,Sint8 branch) {

	write_byte(0xAD); // LDA
	write_byte(address1 & 0xFF);	
	write_byte(address1 >> 8); // $0010
	
	write_byte(0xCD); // CMP
	write_byte(address2 & 0xFF);	
	write_byte(address2 >> 8); // $0010
	
	write_byte(0x30); // BMI
	write_byte(branch); // how many?

}

void NSF_Export::load_song_ptr_in_a() {

        //firts lets put Y to zero
	write_byte(0xA0); //LDY
	write_byte(0x0);
	
	write_byte(0xB1); //LDA
	write_byte(0x18);//($18),Y (getting the byte at song ptr)
	
	write_byte(0xAA); // A->X (storing the result in X)
	write_byte(0x18); //CLC	
		
	write_byte(0xA9); //LDA
	write_byte(0x1); //#1

	write_byte(0x65); //ADC	
	write_byte(0x18); //$19
	
	write_byte(0x85); //STA
	write_byte(0x18); //$19

	write_byte(0xA9); //LDA
	write_byte(0x0); //#0

	write_byte(0x65); //ADC	
	write_byte(0x19); //$18
	
	write_byte(0x85); //STA
	write_byte(0x19); //$18

	write_byte(0x8A); // C->A (recover the result from X)
}

int NSF_Export::init() {

	char name[32];
	string filename;
	string title;
	request_player_data();
	player_playing=false;
	dumping=false;
	player_stopped=false;
	last_frame_written=current_frame=0;
	player->set_force_no_nna(true);
        player->set_force_external_vibratos(false);	
	current_bank=1;
	filename=player->get_song()->variables.filename;
	if (filename=="") {
	
		filename="noname.nsf";
	} else {
	
		filename=filename+".nsf";
	}
	
	writer.open(filename.c_str());
	
	write_header();
	
	pos_counter=0x8000;
	
	write_address(0x4015,15); // activate all channels
	update_voice_data(0);	
	update_voice_data(1);	
	update_voice_data(3);
	
	write_address(0x0010,0); //current time = 0
	write_address(0x0011,0);
	write_address(0x0012,0);
	write_address(0x0013,0);
	write_address(0x0014,0); //new time = 0
	write_address(0x0015,0);
	write_address(0x0016,0);
	write_address(0x0017,0);
	write_address(0x0017,0);
	write_address(0x0018,0x00);
	write_address(0x0019,0x90);
	write_address(0x001B,0x40); //low part of register address is 0x40
	write_address(0x001C,0x40); //high part of register address is 0x40

	write_byte(0xA9); //LDA
	write_byte(0x7F); //#1
	write_byte(0x8D); //LDA
	write_byte(0x01); //LDA
	write_byte(0x40); //LDA
	write_byte(0x8D); //LDA
	write_byte(0x05); //LDA
	write_byte(0x40); //LDA
	
	write_byte(0x60); // RTS
	
	while (pos_counter<0x806C) write_byte(0x00);
	write_byte(0x60); //RET! so there's a RET at 8019

	//increment frame	
	write_byte(0x18); //CLC	
		
	write_byte(0xA9); //LDA
	write_byte(0x1); //#1

	write_byte(0x65); //ADC	
	write_byte(0x12); //$12
	
	write_byte(0x85); //STA
	write_byte(0x12); //$12

	write_byte(0xA9); //LDA
	write_byte(0x0); //#0

	write_byte(0x65); //ADC	
	write_byte(0x11); //$11
	
	write_byte(0x85); //STA
	write_byte(0x11); //$11

	write_byte(0xA9); //LDA
	write_byte(0x0); //#0

	write_byte(0x65); //ADC	
	write_byte(0x10); //$10
	
	write_byte(0x85); //STA
	write_byte(0x10); //$10
	
		
	//$0010 current frame, $0014 new event frame, $0018 song ptr ,$001A register, $001C 1!
	//8050 - read time subroutine
	//8070 - read register subroutine

	//compare current frame < with new note frame - if OK, continue, if not, bye
	

	//while the current frame time > next event time...
	compare_and_branch_if_min(0x0010,0x0014,-28); //go back to ret
	compare_and_branch_if_min(0x0011,0x0015,-36); //go back to ret
	compare_and_branch_if_min(0x0012,0x0016,-44); //go back to ret!
	
	load_song_ptr_in_a();


	//jump to song end handler if song set time
	write_byte(0xC9); //CMP
	write_byte(0xFE); // #$FE (song set time??)
	write_byte(0xD0); // BNE
	write_byte(66); // how many?
/* if A==0x */	
/**/	
	
	load_song_ptr_in_a(); // branch +19
	write_byte(0x85); //STA
	write_byte(0x14); //store a in register address (+22)
	load_song_ptr_in_a(); // branch +19
	write_byte(0x85); //STA
	write_byte(0x15); //store a in register address (+44)
	load_song_ptr_in_a(); // branch +19
	write_byte(0x85); //STA
	write_byte(0x16); //store a in register address (+66)

/**/	write_byte(0x4C); //JMP
/**/	write_byte(0x80);
/**/	write_byte(0x80); // $8020 - continue the while (+69)
	
	write_byte(0xC9); //CMP
	write_byte(0xFD); // #$FE (change bank??)
	write_byte(0xD0); // BNE
	write_byte(35); // how many?
/* if A==0x */

	load_song_ptr_in_a();
	write_byte(0x8D); //STA
	write_byte(0xF9);	
	write_byte(0x5F); //$5FF9 //change bankus
	write_address(0x0018,0x00);
	write_address(0x0019,0x90); //reset song ptr!
/**/	write_byte(0x4C); //JMP
/**/	write_byte(0x80);
/**/	write_byte(0x80); // $8020 - continue the while (+69)

	
	
//nothing left, to do, so then we should write a register
	
	write_byte(0x85); //STA
	write_byte(0x1A); //store a in register address

	load_song_ptr_in_a(); //get parameter
	
	write_byte(0xA0); //LDY
	write_byte(0x0);
	
	write_byte(0x91); //STA
	write_byte(0x1A);//($1A),Y (register address)
	
	write_byte(0x4C); //JMP
	write_byte(0x80);
	write_byte(0x80); // $8020 - continue the while

	while (pos_counter<0x9000) write_byte(0x00); //wait 'til next bank
	
	return 0;
}
bool NSF_Export::finish() {

	player->set_force_no_nna(false);
        player->set_force_external_vibratos(false);
}


bool NSF_Export::update() {

	if ((player->get_play_mode()==Player_Data::PLAY_SONG) && (!player_stopped)) {

		int i;
		for (i=0;i<50;i++) {
			player->process_tick();
			current_frame+=60.0/((float)player->get_current_tempo()/2.5);
		}
		
		if (player->reached_end_of_song()) {
  		
  			write_byte(0xFD);   //looping
			write_byte(1);
			while (pos_counter<0xA000) write_byte(0x00);
			pos_counter=0x9000;	
			
			writer.close();
			player_stopped=true;
		}
	}	
	
	return true;
}

void NSF_Export::write_frame() {

	Uint8 f1,f2,f3;
	int frame=current_frame;

	if (pos_counter>0x9FC0) {
		
		current_bank++;
		write_byte(0xFD);
		write_byte(current_bank);
		while (pos_counter<0xA000) write_byte(0x00);
		pos_counter=0x9000;			
	}
		
	if ((current_frame<=last_frame_written) && (current_frame>0)) return;
	
	frame=current_frame;
	
	f1=frame&0xFF;
	frame>>=8;
	f2=frame&0xFF;
	frame>>=8;
	f3=frame&0xFF;
	

	write_byte(0xFE); //set song time
	write_byte(f3);
	write_byte(f2);
	write_byte(f1);
	last_frame_written=current_frame;
}

void NSF_Export::link_player_data(Player_Data *p_player_data) {

	player=p_player_data;
}

void NSF_Export::setup_voice(int p_voice_index,Sample_Data *p_sample_data,Sint32 p_start_index) {

	if (p_sample_data==NULL) return;
	if (p_voice_index>=2) return;

	int index=player->get_voice_sample_index(p_voice_index);
	
	if (index>3) return;
		
	if (index==voice[p_voice_index].duty) return;
	
	voice[p_voice_index].duty=index;
	
	write_frame();	
	update_voice_data(p_voice_index,true);	
	


}

void NSF_Export::stop_voice(int p_voice_index) {


}

void NSF_Export::set_voice_frequency(int p_voice_index,Uint32 p_freq) {
	

	if (p_voice_index>=4) return;


	int real_freq = p_freq/16;
        int nesfreq;

	switch (p_voice_index) {
	
		case 0:
		case 1: {
		
			nesfreq=(float) (56387.665/((float)real_freq/12.0));
		} break;
		case 2: {
			nesfreq=(float)(56387.665/((float)real_freq/6.0));
		} break;
		case 3: {
		        nesfreq=(float)(56387.665/((float)real_freq/2.0));
		        nesfreq>>=6;

		} break;
	}
		
        if (nesfreq>0x7FF) nesfreq=0x7FF;
        if (nesfreq<0) nesfreq=0;
	if (nesfreq==voice[p_voice_index].freq) return;
	
	write_frame();
	
	voice[p_voice_index].freq=nesfreq;
	
	update_voice_freq(p_voice_index);

}

void NSF_Export::set_voice_volume(int p_voice_index,int p_vol) {
	
	if (p_voice_index>=4) return;
        int nesvolume=p_vol*15/512;
	
        if (p_voice_index==2) {

        	nesvolume=(nesvolume<2)?nesvolume=0:nesvolume=15;

        }

        if (nesvolume>15) nesvolume=15;
        if (nesvolume<0) nesvolume=0;

        if (nesvolume==voice[p_voice_index].volume) return;

	write_frame();

	voice[p_voice_index].volume=nesvolume;
	update_voice_data(p_voice_index,true);	
}

void NSF_Export::update_voice_vibrato(Uint8 p_voice) {

	if (p_voice<2) {
	
		Uint16 val;
		Uint16 reg;

		reg=1+4*p_voice;		
				
		if ((voice[p_voice].vibdepth==0) || (voice[p_voice].vibsweep==0)) {
		
			val=0;		

		} else {
		
			val=voice[p_voice].vibdepth;
			val|=8; //increase!
			val|=voice[p_voice].vibsweep<<4; //increase!
			val|=0x80; //enable
		}			

		write_byte(reg);
		write_byte(val);
		
	}
}


void NSF_Export::set_voice_vibrato(int p_voice_index,int p_speed,int p_depth) {
	
	if (p_voice_index>=2) return;

	int newsweep,newdepth;
	
	
	//newsweep=p_speed*7/0xF;
	//newdepth=p_depth*7/0xF;
/*
	if (p_speed>0) {
	

		newsweep=6;
		
	} else {
	
		newsweep=0;

		
	}
	if (p_depth>0) {
		

	
		newdepth=2;
	} else {
	

		newdepth=0;
	}

	if ((newsweep==voice[p_voice_index].vibsweep) && (newdepth==voice[p_voice_index].vibdepth)) return;
	
	voice[p_voice_index].vibsweep=newsweep;
	voice[p_voice_index].vibdepth=newdepth;

	write_frame();	
	update_voice_vibrato(p_voice_index);
	
	*/
}



NSF_Export::NSF_Export(){
}
NSF_Export::~NSF_Export(){
}
