;;; -*- Mode: LISP; Syntax: ANSI-Common-Lisp; Package: CL-USER; -*-
;;;
;;; Filename:    ssl-ffi-lw.lisp
;;; Authors:     Jochen Schmidt <jsc@dataheaven.de>
;;;              Wade Humeniuk <humeniuw@cadvision.com>
;;; Description: Definitions of the needed foreign-functions
;;;              and the byte-vector handling needed for
;;;              simple buffering.
;;;

(in-package :ssl-internal)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Connection and Error handling  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
#! (:export nil :library "ssleay32")
void SSL_load_error_strings();
int SSL_library_init();
void *SSLv23_method();	
void *SSLv23_client_method();	
void SSL_set_connect_state(void* ssl);
void SSL_set_accept_state(void* ssl);
void *SSL_CTX_new(void *meth);
void *SSL_new(void *ctx);
int	SSL_set_fd(void *s, int fd);
long SSL_CTX_set_mode(void* ctx, long fd);
int SSL_get_error(void* ssl, int ret);
int	SSL_connect(void *ssl);
int SSL_accept(void* ssl);
int	SSL_write(void *ssl,const char *buf,int num);
int	SSL_read(void *ssl,char *buf,int num);
int SSL_pending(void* ssl);
int SSL_shutdown(void* ssl);
void SSL_free(void *ssl);
void SSL_CTX_free(void * ctx);
!#

#! (:export nil :library "libeay32")
void RAND_seed(char* buf, int num);
unsigned long ERR_get_error();
!#

(defun ssl-load-error-strings ()
    (ssl_load_error_strings))

(defun ssl-library-init ()
    (ssl_library_init))

(defun ssl-v23-method ()
    (SSLv23_method))

(defun ssl-set-connect-state (ssl)
    (SSL_set_connect_state ssl))

(defun ssl-set-accept-state (ssl)
    (SSL_set_accept_state ssl))

(defun ssl-ctx-new (method)
    (SSL_CTX_new method))

(defun ssl-new (ctx)
    (SSL_new ctx))

(defun ssl-set-fd (ssl fd)
    (SSL_set_fd ssl fd))

(defun ssl-ctx-set-mode (ctx fd)
    (SSL_CTX_set_mode ctx fd))

(defun ssl-get-error (ssl ret)
    (SSL_get_error ssl ret))

(defun err-get-error ()
    (ERR_get_error))

(defun ssl-connect (ssl)
    (SSL_connect ssl))

(defun ssl-accept (ssl)
    (SSL_accept ssl))

(defun ssl-write (ssl buf num)
    (SSL_write ssl buf num))

(defun ssl-read (ssl buf num)
    (SSL_read ssl buf num))

(defun ssl-pending (ssl)
    (SSL_pending ssl))

(defun ssl-shutdown (ssl)
    (SSL_shutdown ssl))

(defun ssl-free (ssl)
    (SSL_free ssl))

(defun ssl-ctx-free (ctx)
    (SSL_CTX_free ctx))

(defun rand-seed (buf num)
    (RAND_seed buf num))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; Certificate and Privatekey handling ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
#! (:export nil :library "ssleay32")
int	SSL_set_cipher_list(void *s, const char *str);
int	SSL_use_RSAPrivateKey_file(void *ssl, const char *file, int type);
int	SSL_CTX_use_RSAPrivateKey_file(void *ctx, const char *file, int type);
int	SSL_use_certificate_file(void *ssl, const char *file, int type);
int SSL_CTX_load_verify_locations(void *ctx, const char *CAfile, const char *CApath);
void SSL_set_client_CA_list(void *s, void *list);
void SSL_CTX_set_client_CA_list(void *ctx, void *list);
void *SSL_load_client_CA_file(const char *file);
!#

(defconstant +ssl-filetype-pem+ 1)
(defconstant +ssl-filetype-asn1+ 2)
(defconstant +ssl-filetype-default+ 3)

;; Set the set of available ciphers
(defun ssl-set-cipher-list (ssl str)
    (SSL_set_cipher_list ssl str))

;; SSL-USE-RSA-PRIVATEKEY-FILE
;; Load the RSA privatekey from the specified filename into the connection-handle
;; type is either +ssl-filetype-pem+ or +ssl-filetype-asn1+
(defun ssl-use-rsa-privatekey-file (ssl str type)
    (SSL_use_RSAPrivateKey_file ssl str type))

;; SSL-CTX-USE-RSA-PRIVATEKEY-FILE
;; Load the RSA privatekey from the specified filename into the CTX
;; type is either +ssl-filetype-pem+ or +ssl-filetype-asn1+
(defun ssl-ctx-use-rsa-privatekey-file (ctx str type)
    (SSL_CTX_use_RSAPrivateKey_file ctx str type))

;; SSL-USE-CERTIFICATE-FILE
;; Load the certificate from the specified filename into the connection-handle
;; type is either +ssl-filetype-pem+ or +ssl-filetype-asn1+
(defun ssl-use-certificate-file (ssl str type)
    (SSL_use_certificate_file ssl str type))

;; SSL-CTX-LOAD-VERIFY-LOCATIONS
;; Set the location where further CA certificates can be found to the specified
;; directory and/or file
(defun ssl-ctx-load-verify-locations (ctx CAfile CApath)
    (SSL_CTX_load_verify_locations ctx CAfile CApath))

                            
;; SSL-CTX-SET-CLIENT-CA-LIST
;; Set the CTX' list of CAs that are acceptable from the client
(defun ssl-ctx-set-client-ca-list (ctx list)
    (SSL_CTX_set_client_CA_list ctx list))

;; SSL-SET-CLIENT-CA-LIST
;; Set the connection-handle's list of CAs that are acceptable from the client
(defun ssl-set-client-ca-list (ssl list)
    (SSL_set_client_CA_list ssl list))

;; SSL-LOAD-CLIENT-CA-FILE
;; Load and return a list of CAs from the specified file
(defun ssl-load-client-ca-file (file)
    (SSL_load_client_CA_file file))

;;;;;;;;;;;;;;;;;;;;
;;; Byte Vectors ;;;
;;;;;;;;;;;;;;;;;;;;

(defun make-byte-vector (size)
    (malloc size))

(defun free-byte-vector (vector)
  (free vector))

(defmacro bvref (buffer i)
  `(cref (:unsigned-char *) ,buffer ,i))