/* window.h							-*- C++ -*-
     $Id: window.h,v 1.11 2001/11/27 23:57:36 elf Exp $

   written by Marc Singer
   19 September 1996

   This file is part of the project CurVeS.  See the file README for
   more information.

   Copyright (C) 1996 Marc Singer

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   with your Debian GNU/Linux system, in
   /usr/share/common-licenses/GPL, or with the Debian GNU/Linux hello
   source package as the file COPYING. If not, write to the Free
   Software Foundation, Inc., 59 Temple Place -Suite 330, MA
   02111-1307, USA.

   -----------
   DESCRIPTION
   -----------

   Header for screen/window class.


*/

#if !defined (_WINDOW_H_)
#    define   _WINDOW_H_

#if defined (HAVE_NCURSES_CURSES_H)
# include <ncurses/curses.h>
#else
# if defined (HAVE_NCURSES_H)
#  include <ncurses.h>
# else
#  if defined (HAVE_CURSES_H)
#   include <curses.h>
#  else
#  endif
			// This is fatal, but what are we to do?
# endif
#endif

#include "mouse.h"

				// Eliminate foolish macros
#undef refresh
#undef border
#undef vline
#undef getch
#undef getstr
#undef scroll
#undef erase
#undef clear

typedef enum {
  colorNul = 0,
  colorBlack,
  colorRed,
  colorGreen,
  colorYellow,
  colorBlue,
  colorMagenta,
  colorCyan,
  colorWhite,
  colorDefault,
} eColor;

class LWindow {
protected:
  WINDOW* m_pWindow;
  LWindow* m_pWindowParent;

  bool is (void) {
    return m_pWindow != NULL; }

public:
  LWindow (WINDOW* pWindow) {
    zero (); init (pWindow); }
  ~LWindow () {
    release_this (); }
  void zero (void) {
    memset (this, 0, sizeof (*this)); }
  void init (WINDOW* pWindow);
  void release_this (void);

  int dx (void) {
    int x, y;
    return is () ? (getmaxyx (m_pWindow, y, x), x) : -1; }
  int dy (void) {
    int x, y;
    return is () ? (getmaxyx (m_pWindow, y, x), y) : -1; }

  void attribute (int attr, bool fEnable) {
    if (fEnable)
      wattron (m_pWindow, attr); 
    else
      wattroff (m_pWindow, attr); }
  void border (void) {
    box (m_pWindow, 0, 0);
    touch (); }
  void clear (void) {
    wclear (m_pWindow); }
  LWindow* create_child (int x, int y, int dx, int dy);
  void defrefresh (void) {
    wnoutrefresh (m_pWindow); }
  void erase (void) {
    //    wclear (m_pWindow);
    werase (m_pWindow);
  }
  int getch (int x, int y) {
#if defined (USE_GPM_MOUSE)
    wmove (m_pWindow, y, x);
    wrefresh (m_pWindow);	// Force the cursor to appear in the window
    return Gpm_Wgetch (m_pWindow);
#else
    return mvwgetch (m_pWindow, y, x); 
#endif
  }
  int getch (void) {
#if defined (USE_GPM_MOUSE)
    wrefresh (m_pWindow);	// Force the cursor to appear in the window
    return Gpm_Wgetch (m_pWindow);
#else
    return wgetch (m_pWindow);
#endif
  }
  int getstr (int x, int y, char* sz, int cch);
  int getstr (int x, int y, char* szPrompt, 
	      char* szResponse, int cchResponseMax, const char* szDefault);
  void moveto (int x, int y) {
    wmove (m_pWindow, y, x); wsyncup (m_pWindow); }
  void on (int attribute) {
    wattron (m_pWindow, attribute); }
  void off (int attribute) {
    wattroff (m_pWindow, attribute); }
  void printfxy (int x, int y, const char* szFormat, ...);
  void redraw (void) {
    redrawwin (m_pWindow); }
  void refresh (void) {
    wrefresh (m_pWindow); }
  void scroll (int dy) {
    wscrl (m_pWindow, dy); }
  void touch (int y);
  void touch (void) {
    if (m_pWindowParent)
      m_pWindowParent->touch ();
    else
      touchwin (m_pWindow); }
  void vline (int x, int yTop, int yBottom) {
    moveto (x, yTop);
    wvline (m_pWindow, 0, yBottom - yTop + 1); 
    touch (); }
};


class LScreen {
protected:
  LWindow* m_pWindowRoot;

  bool is (void) {
    return m_pWindowRoot != NULL; }
  
  int _color_of (int color);

public:
  LScreen () {
    zero (); init (); }
  ~LScreen () {
    release_this (); }
  void zero (void) {
    memset (this, 0, sizeof (*this)); }
  void init (void);
  void release_this (void);
  
  int dx (void) {
    return is () ? m_pWindowRoot->dx (): -1; }
  int dy (void) {
    return is () ? m_pWindowRoot->dy (): -1; }
  LWindow* root (void) {
    return m_pWindowRoot; }

  static int string_dx (const char* sz, int cb = -1) {
    int cch = strlen (sz);
    if (cb == -1)
      return cch;
    return (cch < cb) ? cch : cb; }
  static int string_dy (const char* sz, int cb = -1) {
    int cch = strlen (sz);
    if (cb == -1)
      return cch ? 1 : 0;
    return (cch || cb) ? 1 : 0; }

  void define_color (int iColor, int colorFore, int colorBack) {
    init_pair (iColor, _color_of (colorFore), _color_of (colorBack)); }
  void update (void) {
    doupdate (); }

};

#endif /* _WINDOW_H_ */
