DACS_SELECT_CREDENTI(8)    DACS Web Services Manual    DACS_SELECT_CREDENTI(8)



[1mNAME[0m
       dacs_select_credentials - temporarily disable [1mDACS [22mcredentials

[1mSYNOPSIS[0m
       [1mdacs_select_credentials [22m[[34m[1mdacsoptions[0m[1m[22m[1]]

[1mDESCRIPTION[0m
       This program is part of the [1mDACS [22msuite.

       A user may concurrently possess more than one set of [1mDACS [22mcredentials
       during a session, with each representing a different identity. Zero or
       more credentials may be submitted with a request for a [1mDACS[22m-wrapped web
       service. It is sometimes desirable or necessary for a user to switch
       between identities, or to be considered unauthenticated. Middleware
       (software situated between a user agent and a [1mDACS[22m-capable web server)
       and more sophisticated user agents might provide this functionality
       simply by sending some [1mDACS [22mHTTP cookies and not sending others, under
       user control. With standard browsers or in other situations where this
       functionality is not available, achieving this by repeatedly
       authenticating and signing off (or by manually deleting cookies) would
       be inconvenient at best.

       The [1mdacs_select_credentials [22mweb service can be used to temporarily
       disable credentials, leaving the remaining credentials selected for
       access control purposes. The user agent continues to send all [1mDACS [22mHTTP
       cookies as usual, but [34m[1mdacs_acs(8)[0m[1m[22m[2] will ignore disabled identities
       before deciding to grant or deny access. This feature can be used to
       work around the maximum number of identities that [1mDACS [22mallows to be
       associated with a request - determined by the [34m[1mACS_CREDENTIALS_LIMIT[0m[1m[22m[3]
       directive - or for administrative, testing, or other reasons. There are
       similarities between [1mdacs_select_credentials [22mand [34m[1msu(1)[0m[1m[22m[4].

       A selected identity is handled normally, but a disabled identity is
       "hidden"; it is not considered for access control purposes and is not
       reported by [34m[1mdacs_current_credentials(8)[0m[1m[22m[5]. A disabled identity may be
       re-enabled by [1mdacs_select_credentials[22m, however, and [34m[1mdacs_signout(8)[0m[1m[22m[6]
       will work with disabled identities. All identities are considered for
       the purposes of revoking access, however, and in other situations
       described below.

       The selected credentials are identified by a cryptographically
       protected cookie that is issued by [1mdacs_select_credentials[22m. The HTTP
       cookie name has the following format:

           DACS:[4mFederation-Name[24m:::SELECTED

       where [4mFederation-Name[24m is the official name assigned to the federation
       for which the cookie is valid. This cookie confers no identity or
       access control rights to its possessor. If this cookie is deleted, or
       just not sent with a request, all credentials accompanying the request
       are used for access control. If [34m[1mdacs_signout(8)[0m[1m[22m[6] asks the browser to
       delete all credentials (i.e., no more credentials exist that
       [1mdacs_signout [22mis aware of), it will also ask the browser to delete the
       selected credentials cookie.

       The [4mFORMAT[24m argument (see [34m[1mdacs(1)[0m[1m[22m[7]) determines the type of output,
       with the default being HTML, using the style sheet
       [34m[1mdacs_select_credentials.css[0m[1m[22m[8]. If XML output is selected, a document
       conforming to [34m[1mdacs_select_credentials.dtd[0m[1m[22m[9] is returned.

[1mOPTIONS[0m
   [1mWeb Service Arguments[0m
       [1mdacs_select_credentials [22maccepts the following arguments in addition to
       the [34m[1mstandard CGI arguments[0m[1m[22m[10].

       [4mOPERATION[0m
           This parameter is required and must be one of (case-insensitively):

           SELECT
               This operation replaces the current set of selected
               credentials, if any, with the set that match the [4mDACS_USERNAME[0m
               and [4mDACS_JURISDICTION[24m arguments. It is an error if no
               credentials match the arguments.

           DESELECT
               This operation disables the specified enabled credentials. If
               no credentials remain selected, the user is effectively
               unauthenticated as if by the [4mSELECT_UNAUTH[24m operation.
               Non-matching arguments are ignored.

           ADD
               The [4mADD[24m operation adds the specified disabled credentials to
               the set of enabled credentials.

           LIST
               This operation lists the selection status.

           CLEAR
               This operation results in no selection, with all credentials
               available again.

           SELECT_UNAUTH
               This operation makes the user effectively unauthenticated; all
               credentials are disabled.

           DESELECT_UNAUTH
               This operation reverses [4mSELECT_UNAUTH[24m, resulting in there being
               no selection and all credentials are again available. It is an
               error if the user is not effectively unauthenticated when the
               operation is invoked.


       [4mDACS_USERNAME[0m
           This argument specifies a username to match against existing
           credentials for the SELECT, DESELECT, and ADD operations. Exact
           string matching is used. If this argument is absent, all usernames
           will be selected.

       [4mDACS_JURISDICTION[0m
           This argument specifies a jurisdiction name to match against
           existing credentials for the SELECT, DESELECT, and ADD operations.
           Exact string matching is used. If this argument is absent, all
           jurisdictions will be selected.

       [4mCOOKIE_SYNTAX[0m
           This parameter has the same semantics as with the
           [34m[1mdacs_authenticate(8)[0m[1m[22m[11] service.

           [1mTip[0m
           The [34m[1mdacs_authenticate(8)[0m[1m[22m[12] web service takes an optional
           argument, [4mOPERATION[24m, that can have the value SELECT. If
           authentication succeeds and this argument is present, the resulting
           credentials are selected as described above.

[1mFILES[0m
       [34m[1mdacs_select_credentials.css[0m[1m[22m[8]

[1mDIAGNOSTICS[0m
       The program exits 0 if everything was fine, 1 if an error occurred.

[1mBUGS[0m
       It might be useful to be able to temporarily suppress one or more
       specific roles of a given identity.

[1mAUTHOR[0m
       Distributed Systems Software ([34m[1mwww.dss.ca[0m[1m[22m[13])

[1mCOPYING[0m
       Copyright (C) 2003-2012 Distributed Systems Software. See the
       [34m[1mLICENSE[0m[1m[22m[14] file that accompanies the distribution for licensing
       information.

[1mNOTES[0m
        1. dacsoptions
           http://dacs.dss.ca/man/dacs.1.html#dacsoptions

        2. dacs_acs(8)
           http://dacs.dss.ca/man/dacs_acs.8.html

        3. ACS_CREDENTIALS_LIMIT
           http://dacs.dss.ca/man/dacs.conf.5.html#ACS_CREDENTIALS_LIMIT

        4. su(1)
           http://www.freebsd.org/cgi/man.cgi?query=su&apropos=0&sektion=1&manpath=FreeBSD+9.0-RELEASE&format=html

        5. dacs_current_credentials(8)
           http://dacs.dss.ca/man/dacs_current_credentials.8.html

        6. dacs_signout(8)
           http://dacs.dss.ca/man/dacs_signout.8.html

        7. dacs(1)
           http://dacs.dss.ca/man/dacs.1.html

        8. dacs_select_credentials.css
           http://dacs.dss.ca/man//css/dacs_select_credentials.css

        9. dacs_select_credentials.dtd
           http://dacs.dss.ca/man/../dtd-xsd/dacs_select_credentials.dtd

       10. standard CGI arguments
           http://dacs.dss.ca/man/dacs.services.8.html#standard_cgi_args

       11. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html#COOKIE_SYNTAX

       12. dacs_authenticate(8)
           http://dacs.dss.ca/man/dacs_authenticate.8.html

       13. www.dss.ca
           http://www.dss.ca

       14. LICENSE
           http://dacs.dss.ca/man/../misc/LICENSE



DACS 1.4.27b                      03/19/2012           DACS_SELECT_CREDENTI(8)
