% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBObject.R, R/DBResult.R
\name{dbGetInfo}
\alias{dbGetInfo}
\title{Get DBMS metadata}
\usage{
dbGetInfo(dbObj, ...)
}
\arguments{
\item{dbObj}{An object inheriting from \linkS4class{DBIObject},
i.e. \linkS4class{DBIDriver}, \linkS4class{DBIConnection},
or a \linkS4class{DBIResult}}

\item{...}{Other arguments to methods.}
}
\value{
a named list
}
\description{
Get DBMS metadata
}
\section{Implementation notes}{

For \code{DBIDriver} subclasses, this should include the version of the
package (\code{driver.version}) and the version of the underlying client
library (\code{client.version}).

For \code{DBIConnection} objects this should report the version of
the DBMS engine (\code{db.version}), database name (\code{dbname}),
username, (\code{username}), host (\code{host}), port (\code{port}), etc.
It MAY also include any other arguments related to the connection
(e.g., thread id, socket or TCP connection type). It MUST NOT include the
password.

For \code{DBIResult} objects, this should include the statement
being executed (\code{statement}), how many rows have been fetched so far
(in the case of queries, \code{row.count}), how many rows were affected
(deleted, inserted, changed,
(\code{rows.affected}), and if the query is complete (\code{has.completed}).


The default implementation for \code{DBIResult objects}
constructs such a list from the return values of the corresponding methods,
\code{\link[=dbGetStatement]{dbGetStatement()}}, \code{\link[=dbGetRowCount]{dbGetRowCount()}},
\code{\link[=dbGetRowsAffected]{dbGetRowsAffected()}}, and \code{\link[=dbHasCompleted]{dbHasCompleted()}}.
}

\seealso{
Other DBIDriver generics: \code{\link{DBIDriver-class}},
  \code{\link{dbCanConnect}}, \code{\link{dbConnect}},
  \code{\link{dbDataType}}, \code{\link{dbDriver}},
  \code{\link{dbIsReadOnly}}, \code{\link{dbIsValid}},
  \code{\link{dbListConnections}}

Other DBIConnection generics: \code{\link{DBIConnection-class}},
  \code{\link{dbAppendTable}}, \code{\link{dbCreateTable}},
  \code{\link{dbDataType}}, \code{\link{dbDisconnect}},
  \code{\link{dbExecute}}, \code{\link{dbExistsTable}},
  \code{\link{dbGetException}}, \code{\link{dbGetQuery}},
  \code{\link{dbIsReadOnly}}, \code{\link{dbIsValid}},
  \code{\link{dbListFields}}, \code{\link{dbListObjects}},
  \code{\link{dbListResults}}, \code{\link{dbListTables}},
  \code{\link{dbReadTable}}, \code{\link{dbRemoveTable}},
  \code{\link{dbSendQuery}}, \code{\link{dbSendStatement}},
  \code{\link{dbWriteTable}}

Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{dbBind}}, \code{\link{dbClearResult}},
  \code{\link{dbColumnInfo}}, \code{\link{dbFetch}},
  \code{\link{dbGetRowCount}},
  \code{\link{dbGetRowsAffected}},
  \code{\link{dbGetStatement}},
  \code{\link{dbHasCompleted}}, \code{\link{dbIsReadOnly}},
  \code{\link{dbIsValid}}, \code{\link{dbQuoteIdentifier}},
  \code{\link{dbQuoteLiteral}},
  \code{\link{dbQuoteString}},
  \code{\link{dbUnquoteIdentifier}}
}
\concept{DBIConnection generics}
\concept{DBIDriver generics}
\concept{DBIResult generics}
