#ifndef __GTS_H__
#define __GTS_H__

#include <sys/param.h>

#define GTS_NICK_SIZE 64
#define GTS_CMD 4096
#define DELAY_BETWEEN_GTS 5

typedef struct
{
	unsigned char slot_status;			/* if ==0, the slot is empty */
												/* if ==1, the slot is busy */
	unsigned long id;						/* it is an id */
	char nick[GTS_NICK_SIZE];			/* user nickname to download from */
	char cmd[GTS_CMD];					/* command to launch */
	time_t next_try;						/* date to reach before retrying */
} GTS_ENTRY;

/******************************/
/* perform GTS initialisation */
/******************************/
void init_gts(void);

/***********/
/* end GTS */
/***********/
void exit_gts(void);

/********************************************************/
/* the following function adds an entry to the GTS file */
/**********************************************************************************************************************/
/* the following cases can appear:                                                                                    */
/* no entry having the same (nick/filename/dlpath) exists and it is created.                                          */
/* an entry having the same (nick/filename/dlpath) exists, nothing is done (we don't add anything else).              */
/**********************************************************************************************************************/
/* output: 0= ok    */
/*         1= error */
/********************/
int add_gts_entry(const char *nickname, const char *cmd, int delay);

/***********************************************************/
/* the following function removes an entry to the GTS file */
/***********************************************************/
void delete_gts_entry(const char *nickname, const char *cmd);

/********************************************************************/
/* the following function removes an entry to the GTS file using ID */
/********************************************************************/
void delete_gts_entry_by_id(unsigned long id);

/***************************************************************************/
/* this function scans the GTS files and looks if there is something to do */
/*******************************************************************************/
/* this function must be called regularly when the connection to the hub works */
/*******************************************************************************/
/* input: user_list containing the list of all users of the hub */
/****************************************************************/
void gts_action(GPtrArray *user_list);

/*******************************************************************************/
/* this function acts in the same way that gts_action except the chosen action */
/* belongs to the given nick and is a download (/DL or /LS)                    */
/*******************************************************************************/
/* output: NULL=nothing found else it is the commandline of the action to do */
/*****************************************************************************/
GString *gts_retrieve_download(char *nick);

/*****************************************/
/* output GTS content into CMD_KB format */
/*****************************************/
void list_gts_content(void);

#endif
