/* DCTC - a Direct Connect text clone for Linux
 * Copyright (C) 2001 Eric Prevoteau
 *
 * unode.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: unode.h,v 1.4 2003/12/28 08:12:38 uid68112 Exp $
*/

#ifndef __UNODE_H__
#define __UNODE_H__

/* --- unode information --- */

#include <netinet/in.h>

/* this structure describes one entry of unode database */
typedef struct
{
	char host_unresolved_addr[128];	/* unresolved hostname:port of this entry */
   time_t resolv_creation_date;     /* each resolved named has a date of solving allowing dynamic host IP to be refreshed */
   struct sockaddr_in dest_addr;    /* it is a ready to use address, including port and addresse type */
   unsigned char entry_enabled;     /* ==0, this entry is disabled, ==1, entry enabled */
   unsigned char dynamic_ip;        /* ==0, this entry is a static hostname/hostip association, ==1, the ip of this host is dynamic */
   char comment[93];                /* a comment (C-string format) */
} UNODE_DATA;

#define MAX_IP_VALIDITY (15*60)     /* 15 minutes */

#define UNODE_MIN_RESEND_DELAY 45	/* min 45 secondes between sending the same string to UNODE */
 
#endif
