;;; skk-tankan.el --- SKK $BC14A;zJQ49%W%m%0%i%`(B -*- coding: iso-2022-jp -*-
;; Copyright (C) 2003 YAGI Tatsuya <ynyaaa@ybb.ne.jp>
;; Copyright (C) 2010 Tsuyoshi Kitamoto <tsuyoshi.kitamoto@gmail.com>

;; Author: YAGI Tatsuya <ynyaaa@ybb.ne.jp>
;; Author: Tsuyoshi Kitamoto <tsuyoshi.kitamoto@gmail.com>
;; Maintainer: SKK Development Team <skk@ring.gr.jp>
;; Version: $Id: skk-tankan.el,v 1.54 2011/12/05 12:21:11 skk-cvs Exp $
;; Keywords: japanese
;; Last Modified: $Date: 2011/12/05 12:21:11 $

;; This file is part of Daredevil SKK.

;; Daredevil SKK is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation; either version 2, or
;; (at your option) any later version.

;; Daredevil SKK is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with Daredevil SKK, see the file COPYING.  If not, write to
;; the Free Software Foundation Inc., 51 Franklin Street, Fifth Floor,
;; Boston, MA 02110-1301, USA.

;;; Commentary:

;; 1. $B;H$$J}(B
;;
;; 1-a. $BFI$_$N:G8e$K!"FI$_$N0lIt$H$7$F(B @ $B$rF~NO$7$F$+$iJQ49$9$k$H!"(B
;;      $B0lJ8;z$N$_$+$i$J$k8uJd$K9J$j9~$s$@>e$G!"(B
;;      $B8uJd$rAm2h?t=g$G%=!<%H$7$F$+$iJQ49$7$^$9!#(B
;;
;; 1-b. $B!VFI$_!WItJ,$,?tCM$G$"$l$P!"$=$N?tCM$rAm2h?t$H$9$k8uJd$rI=<($7$^$9!#(B
;;        $B"&(B12@<SPC> [Q 1 2 @ <SPC>]
;;  
;; 1-c. $B!VFI$_!WItJ,$,(B @ $B$G$"$l$P!"It<sJQ49$r3+;O$7$^$9!#(B
;;        $B"&(B@@<SPC> [Q @ @ <SPC>]
;;
;; 2. $B@_DjJ}K!(B
;;
;; ~/.skk $B$K$O<!$NMM$J$3$H$r=q$$$F$*$-$^$9!#(B
;;
;; ;; $B8!:w@h$N;XDj$O(B
;; ;; skk-search-prog-list $B$K;XDj$G$-$kMWAG(B (function . args) $B$KBP$7$F(B
;; ;; (skk-tankan-search 'function . args) $B$r;XDj$9$k(B
;; ;; $B$[$+$N(B skk-search-prog-list $B$rJQ99$9$k@_Dj$h$j8e$K@_Dj$9$Y$-$G$9!#(B
;;
;; ;; $B3NDjJQ49$rMQ$$$J$$>l9g$O!"0J2<$N$h$&$K(B skk-search-prog-list $B$N@hF,$K(B
;; ;; $BDI2C$7$F$b9=$$$^$;$s!#(B
;; (add-to-list 'skk-search-prog-list
;;              '(skk-tankan-search 'skk-search-jisyo-file
;;                                  skk-large-jisyo 10000))
;;
;; ;; $B$7$+$7!"3NDjJQ49$rJ;MQ$9$k>l9g$O!"(B skk-search-kakutei-jisyo-file
;; ;; $B$^$?$OBe$o$j$N3NDj%W%m%0%i%`$,(B skk-search-prog-list $B$N@hF,$K(B
;; ;; $B$J$1$l$P$$$1$^$;$s!#$=$N>l9g$OBe$o$j$K0J2<$N@_Dj$r$7$^$9!#(B
;; (setq skk-search-prog-list
;;       (cons (car skk-search-prog-list)
;;	       (cons '(skk-tankan-search 'skk-search-jisyo-file
;;				         skk-large-jisyo 10000)
;;		     (cdr skk-search-prog-list))))
;;
;; ;; $BC14A;z8!:w$N%-!<$r(B @ $B$K$9$k(B($B%G%U%)%k%H(B)
;; (setq skk-tankan-search-key ?@)
;;
;; ;; ;; @ $B$rF~NO$G$-$k$h$&$K$9$k(B          ; DDSKK 14.2 $B$+$i$OITMW$G$9!#(B
;; ;; (setq skk-rom-kana-rule-list         ; $B%a!<%j%s%0%j%9%H(B 2010-11-27
;; ;;       (append skk-rom-kana-rule-list ; 
;; ;;	         '(("@" nil "@"))))        ;
;;
;; ;; annotation $B$H$7$F2h?t$HIt<s$rI=<($9$k(B
;; (setq skk-show-annotation t)
;;
;; ;; $BC14A;zF~NO$O3X=,BP>]$+$i$O$:$9(B
;; (add-hook 'skk-search-excluding-word-pattern-function
;;	  #'(lambda (kakutei-word)
;;	      (string-match (format "%s$"
;;				    (regexp-quote
;;				     (char-to-string skk-tankan-search-key)))
;;			    skk-henkan-key)))
;;
;; ;; $BJ8;z(B CHAR $B$N(B ANNOTATION ($BJ8;zNs(B)$B$rJQ99$7$?$$>l9g(B
;; ;; (skk-tankan-set-char-annotation CHAR ANNOTATION)
;;
;; ;; $B%a%b%j$r@aLs$7$?$$?M8~$1(B($BIt<s$H2h?t0J30$N%G!<%?$rJ];}$7$^$;$s(B)
;; ;; (setq skk-tankan-annotation-table nil)

;;; Code:

(eval-when-compile
  (require 'skk-macs)
  (require 'skk-vars)
;;  (require 'skk-kcode)
  )

;;; $BIt<sHV9f$rIt<s$rI=$9J8;zNs$KJQ49$9$k$?$a$NG[Ns(B
(defconst skk-tankan-radical-vector
  (let ((v (string-to-vector "\
$B".(B\
$B0l!CP&P(25P-(B\
$BFsP5?MQ9F~H,QDQLQRQ\QaEaNOR1R8R9R>==KNRGRLRSKt(B\
$B8}SxEZ;NTiTjM<Bg=w;RU_@#>.UwUyV%;3V_9)8J6R43VvVxW.W0W55]W@WDWF(B\
$B?4Xy8M<j;YZ=J8EM6TJ}Z\F|[)7nLZ7g;_]F]U]YHfLS;a]c?e2PD^Ic`+`-JR2g5m8$(B\
$B8<6L1;4$4E@8MQEDI%IBb"GrHi;.L\L7Lp@P<(c<2S7jN)(B\
$BC]JF;e4Lf&MS1)O7<)fP<*ffFy?C<+;j11@eA$=.:1?'ggiHCn7l9T0ak((B\
$B8+3Q8@C+F&l5l83-@VAvB-?H<V?IC$?JM8FSHPN$(B\
$B6bD9LgIlp0p21+@DHsLL(B\
$B3Wpjpl2;JGIwHt?)<s9a(B\
$BGO9|9bqur(r.r/(B\
$B545{D;sC</sNKc(B\
$B2+5P9usc(B\
$BsfE$8]AM(B\
$BI!sn(B\
$Bso(B\
$BN6s}(B\
$Bs~(B\
"))
	(i 0))
    (while (< i (length v))
      (aset v i (char-to-string (aref v i)))
      (setq i (1+ i)))
    ;; modify char if japanese-jisx0213-1 is available
    (when (charsetp 'japanese-jisx0213-1)
      (dolist (cell '((002 14 4)
		      (104 88 44)
		      (114 89 36)
		      (162 92 51)
		      (201 94 81)
		      (203 94 82)))
	(aset v (car cell)
	      (char-to-string
	       (make-char 'japanese-jisx0213-1
			  (+ 32 (nth 1 cell)) (+ 32 (nth 2 cell)))))))
    v))

;;; $BIt<s$KBP1~$9$kItJ,$N2h?t$rI=$9G[Ns(B
(defconst skk-tankan-stroke-for-radical-vector
  [0 1 1 1 1 1 1
     2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2 2
     3 3 3 3 3 3 3 3 3 3 3 3 3 (3 3 4) 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3 3
     (4 4 4 3) 4 4 (3 4 4 3) 4 4 4 4 4 4 (4 5) 4 4 4 4 4 4
     (4 4 5) 4 4 4 4 4 4 (4 5 3 3) 4 4 4 4 (3 4) 4 (5 4) 4 (4 4 3)
     5 (5 4 4) 6 5 5 5 5 5 5 5 5 5 5 5 5 5 5 5 (5 5 5 4) (4 5) 5 5 5
     6 6 6 6 (4 5 5 6) 6 6 (4 6) 6 6 6 (5 6) (6 4 4 4)
     6 6 6 (6 7) 6 (6 7) 6 6 6 (6 4 3 3) 6 6 6 6 (4 6 6 5) 6
     7 7 7 7 7 7 7 7 7 (6 7) 7 7 7 7 7 (7 3 4) (7 3) 7 7 7
     8 (8 7) 8 (8 3 3) 8 8 8 8 8
     9 9 10 9 9 9 9 9 (9 9 8 9) 9 9
     10 10 10 10 10 10 10 10
     11 (7 11 11 11) 11 (9 11 11 11) (7 11) 11
     (11 12) 12 (11 12 12) 12 13 13 13 (8 13 13)
     14 14 (12 12 15 15) (10 16) (11 16) 17])

(defconst skk-tankan-radical-name
  ;; $BFI$_$O(B http://ja.wiktionary.org/wiki/Wiktionary:$B4A;z:w0z(B $BIt<s(B
  ;; $B$+$i0zMQ$7$?!#(B
  ["$B".(B"
   "$B$$$A(B"				;1
   "$B$\$&!"$?$F$\$&(B"			;2
   "$B$F$s(B"				;3
   "$B$N(B"					;4
   "$B$*$D(B"				;5
   "$B$O$M$\$&(B"				;6
   "$B$K(B"					;7
   "$B$J$Y$V$?(B"				;8
   "$B$R$H!"$R$H$,$7$i(B"			;9
   "$B$K$s$K$g$&!"$R$H$"$7(B"		;10
   "$B$$$k!"$$$j$,$7$i!"$$$j$d$M(B"		;11
   "$B$O$A!"$O$A$,$7$i(B"			;12
   "$B$1$$$,$^$(!"$^$-$,$^$(!"$I$&$,$^$((B"	;13
   "$B$o$+$s$`$j(B"				;14
   "$B$K$9$$(B"				;15
   "$B$D$/$(!"$D$/$($-$K$g$&!"$+$<$+$s$`$j(B" ;16
   "$B$+$s$K$g$&!"$&$1$P$3(B"		;17
   "$B$+$?$J(B"				;18
   "$B$A$+$i(B"				;19
   "$B$D$D$_$,$^$((B"			;20
   "$B$R!"$"$$$/$A(B"			;21
   "$B$O$3$,$^$((B"				;22
   "$B$+$/$7$,$^$((B"			;23
   "$B$8$e$&(B"				;24
   "$B$\$/!"$\$/$N$H(B"			;25
   "$B$U$7$E$/$j(B"				;26
   "$B$,$s$@$l(B"				;27
   "$B$`(B"					;28
   "$B$^$?(B"				;29
   "$B$/$A!"$/$A$X$s(B"			;30
   "$B$/$K$,$^$((B"				;31
   "$B$D$A!"$D$A$X$s(B"			;32
   "$B$5$`$i$$!"$5$`$i$$$+$s$`$j(B"		;33
   "$B$U$f$,$7$i!"$A$+$s$`$j(B"		;34
   "$B$9$$$K$g$&!"$J$D$N$"$7(B"		;35
   "$B$f$&!"$f$&$Y(B"			;36
   "$B$@$$!"$@$$$+$s$`$j!"$@$$$+$7$i(B"	;37
   "$B$*$s$J!"$*$s$J$X$s(B"			;38
   "$B$3!"$3$X$s(B"				;39
   "$B$&$+$s$`$j(B"				;40
   "$B$9$s(B"				;41
   "$B$7$g$&!"$7$g$&$,$7$i!"$J$*$,$7$i(B"	;42
   "$B$@$$$N$^$2$"$7(B"			;43
   "$B$7$+$P$M!"$7$+$P$M$+$s$`$j(B"		;44
   "$B$F$D!"$/$5$N$a(B"			;45
   "$B$d$^!"$d$^$X$s(B"			;46
   "$B$^$,$j$+$o(B"				;47
   "$B$3$&!"$?$/$_$X$s(B"			;48
   "$B$3!"$-!"$*$N$l!"$$!"$9$G$K!"$7!"$_(B"	;49
   "$B$O$P!"$O$P$X$s!"$-$s$Y$s(B"		;50
   "$B$+$s!"$$$A$8$e$&(B"			;51
   "$B$h$&!"$$$H$,$7$i(B"			;52
   "$B$^$@$l(B"				;53
   "$B$($s$K$g$&!"$$$s$K$g$&(B"		;54
   "$B$-$g$&!"$3$^$L$-(B"			;55
   "$B$h$/!"$7$-$,$^$((B"			;56
   "$B$f$_!"$f$_$X$s(B"			;57
   "$B$1$$$,$7$i(B"				;58
   "$B$5$s$E$/$j!"$1$+$6$j(B"		;59
   "$B$.$g$&$K$s$Y$s(B"			;60
   "$B$3$3$m(B"				;61
   "$B$[$3!"$[$3$E$/$j(B"			;62
   "$B$H!"$H$+$s$`$j(B"			;63
   "$B$F(B"					;64
   "$B$7$K$g$&!"$($@$K$g$&(B"		;65
   "$B$\$/$E$/$j!"$\$/$K$g$&!"$N$V$s(B"	;66
   "$B$V$s(B"				;67
   "$B$H!"$H$^$9(B"				;68
   "$B$*$N!"$*$N$E$/$j(B"			;69
   "$B$[$&!"$[$&$X$s!"$+$?$X$s(B"		;70
   "$B$J$7!"$`$K$g$&!"$9$G$N$D$/$j(B"	;71
   "$B$R!"$R$X$s!"$K$A$X$s(B"		;72
   "$B$R$i$S(B"				;73
   "$B$D$-!"$D$-$X$s(B"			;74
   "$B$-!"$-$X$s(B"				;75
   "$B$"$/$S(B"				;76
   "$B$H$a$k!"$H$a$X$s(B"			;77
   "$B$,$D$X$s!"$+$P$M$X$s(B"		;78
   "$B$[$3$E$/$j!"$k$^$?(B"			;79
   "$B$J$+$l!"$O$O(B"			;80
   "$B$J$i$S$R!"$/$i$Y$k(B"			;81
   "$B$1(B"					;82
   "$B$&$8(B"				;83
   "$B$-$,$^$((B"				;84
   "$B$_$:!"$7$?$_$:(B"			;85
   "$B$R!"$R$X$s(B"				;86
   "$B$D$a!"$=$&$K$g$&(B"			;87
   "$B$A$A(B"				;88
   "$B$3$&(B"				;89
   "$B$7$g$&!"$7$g$&$X$s(B"			;90
   "$B$+$?!"$+$?$X$s(B"			;91
   "$B$-$P!"$-$P$X$s(B"			;92
   "$B$&$7(B"				;93
   "$B$$$L(B"				;94
   "$B$2$s(B"				;95
   "$B$?$^(B"				;96
   "$B$&$j(B"				;97
   "$B$+$o$i(B"				;98
   "$B$"$^$$(B"				;99
   "$B$$$-$k!"$&$^$l$k(B"			;100
   "$B$b$A$$$k(B"				;101
   "$B$?!"$?$X$s(B"				;102
   "$B$R$-(B"				;103
   "$B$d$^$$$@$l(B"				;104
   "$B$O$D$,$7$i(B"				;105
   "$B$7$m(B"				;106
   "$B$1$,$o!"$R$N$+$o(B"			;107
   "$B$5$i(B"				;108
   "$B$a!"$a$X$s(B"				;109
   "$B$[$3!"$[$3$X$s(B"			;110
   "$B$d!"$d$X$s(B"				;111
   "$B$$$7!"$$$7$X$s(B"			;112
   "$B$7$a$9(B"				;113
   "$B$8$e$&$N$"$7(B"			;114
   "$B$N$.!"$N$.$X$s(B"			;115
   "$B$"$J!"$"$J$+$s$`$j(B"			;116
   "$B$?$D!"$?$D$X$s(B"			;117
   "$B$?$1!"$?$1$+$s$`$j(B"			;118
   "$B$3$a!"$3$a$X$s(B"			;119
   "$B$$$H(B"				;120
   "$B$[$H$.!"$[$H$.$X$s!"$U(B"		;121
   "$B$"$_$,$7$i(B"				;122
   "$B$R$D$8!"$R$D$8$X$s(B"			;123
   "$B$O$M(B"				;124
   "$B$*$$$+$s$`$j(B"			;125
   "$B$7$3$&$7$F(B"				;126
   "$B$i$$$9$-!"$i$$$X$s(B"			;127
   "$B$_$_!"$_$_$X$s(B"			;128
   "$B$$$D!"$U$G$E$/$j(B"			;129
   "$B$K$/(B"				;130
   "$B$7$s(B"				;131
   "$B$8!"$_$:$+$i(B"			;132
   "$B$$$?$k!"$$$?$k$X$s(B"			;133
   "$B$&$9(B"				;134
   "$B$7$?!"$7$?$X$s(B"			;135
   "$B$^$$$"$7(B"				;136
   "$B$U$M!"$U$M$X$s(B"			;137
   "$B$4$s!"$4$s$E$/$j!"$M$E$/$j!"$&$7$H$i(B" ;138
   "$B$$$m(B"				;139
   "$B$/$5!"$/$5$+$s$`$j(B"			;140
   "$B$H$i$+$s$`$j!"$H$i$,$7$i(B"		;141
   "$B$`$7!"$`$7$X$s(B"			;142
   "$B$A(B"					;143
   "$B$.$g$&$,$^$(!"$f$-$,$^$((B"		;144
   "$B$3$m$b(B"				;145
   "$B$K$7!"$*$*$$$+$s$`$j(B"		;146
   "$B$_$k(B"				;147
   "$B$D$N!"$D$N$X$s(B"			;148
   "$B$3$H$P!"$2$s!"$4$s$Y$s(B"		;149
   "$B$?$K!"$?$K$X$s(B"			;150
   "$B$^$a!"$^$a$X$s(B"			;151
   "$B$$$N$3!"$$$N$3$X$s!"$V$?(B"		;152
   "$B$`$8$J$X$s(B"				;153
   "$B$+$$!"$+$$$X$s!"$3$,$$(B"		;154
   "$B$"$+(B"				;155
   "$B$O$7$k!"$=$&$K$g$&(B"			;156
   "$B$"$7!"$"$7$X$s(B"			;157
   "$B$_!"$_$X$s(B"				;158
   "$B$/$k$^!"$/$k$^$X$s(B"			;159
   "$B$7$s!"$+$i$$(B"			;160
   "$B$7$s$N$?$D(B"				;161
   "$B$7$s$K$g$&!"$7$s$K$e$&(B"		;162
   "$B$`$i(B"				;163
   "$B$H$j$X$s!"$R$h$_$N$H$j!"$5$1$N$H$j(B"	;164
   "$B$N$4$a!"$N$4$a$X$s(B"			;165
   "$B$5$H!"$5$H$X$s(B"			;166
   "$B$+$M!"$+$M$X$s(B"			;167
   "$B$J$,$$(B"				;168
   "$B$b$s!"$b$s$,$^$(!"$+$I$,$^$((B"	;169
   "$B$*$+(B"				;170
   "$B$l$$$E$/$j(B"				;171
   "$B$U$k$H$j(B"				;172
   "$B$"$a!"$"$a$+$s$`$j(B"			;173
   "$B$"$*(B"				;174
   "$B$"$i$:(B"				;175
   "$B$a$s(B"				;176
   "$B$+$o$X$s!"$D$/$j$,$o(B"		;177
   "$B$J$a$7$,$o(B"				;178
   "$B$K$i(B"				;179
   "$B$*$H!"$*$H$X$s(B"			;180
   "$B$*$*$,$$(B"				;181
   "$B$+$<(B"				;182
   "$B$H$V(B"				;183
   "$B$7$g$/!"$7$g$/$X$s(B"			;184
   "$B$/$S(B"				;185
   "$B$+$*$j(B"				;186
   "$B$&$^!"$&$^$X$s(B"			;187
   "$B$[$M!"$[$M$X$s(B"			;188
   "$B$?$+$$(B"				;189
   "$B$+$_$+$s$`$j!"$+$_$,$7$i(B"		;190
   "$B$H$&$,$^$(!"$?$?$+$$$,$^$((B"		;191
   "$B$A$g$&!"$K$*$$$6$1(B"			;192
   "$B$+$J$((B"				;193
   "$B$*$K!"$-$K$g$&(B"			;194
   "$B$5$+$J!"$&$*$X$s(B"			;195
   "$B$H$j!"$H$j$X$s(B"			;196
   "$B$7$*(B"				;197
   "$B$7$+(B"				;198
   "$B$`$.!"$P$/$K$g$&(B"			;199
   "$B$"$5!"$"$5$+$s$`$j(B"			;200
   "$B$-(B"					;201
   "$B$-$S(B"				;202
   "$B$/$m(B"				;203
   "$B$L$$$H$j!"$U$D$X$s!"$A(B"		;204
   "$B$Y$s$"$7!"$+$($k!"$Y$s(B"		;205
   "$B$+$J$(!"$F$$(B"			;206
   "$B$D$E$_(B"				;207
   "$B$M$:$_!"$M$:$_$X$s(B"			;208
   "$B$O$J!"$O$J$X$s(B"			;209
   "$B$;$$(B"				;210
   "$B$O!"$O$X$s(B"				;211
   "$B$j$e$&(B"				;212
   "$B$+$a(B"				;213
   "$B$d$/!"$U$((B"				;214
   ]
  "$BIt<s$NFI$_(B")

;; ;; $B"-2?$+$K;H$($=$&$J(B alist
;; (let ((i 0)
;;       alist)
;;   (mapc #'(lambda (radical)
;; 	    (mapc #'(lambda (yomi)
;; 		      (setq alist (cons (cons radical yomi) alist)))
;; 		  (split-string (aref skk-tankan-radical-name i) "$B!"(B"))
;; 	    (setq i (1+ i)))
;; 	(append skk-tankan-radical-vector nil))
;;   alist)


;;; japanese-jisx0208, japanese-jisx0213-1 $BMQ$NIt<s!&2h?t%G!<%?(B
;; 1$BLL(B-14$B6h(B-01$BE@(B $B$+$i(B 2Byte $B$:$D;HMQ$7$F$$$k(B
;; 1st byte = radical number
;; 2nd byte = (sub radical index) << 6 | strokes in radical
(defconst skk-tankan-radical-stroke-table-0213-1 "\
\011\210\001\003\001\005\002\000\002\003\002\003\007\001\011\203\
\011\204\011\204\011\204\011\204\011\205\011\205\011\205\011\205\
\011\205\011\206\011\206\011\206\011\206\011\206\011\206\011\207\
\011\207\011\207\011\210\011\210\011\210\011\210\011\210\011\210\
\011\210\011\211\011\211\011\212\011\213\011\215\011\214\011\214\
\011\214\011\214\011\215\011\215\011\216\011\221\012\004\012\005\
\012\005\012\007\014\005\016\005\017\107\017\110\017\016\020\001\
\020\106\022\000\022\003\022\104\022\004\022\107\022\110\022\110\
\022\116\023\207\023\007\023\210\023\210\023\211\023\212\023\213\
\023\015\024\002\024\002\024\003\026\003\030\006\031\003\031\005\
\032\007\033\006\033\010\033\014\036\303\036\304\036\304\036\305\
\036\305\036\305\036\305\036\305\036\305\036\306\
\036\306\036\306\036\007\036\307\036\310\036\310\036\310\036\310\
\036\311\036\011\036\311\036\311\036\311\036\312\036\313\036\313\
\036\313\036\314\036\314\036\314\036\315\036\115\036\315\036\315\
\036\315\036\317\036\017\036\320\036\320\036\221\036\323\036\023\
\037\010\040\001\040\001\040\203\040\203\040\203\040\205\040\205\
\040\205\040\206\040\207\040\107\040\207\040\207\040\207\040\207\
\040\210\040\210\040\210\040\010\040\110\040\210\040\212\040\212\
\040\212\040\213\040\213\040\213\040\214\040\114\040\214\040\215\
\040\215\040\216\040\216\040\220\040\220\040\225\043\005\043\024\
\045\110\045\014\046\204\046\204\046\204\046\205\046\205\046\206\
\046\207\046\207\046\210\046\210\046\211\046\211\046\211\046\211\
\046\211\046\212\046\215\046\215\046\216\022\110\
\007\005\036\307\046\206\252\205\036\006\075\011\100\307\046\206\
\242\207\214\311\214\306\163\313\075\107\100\311\125\311\110\002\
\214\312\214\304\303\210\113\307\040\002\104\012\100\303\050\005\
\046\205\216\303\270\305\170\206\170\210\303\205\076\004\167\106\
\221\306\050\003\065\010\100\306\110\311\113\206\251\011\261\106\
\113\103\011\003\011\204\011\205\011\206\011\212\037\004\045\003\
\046\105\046\006\051\210\075\310\075\111\075\113\110\104\113\310\
\126\305\146\104\146\106\163\306\170\210\170\212\202\205\214\310\
\221\100\225\211\242\112\242\114\027\005\007\002\010\004\040\210\
\202\204\243\106\160\214\001\000\041\004\125\312\242\110\163\311\
\214\306\214\303\303\212\012\002\032\004\036\306\036\107\037\003\
\046\206\071\101\270\204\125\310\202\105\214\313\
\252\207\252\210\252\213\264\212\036\303\036\202\050\003\126\306\
\174\000\242\203\255\000\032\003\304\307\164\013\001\003\160\210\
\206\000\125\311\036\313\036\307\113\025\214\313\303\213\046\206\
\033\014\125\307\141\000\251\004\036\314\007\002\242\111\255\104\
\214\306\270\306\035\016\036\011\046\116\073\014\110\305\111\002\
\113\205\125\001\125\305\125\306\140\210\154\004\163\013\161\013\
\214\305\220\012\225\205\247\207\125\310\150\004\154\005\273\204\
\075\307\225\210\234\105\251\007\113\312\033\014\015\002\037\012\
\040\211\045\105\050\007\066\005\075\105\100\310\100\311\125\305\
\125\313\126\104\126\207\126\211\126\314\136\212\170\211\213\015\
\214\305\214\315\242\112\247\205\304\205\040\212\106\104\125\303\
\144\007\021\003\045\002\045\211\074\005\075\003\
\100\305\110\304\113\313\114\104\117\104\140\100\174\204\221\315\
\304\205\304\304\311\000\056\005\125\304\214\307\011\215\054\006\
\075\315\202\315\113\307\135\203\005\000\011\210\032\007\075\106\
\125\311\163\313\264\000\001\002\025\002\011\204\011\205\011\205\
\011\206\011\206\023\003\036\002\036\013\043\007\046\212\050\007\
\050\013\163\304\110\311\113\204\113\205\114\112\125\305\126\000\
\140\205\161\311\163\000\163\312\166\010\214\304\214\305\214\305\
\214\307\214\307\214\310\216\311\225\210\036\312\232\104\242\205\
\242\111\255\111\216\304\011\207\056\307\076\003\134\100\146\003\
\203\102\214\305\216\307\232\105\254\205\270\207\273\105\011\102\
\011\104\224\106\037\003\040\212\040\215\066\006\075\304\075\305\
\075\306\075\306\075\315\076\003\100\305\102\203\
\302\204\110\307\113\307\125\306\126\002\146\104\152\004\170\206\
\214\304\216\215\251\004\252\211\232\000\020\012\023\206\044\002\
\036\306\050\007\056\110\075\312\113\312\125\310\160\210\214\312\
\220\006\225\206\247\212\274\006\125\307\272\013\216\306\040\206\
\113\305\216\305\247\204\022\114\036\316\036\203\065\013\100\305\
\100\314\113\306\113\306\117\107\136\215\160\212\163\315\223\105\
\224\000\233\007\237\106\243\110\251\006\252\212\261\000\047\105\
\056\205\113\211\265\111\265\111\100\310\166\005\113\313\113\315\
\113\307\303\211\125\314\022\112\036\310\075\306\100\306\125\306\
\125\310\125\312\214\311\221\310\237\112\001\004\303\213\036\302\
\113\307\113\312\261\105\113\306\012\011\164\014\214\312\247\002\
\247\212\036\314\304\305\113\306\214\305\214\311\
\167\006\022\102\214\304\142\000\005\012\011\206\016\007\050\011\
\022\103\023\211\023\213\061\006\036\311\040\211\046\006\050\004\
\050\005\050\012\063\000\063\012\075\107\075\111\075\313\075\315\
\100\311\102\210\113\305\113\306\113\310\114\110\114\113\125\303\
\125\312\125\314\125\313\140\215\143\000\154\011\155\204\166\003\
\166\010\166\014\170\211\171\000\174\012\202\303\211\016\214\307\
\223\213\225\210\232\104\242\115\247\216\251\004\251\004\251\006\
\252\207\262\010\270\210\207\012\003\002\036\204\056\105\056\121\
\140\204\150\014\155\306\056\105\174\011\232\014\254\004\265\104\
\265\111\265\112\011\104\011\204\032\004\036\211\036\114\040\110\
\045\105\046\214\050\010\056\304\062\104\064\011\075\103\100\311\
\113\302\106\112\107\105\112\010\113\310\113\211\
\113\314\062\007\117\113\124\002\125\304\146\012\161\304\047\105\
\163\307\170\203\074\016\223\204\225\203\232\105\234\103\237\102\
\237\010\270\202\273\210\302\000\325\000\011\211\011\215\046\204\
\050\005\076\113\100\304\100\316\114\110\135\215\147\011\161\204\
\173\107\216\315\225\210\225\215\100\310\214\310\261\110\036\203\
\036\303\036\311\113\306\113\314\225\206\160\205\113\304\312\000\
\032\005\050\006\202\307\215\104\242\106\001\004\004\002\011\202\
\011\204\035\001\036\303\050\007\071\000\075\105\102\207\113\302\
\125\102\125\304\125\305\126\103\140\207\164\002\164\012\166\004\
\170\203\170\203\170\206\110\001\135\000\034\003\054\005\060\002\
\100\305\100\305\100\206\125\211\215\105\225\204\235\205\247\210\
\125\313\161\114\303\000\010\005\010\006\010\006\
\011\206\011\206\011\214\012\004\165\017\014\004\021\002\030\006\
\026\004\032\012\036\303\036\011\040\213\056\306\071\110\071\115\
\075\305\075\106\075\206\100\306\102\207\113\314\125\305\136\204\
\136\206\157\114\202\306\202\206\206\111\214\314\243\110\247\213\
\264\113\270\115\273\114\011\204\017\116\012\006\110\310\113\011\
\054\004\111\002\113\310\140\000\113\306\167\203\011\213\023\212\
\040\204\062\000\247\210\105\000\114\104\114\110\140\110\161\110\
\162\010\166\006\170\110\214\304\214\310\221\304\221\315\225\212\
\242\104\247\000\036\304\247\206\005\001\011\210\036\002\027\002\
\136\205\140\203\157\105\214\305\236\004\273\204\273\205\273\205\
\014\006\075\111\215\107\036\311\164\003\011\211\050\011\242\111\
\252\211\002\006\113\317\247\203\054\007\054\005\
\100\310\164\010\125\004\261\104\237\017\164\011\126\312\252\211\
\167\103\113\206\170\215\113\206\247\211\023\015\036\204\214\315\
\225\203\173\007\237\002\243\107\031\006\221\105\161\203\011\207\
\011\213\022\104\012\003\036\210\040\103\140\206\040\106\045\206\
\073\004\074\005\075\106\075\013\075\113\075\114\100\310\100\312\
\102\210\110\110\113\306\125\310\146\306\163\312\170\101\170\205\
\170\207\170\113\172\210\214\305\214\306\216\205\225\202\225\206\
\225\114\237\105\265\105\304\310\214\304\242\104\303\210\022\115\
\076\110\100\213\125\315\252\212\113\306\011\213\114\000\125\304\
\125\314\164\000\170\206\217\000\225\204\112\000\011\204\011\210\
\011\210\011\211\014\010\022\006\022\110\036\311\037\011\040\110\
\046\212\066\006\075\114\075\120\100\206\100\310\
\113\310\113\313\135\107\136\000\136\111\160\204\160\207\170\207\
\155\004\202\104\223\000\225\212\232\110\237\103\242\112\247\211\
\252\210\265\111\273\210\305\110\012\002\033\010\033\017\064\001\
\071\105\125\311\125\312\137\000\140\207\170\205\211\005\225\000\
\225\211\252\206\004\004\011\210\036\202\036\305\037\005\046\205\
\047\206\061\000\065\007\071\106\077\000\102\205\113\305\125\311\
\136\206\167\211\221\306\202\304\202\105\214\311\215\102\225\206\
\235\206\247\205\254\004\265\114\317\000\007\002\007\002\011\204\
\030\002\036\104\036\204\046\207\074\006\074\011\075\307\113\307\
\113\314\140\211\160\110\225\207\225\207\225\215\244\211\005\002\
\303\207\010\004\011\206\011\207\011\210\011\210\012\004\014\002\
\023\203\023\206\024\002\033\007\036\000\036\003\
\036\003\036\311\040\204\040\206\046\203\047\201\047\104\050\004\
\060\000\060\002\061\006\063\005\065\002\065\005\065\010\071\102\
\075\306\075\311\100\304\100\305\100\310\102\203\110\104\110\106\
\111\003\113\304\113\306\113\307\113\312\125\303\125\306\125\307\
\125\311\125\312\146\000\152\104\160\207\163\312\167\213\170\203\
\170\204\170\206\170\210\177\004\175\002\202\204\202\304\202\310\
\202\212\211\004\214\306\220\000\220\012\225\212\232\103\232\212\
\243\106\244\207\247\205\160\205\247\210\251\006\252\207\265\103\
\272\000\275\000\304\306\022\110\023\205\036\102\036\203\040\216\
\100\306\125\316\230\107\237\016\307\010\012\005\022\106\036\204\
\037\005\163\011\244\207\304\307\313\000\136\112\125\313\202\311\
\142\214\075\104\075\310\274\000\136\205\242\102\
\115\002\265\102\011\102\037\004\040\205\040\115\046\210\075\306\
\075\115\110\204\110\104\113\306\113\307\125\310\150\006\170\205\
\212\000\302\104\007\006\011\205\035\001\036\307\056\312\060\002\
\060\007\113\105\125\304\140\212\160\204\225\205\247\212\221\107\
\040\004\065\007\100\307\011\213\011\213\015\004\111\010\036\006\
\040\112\046\105\050\007\073\010\100\000\100\310\113\006\115\011\
\125\310\126\103\127\104\135\010\160\204\160\106\161\106\103\007\
\170\205\214\310\221\106\237\006\252\213\022\110\040\003\113\303\
\172\210\232\203\017\105\040\204\252\204\040\211\113\312\202\204\
\036\306\056\310\040\210\160\210\304\215\011\205\022\107\036\305\
\100\312\110\305\112\006\113\305\164\005\166\006\170\104\247\210\
\113\306\303\206\166\005\025\011\015\003\022\106\
\050\013\100\306\100\314\100\316\113\301\117\106\214\316\254\206\
\152\106\303\210\100\307\247\210\303\206\154\000\110\306\001\002\
\011\112\034\006\056\000\075\310\100\314\102\210\113\306\126\215\
\140\205\144\006\166\010\170\116\216\204\225\217\232\110\244\207\
\270\107\105\007\110\213\116\106\011\203\011\203\011\205\011\206\
\022\106\036\202\036\002\036\012\037\002\041\000\046\205\046\205\
\046\106\047\000\054\006\062\102\062\007\075\103\075\105\100\306\
\101\000\047\204\105\010\106\105\110\202\113\304\115\000\116\002\
\123\000\136\212\161\304\163\302\170\000\170\204\170\106\202\304\
\202\306\205\000\223\204\225\205\225\206\225\206\225\207\225\211\
\232\106\232\210\254\206\270\205\323\000\006\007\011\205\011\206\
\012\005\047\103\051\103\075\111\100\306\110\306\
\114\102\125\311\125\305\131\012\140\016\150\006\160\211\161\000\
\176\000\200\000\204\000\214\312\240\006\125\303\306\100\070\003\
\225\214\304\305\166\002\237\105\050\004\255\103\001\001\036\302\
\040\010\045\002\046\212\050\006\075\107\125\311\125\313\150\005\
\232\110\050\005\214\313\166\013\011\211\113\206\214\303\054\011\
\214\314\170\212\011\106\016\003\051\207\100\310\233\004\104\007\
\126\310\161\303\170\204\175\004\225\212\237\000\242\113\216\305\
\243\105\011\210\024\001\054\001\113\303\126\203\127\115\244\203\
\245\004\247\210\214\305\050\010\071\007\075\110\003\004\035\006\
\050\003\100\100\113\002\116\106\136\206\140\206\163\311\202\311\
\234\110\244\003\271\000\011\216\035\006\036\305\051\104\100\310\
\113\314\170\210\255\106\037\002\035\003\036\005\
\050\005\053\011\057\103\011\210\075\111\100\306\125\306\163\102\
\163\304\170\205\170\213\174\105\204\003\211\000\214\312\217\006\
\221\120\225\120\235\214\237\111\242\110\244\102\244\206\254\104\
\244\212\011\202\011\205\012\004\030\000\074\007\076\002\113\205\
\125\302\125\310\136\114\170\212\246\002\247\206\035\006\044\003\
\050\010\125\310\161\305\170\213\201\006\040\113\126\313\021\003\
\220\005\242\105\011\207\056\307\110\205\155\315\165\107\210\106\
\273\207\017\110\074\011\110\002\113\311\116\106\125\310\125\212\
\125\314\155\004\170\204\057\003\242\114\244\210\265\103\020\003\
\022\005\077\004\110\110\110\315\125\310\065\010\170\210\172\210\
\111\006\214\316\214\320\225\210\023\205\035\007\046\000\065\004\
\074\007\075\106\247\207\252\207\011\213\011\217\
\023\012\026\004\030\002\036\202\036\307\036\010\036\310\036\013\
\045\212\046\105\046\210\050\007\051\007\052\000\052\001\052\005\
\065\003\065\004\065\014\073\013\100\104\100\304\100\305\100\210\
\100\310\110\104\110\104\110\305\110\110\113\304\113\307\113\313\
\113\314\125\305\125\307\125\310\125\311\126\210\126\310\126\311\
\150\005\155\204\160\207\160\214\161\306\163\305\165\006\166\004\
\167\206\170\205\202\203\214\310\214\312\214\314\220\011\221\110\
\225\204\225\205\225\205\225\206\230\105\232\110\244\112\247\205\
\247\211\247\214\252\213\261\107\001\002\001\002\001\005\004\010\
\016\002\022\111\040\206\040\211\040\215\046\215\062\110\075\310\
\100\317\113\203\113\303\125\306\136\103\146\107\163\315\214\312\
\225\215\244\215\247\210\036\314\040\210\270\205\
\100\306\113\310\116\110\126\215\170\214\200\214\213\000\224\106\
\270\000\216\011\241\003\054\002\011\205\011\207\011\207\036\207\
\046\207\050\012\050\014\075\000\075\312\100\307\105\011\110\206\
\113\110\113\312\125\307\125\310\146\000\150\005\155\005\161\305\
\163\205\170\205\203\000\214\304\214\315\223\211\225\205\236\000\
\240\000\242\110\247\202\255\107\011\000\011\202\022\001\040\013\
\041\001\051\111\143\004\054\003\202\210\225\203\242\103\252\207\
\261\103\166\005\225\210\265\103\244\205\037\004\033\012\242\207\
\036\304\040\005\062\006\100\310\125\000\126\204\155\310\167\204\
\174\110\221\204\242\111\244\204\247\210\247\210\252\211\140\211\
\274\011\056\110\056\112\102\211\113\304\234\112\254\212\100\310\
\113\303\113\310\214\310\265\105\254\003\221\310\
\125\314\100\313\051\000\001\004\125\320\146\005\110\105\017\110\
\022\106\023\113\046\205\074\005\075\305\076\002\102\205\102\114\
\110\105\110\310\113\310\113\306\115\001\125\310\135\205\144\000\
\154\006\167\210\200\007\041\004\221\110\222\000\225\206\225\107\
\225\210\242\107\244\211\256\000\256\006\103\004\163\307\202\306\
\254\102\062\007\075\310\076\007\105\001\110\204\113\304\160\000\
\163\313\166\016\170\213\202\206\232\104\233\000\235\206\235\213\
\160\211\022\002\100\305\100\310\100\312\100\304\225\204\164\004\
\166\007\225\207\255\103\170\206\207\000\216\311\011\203\012\004\
\030\001\031\003\050\006\051\106\052\003\057\100\076\111\077\006\
\100\314\113\306\113\306\125\005\125\306\125\306\125\206\125\314\
\126\311\126\212\106\107\164\004\166\011\170\211\
\170\213\173\107\202\311\210\000\211\005\214\315\225\206\232\206\
\235\206\242\114\242\114\247\206\247\206\251\002\303\206\022\107\
\036\211\125\313\126\310\013\004\161\311\170\214\202\314\167\211\
\036\314\040\112\056\305\100\310\111\010\111\007\113\111\136\205\
\147\107\147\107\160\215\161\305\163\305\167\205\170\104\170\205\
\214\320\225\205\252\205\242\212\320\100\011\213\022\112\035\002\
\035\020\011\110\036\011\041\003\045\006\131\007\050\004\054\013\
\026\003\075\110\075\111\100\307\100\310\100\307\100\310\100\315\
\110\102\111\007\113\207\113\312\113\313\125\313\126\215\006\005\
\150\007\155\004\164\006\167\213\170\210\170\210\200\210\214\306\
\214\306\214\311\214\312\214\320\221\106\234\100\242\106\242\113\
\247\212\255\111\273\210\011\214\040\213\075\313\
\202\316\214\313\232\213\242\107\011\207\011\211\022\107\032\005\
\075\106\100\307\113\003\125\311\235\000\242\107\011\207\054\011\
\232\206\106\107\170\207\030\006\221\305\014\006\100\311\047\003\
\047\207\051\111\100\312\113\303\242\212\011\203\044\003\045\001\
\125\304\225\205\036\310\040\111\046\104\075\311\100\302\113\305\
\211\005\113\311\252\205\273\204\273\211\011\205\040\210\051\204\
\176\003\056\205\062\107\074\006\075\105\075\112\076\015\111\010\
\125\105\125\312\202\305\202\312\214\305\221\105\232\105\242\106\
\242\110\252\211\313\005\303\210\011\203\036\202\045\000\166\005\
\244\211\265\011\304\115\125\312\125\320\030\006\036\307\050\003\
\100\303\100\304\100\305\125\304\125\316\140\207\225\203\247\215\
\125\315\225\210\214\306\020\103\216\307\036\102\
\036\302\011\205\242\111\241\000\045\113\202\307\014\012\165\010\
\242\203\113\310\226\000\136\207\303\213\113\314\225\210\003\003\
\030\007\036\312\040\205\100\305\100\310\110\101\114\113\125\310\
\125\311\126\005\157\107\165\111\166\011\170\210\200\204\202\305\
\216\205\225\210\247\211\037\003\040\215\071\111\105\007\110\311\
\113\315\117\105\146\102\225\210\011\210\157\103\040\203\071\103\
\075\006\110\210\125\303\150\010\163\310\172\210\205\004\216\310\
\242\111\273\203\166\012\146\205\166\000\166\006\214\312\242\107\
\163\305\164\006\214\306\046\213\155\207\002\003\011\204\050\005\
\075\104\100\305\110\005\113\305\125\305\216\000\221\005\225\205\
\244\203\247\207\273\205\113\313\125\320\136\210\214\305\214\310\
\232\205\001\001\012\004\017\110\036\311\050\020\
\062\205\062\210\065\002\071\001\071\110\073\010\074\013\075\116\
\100\306\110\012\112\010\125\314\133\011\146\302\155\306\200\213\
\202\310\202\311\216\311\225\210\225\211\234\105\235\206\247\206\
\250\000\265\102\304\100\023\207\100\307\155\003\112\106\125\304\
\140\205\232\106\247\212\252\210\125\306\040\114\113\310\113\312\
\242\106\247\212\150\007\242\107\040\211\113\305\100\310\113\313\
\011\205\125\313\113\305\242\202\214\313\170\210\247\211\113\311\
\125\314\040\205\041\010\046\216\170\205\127\000\036\103\247\203\
\304\312\010\007\011\205\011\211\011\211\022\107\232\102\036\104\
\040\211\050\005\062\106\065\005\065\007\066\004\071\004\075\307\
\100\305\100\307\100\311\113\307\125\302\160\210\161\311\163\307\
\170\211\211\007\225\202\225\211\235\211\242\107\
\243\105\243\114\247\202\316\000\125\305\100\313\100\316\102\213\
\125\313\152\203\166\005\242\113\247\213\125\312\036\207\074\014\
\100\314\237\114\242\105\247\205\014\006\040\212\045\201\054\007\
\065\005\125\310\170\217\143\006\232\205\237\104\265\112\126\305\
\011\204\117\111\125\315\146\000\255\105\012\005\036\303\040\211\
\040\112\046\205\054\011\074\007\104\000\113\303\125\311\151\007\
\214\311\232\211\242\107\243\110\247\211\160\205\160\205\023\105\
\065\006\040\000\046\202\075\105\011\210\012\010\017\003\017\110\
\022\000\036\007\040\211\040\212\045\107\050\005\056\207\056\313\
\075\310\100\304\100\311\113\004\113\306\113\307\113\310\154\006\
\125\310\125\311\125\307\126\202\126\214\072\003\150\007\161\307\
\166\006\166\006\166\006\167\212\170\206\022\106\
\214\311\214\314\214\317\225\203\225\012\227\000\235\210\242\106\
\242\107\247\214\252\210\265\107\273\012\251\012\011\213\023\211\
\036\003\040\110\051\114\075\314\100\314\125\306\155\314\165\007\
\202\306\214\310\242\111\247\206\056\306\304\304\027\010\074\010\
\074\013\125\307\135\206\155\210\163\102\166\012\120\004\136\206\
\225\207\113\305\113\314\021\003\164\003\113\311\054\005\304\203\
\214\305\050\010\244\000\125\320\036\315\055\001\075\310\102\210\
\125\304\230\004\242\211\265\104\036\204\110\114\247\204\045\105\
\243\104\015\002\004\004\020\104\214\315\225\212\125\323\100\310\
\247\211\113\311\273\203\170\211\146\310\030\007\113\311\237\104\
\254\212\125\303\007\000\054\002\070\003\242\105\024\002\232\207\
\202\000\216\303\030\002\110\000\005\107\013\000\
\046\203\054\004\263\003\011\204\046\204\075\103\225\207\125\316\
\161\216\161\305\050\013\214\311\136\210\126\313\063\003\075\104\
\100\310\100\314\126\214\167\205\004\001\066\006\004\002\040\110\
\036\017\075\307\125\315\170\204\202\106\202\307\202\315\241\006\
\223\205\216\204\061\101\100\304\100\314\222\215\113\304\125\305\
\125\306\140\110\160\205\046\110\172\212\214\304\273\000\011\210\
\065\011\100\305\100\310\102\207\113\304\154\004\133\010\202\205\
\202\305\237\010\244\203\011\210\040\210\046\211\113\306\113\311\
\126\211\136\207\232\105\041\004\232\210\252\210\242\207\216\311\
\163\305\157\104\214\311\011\205\022\110\030\012\100\305\113\305\
\125\305\152\000\166\010\167\205\211\005\214\315\242\105\110\317\
\125\312\126\217\170\212\214\307\273\204\307\000\
\021\006\166\011\160\207\166\011\201\110\166\006\113\320\062\214\
\202\302\146\004\146\205\014\000\247\205\125\311\151\004\244\211\
\276\004\011\204\172\211\100\304\166\006\251\006\304\302\036\315\
\040\212\216\306\254\102\011\205\022\105\030\003\035\002\035\007\
\062\203\100\312\103\010\113\304\125\302\125\303\133\004\136\202\
\140\206\146\305\170\112\211\004\214\317\232\204\166\011\245\000\
\126\211\265\104\270\204\100\307\110\310\146\207\154\012\160\112\
\214\314\216\206\026\010\030\007\036\204\046\203\065\004\074\005\
\075\110\077\010\100\304\100\305\103\010\121\000\125\305\150\005\
\153\000\160\211\163\305\170\210\172\212\202\304\221\305\225\210\
\232\105\242\115\257\000\267\000\113\313\166\015\011\212\054\004\
\074\012\113\304\121\005\140\110\155\004\173\103\
\321\000\113\305\163\310\027\002\147\000\276\006\073\006\202\313\
\214\310\202\303\071\111\075\001\146\106\166\006\242\211\113\306\
\046\206\046\211\170\204\152\001\225\213\011\210\073\010\113\313\
\125\001\125\313\141\013\161\106\221\004\225\205\231\003\065\014\
\100\310\150\005\163\304\214\305\247\210\247\207\214\312\216\306\
\303\212\036\106\073\010\103\010\125\307\125\320\232\104\232\110\
\265\110\102\206\142\206\001\003\011\203\040\210\045\001\046\210\
\050\011\016\011\062\102\065\005\075\305\100\304\102\213\105\004\
\110\210\125\307\130\000\166\005\202\010\202\113\214\304\225\214\
\232\102\232\210\234\102\252\000\252\205\011\206\100\314\115\004\
\210\110\214\311\214\314\243\110\051\206\113\311\266\000\214\311\
\214\315\011\204\022\111\074\011\062\211\112\104\
\161\311\202\311\221\311\222\214\125\311\071\002\100\302\125\305\
\011\202\135\204\303\205\022\002\036\304\036\314\040\214\075\314\
\100\304\126\110\045\115\167\204\167\013\170\204\255\104\103\000\
\200\010\001\004\011\206\014\005\040\211\062\114\063\002\067\014\
\113\305\001\007\214\314\251\003\252\207\167\000\265\000\011\215\
\040\115\150\015\160\111\022\105\155\214\214\313\166\010\011\211\
\042\006\133\000\166\011\170\211\242\102\242\104\242\111\011\207\
\023\010\046\207\067\002\261\111\011\207\011\115\247\207\037\007\
\100\307\115\004\145\002\221\307\237\107\163\312\023\112\040\112\
\075\212\076\001\110\212\120\001\166\015\214\310\011\210\011\210\
\024\003\036\104\040\011\045\005\050\005\056\307\056\107\056\110\
\065\005\100\305\100\310\102\204\106\000\112\104\
\125\305\125\305\126\307\160\205\170\212\202\305\214\304\214\310\
\214\313\216\307\221\211\225\204\227\106\243\104\247\207\270\205\
\304\103\304\310\004\003\010\001\011\212\022\110\040\204\046\204\
\062\211\075\103\075\303\077\004\110\113\112\007\113\205\113\310\
\155\204\170\204\202\304\202\314\225\211\231\007\232\105\247\206\
\252\204\036\304\265\106\025\003\011\214\031\000\040\113\100\314\
\113\302\135\204\155\310\163\313\247\203\023\207\125\304\116\105\
\040\210\062\212\045\105\113\001\174\314\020\001\154\004\100\113\
\160\013\302\013\310\000\040\207\046\205\110\305\113\304\120\002\
\036\307\113\312\062\112\202\312\113\304\303\206\113\305\303\214\
\113\307\010\004\011\207\035\000\100\305\113\001\125\305\242\203\
\011\206\170\014\310\007\001\002\075\313\125\311\
\125\313\214\313\036\305\113\001\302\205\061\100\166\010\056\305\
\050\010\216\210\125\311\214\312\163\310\202\306\046\204\167\204\
\123\001\155\305\023\011\044\012\126\310\135\102\156\000\255\113\
\304\310\113\310\046\211\046\207\016\010\036\203\036\005\110\304\
\154\010\242\106\247\206\304\303\046\206\135\202\125\312\012\006\
\113\310\170\210\170\211\260\000\307\011\100\312\113\312\214\305\
\046\103\047\005\122\000\136\210\155\203\170\210\177\004\214\312\
\011\220\113\000\313\004\155\000\113\103\024\002\270\306\053\001\
\077\003\167\203\232\105\036\010\075\010\170\204\251\000\024\002\
\005\102\017\105\044\005\130\011\200\203\246\004\071\105\157\000\
\033\002\074\004\170\203\214\315\225\204\235\216\256\005\113\305\
\214\315\247\216\075\311\075\111\125\305\150\015\
\225\211\237\111\036\310\011\205\011\217\023\107\035\002\050\006\
\064\006\075\107\075\013\100\311\112\002\113\305\125\311\125\307\
\136\211\136\111\146\000\161\305\221\307\225\207\242\111\243\000\
\243\110\254\204\216\012\044\000\006\003\011\105\001\002\225\106\
\237\012\265\104\011\213\064\002\046\204\050\007\065\010\100\311\
\100\311\100\315\110\316\113\311\113\312\125\306\125\312\126\212\
\145\000\164\012\173\000\174\016\214\311\214\312\222\203\225\211\
\235\207\242\111\252\211\270\106\075\113\100\304\114\107\125\304\
\125\307\174\105\174\113\125\310\172\216\216\313\221\310\113\003\
\214\307\265\107\255\105\125\306\170\206\214\311\244\206\005\106\
\032\005\056\111\113\320\125\316\214\316\214\320\223\111\022\105\
\036\003\054\014\113\103\113\207\140\207\140\212\
\150\007\221\207\221\307\246\000\254\212\252\210\074\006\137\006\
\165\000\214\311\100\310\146\306\022\115\125\307\125\312\140\207\
\146\205\160\207\167\205\252\210\324\000\324\100\011\207\075\013\
\106\106\215\107\006\001\010\007\011\214\001\005\017\110\050\014\
\104\006\113\207\125\310\136\210\150\014\155\314\163\310\167\214\
\212\001\225\210\242\114\246\005\252\210\265\105\023\000\170\210\
\011\210\033\007\113\304\125\310\126\215\140\210\203\113\237\110\
\252\215\303\215\306\115\140\212\040\111\125\307\170\105\265\111\
\011\103\011\205\011\206\017\105\023\205\056\116\075\305\140\205\
\161\301\214\305\247\205\253\010\255\105\255\107\306\110\323\105\
\110\012\115\012\022\104\023\104\126\306\221\106\065\012\075\106\
\075\315\125\313\126\211\166\015\170\210\200\213\
\214\312\242\107\247\210\036\104\303\004\113\317\126\204\232\206\
\235\206\255\115\023\105\046\110\065\011\067\004\112\006\113\311\
\113\312\125\307\125\313\135\103\136\207\166\012\175\100\200\120\
\216\310\243\106\014\002\306\110\161\310\202\302\247\210\225\210\
\011\210\036\005\225\206\115\005\232\206\202\306\075\110\113\304\
\304\214\007\004\007\004\303\211\225\206\214\316\214\314\113\310\
\125\311\160\210\202\310\036\302\046\121\047\203\047\120\050\005\
\050\012\050\013\052\002\052\011\053\200\053\104\054\003\054\013\
\054\014\055\000\056\103\056\303\056\304\056\305\056\305\056\105\
\056\105\056\306\056\306\056\306\056\307\056\310\056\110\056\310\
\056\110\056\311\056\211\056\011\056\111\056\312\056\312\056\313\
\056\314\056\114\056\315\056\316\056\122\036\204\
\070\001\001\003\001\004\002\002\002\004\003\000\003\004\004\000\
\004\001\004\007\004\011\005\114\006\000\230\011\006\006\207\006\
\070\002\007\001\007\006\007\006\010\000\010\002\010\007\010\010\
\010\013\011\002\011\202\011\002\011\202\011\202\011\203\011\203\
\011\203\011\203\011\204\011\204\011\205\011\205\011\205\011\205\
\011\205\011\205\011\206\011\206\011\206\011\206\011\206\011\206\
\011\206\011\206\011\206\011\006\011\106\011\216\011\207\011\207\
\011\007\011\207\011\207\011\207\011\207\011\207\011\207\011\207\
\011\210\011\210\011\210\011\210\011\210\011\210\011\204\011\210\
\011\210\011\210\011\210\011\210\011\210\011\210\011\210\011\211\
\011\211\011\113\011\211\011\211\011\211\011\211\011\211\011\211\
\011\211\011\212\011\212\011\212\011\213\011\213\
\011\113\011\214\011\213\011\213\011\214\011\214\011\214\011\214\
\011\214\011\214\011\215\011\215\011\215\011\214\011\215\011\216\
\011\216\011\216\011\215\011\217\011\223\011\223\011\224\011\224\
\012\000\012\001\012\006\012\005\012\006\012\014\165\021\013\006\
\013\007\014\002\014\016\015\000\015\003\015\003\015\003\015\005\
\015\007\015\010\015\011\016\000\016\010\016\010\016\010\016\014\
\016\015\017\000\017\104\017\104\017\104\017\104\017\105\017\106\
\017\110\017\110\017\115\020\000\215\105\020\104\020\006\020\111\
\021\000\021\007\022\001\022\103\022\104\022\104\022\005\022\105\
\022\106\022\106\022\106\022\007\022\107\022\107\022\107\022\110\
\022\110\022\011\022\112\022\112\022\111\022\113\022\113\022\115\
\022\016\022\016\022\011\022\015\022\116\022\116\
\240\011\023\205\023\205\023\206\023\106\023\207\023\210\023\011\
\023\112\023\213\023\213\023\013\023\213\023\216\023\216\023\221\
\024\000\024\003\024\004\024\005\024\007\024\011\024\011\025\000\
\026\000\026\005\026\013\026\014\026\015\027\000\027\011\030\002\
\030\002\001\004\030\003\030\002\017\112\031\002\032\000\032\003\
\032\003\032\007\032\006\033\000\033\007\033\011\033\012\033\012\
\033\014\033\014\034\000\034\011\034\017\254\012\035\010\035\011\
\035\017\036\302\036\302\036\302\036\302\036\303\036\304\036\304\
\036\304\036\304\036\304\036\304\036\304\036\304\036\204\036\304\
\036\305\036\305\036\205\036\305\036\306\036\305\036\206\036\105\
\036\305\036\305\036\305\036\305\036\305\036\305\036\306\036\106\
\036\006\036\306\036\306\036\306\036\306\036\206\
\036\006\036\306\036\306\036\306\036\006\036\306\036\007\036\307\
\036\307\036\307\036\307\036\307\036\107\036\307\036\307\036\310\
\036\310\036\311\036\310\036\210\036\310\036\310\036\310\036\310\
\036\310\036\307\036\310\036\311\036\311\036\306\036\311\036\311\
\036\211\036\311\036\311\036\311\036\111\036\311\036\311\036\311\
\036\311\036\311\036\312\036\312\036\312\036\312\036\312\036\312\
\036\312\036\313\036\313\036\313\036\313\036\313\036\313\036\313\
\036\314\036\114\036\016\036\315\036\314\036\314\036\314\036\315\
\036\315\036\315\036\315\036\315\036\315\036\316\036\316\036\317\
\036\317\036\316\036\320\036\020\036\321\036\121\036\122\036\322\
\036\322\036\322\036\322\036\322\036\323\036\325\036\325\037\000\
\037\004\037\005\037\006\037\006\037\007\037\010\
\037\010\037\010\037\011\037\012\037\013\037\013\037\012\037\015\
\040\202\040\203\040\203\040\204\040\204\040\204\040\204\040\205\
\040\007\040\105\040\205\040\205\040\205\040\206\040\206\040\206\
\040\206\040\206\040\206\040\207\040\207\040\207\040\207\040\207\
\040\110\040\207\040\210\040\210\040\211\040\211\040\213\040\111\
\040\212\040\112\040\112\040\012\040\212\040\211\040\113\040\113\
\040\214\040\214\040\214\040\215\040\220\040\215\040\214\040\114\
\040\115\040\016\040\116\040\216\040\217\040\117\040\221\040\220\
\040\221\040\120\041\004\041\011\041\011\041\011\041\012\041\013\
\042\000\043\000\043\013\044\003\044\010\044\013\045\001\045\201\
\045\102\045\103\045\004\165\004\045\206\045\206\045\106\045\207\
\045\207\045\111\045\211\045\212\045\213\045\113\
\046\203\046\203\046\004\046\004\046\005\046\204\046\205\046\205\
\046\206\046\106\046\204\046\206\046\206\046\207\046\207\046\107\
\046\207\046\207\046\207\046\210\046\210\046\210\046\210\046\110\
\046\210\046\110\046\211\046\212\046\212\046\212\046\211\046\212\
\046\213\046\213\046\213\046\213\046\213\046\214\046\214\046\214\
\046\214\046\115\046\016\046\212\046\216\046\216\046\220\046\221\
\046\221\046\221\047\000\047\102\047\104\047\104\047\105\047\206\
\047\010\047\111\047\013\047\115\103\003\047\216\050\000\050\002\
\050\006\050\007\050\010\050\010\050\010\050\011\050\011\050\013\
\050\013\050\013\050\012\050\013\050\014\050\015\050\021\050\020\
\051\007\051\010\051\110\051\213\052\002\052\012\053\000\053\004\
\054\000\054\001\054\004\054\005\054\006\054\007\
\054\007\054\006\054\011\054\022\055\000\005\103\056\102\056\303\
\056\104\056\104\056\204\056\104\056\305\056\305\056\305\056\305\
\056\305\056\305\056\305\056\106\056\306\056\107\056\307\056\307\
\056\307\056\113\056\307\056\107\056\310\056\110\056\111\056\110\
\056\310\056\110\056\110\056\310\056\310\056\110\056\310\056\111\
\056\211\056\311\056\311\056\112\056\112\056\312\056\313\056\113\
\056\313\056\314\056\314\056\315\056\315\056\116\056\114\056\116\
\056\315\056\321\056\122\056\123\056\223\056\124\057\000\060\004\
\061\200\061\104\062\104\062\105\062\205\062\105\062\105\062\110\
\062\210\062\211\062\211\062\211\062\212\062\213\062\213\062\214\
\062\214\062\114\062\111\063\003\063\003\064\000\064\013\065\000\
\065\006\065\011\065\011\065\012\065\013\065\013\
\065\013\065\014\065\014\065\014\065\014\065\014\065\014\065\015\
\065\015\065\020\065\022\065\026\065\021\066\000\066\005\067\000\
\067\004\067\007\067\017\072\015\070\000\070\011\071\001\071\005\
\071\106\071\110\071\112\071\114\071\116\071\023\071\006\072\000\
\072\006\072\010\072\012\073\000\073\011\074\000\074\004\074\005\
\074\005\074\005\074\006\074\006\074\007\074\006\074\010\074\010\
\074\010\074\010\074\011\074\012\074\015\075\303\075\304\075\304\
\075\304\075\304\075\204\075\110\075\104\075\305\075\306\075\305\
\075\305\075\305\075\105\075\105\075\305\075\305\075\305\075\305\
\075\305\075\305\075\106\075\106\075\306\075\106\075\306\075\306\
\075\306\075\306\075\106\075\306\075\306\075\306\075\306\075\306\
\075\106\075\307\075\307\075\310\075\307\075\307\
\075\307\075\307\075\307\075\307\075\307\075\307\075\307\075\110\
\075\310\075\110\075\310\075\310\075\304\075\310\075\310\075\310\
\075\310\075\312\075\311\075\111\075\311\075\111\075\311\075\311\
\075\311\075\311\075\311\075\311\075\311\075\111\075\311\075\112\
\075\312\075\112\075\312\075\312\075\112\075\312\075\112\075\312\
\075\312\075\112\075\312\075\313\075\313\075\313\075\113\075\313\
\075\113\075\313\075\313\075\313\075\313\075\313\075\112\075\313\
\075\313\075\114\075\114\075\113\075\314\075\314\075\314\075\114\
\075\114\075\314\075\314\075\315\075\315\075\015\075\320\075\315\
\075\115\075\315\075\315\075\115\075\315\075\315\075\316\075\116\
\075\320\075\321\075\317\075\022\075\321\075\322\075\322\075\123\
\076\000\076\001\076\002\076\002\076\004\076\007\
\076\010\076\111\076\012\076\113\076\114\076\115\076\116\077\005\
\100\301\100\303\100\303\100\303\100\303\100\303\100\304\100\304\
\100\304\100\304\100\304\100\304\100\304\100\305\100\304\100\304\
\100\305\100\305\100\305\100\205\100\206\100\305\100\315\100\305\
\100\105\100\305\100\305\100\305\100\305\100\304\100\305\100\306\
\100\306\100\306\100\306\100\306\100\206\100\306\100\306\100\307\
\100\307\100\307\100\311\100\307\100\310\100\310\100\310\100\310\
\100\310\100\210\100\310\100\310\100\310\100\310\100\310\100\307\
\100\311\100\311\100\311\100\311\100\311\100\311\100\311\100\311\
\100\311\100\312\100\212\100\312\100\312\100\312\100\312\100\322\
\100\312\100\312\100\312\100\313\100\213\100\313\100\313\100\324\
\100\314\100\314\100\314\100\314\100\314\100\315\
\100\315\100\314\100\315\100\315\100\315\100\215\100\315\100\316\
\100\215\206\111\100\316\100\316\100\305\100\316\100\316\100\325\
\100\317\100\317\100\317\100\317\100\217\100\317\100\321\100\322\
\100\317\100\323\100\223\100\324\102\000\102\100\102\202\102\203\
\102\203\146\304\102\206\102\207\102\207\102\007\102\207\102\210\
\102\210\102\012\102\213\102\215\102\116\102\123\104\007\104\011\
\105\005\105\016\106\106\106\106\106\006\106\106\106\107\106\111\
\106\116\106\114\107\000\107\000\110\103\110\104\110\104\110\104\
\110\104\110\204\110\305\110\005\110\105\110\105\110\106\110\306\
\110\206\110\106\110\307\110\007\110\307\110\307\110\107\110\106\
\110\207\110\310\110\110\110\111\110\310\110\311\110\311\110\311\
\110\312\110\014\110\014\110\314\110\314\110\214\
\110\312\110\314\110\315\110\315\110\317\110\305\110\320\110\121\
\111\000\111\003\111\005\112\105\112\107\112\010\112\115\112\120\
\112\021\113\001\113\002\113\202\113\302\113\302\113\302\113\303\
\113\303\113\303\113\303\113\303\113\303\113\304\113\104\113\104\
\113\304\113\304\113\304\113\304\113\304\113\304\113\304\113\305\
\113\305\113\305\113\005\113\305\113\305\113\305\113\305\113\305\
\113\305\113\305\113\305\113\305\113\305\113\305\113\306\113\315\
\113\206\113\306\113\306\113\207\113\306\113\306\113\306\113\307\
\113\306\113\306\113\306\113\307\113\307\113\207\113\307\113\307\
\113\307\113\007\113\307\113\307\113\316\113\307\113\307\113\107\
\113\307\113\107\113\310\113\307\113\307\113\310\113\210\113\310\
\113\010\113\310\113\310\113\310\113\310\113\310\
\113\310\113\310\113\310\113\311\113\310\113\310\113\010\113\310\
\113\310\113\310\113\210\113\310\113\310\113\310\113\310\113\310\
\113\310\113\310\113\311\113\311\113\311\113\311\113\311\113\311\
\113\311\113\311\113\311\113\311\113\311\113\311\113\311\113\311\
\113\311\113\311\113\311\113\311\113\312\113\212\113\312\113\312\
\113\312\113\312\113\312\113\312\113\212\113\212\113\312\113\312\
\113\212\113\312\113\312\113\312\113\312\113\312\113\312\113\312\
\113\312\113\313\113\213\113\313\113\313\113\321\113\313\113\313\
\113\213\113\313\113\312\113\313\113\313\113\313\113\313\113\013\
\113\313\113\316\113\313\113\313\113\314\113\313\113\314\113\314\
\113\314\113\314\113\314\113\314\113\314\113\314\113\314\113\313\
\113\315\113\315\113\214\113\315\113\315\113\315\
\113\215\214\321\113\316\113\316\113\316\113\316\113\316\113\315\
\113\317\113\317\113\317\113\315\113\317\113\320\113\321\113\321\
\214\321\113\321\113\223\113\325\113\031\113\330\114\107\114\107\
\114\010\114\110\114\111\114\111\114\111\114\112\114\113\114\114\
\114\114\114\115\114\115\114\121\115\016\116\000\116\104\116\104\
\116\105\116\105\116\107\116\110\116\110\116\112\116\113\116\114\
\116\114\116\116\116\121\116\117\117\000\117\106\117\110\117\113\
\120\000\120\012\122\104\122\307\122\107\122\010\122\310\122\013\
\122\215\123\004\124\000\124\004\124\006\124\006\125\003\125\303\
\125\303\125\304\125\304\125\304\125\304\125\304\125\304\125\304\
\125\304\125\304\125\304\125\304\125\305\125\305\125\305\125\305\
\125\305\125\305\125\305\125\305\125\305\125\305\
\125\305\125\304\125\305\125\305\125\305\125\306\125\206\125\306\
\125\306\125\306\125\306\125\306\125\306\125\306\125\306\125\306\
\125\307\125\307\125\307\125\307\125\307\125\307\125\307\125\307\
\125\316\125\307\125\310\125\310\125\310\125\310\125\310\125\310\
\125\310\125\310\125\310\125\310\125\310\125\310\125\310\125\310\
\125\310\125\310\125\310\125\310\125\310\125\310\125\311\125\311\
\125\310\125\311\125\311\125\311\125\311\125\311\125\311\125\311\
\125\311\125\311\125\311\125\311\125\311\125\311\125\311\125\313\
\125\311\125\311\125\311\125\312\125\312\125\312\125\312\125\312\
\125\312\125\312\125\312\125\312\125\312\125\112\125\312\125\312\
\125\312\125\312\125\013\125\314\125\321\125\313\125\313\125\313\
\125\013\125\313\125\313\125\313\125\313\125\313\
\125\313\125\312\125\313\125\314\125\314\125\314\125\314\125\316\
\125\314\125\314\125\320\125\314\125\314\125\314\125\314\125\314\
\125\314\125\315\125\314\125\315\125\315\125\315\125\315\125\315\
\125\314\125\315\125\316\125\316\125\316\125\316\125\316\125\316\
\125\316\125\315\125\317\125\317\125\317\125\317\125\317\125\317\
\125\317\125\320\125\320\125\314\125\320\125\320\125\320\125\321\
\125\321\125\321\125\323\125\326\126\104\126\204\126\205\126\207\
\126\205\126\205\126\205\126\205\126\206\126\306\126\306\126\206\
\126\307\126\207\126\210\126\210\126\211\126\311\126\312\126\311\
\126\011\126\211\126\211\126\211\126\312\126\216\126\212\126\212\
\126\113\126\313\126\214\126\314\126\214\126\214\126\214\126\214\
\126\214\126\215\126\215\126\215\126\215\126\216\
\126\116\126\216\126\217\126\220\126\221\126\131\127\204\127\004\
\127\205\127\210\131\000\131\005\132\100\132\104\132\115\133\010\
\133\017\135\205\135\207\135\110\135\107\135\010\135\212\135\112\
\135\217\135\220\136\204\136\203\136\204\136\204\136\204\136\205\
\136\205\136\206\136\206\136\206\136\207\136\207\136\006\136\210\
\136\210\136\210\136\210\136\210\136\211\136\211\136\211\136\211\
\136\212\136\013\136\212\136\114\136\214\136\215\136\215\136\216\
\136\117\136\217\136\120\136\220\140\205\140\205\140\205\140\205\
\140\205\140\206\140\206\140\206\140\214\140\207\140\212\140\210\
\140\207\140\210\140\210\140\211\140\211\140\111\140\211\140\211\
\140\211\140\012\140\212\140\212\140\212\140\211\140\213\140\213\
\140\214\140\015\140\216\140\220\140\221\140\206\
\141\006\141\016\142\302\142\303\142\104\142\304\142\304\142\304\
\142\306\142\106\142\211\142\111\142\311\142\213\142\213\142\112\
\142\115\142\115\143\010\144\007\145\002\146\102\146\203\146\304\
\146\304\146\304\146\305\146\004\146\205\146\306\146\306\146\106\
\146\007\146\307\146\310\146\210\146\016\146\316\146\307\146\121\
\146\121\146\113\150\002\150\003\150\003\150\004\150\004\150\005\
\150\005\150\005\150\006\150\005\150\005\150\005\150\005\150\006\
\150\006\150\006\150\007\150\007\150\007\150\010\150\010\150\010\
\150\010\150\010\150\010\150\010\150\010\150\011\150\011\150\011\
\150\012\150\012\150\012\150\012\150\012\150\012\150\013\150\013\
\150\013\150\014\150\014\150\014\150\015\150\014\150\016\150\017\
\150\020\150\020\150\020\150\020\150\021\150\022\
\150\023\151\000\151\004\151\007\152\102\152\102\152\204\152\105\
\152\206\152\207\152\207\152\010\152\212\153\205\153\107\153\111\
\153\211\153\112\154\003\154\005\154\006\154\006\154\010\154\011\
\154\013\154\013\154\014\214\321\155\304\155\304\155\304\155\304\
\155\305\155\305\155\005\155\206\155\306\155\305\155\206\155\306\
\155\307\155\310\155\310\155\310\155\310\155\310\155\211\155\111\
\155\311\155\312\155\312\155\312\155\313\155\313\155\314\155\314\
\155\315\155\015\155\315\155\215\155\315\155\315\155\017\155\023\
\155\325\156\004\157\002\157\110\160\203\160\204\160\204\160\217\
\160\205\160\216\160\206\160\210\160\207\160\110\160\210\160\210\
\160\210\160\211\160\211\160\211\160\211\160\212\160\212\160\212\
\160\213\160\212\160\212\160\212\160\012\160\113\
\160\213\160\213\160\214\160\214\160\215\160\215\160\215\160\216\
\160\117\160\217\161\203\161\205\161\205\161\105\161\205\161\205\
\161\205\161\210\161\210\161\211\161\212\161\214\161\014\161\214\
\161\215\161\221\162\104\162\104\163\003\163\304\163\305\163\305\
\163\305\163\305\163\307\163\307\163\310\163\310\163\310\163\210\
\161\110\163\311\163\312\163\212\163\312\163\312\163\314\163\314\
\163\315\163\315\163\316\163\320\163\321\164\003\164\004\164\005\
\164\007\164\006\164\007\164\007\164\011\164\020\164\012\164\013\
\164\015\164\015\164\014\164\015\164\017\164\021\165\102\165\103\
\165\104\165\104\165\105\165\105\165\105\165\106\165\107\165\107\
\165\111\165\111\166\003\166\004\166\004\166\004\166\005\166\005\
\166\005\166\005\166\005\166\005\166\005\166\006\
\166\007\166\004\166\006\166\004\166\006\166\006\166\007\166\007\
\166\007\166\007\166\007\166\007\166\006\166\007\166\010\166\010\
\166\010\166\010\166\010\166\010\166\010\166\010\166\010\166\006\
\166\010\166\011\166\011\166\011\166\011\166\011\166\011\166\012\
\166\012\166\012\166\013\166\012\166\012\166\020\166\013\166\013\
\166\013\166\013\166\013\166\013\166\013\166\013\166\014\166\014\
\166\016\166\014\166\015\166\015\166\015\166\016\166\016\166\017\
\166\016\166\015\166\017\166\020\166\020\166\021\166\017\166\021\
\166\022\167\202\167\204\167\204\167\006\167\206\167\106\167\206\
\167\206\167\206\167\207\167\107\167\107\167\207\167\210\167\210\
\167\207\167\211\167\211\167\212\167\212\167\013\167\212\301\014\
\167\216\167\216\167\020\167\023\170\201\170\203\
\170\203\170\204\170\204\170\104\170\205\170\205\170\105\170\205\
\170\205\170\205\170\205\170\206\170\206\170\206\170\206\170\206\
\170\106\170\206\170\206\170\207\170\207\170\007\170\207\170\207\
\170\207\170\210\170\110\170\210\170\210\170\210\170\210\170\210\
\170\213\170\210\170\210\170\011\170\210\170\207\170\210\170\211\
\170\211\170\211\170\211\170\212\170\211\170\211\170\211\170\212\
\170\012\170\212\170\212\170\213\170\212\170\212\170\212\170\012\
\170\213\170\214\170\013\170\213\170\213\170\213\170\213\170\213\
\170\213\170\214\170\214\170\214\170\214\170\214\170\214\170\215\
\170\215\170\215\170\216\170\216\170\216\170\210\170\216\170\016\
\170\216\170\217\170\217\170\217\170\220\170\217\170\221\170\221\
\170\221\170\217\170\022\170\225\171\203\171\204\
\171\213\171\116\171\117\171\220\171\221\172\300\172\003\172\103\
\172\204\172\205\172\205\172\210\172\210\172\210\172\212\172\215\
\172\216\172\215\172\223\172\221\173\102\173\104\173\105\173\205\
\173\205\173\007\173\211\173\112\173\115\173\111\173\215\173\015\
\173\016\174\004\174\104\174\305\174\206\174\306\174\210\174\211\
\174\311\174\213\174\014\267\014\175\104\175\104\175\106\177\000\
\177\004\177\004\177\005\177\007\177\012\200\204\200\204\200\205\
\200\205\200\206\200\207\200\010\200\110\200\210\200\211\200\113\
\200\113\200\213\200\014\200\216\200\020\201\100\201\107\201\107\
\201\010\202\303\202\203\202\303\202\304\015\006\202\304\202\305\
\202\205\202\305\202\305\202\205\202\305\202\305\202\305\202\306\
\202\306\202\307\202\107\202\207\202\307\202\310\
\202\110\202\310\202\310\202\310\202\310\202\306\202\311\202\311\
\202\311\202\311\202\311\202\312\202\312\202\312\202\312\202\212\
\202\313\202\313\202\313\202\313\202\311\202\313\202\314\202\314\
\202\313\202\315\202\315\202\315\202\215\202\215\202\115\202\315\
\202\316\202\316\202\320\202\317\202\314\202\320\202\321\202\023\
\203\010\205\010\205\012\206\102\206\003\206\005\206\007\206\106\
\206\013\207\002\207\004\207\011\211\004\211\004\211\005\211\005\
\211\007\211\012\211\012\211\013\211\013\211\014\211\015\211\015\
\211\015\211\017\211\020\211\004\212\013\213\022\214\000\214\302\
\214\303\214\303\214\304\214\304\214\004\214\304\214\305\214\305\
\214\305\214\305\214\305\214\305\214\305\214\307\214\305\214\305\
\214\305\214\305\214\305\214\305\214\305\214\305\
\214\306\214\306\214\306\214\306\214\306\214\306\214\306\214\306\
\214\306\214\306\214\306\214\306\214\306\214\307\214\307\214\307\
\214\307\214\307\214\307\214\307\214\307\214\307\214\307\214\307\
\214\307\214\307\214\307\214\307\214\307\214\307\214\310\214\310\
\214\310\214\310\214\310\214\310\214\310\214\310\214\310\214\310\
\214\310\214\310\214\310\214\310\214\310\214\310\214\306\214\311\
\214\313\214\310\214\311\214\311\214\311\214\314\214\311\214\311\
\214\311\214\312\214\311\214\311\214\311\214\311\214\311\214\311\
\214\311\214\311\214\312\214\311\214\312\214\312\214\312\214\312\
\214\312\214\312\214\312\214\312\214\312\214\312\214\312\214\312\
\214\313\214\313\214\313\214\313\214\313\214\314\214\313\214\313\
\214\313\214\313\214\314\214\314\214\314\214\314\
\214\314\214\320\214\314\214\314\214\315\214\315\214\315\214\315\
\214\315\214\315\214\315\214\315\214\315\214\317\214\315\214\315\
\214\315\214\315\214\315\214\316\214\316\214\316\214\316\214\316\
\214\317\214\317\214\317\214\317\214\320\214\320\214\320\214\320\
\214\320\214\320\214\320\214\320\214\321\214\321\214\323\215\000\
\004\006\215\104\215\007\215\013\216\002\216\304\216\304\216\204\
\216\304\216\304\216\304\216\305\216\305\216\305\216\305\216\305\
\216\305\216\316\216\305\216\306\216\306\216\206\216\206\216\306\
\216\306\216\306\216\307\216\307\216\307\216\007\216\207\216\307\
\216\207\216\307\216\307\216\307\216\307\216\310\216\310\216\310\
\216\310\216\310\216\310\216\210\216\311\216\311\216\311\216\311\
\216\311\216\311\216\311\216\111\216\311\216\311\
\216\311\216\311\216\311\216\315\216\212\216\312\216\312\216\213\
\216\313\216\113\216\313\216\313\216\013\216\213\216\213\216\313\
\216\212\216\312\216\313\216\314\216\114\216\314\216\315\216\315\
\216\315\216\315\216\315\216\313\216\311\216\316\216\315\216\316\
\216\117\216\117\216\121\216\124\216\122\216\120\216\223\217\004\
\217\003\220\005\220\007\220\012\220\022\221\303\221\006\221\104\
\221\205\221\304\221\304\221\306\221\304\221\304\221\305\221\305\
\221\305\221\305\221\305\221\305\221\205\221\105\221\306\221\306\
\221\306\221\306\221\107\221\107\221\307\221\107\221\210\221\310\
\221\310\221\110\221\310\221\310\221\310\221\311\221\311\221\311\
\221\213\221\312\221\312\221\312\221\312\221\313\221\213\221\213\
\221\313\221\313\221\314\221\311\221\315\221\115\
\221\316\221\316\221\317\221\316\221\320\221\321\221\321\222\100\
\222\106\222\115\222\123\223\104\223\205\223\207\223\211\223\211\
\223\212\223\212\223\213\223\115\223\116\223\217\223\221\224\106\
\224\006\224\105\224\106\224\113\224\115\225\202\225\203\225\203\
\225\203\225\204\225\204\225\204\225\205\225\205\225\205\225\205\
\225\205\225\105\225\206\225\206\225\206\225\206\225\206\225\206\
\225\206\225\207\225\207\225\207\225\207\225\207\225\207\225\207\
\225\210\225\210\225\210\225\210\225\211\225\211\225\211\225\211\
\225\212\225\212\225\211\225\211\225\211\225\211\225\210\225\212\
\225\112\225\212\225\211\225\212\225\212\225\212\225\212\225\213\
\225\013\225\113\225\213\225\213\225\212\225\212\225\214\225\214\
\225\214\225\214\225\214\225\214\225\214\225\215\
\225\215\225\115\225\215\225\216\225\115\225\217\225\220\225\020\
\225\221\225\221\225\221\225\221\225\223\226\205\226\112\226\112\
\227\103\227\210\227\110\227\113\230\000\230\106\230\211\231\000\
\231\003\231\005\231\006\231\006\231\006\231\007\231\010\231\012\
\231\004\231\012\076\107\232\004\232\104\232\205\232\106\232\005\
\232\004\232\204\232\106\232\105\232\210\232\110\232\110\232\112\
\232\212\232\212\232\113\232\113\232\114\232\114\232\015\232\215\
\232\216\232\016\232\216\232\206\232\016\232\217\233\005\233\011\
\234\000\234\103\234\105\234\107\235\204\235\204\235\204\235\205\
\235\205\235\205\235\205\235\205\235\205\235\206\235\106\235\206\
\235\206\235\207\235\207\235\207\235\207\235\210\235\210\235\210\
\235\210\235\211\235\211\235\211\235\211\235\212\
\235\112\235\212\235\212\235\212\235\212\235\113\235\213\235\213\
\235\210\235\213\235\213\235\214\235\214\235\214\235\215\235\214\
\235\215\235\115\235\216\235\216\235\217\235\217\235\217\235\220\
\235\223\235\222\236\003\236\005\236\015\236\006\236\011\236\014\
\236\021\237\101\237\104\237\004\237\105\237\105\237\105\237\106\
\237\106\237\106\237\107\237\107\237\110\237\107\237\110\237\110\
\237\110\237\106\237\010\237\111\237\111\237\111\237\112\237\012\
\237\112\237\113\237\113\237\113\237\114\237\115\237\116\237\117\
\237\120\237\120\240\005\240\006\240\007\240\014\240\016\242\201\
\242\204\242\205\242\205\242\105\242\205\242\216\242\206\242\206\
\242\206\242\206\242\207\242\207\242\207\242\207\242\207\242\207\
\242\207\242\207\242\210\242\210\242\210\242\206\
\242\211\242\211\242\211\242\211\242\207\242\211\242\211\242\211\
\242\212\242\212\242\213\242\213\242\214\242\214\242\214\242\215\
\242\215\242\214\242\215\242\217\242\215\242\223\243\104\243\105\
\243\105\243\105\243\107\243\107\077\007\243\107\243\111\243\112\
\243\113\243\114\243\114\244\202\244\204\244\204\244\205\244\205\
\244\206\244\207\244\207\244\210\244\210\244\210\244\212\244\113\
\244\214\244\213\244\215\244\215\244\216\244\221\244\022\245\005\
\245\015\246\013\247\202\247\202\247\102\247\202\247\203\247\203\
\247\203\247\204\247\204\247\204\247\204\247\204\247\204\247\205\
\247\205\247\205\247\205\247\205\247\205\247\206\247\205\247\205\
\247\205\247\006\247\206\247\206\247\206\247\205\247\207\247\207\
\247\207\247\206\247\210\247\210\247\210\247\210\
\247\210\247\210\247\210\247\210\247\207\247\207\247\210\247\211\
\247\211\247\211\247\211\247\211\247\212\247\212\247\212\247\212\
\247\212\247\013\247\213\247\113\247\213\247\213\247\213\247\213\
\247\213\247\213\247\213\247\214\247\214\247\214\247\214\247\214\
\247\214\247\215\247\214\247\215\247\214\247\215\247\215\247\116\
\247\216\247\217\247\217\247\217\247\217\247\220\247\204\247\221\
\247\221\247\222\247\223\247\217\247\223\247\123\247\224\247\124\
\251\001\251\003\251\003\251\004\251\004\251\005\251\005\251\005\
\251\006\251\006\251\007\251\010\251\010\251\010\251\010\251\011\
\125\316\251\011\251\011\251\011\251\012\251\012\251\012\251\013\
\251\014\251\015\251\015\252\203\252\204\252\204\252\204\252\205\
\252\206\252\206\252\206\252\210\252\207\252\207\
\252\207\252\207\252\207\252\210\252\210\252\211\252\212\252\212\
\252\212\252\215\252\215\252\216\252\216\252\216\252\220\253\000\
\253\011\254\000\254\205\254\104\254\205\254\005\221\314\254\212\
\255\110\254\210\255\105\255\107\255\107\255\107\255\110\255\110\
\255\110\255\110\255\110\255\110\255\112\255\113\255\114\255\115\
\255\116\255\116\255\120\255\020\255\120\255\120\255\021\256\010\
\257\007\260\005\260\007\260\016\261\102\261\103\261\103\261\104\
\261\105\261\105\261\105\261\105\261\105\261\106\261\006\261\106\
\261\110\261\111\261\111\261\111\261\111\261\112\261\115\261\117\
\261\116\262\000\262\112\263\000\322\011\263\012\264\002\264\205\
\264\204\265\104\265\104\265\107\265\106\265\106\265\107\265\107\
\265\110\265\111\265\111\265\115\265\116\265\017\
\265\120\265\121\265\122\266\103\266\205\266\305\266\310\266\213\
\266\313\266\214\270\304\270\304\270\306\270\306\270\307\270\307\
\270\307\270\310\270\307\270\310\270\310\270\310\270\311\270\111\
\270\312\270\312\270\312\270\313\270\313\270\314\270\314\270\314\
\270\314\270\314\270\115\271\002\271\010\272\111\273\202\273\002\
\273\204\273\205\273\205\273\205\273\205\273\105\273\206\273\206\
\273\206\273\206\273\207\273\207\273\207\273\210\273\210\273\206\
\273\211\273\112\273\212\273\213\273\213\273\112\273\213\273\213\
\273\214\273\214\273\215\273\215\273\216\273\220\273\220\273\221\
\273\221\273\024\273\223\274\003\274\004\274\006\274\010\274\013\
\274\015\274\015\274\015\275\015\276\000\276\003\276\004\276\004\
\276\005\276\005\276\005\276\005\276\005\276\006\
\276\006\276\010\276\013\276\014\276\015\276\016\276\017\277\000\
\277\005\277\006\277\010\277\012\277\020\300\000\301\000\302\105\
\302\205\302\110\302\210\302\210\302\212\302\016\303\204\303\205\
\303\205\303\205\303\205\303\205\303\206\303\206\303\206\303\206\
\303\207\303\107\303\207\303\207\303\207\303\207\303\207\303\210\
\303\210\303\210\303\210\303\210\303\213\303\210\303\210\303\210\
\303\211\303\211\303\211\303\211\303\211\303\211\303\211\303\211\
\303\211\303\211\303\212\303\211\303\212\303\212\303\212\303\212\
\303\213\303\113\303\213\303\213\303\214\303\215\303\215\303\217\
\303\220\304\102\304\002\304\302\304\304\304\104\304\102\304\104\
\304\304\304\305\304\205\304\212\304\305\304\305\304\306\304\105\
\304\305\304\306\304\306\304\306\304\106\304\306\
\304\307\304\207\304\307\304\307\304\307\304\307\304\310\304\310\
\304\310\304\311\304\310\304\310\304\311\304\311\304\211\304\312\
\304\312\304\312\304\312\304\312\304\312\304\312\304\312\304\312\
\304\213\304\313\304\314\304\314\304\314\304\314\304\215\304\321\
\304\321\304\223\305\000\305\111\305\015\306\102\306\305\306\206\
\306\207\306\110\306\310\306\210\306\312\307\100\307\104\307\004\
\307\104\307\105\310\010\311\115\312\003\312\005\312\012\313\204\
\313\205\313\205\313\205\313\206\313\210\313\110\313\211\313\113\
\313\116\313\217\314\000\314\005\314\007\315\000\315\113\315\114\
\153\111\317\005\320\000\320\205\321\003\322\000\323\200\323\302\
\323\305\323\305\323\305\323\305\323\306\323\206\323\307\323\307\
\323\311\323\311\323\311\324\106\325\100\326\000\
\040\011\113\312\242\212\140\212\017\115\126\312\036\314\057\010\
\062\205\062\105\062\213\062\214\065\010\065\012\065\012\066\005\
\067\001\067\003\067\006\071\104\071\105\071\110\071\110\071\111\
\071\012\071\113\072\005\072\011\073\004\073\007\074\005\074\006\
\074\010\074\011\074\012\074\014\074\014\075\302\075\104\075\304\
\075\104\075\305\075\305\075\105\075\305\075\305\075\306\075\307\
\075\307\075\307\075\310\075\310\075\310\075\310\075\311\075\311\
\075\312\075\312\075\312\075\314\075\314\075\314\075\114\075\315\
\075\117\076\111\077\004\077\005\100\302\100\303\100\304\100\304\
\100\305\100\305\100\306\100\306\100\306\100\307\100\307\100\310\
\100\310\100\311\100\311\100\311\100\312\100\312\100\312\100\212\
\100\313\100\313\100\313\100\214\100\315\100\315\
\100\315\100\215\100\315\100\317\100\317\100\323\100\324\102\207\
\102\010\104\010\107\107\110\304\110\304\110\304\110\305\110\105\
\110\305\110\305\110\305\110\105\110\105\110\305\110\107\110\306\
\110\306\110\107\110\307\110\307\110\307\110\307\110\210\110\110\
\110\111\110\311\110\111\110\112\110\313\110\314\110\014\110\314\
\110\315\110\316\110\320\111\006\112\106\112\007\113\302\113\303\
\113\303\113\303\113\304\113\304\113\304\113\304\113\304\113\305\
\113\304\113\305\113\305\113\305\113\305\113\205\113\306\113\306\
\113\306\113\306\113\307\113\307\113\307\113\307\113\207\113\307\
\113\310\113\210\113\210\113\310\113\310\113\310\113\110\113\310\
\113\310\113\311\113\311\113\311\113\311\113\311\113\311\113\311\
\113\311\113\312\113\312\113\312\113\312\113\312\
\113\313\113\313\113\214\113\314\113\313\113\313\113\313\113\313\
\113\314\113\314\113\314\113\314\113\214\113\314\113\314\113\314\
\113\314\113\116\113\315\113\315\113\315\113\315\113\315\113\317\
\113\320\113\320\113\321\113\325\113\330\114\106\114\107\114\111\
\114\114\114\117\115\003\115\004\115\014\116\105\116\115\116\115\
\117\107\120\003\121\005\121\005\122\213\122\114\123\001\124\012\
\125\303\125\303\125\304\125\304\125\304\125\304\125\304\125\304\
\125\304\125\305\125\305\125\305\125\305\125\305\125\305\125\106\
\125\306\125\306\125\306\125\306\125\306\125\306\125\307\125\307\
\125\307\125\307\125\307\125\307\125\307\125\310\125\310\125\310\
\125\310\125\310\125\310\125\310\125\310\125\010\125\311\125\311\
\125\311\125\311\125\311\125\312\125\312\125\312\
\125\312\125\012\125\013\125\313\125\313\125\313\125\313\125\313\
\125\314\125\314\125\315\125\314\125\314\125\315\125\314\125\314\
\125\314\125\314\125\315\125\315\125\315\125\315\125\315\125\315\
\125\317\125\316\125\316\125\317\125\317\125\320\125\322\125\325\
\125\325\125\327\125\327\126\103\126\104\126\205\126\205\126\205\
\126\206\126\206\126\206\126\307\126\207\126\210\126\210\126\210\
\126\210\126\211\126\211\126\111\126\311\126\212\126\211\126\211\
\126\211\126\312\126\212\126\212\126\112\126\212\126\214\126\014\
\126\316\126\216\126\117\133\013\133\013\135\207\135\211\135\013\
\136\204\136\104\136\207\136\211\136\211\136\211\136\211\136\213\
\136\214\136\221\140\203\140\204\140\204\140\204\140\204\140\204\
\140\205\140\205\140\206\140\206\140\206\140\206\
\140\207\140\210\140\210\140\210\140\210\140\210\140\210\140\210\
\140\210\140\210\140\210\140\210\140\210\140\211\140\211\140\211\
\140\212\140\211\140\212\140\212\140\212\140\213\140\213\140\213\
\140\215\140\214\140\214\140\214\140\215\140\215\140\215\140\215\
\140\215\140\216\140\217\140\217\140\223\142\210\142\210\142\220\
\145\007\146\307\146\310\150\000\150\002\150\006\150\007\150\010\
\150\010\150\011\150\011\150\011\150\012\150\012\150\013\150\013\
\150\014\150\014\150\017\150\017\150\021\150\022\150\023\152\102\
\152\112\152\012\152\212\152\215\152\217\153\111\154\004\154\005\
\154\005\154\006\154\013\155\303\155\304\155\304\155\305\155\306\
\155\306\155\307\155\307\155\307\155\310\155\310\155\310\155\311\
\155\211\155\313\155\314\156\010\160\204\160\206\
\160\206\160\206\160\206\160\206\160\207\160\207\160\210\160\211\
\160\211\160\211\160\212\160\214\160\214\160\215\160\115\160\220\
\160\120\160\220\161\203\161\204\161\204\161\204\161\204\161\205\
\161\205\161\205\161\205\161\205\161\206\161\210\161\211\161\211\
\161\211\161\211\161\216\162\000\163\303\163\103\163\304\163\304\
\163\305\163\305\163\304\163\307\163\012\163\312\163\314\163\317\
\164\004\164\005\164\010\164\011\164\014\164\013\165\003\165\110\
\166\003\166\004\166\005\166\005\166\006\166\006\166\007\166\007\
\166\007\166\007\166\010\166\011\166\012\166\012\166\013\166\014\
\166\014\166\014\166\015\166\015\166\015\166\017\166\020\166\023\
\167\203\167\204\167\205\167\206\167\011\167\212\167\213\167\213\
\170\203\170\203\170\204\170\204\170\204\170\205\
\170\205\170\205\170\206\170\106\170\207\170\207\170\207\170\210\
\170\110\170\210\170\210\170\211\170\211\170\211\170\212\170\112\
\170\212\170\212\170\113\170\013\170\214\170\215\170\217\170\117\
\171\214\172\211\173\103\173\104\174\103\174\305\174\007\174\110\
\174\111\174\312\174\314\175\005\177\003\177\011\200\202\200\103\
\200\204\202\305\202\305\202\305\202\306\202\307\202\310\202\311\
\202\311\202\311\202\311\202\315\202\315\202\316\202\316\204\004\
\205\007\207\005\211\014\213\005\214\302\214\303\214\304\214\304\
\214\304\214\304\214\304\214\304\214\304\214\304\214\304\214\305\
\214\306\214\305\214\305\214\305\214\306\214\306\214\306\214\306\
\214\306\214\306\214\306\214\306\214\307\214\307\214\307\214\307\
\214\307\214\307\214\310\214\310\214\310\214\310\
\214\310\214\310\214\310\214\310\214\310\214\310\214\311\214\311\
\214\311\214\311\214\311\214\311\214\312\214\212\214\312\214\312\
\214\312\214\312\214\313\214\313\214\313\214\313\214\313\214\314\
\214\314\214\315\214\315\214\315\214\315\214\315\214\315\214\316\
\214\316\214\316\214\317\214\320\214\320\214\320\214\320\214\320\
\214\321\214\321\214\321\214\323\215\105\215\106\215\107\215\011\
\216\201\216\301\216\303\216\304\216\305\216\307\216\307\216\307\
\216\307\216\111\216\312\216\312\216\313\216\312\216\313\216\013\
\216\314\216\314\216\214\216\315\216\316\216\316\216\317\221\305\
\221\305\221\107\221\307\221\307\221\210\221\111\221\311\221\312\
\221\311\221\311\221\112\221\112\221\312\221\313\221\313\223\104\
\223\205\224\102\224\106\224\114\225\203\225\203\
\225\204\225\205\225\205\225\205\225\205\225\206\225\206\225\006\
\225\207\225\110\225\211\225\211\225\211\225\211\225\211\225\213\
\225\214\225\214\225\214\225\215\225\224\227\204\230\207\232\107\
\232\010\232\011\232\012\232\012\232\214\232\116\232\021\234\116\
\235\205\235\205\235\205\235\210\235\210\235\211\235\214\235\214\
\236\012\236\013\237\102\237\105\237\110\237\111\237\111\237\115\
\237\116\240\011\242\000\242\205\242\205\242\205\242\206\242\210\
\242\210\242\216\243\003\243\103\243\103\243\103\243\104\243\105\
\243\106\243\106\243\106\243\106\243\107\243\107\243\107\243\110\
\243\110\243\111\243\112\243\112\243\112\243\113\243\113\243\114\
\243\114\243\114\243\115\243\117\243\123\244\204\244\210\244\212\
\244\113\244\214\244\220\247\202\247\203\247\203\
\247\203\247\203\247\203\247\204\247\204\247\205\247\205\247\205\
\247\205\247\205\247\205\247\205\247\206\247\206\247\207\247\207\
\247\207\247\207\247\207\247\210\247\210\247\210\247\210\247\210\
\247\210\247\211\247\211\247\211\247\211\247\111\247\211\247\212\
\247\112\247\212\247\213\247\213\247\213\247\214\247\215\247\215\
\247\215\247\217\247\020\247\221\247\221\251\004\251\005\251\006\
\251\006\251\007\251\010\251\010\251\011\251\012\251\012\251\013\
\251\013\251\014\252\207\252\211\252\211\252\213\252\214\252\214\
\254\206\254\212\254\213\255\103\255\104\255\114\255\115\255\123\
\255\123\255\125\256\007\261\103\261\104\261\107\261\111\261\113\
\261\115\261\120\262\112\262\112\264\204\264\115\265\104\265\106\
\265\106\265\107\265\107\265\111\265\111\265\112\
\265\112\265\112\265\112\265\112\265\114\265\116\266\311\266\314\
\270\003\270\315\272\107\273\207\273\207\273\211\273\112\273\212\
\273\212\273\212\273\214\273\214\274\005\274\010\274\011\274\013\
\274\016\276\006\276\007\276\010\276\015\277\013\277\017\303\202\
\303\204\303\204\303\204\303\204\303\205\303\205\303\205\303\206\
\303\206\303\207\303\206\303\210\303\211\303\211\303\211\303\212\
\303\213\303\214\303\215\303\214\303\215\303\215\303\220\304\305\
\304\305\304\306\304\306\304\307\304\307\304\310\304\310\304\310\
\304\211\304\311\304\312\304\312\304\313\304\314\304\314\304\315\
\304\320\305\115\306\213\306\226\307\105\307\106\307\110\307\111\
\311\100\313\100\316\002\320\212\323\304\324\103\324\106\324\121\
\326\005\046\206\054\010\063\005\150\012\170\115\
")

;;; japanese-jisx0213-2 $BMQ$NIt<s!&2h?t%G!<%?(B
;; 2-1-1 $B$+$i(B 2Byte $B$:$D;HMQ(B(skk-tankan-radical-stroke-table-0213-1 $B$KF1$8(B)
;; $B$?$@$7L$;HMQ$N6h$O$H$P$7$F$$$k(B
(defconst skk-tankan-radical-stroke-table-0213-2 "\
\001\001\001\001\001\003\001\003\002\002\002\002\002\003\004\000\
\004\002\004\002\004\005\004\005\004\005\004\005\005\100\005\105\
\007\006\010\005\010\013\010\024\011\200\011\100\011\001\011\202\
\011\202\011\102\011\203\011\103\011\204\011\204\011\204\011\204\
\011\205\011\205\011\205\011\205\011\105\011\206\011\206\011\206\
\011\206\011\206\011\206\011\206\011\206\011\206\011\207\011\207\
\011\207\011\207\011\207\011\207\011\207\011\210\011\210\011\210\
\011\210\011\210\011\210\011\210\011\210\011\210\011\211\011\211\
\011\211\011\211\011\211\011\211\011\211\011\211\011\211\011\212\
\011\212\011\212\011\212\011\212\011\212\011\212\011\213\011\213\
\011\213\011\213\011\213\011\213\011\213\011\214\011\214\011\214\
\011\214\011\214\011\214\011\214\011\214\011\215\
\011\215\011\216\011\216\011\217\011\221\012\012\014\004\014\004\
\015\002\015\003\015\011\016\002\016\010\017\003\017\104\017\106\
\017\107\020\100\020\014\020\014\022\100\022\104\022\104\022\010\
\022\110\022\110\022\111\022\113\022\114\022\114\022\115\022\123\
\023\004\023\204\023\004\023\205\023\206\023\206\023\007\023\110\
\023\210\023\217\023\221\024\006\024\006\026\005\026\017\027\011\
\030\001\030\002\030\006\031\006\032\002\032\006\033\012\033\021\
\034\002\034\002\034\006\035\002\035\005\035\006\035\006\035\007\
\036\202\036\202\036\002\036\304\036\304\036\304\036\304\036\304\
\036\305\036\305\036\305\036\305\036\305\036\305\036\106\036\306\
\036\306\036\306\036\306\036\306\036\306\036\306\036\307\036\307\
\036\307\036\307\036\307\036\307\036\307\036\307\
\036\310\036\310\036\310\036\010\036\310\036\310\036\210\036\310\
\036\310\036\211\036\311\036\311\036\311\036\311\036\311\036\311\
\036\312\036\312\036\112\036\312\036\312\036\312\036\312\036\312\
\036\312\036\312\036\312\036\313\036\313\036\313\036\313\036\314\
\036\314\036\314\036\314\036\314\036\314\036\314\036\315\036\315\
\036\315\036\316\036\316\036\316\036\317\036\117\036\317\036\320\
\036\020\036\021\036\023\036\025\037\003\037\004\037\005\037\005\
\037\011\037\012\040\102\040\203\040\203\040\204\040\204\040\204\
\040\104\040\204\040\204\040\205\040\205\040\205\040\105\040\205\
\040\205\040\206\040\206\040\206\040\006\040\206\040\206\040\206\
\040\207\040\207\040\207\040\210\040\210\040\210\040\210\040\210\
\040\210\040\210\040\210\040\210\040\210\040\211\
\040\211\040\211\040\111\040\211\040\112\040\212\040\212\040\212\
\040\113\040\213\040\114\040\113\040\213\040\213\040\214\040\114\
\040\214\040\215\040\215\040\116\040\220\041\005\041\006\042\004\
\042\004\043\004\043\006\043\022\044\013\045\002\045\203\045\104\
\045\205\045\105\045\205\045\007\045\110\045\110\045\011\046\202\
\046\202\046\203\046\104\046\205\046\205\046\205\046\205\046\206\
\046\206\046\206\046\006\046\206\046\206\046\207\046\207\046\207\
\046\206\046\207\046\207\046\207\046\210\046\210\046\111\046\211\
\046\211\046\211\046\211\046\211\046\212\046\212\046\012\046\212\
\046\212\046\213\046\213\046\013\046\213\046\213\046\213\046\214\
\046\214\046\214\046\215\046\015\046\216\046\123\047\000\047\006\
\047\110\047\120\047\123\050\002\050\002\050\003\
\050\005\050\006\050\010\050\010\050\011\050\011\050\012\050\013\
\050\014\050\016\051\104\051\105\051\107\053\204\053\011\054\006\
\054\011\054\013\054\014\054\016\054\017\055\003\056\301\056\103\
\056\303\056\304\056\104\056\305\056\204\056\305\056\305\056\305\
\056\305\056\105\056\105\056\105\056\305\056\305\056\305\056\107\
\056\106\056\107\056\310\056\310\056\310\056\110\056\310\056\310\
\056\310\056\310\056\111\056\311\056\111\056\311\056\112\056\312\
\056\312\056\312\056\113\056\313\056\113\056\213\056\314\056\114\
\056\314\056\315\056\315\056\114\056\215\056\316\056\316\056\323\
\056\324\056\324\057\004\057\006\057\014\060\003\061\102\062\101\
\062\203\062\105\062\205\062\005\062\106\062\107\062\211\062\211\
\062\213\062\213\062\214\062\116\062\216\062\216\
\062\217\062\222\065\006\065\007\065\007\065\010\065\010\065\012\
\065\013\065\013\066\005\066\007\067\006\070\003\071\103\071\103\
\071\104\071\115\073\004\073\023\074\005\074\007\074\010\074\011\
\074\014\075\300\075\200\075\302\075\303\075\003\075\303\075\303\
\075\104\075\304\075\304\075\304\075\304\075\205\075\305\075\305\
\075\105\075\306\075\306\075\107\075\107\075\307\075\107\075\110\
\075\310\075\310\075\310\075\310\075\310\075\310\075\311\075\311\
\075\311\075\311\075\311\075\311\075\111\075\311\075\311\075\112\
\075\112\075\312\075\313\075\113\075\114\075\314\075\314\075\114\
\075\314\075\114\075\114\075\314\075\115\075\116\075\316\075\116\
\075\317\076\002\076\104\076\111\076\112\077\006\100\300\100\302\
\100\302\100\303\100\303\100\304\100\304\100\304\
\100\304\100\305\100\305\100\205\100\306\100\306\100\306\100\206\
\100\307\100\307\100\207\100\307\100\307\100\307\100\307\100\307\
\100\307\100\307\100\307\100\310\100\310\100\310\100\310\100\310\
\100\311\100\210\100\311\100\311\100\311\100\311\100\311\100\311\
\100\211\100\311\100\311\100\312\100\312\100\312\100\313\100\312\
\100\313\100\312\100\313\100\313\100\313\100\314\100\314\100\314\
\100\314\100\315\100\315\100\314\100\315\100\316\100\316\100\216\
\100\317\100\317\100\321\100\320\100\321\100\321\100\322\100\323\
\101\010\102\205\102\207\102\211\102\013\102\215\102\117\102\020\
\103\006\105\013\105\015\105\025\106\105\106\106\106\007\106\111\
\110\203\110\103\110\204\110\304\110\304\110\304\110\305\110\105\
\110\306\110\106\110\306\110\006\110\007\110\307\
\110\307\110\307\110\110\110\010\110\310\110\310\110\310\110\310\
\110\310\110\310\110\312\110\311\110\311\110\112\110\313\110\312\
\110\313\110\314\110\314\110\214\110\323\111\003\111\012\111\012\
\112\106\112\107\112\007\113\303\113\303\113\303\113\303\113\303\
\113\303\113\303\113\304\113\304\113\304\113\304\113\304\113\305\
\113\004\113\205\113\305\113\305\113\205\113\305\113\305\113\205\
\113\305\113\305\113\105\113\305\113\306\113\306\113\306\113\306\
\113\306\113\306\113\306\113\306\113\306\113\206\113\306\113\306\
\113\306\113\206\113\306\113\306\113\307\113\307\113\307\113\307\
\113\107\113\307\113\307\113\307\113\307\113\307\113\307\113\307\
\113\307\113\307\113\307\113\307\113\307\113\207\113\310\113\310\
\113\310\113\210\113\310\113\310\113\310\113\310\
\113\310\113\310\113\310\113\310\113\310\113\310\113\310\113\310\
\113\310\113\311\113\311\113\211\113\311\113\311\113\311\113\311\
\113\311\113\311\113\312\113\212\113\012\113\212\113\012\113\312\
\113\312\113\012\113\312\113\212\113\012\113\212\113\313\113\213\
\113\313\113\313\113\313\113\313\113\313\113\313\113\213\113\313\
\113\313\113\313\113\313\113\313\113\313\113\314\113\314\113\314\
\113\314\113\314\113\014\113\314\113\314\113\314\113\314\113\214\
\113\315\113\315\113\215\113\315\113\315\113\315\113\315\113\315\
\113\316\113\316\113\316\113\316\113\316\113\217\113\217\113\317\
\113\320\113\320\113\320\113\220\113\320\113\320\113\221\113\322\
\113\322\113\323\113\323\113\323\113\323\113\324\114\105\114\106\
\114\112\114\114\115\006\115\013\116\200\116\104\
\116\110\116\115\117\107\117\110\117\111\117\114\117\114\117\016\
\121\015\122\206\122\306\122\007\122\310\122\013\122\315\122\226\
\125\200\125\001\125\100\125\302\125\302\125\303\125\303\125\304\
\125\304\125\304\125\304\125\304\125\304\125\104\125\305\125\305\
\125\305\125\305\125\305\125\306\125\305\125\305\125\305\125\305\
\125\306\125\306\125\306\125\306\125\306\125\306\125\306\125\006\
\125\306\125\307\125\307\125\307\125\307\125\307\125\307\125\307\
\125\307\125\307\125\307\125\307\125\310\125\310\125\310\125\310\
\125\310\125\310\125\310\125\310\125\310\125\310\125\310\125\310\
\125\310\125\310\125\310\125\310\125\310\125\311\125\311\125\311\
\125\311\125\311\125\311\125\311\125\311\125\311\125\311\125\311\
\125\311\125\311\125\311\125\311\125\311\125\311\
\125\312\125\312\125\312\125\312\125\312\125\312\125\312\125\313\
\125\313\125\313\125\313\125\313\125\313\125\313\125\313\125\313\
\125\313\125\314\125\314\125\314\125\315\125\314\125\314\125\314\
\125\314\125\314\125\314\125\315\125\315\125\315\125\315\125\315\
\125\315\125\315\125\315\125\316\125\316\125\315\125\317\125\317\
\125\317\125\317\125\317\125\320\125\321\125\321\125\321\125\321\
\125\322\125\322\125\322\125\323\125\323\125\027\125\334\126\300\
\126\002\126\203\126\103\126\305\126\204\126\204\126\104\126\205\
\126\205\126\205\126\105\126\006\126\206\126\206\126\206\126\206\
\126\206\126\207\126\307\126\207\126\207\126\107\126\207\126\007\
\126\210\126\010\126\210\126\211\126\211\126\311\126\211\126\212\
\126\212\126\213\126\213\126\213\126\213\126\213\
\126\213\126\114\126\214\126\114\126\114\126\214\126\316\126\217\
\127\100\127\200\127\013\130\004\130\006\132\000\132\106\133\012\
\133\013\135\203\135\104\135\105\135\205\135\206\135\207\135\111\
\135\011\136\200\136\001\136\202\136\203\136\204\136\204\136\205\
\136\205\136\205\136\207\136\207\136\210\136\110\136\210\136\210\
\136\210\136\211\136\211\136\211\136\211\136\212\136\013\136\214\
\136\215\136\215\136\215\136\216\136\216\136\216\136\217\136\224\
\137\004\140\101\140\203\140\203\140\204\140\204\140\204\140\204\
\140\205\140\205\140\205\140\206\140\205\140\205\140\205\140\106\
\140\206\140\206\140\207\140\207\140\207\140\210\140\210\140\110\
\140\211\140\211\140\211\140\211\140\211\140\211\140\212\140\213\
\140\213\140\213\140\114\140\214\140\014\140\214\
\140\214\140\214\140\214\140\215\140\215\140\216\140\216\140\016\
\140\221\140\221\141\005\142\204\142\104\142\307\142\207\142\311\
\144\004\144\007\145\001\146\302\146\302\146\303\146\203\146\103\
\146\304\146\304\146\204\146\004\146\207\146\207\146\207\146\010\
\146\311\146\112\146\313\147\100\147\003\150\003\150\004\150\004\
\150\005\150\005\150\005\150\005\150\005\150\006\150\006\150\007\
\150\007\150\007\150\007\150\010\150\010\150\010\150\010\150\010\
\150\011\150\011\150\011\150\011\150\011\150\011\150\012\150\012\
\150\012\150\012\150\012\150\012\150\013\150\013\150\014\150\014\
\150\014\150\014\150\015\150\020\150\021\152\007\152\212\152\213\
\152\213\152\215\152\115\153\203\154\004\154\005\154\005\154\014\
\154\015\155\304\155\305\155\205\155\306\155\306\
\155\307\155\307\155\310\155\310\155\110\155\310\155\110\155\311\
\155\311\155\311\155\311\155\311\155\312\155\313\155\313\155\212\
\155\314\155\314\156\007\156\007\157\003\157\004\157\106\157\107\
\157\107\157\114\160\202\160\203\160\204\160\204\160\204\160\104\
\160\204\160\205\160\205\160\205\160\206\160\207\160\207\160\110\
\160\210\160\210\160\210\160\211\160\111\160\211\160\212\160\212\
\160\212\160\212\160\212\160\213\160\213\160\213\160\214\160\214\
\160\214\160\214\160\215\160\115\160\216\160\220\160\217\161\300\
\161\204\161\205\161\205\161\106\161\206\161\207\161\211\161\212\
\161\211\161\212\161\212\161\213\161\221\162\006\163\102\163\303\
\163\004\163\304\163\304\163\206\163\306\163\307\163\307\163\307\
\163\310\163\310\163\310\163\310\163\311\163\311\
\163\312\163\313\163\013\163\314\163\314\163\314\163\315\163\315\
\163\316\163\316\164\001\164\003\164\004\164\006\164\006\164\010\
\164\011\164\012\164\013\164\013\164\013\164\014\164\016\165\102\
\165\104\165\107\165\110\165\114\166\003\166\003\166\004\166\004\
\166\005\166\005\166\005\166\005\166\005\166\005\166\005\166\006\
\166\007\166\006\166\006\166\006\166\007\166\007\166\007\166\007\
\166\007\166\010\166\010\166\010\166\010\166\011\166\011\166\011\
\166\011\166\011\166\011\166\011\166\012\166\012\166\012\166\012\
\166\012\166\012\166\013\166\013\166\013\166\013\166\013\166\014\
\166\015\166\016\166\017\166\020\166\021\166\020\166\023\166\023\
\166\024\166\024\167\103\167\205\167\206\167\007\167\006\167\210\
\167\210\167\210\167\011\167\211\167\211\167\211\
\167\211\167\212\167\212\167\214\167\214\167\215\167\217\167\120\
\170\203\170\203\170\204\170\204\170\204\170\205\170\205\170\205\
\170\205\170\205\170\205\170\206\170\206\170\206\170\206\170\206\
\170\206\170\206\170\206\170\207\170\207\170\207\170\207\170\207\
\170\207\170\210\170\210\170\210\170\210\170\210\170\210\170\210\
\170\211\170\211\170\211\170\211\170\211\170\211\170\212\170\212\
\170\212\170\212\170\212\170\012\170\213\170\213\170\213\170\215\
\170\215\170\216\170\217\170\017\170\220\170\220\170\223\170\223\
\171\104\171\204\171\205\171\206\171\112\171\113\171\220\172\000\
\172\100\172\200\172\204\172\205\172\206\172\207\172\210\172\214\
\172\214\173\100\214\106\173\104\173\104\173\204\173\205\173\211\
\174\004\174\304\174\105\174\110\174\211\174\112\
\174\313\175\000\175\006\175\105\176\003\176\003\177\004\177\010\
\177\013\177\017\200\205\200\211\200\113\200\214\200\116\202\203\
\202\303\202\304\202\304\202\304\202\305\202\305\202\305\202\305\
\202\305\202\306\202\306\202\306\202\306\202\306\202\307\202\307\
\202\307\202\307\202\307\202\307\202\307\202\310\202\310\202\310\
\202\311\202\311\202\312\202\312\202\312\202\312\202\312\202\313\
\202\314\202\315\202\315\202\217\202\320\203\000\203\102\203\112\
\204\004\206\100\206\002\206\003\206\106\206\006\207\007\207\014\
\211\003\211\003\211\004\211\005\211\005\211\006\211\007\211\007\
\211\007\211\010\211\010\211\010\211\011\211\011\211\012\211\013\
\211\013\211\015\211\017\214\100\214\100\214\200\214\200\214\302\
\214\302\214\303\214\303\214\303\214\304\214\304\
\214\304\214\304\214\304\214\304\214\305\214\305\214\305\214\305\
\214\306\214\305\214\306\214\306\214\306\214\306\214\306\214\306\
\214\306\214\306\214\306\214\307\214\306\214\307\214\307\214\307\
\214\307\214\307\214\310\214\110\214\310\214\310\214\310\214\310\
\214\310\214\310\214\310\214\210\214\310\214\311\214\311\214\311\
\214\311\214\311\214\311\214\311\214\311\214\311\214\311\214\311\
\214\311\214\311\214\211\214\312\214\312\214\312\214\312\214\312\
\214\312\214\312\214\314\214\312\214\313\214\313\214\313\214\313\
\214\313\214\313\214\313\214\313\214\313\214\313\214\313\214\313\
\214\313\214\313\214\314\214\314\214\313\214\314\214\314\214\314\
\214\314\214\314\214\314\214\314\214\315\214\315\214\315\214\315\
\214\315\214\315\214\315\214\315\214\315\214\316\
\214\316\214\316\214\316\214\316\214\315\214\316\214\317\214\317\
\214\317\214\317\214\317\214\320\214\320\214\320\214\321\214\321\
\214\321\214\321\214\322\214\323\214\323\214\323\214\323\214\325\
\215\004\215\105\216\303\216\303\216\003\216\304\216\204\216\304\
\216\304\216\305\216\304\216\304\216\305\216\305\216\305\216\305\
\216\305\216\306\216\306\216\206\216\306\216\306\216\207\216\307\
\216\207\216\307\216\307\216\307\216\310\216\310\216\310\216\310\
\216\310\216\310\216\310\216\310\216\310\216\311\216\311\216\311\
\216\211\216\311\216\311\216\212\216\012\216\312\216\312\216\312\
\216\312\216\312\216\212\216\313\216\313\216\313\216\113\216\313\
\216\314\216\314\216\114\216\314\216\314\216\314\216\314\216\314\
\216\314\216\215\216\015\216\315\216\315\216\320\
\216\321\216\021\216\324\217\003\217\016\220\007\220\012\221\300\
\221\303\221\303\221\303\221\304\221\304\221\205\221\306\221\306\
\221\306\221\306\221\207\221\307\221\307\221\307\221\207\221\310\
\221\310\221\310\221\010\221\312\221\313\221\313\221\313\221\313\
\221\314\221\314\221\315\221\315\222\200\222\121\223\004\223\207\
\223\213\223\214\224\104\224\104\224\107\224\111\224\011\224\012\
\224\117\224\122\225\202\225\203\225\103\225\204\225\204\225\205\
\225\106\225\205\225\205\225\205\225\207\225\207\225\210\225\010\
\225\210\225\211\225\211\225\211\225\212\225\112\225\212\225\212\
\225\213\225\214\225\014\225\214\225\215\225\016\225\217\225\217\
\225\120\225\221\225\221\225\224\225\224\226\204\226\205\226\207\
\226\110\226\212\226\220\227\203\227\212\227\025\
\230\003\230\207\230\211\230\012\231\005\231\010\231\011\231\013\
\231\014\231\021\232\203\232\207\232\207\232\210\232\110\232\211\
\232\211\232\214\232\214\232\214\233\011\234\105\234\107\234\111\
\235\200\235\205\235\205\235\205\235\206\235\207\235\207\235\207\
\235\207\235\210\235\210\235\210\235\210\235\210\235\210\235\211\
\235\211\235\211\235\211\235\212\235\113\235\213\235\214\235\214\
\235\214\235\220\235\221\236\004\236\007\236\007\236\010\236\010\
\236\014\237\103\237\103\237\104\237\105\237\106\237\106\237\106\
\237\110\237\110\237\112\237\113\237\115\240\001\240\010\241\014\
\242\100\242\200\242\103\242\203\242\203\242\204\242\204\242\204\
\242\205\242\204\242\205\242\205\242\206\242\206\242\206\242\207\
\242\210\242\111\242\211\242\211\242\212\242\214\
\242\214\242\215\242\217\242\223\243\100\243\104\243\104\243\105\
\243\105\243\106\243\106\243\107\243\107\243\107\243\110\243\010\
\243\110\243\110\243\110\243\111\243\111\243\111\243\111\243\113\
\243\113\243\113\243\115\243\116\243\117\243\122\243\123\244\204\
\244\204\244\205\244\205\244\207\244\207\244\210\244\211\244\212\
\244\214\244\215\244\215\244\223\244\223\247\202\247\203\247\203\
\247\203\247\203\247\204\247\204\247\204\247\204\247\105\247\205\
\247\205\247\205\247\205\247\205\247\205\247\205\247\205\247\205\
\247\205\247\205\247\205\247\205\247\206\247\206\247\206\247\206\
\247\206\247\206\247\206\247\206\247\206\247\206\247\206\247\206\
\247\207\247\207\247\207\247\207\247\207\247\107\247\207\247\207\
\247\207\247\207\247\207\247\207\247\210\247\210\
\247\210\247\210\247\210\247\110\247\210\247\210\247\210\247\210\
\247\210\247\210\247\210\247\211\247\211\247\211\247\211\247\211\
\247\211\247\111\247\211\247\111\247\211\247\212\247\212\247\212\
\247\212\247\112\247\212\247\212\247\213\247\213\247\213\247\213\
\247\213\247\213\247\213\247\113\247\214\247\214\247\214\247\214\
\247\215\247\215\247\215\247\215\247\216\247\217\247\217\247\221\
\247\221\250\100\250\103\251\003\251\004\251\004\251\006\251\007\
\251\007\251\011\251\012\251\023\252\204\252\204\252\204\252\204\
\252\205\252\205\252\205\252\207\252\210\252\211\252\212\252\213\
\252\214\252\215\252\215\252\216\252\117\254\002\254\102\254\205\
\254\210\254\011\254\011\254\212\254\213\255\110\255\112\255\112\
\255\115\255\117\255\120\256\005\256\006\256\010\
\261\102\261\106\261\107\261\107\261\110\261\110\261\111\261\112\
\261\112\261\112\262\103\262\006\262\110\262\111\262\011\262\112\
\263\010\265\102\265\104\265\104\265\105\265\105\265\105\265\106\
\265\106\265\107\265\107\265\107\265\110\265\114\266\304\266\305\
\266\305\266\106\266\310\266\311\266\212\266\312\266\212\266\313\
\266\314\266\315\270\200\270\300\270\002\270\302\270\303\270\304\
\270\304\270\004\270\305\270\106\270\206\270\107\270\307\270\307\
\270\210\270\310\270\310\270\310\270\311\270\311\270\311\270\311\
\270\312\270\312\270\312\270\312\270\312\270\313\270\314\270\314\
\270\116\270\321\270\323\272\110\272\112\273\204\273\004\273\204\
\273\204\273\205\273\205\273\205\273\205\273\206\273\206\273\207\
\273\207\273\210\273\210\273\111\273\211\273\211\
\273\212\273\212\273\213\273\215\273\015\273\030\274\004\274\005\
\274\005\274\006\274\006\274\011\274\012\274\014\274\014\274\016\
\275\003\275\010\276\002\276\004\276\004\276\010\276\011\276\012\
\276\012\276\013\276\014\277\014\301\006\302\203\302\205\302\210\
\303\204\303\204\303\204\303\204\303\204\303\204\303\204\303\206\
\303\206\303\206\303\207\303\207\303\206\303\207\303\207\303\207\
\303\210\303\210\303\210\303\210\303\210\303\210\303\210\303\210\
\303\210\303\211\303\211\303\211\303\211\303\211\303\211\303\210\
\303\211\303\212\303\212\303\012\303\212\303\212\303\213\303\213\
\303\213\303\213\303\213\303\215\303\214\303\114\303\214\303\214\
\303\214\303\214\303\214\303\214\303\115\303\215\303\215\303\215\
\303\216\303\215\303\216\303\217\303\217\303\223\
\304\101\304\303\304\304\304\304\304\304\304\205\304\305\304\305\
\304\306\304\306\304\106\304\306\304\306\304\306\304\307\304\207\
\304\307\304\207\304\310\304\310\304\310\304\310\304\310\304\310\
\304\310\304\310\304\310\304\311\304\311\304\211\304\312\304\312\
\304\312\304\312\304\112\304\312\304\213\304\313\304\213\304\313\
\304\314\304\314\304\315\304\315\304\315\304\316\304\321\304\322\
\304\323\305\112\306\000\306\302\306\205\306\311\307\104\307\007\
\310\003\313\205\313\206\313\110\313\211\315\104\315\105\315\006\
\315\106\317\006\317\010\320\207\320\212\320\117\321\002\321\005\
\321\012\321\012\323\301\323\303\323\304\323\105\323\305\323\006\
\323\306\323\107\323\310\323\310\323\311\325\004\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\
")


;;; get/set char's annotation
(defun skk-tankan-get-char-annotation (char)
  (if skk-tankan-annotation-table
      (cond ((eval-when-compile (featurep 'xemacs))
	     (get-char-table char skk-tankan-annotation-table))
	    (t
	     (aref skk-tankan-annotation-table char)))
    nil))

(defun skk-tankan-set-char-annotaion (char annotation)
  (cond ((eval-when-compile (featurep 'xemacs))
	 (put-char-table char annotation skk-tankan-annotation-table))
	(t
	 (aset skk-tankan-annotation-table char annotation))))

;;; get stroke for radical part
(defun skk-tankan-stroke-for-radical (radical dat)
  (let ((v (aref skk-tankan-stroke-for-radical-vector radical)))
    (if (integerp v)
	v
      (nth (lsh dat -6) v))))

;;; get char's radical, strokes in radical, total strokes
(defun skk-tankan-get-char-data (char)
  "$BJ8;z$rI=$9@0?t(B CHAR $B$rM?$($k$H!"$=$NJ8;z$K4X$9$kIt<s!"It<sFb2h?t!"Am2h?t$r(B
$B%j%9%H$GJV$9!#(B

\(string-to-char \"$BC1(B\"\)
 => 57777

\(skk-tankan-get-char-data 57777\)
 => \(24 7 9\)

\(aref skk-tankan-radical-vector 24\)
 => \"$B==(B\"
"
  (let* ((charset (if (eval-when-compile (and skk-running-gnu-emacs
					      (>= emacs-major-version 23)))
		      ;; GNU Emacs 23.1 or later
		      (char-charset char skk-charset-list)
		    (char-charset char))) ; => 'japanese-jisx0208
					  ; or 'japanese-jisx0213-2
	(fun (cdr (assq charset skk-tankan-get-char-data-functions))))
    ;;
    (or (and fun
	     (funcall fun char))	; => skk-tankan-get-char-data-0213-1
	(list 0 0 0))))

(defun skk-tankan-get-char-data-0213-1 (char)
  (skk-tankan-get-char-data-internal char #'skk-tankan-encode-0213-1
				     skk-tankan-radical-stroke-table-0213-1))

(defun skk-tankan-get-char-data-0213-2 (char)
  (skk-tankan-get-char-data-internal char #'skk-tankan-encode-0213-2
				     skk-tankan-radical-stroke-table-0213-2))

(defun skk-tankan-get-char-data-internal (char encoder table)
  (let ((n (funcall encoder char))
	radical dat stroke)
    (if (null n)
	nil
      (setq n (* 2 n)			; table $B$O!"(B1$BJ8;z$"$?$j(B 2byte $B$r;HMQ(B
	    radical (aref table n)	; $BIt<sHV9f(B
	    dat (aref table (1+ n))	;
	    stroke (logand 63 dat))	; $BIt<sFb2h?t(B
      (list radical stroke
	    (+ stroke (skk-tankan-stroke-for-radical radical dat))))))

;; (string-to-char "$B0!(B")  => 55329
;; (split-char 55329)     => (japanese-jisx0208 48 33)
;; split-char $B$N7k2L$r(B16$B?J$KD>$9$H(B JIS$B%3!<%I(B $B$,F@$i$l$k!#(B
;; (format "%x %x" 48 33) => "30 21" 

;; ?! = 33 = 0x21
;; 01$B6h!A(B13$B6h$^$G$OHs4A;zNN0h(B
;; $B6h$R$H$DEv$?$j(B (- (* 16 6) 2) = 94

;; (skk-tankan-encode-0213-1 55329) => 188

(defun skk-tankan-encode-0213-1 (char)
  (let* ((l (split-char char))
	 (n (+ (* 94 (- (nth 1 l) ?! 13)) (- (nth 2 l) ?!))))
    (and (>= n 0) n)))

(defun skk-tankan-encode-0213-2 (char)
  (let* ((l (skk-split-char char))
	 (ku (- (nth 1 l) ?!))
	 (tmp (if (>= ku 77)
		  (- ku 68)
		(cdr (assq ku '((0 . 0) (2 . 1) (3 . 2) (4 . 3) (7 . 4)
				(11 . 5) (12 . 6) (13 . 7) (14 . 8)))))))
    (and tmp
	 (+ (* 94 tmp) (- (nth 2 l) ?!)))))

(defun skk-search-by-stroke-or-radical-sub (high himax lomin lomax num i charset)
  (let (low char list)
    (while (<= high himax)
      (setq low lomin)
      (while (<= low lomax)
	(setq char (make-char charset high low))
	(if (= num (nth i (skk-tankan-get-char-data char)))
	    (setq list (cons (char-to-string char) list)))
	(setq low (1+ low)))
      (setq high (1+ high)))
    list))

(defun skk-search-by-stroke-or-radical (num method)
  "JIS X 0208 $BKt$O(B JIS X 0213-[12] $B$NJ8;z=89g$N$&$A;XDj$NJ}K!$GC14A;z$r8!:w$9$k!#(B
NUM $B$O?tCM$G$"$j!"(BMETHOD $B$,(B 0 $B$G$"$l$PIt<sHV9f$H$7$F!"(B
METHOD $B$,(B 2 $B$G$"$l$PAm2h?t$H$7$F8!:w$r<B9T$9$k!#(B
$BLa$jCM$O(B (\"$BNO(B\" \"$BN;(B\" \"$BKt(B\" $B!D(B) $B$N%j%9%H$G$"$k!#(B"
  ;; TODO
  ;; $B2s$j$/$I$$%k!<%W$H(B skk-tankan-get-char-data $B7PM3$OL@$i$+$KL5BL!#(B
  ;; skk-tankan-radical-stroke-table-0213-1 $B$rD>@\;2>H$9$k$h$&=q$-49$($k!#(B
  ;; $B",$N(B 1st byte $B$,It<sHV9f!#(B
  ;; $B",$N(B 2nd byte + skk-tankan-stroke-for-radical-vector $B$,Am2h?t!#(B
  ;; index $B$+$i(B char $B$X$O(B skk-tankan-encode-0213-1 $B$r5U;;$9$l$P2DG=!#(B

  (if (or (and skk-running-gnu-emacs
	       (>= emacs-major-version 23))
	  (featurep 'jisx0213))		; Mule-UCS
      ;; JIS X 0213
      (append
       (skk-search-by-stroke-or-radical-sub ?\x2e ?\x7e ?\x21 ?\x7e
					    num method 'japanese-jisx0213-1)
       (skk-search-by-stroke-or-radical-sub ?\x21 ?\x21 ?\x21 ?\x7e
					    num method 'japanese-jisx0213-2)
       (skk-search-by-stroke-or-radical-sub ?\x23 ?\x25 ?\x21 ?\x7e
					    num method 'japanese-jisx0213-2)
       (skk-search-by-stroke-or-radical-sub ?\x28 ?\x28 ?\x21 ?\x7e
					    num method 'japanese-jisx0213-2)
       (skk-search-by-stroke-or-radical-sub ?\x2c ?\x2f ?\x21 ?\x7e
					    num method 'japanese-jisx0213-2)
       (skk-search-by-stroke-or-radical-sub ?\x6e ?\x7e ?\x21 ?\x7e
					    num method 'japanese-jisx0213-2)
       )
    ;; JIS X 0208
    (let ((charset 'japanese-jisx0208))
      (append
       (skk-search-by-stroke-or-radical-sub ?\x30 ?\x4e ?\x21 ?\x7e num method charset)
       (skk-search-by-stroke-or-radical-sub ?\x4f ?\x4f ?\x21 ?\x53 num method charset)
       (skk-search-by-stroke-or-radical-sub ?\x50 ?\x73 ?\x21 ?\x7e num method charset)
       (skk-search-by-stroke-or-radical-sub ?\x74 ?\x74 ?\x21 ?\x26 num method charset)
       ))))

(defun skk-tankan-bushu-compread ()
  "$BG[Ns(B `skk-tankan-radical-vector' $B$NFbMF$r0lMwI=<($7$FA*Br$9$k!#(B
$BLa$jCM$O?tCM$G$"$k!#(B"
  ;; Memo
  ;;   skk-tankan-radical-vector $B$O8GDjCM!JITJQ!K$J$N$G!"(B
  ;;   $BK\Mh$G$"$l$P(B alist $B$bF0E*$K@8@.$;$:$K8GDjCM$GNI$$!#(B
  ;;   $B$?$@$7!"(Bface $B$rF3F~$7$F$7$^$C$?(B(2011-1-3)$B$N$G!"F0E*$K(B face $B$rE,MQ$5$;$k$?$a(B
  ;;   $BEvLL$O(B alist $B$bF0E*$K@8@.$9$k!#(B
  (let ((i 1)
	(len (length skk-tankan-radical-vector))
	alist)
    (while (< i len)
      (setq alist (cons (list (concat (format "%03d " i)
				      (propertize
				       (aref skk-tankan-radical-vector i)
				       'face 'skk-tankan-face)
				      (propertize
				       (concat " ("
					       (aref skk-tankan-radical-name i)
					       ")")
				       'face 'skk-tankan-radical-name-face)))
			alist))
      (setq i (1+ i)))

    (setq i (string-to-number (completing-read "$BIt<s$rHV9f$GA*Br!J(BTAB$B$G0lMwI=<(!K(B: "
					       alist nil t)))
    (message "%s %s"
	     (aref skk-tankan-radical-vector i)
	     (aref skk-tankan-radical-name i))
    i))

(defun skk-tankan-mode ()
  "Major mode for skk-tankan.

\\{skk-tankan-mode-map}"
  (kill-all-local-variables)
  (setq mode-name "skk-tankan"
	major-mode 'skk-tankan-mode)
  (use-local-map skk-tankan-mode-map))

(defconst skk-tankan-name-radical-alist
  (let ((i 1)
	alist)
    (mapc #'(lambda (radical)
	      (mapc #'(lambda (yomi)
			(setq alist
			      (cons (cons (format "%-16s (%03d) %s" yomi i radical)
					  nil)
				    alist)))
		    (split-string (aref skk-tankan-radical-name i) "$B!"(B"))
	      (setq i (1+ i)))
	  (cdr (append skk-tankan-radical-vector nil)))
    alist))

(defun skk-tankan-yomi-compread ()
  (let ((radical (completing-read "$BIt<s$rFI$_$GA*Br!J(BTAB$B$G0lMwI=<(!K(B: "
				  skk-tankan-name-radical-alist nil t)))
    (if (equal "" radical)
	0
      (save-match-data
	(string-match "(\\(.+\\))" radical)
	(string-to-number (substring radical (match-beginning 1) (match-end 1)))))))

;;;###autoload
(defun skk-tankan (arg)
  "$BC14A;zJQ49$r3+;O$9$k!#(B
\\[skk-tankan] $B$GIt<sJQ49$r!"(B
\\[universal-argument] $B?tCM(B \\[skk-tankan] $B$GAm2h?tJQ49$r3+;O$9$k!#(B"
  (interactive "P")
  (let (tankan)
    (if (integerp arg)
	(setq tankan (skk-search-by-stroke-or-radical arg 2))
      (let ((i (skk-tankan-bushu-compread)))
	(if (zerop i)
	    (progn
	      (setq i (skk-tankan-yomi-compread))
	      (if (zerop i)
		  (setq tankan nil)
		(setq tankan (skk-search-by-stroke-or-radical i 0))))
	  (setq tankan (skk-search-by-stroke-or-radical i 0)))))

    (when tankan
      (let ((buf (get-buffer-create "*$BC14A;z(B*"))
	    list)
	(setq skk-tankan-mode-original-window-configuration
	      (current-window-configuration))
	(setq list (skk-tankan-select-tankanji-kouho (cons nil tankan)))
	(set-buffer buf)
	(setq buffer-read-only nil)
	(erase-buffer)
	(set-buffer-multibyte t)
	(dolist (str list)
	  (insert (format " %s  %s\n"
			  (propertize (substring str 0 1) 'face 'skk-tankan-face)
			  (substring str 2))))
	(set-buffer-modified-p nil)
	(setq buffer-read-only t)
	(pop-to-buffer "*$BC14A;z(B*")
	(goto-char (point-min))
	(skk-tankan-mode)
	(skk-tankan-overlay)))))

(defun skk-tankan-overlay ()
  (or skk-tankan-overlay
      (progn
	(make-local-variable 'skk-tankan-overlay)
	(setq skk-tankan-overlay (make-overlay (point) (point)))))
  (move-overlay skk-tankan-overlay
		(line-beginning-position)
		(line-end-position))
  (overlay-put skk-tankan-overlay 'face
	       'highlight))

(defun skk-tankan-mode-prev ()
  (interactive)
  (forward-line -1)
  (skk-tankan-overlay))

(defun skk-tankan-mode-next ()
  (interactive)
  (forward-line)
  (if (eobp)
      (forward-line -1))
  (skk-tankan-overlay))

(defun skk-tankan-mode-copy ()
  (interactive)
  (if (eobp)
      (forward-line -1))
  (beginning-of-line)
  (let ((str (char-to-string (char-after (1+ (point))))))
    (kill-new str)
    (message "`%s' copied." str)))

(defun skk-tankan-mode-quit ()
  (interactive)
  (kill-buffer "*$BC14A;z(B*")
  (set-window-configuration skk-tankan-mode-original-window-configuration))

(defun skk-tankan-mode-display-code ()
  (interactive)
;;   (skk-display-code (char-after (1+ (point))))
  )

;;;###autoload
(defun skk-tankan-search (func &rest args)
  "$BJQ?t(B `skk-henkan-key' $B$G;XDj$5$l$?!VFI$_!W$K4p$E$$$FC14A;zJQ49$r<B9T$9$k!#(B
$BDL>o$O(B `skk-search-prog-list' $B$N#1MWAG$H$7$F<!$N7A<0$G;XDj$5$l$k!#(B
'(skk-tankan-search 'skk-search-jisyo-file
                    skk-large-jisyo 10000))"
  (when (string-match (format "%s$" (regexp-quote
				     (char-to-string skk-tankan-search-key)))
		      skk-henkan-key)
    (let ((skk-henkan-key (substring skk-henkan-key 0 (match-beginning 0))))
      ;; get KOUHO list
      (skk-tankan-select-tankanji-kouho
       (cons nil (cond
		  ;; $B"&(B12@ <SPC> => $BAm2h?tJQ49(B
		  ((string-match "^[0-9]+$" skk-henkan-key)
		   (skk-search-by-stroke-or-radical
		    (string-to-number skk-henkan-key) 2))
		  ;; $B"&(B@@ <SPC> => $BIt<sJQ49(B
		  ((equal (char-to-string skk-tankan-search-key)
			  skk-henkan-key)
		   (skk-search-by-stroke-or-radical
		    (skk-tankan-bushu-compread) 0))
		  ;; $B"&$"(B <SPC> => "$BFI$_(B"$BC14A;zJQ49(B
		  (t
		   (apply func args))))))))

(defun skk-tankan-select-tankanji-kouho (lis)
  (let ((top lis)
	tmp)
    ;; select TANKANJI KOUHO
    (while (cdr lis)
      ;; remove annotation
      (setq tmp (nth 1 lis))
      (if (string-match ";" tmp)
	  (setq tmp (substring tmp 0 (match-beginning 0))))
      (if (not (string-match "^.$" tmp))
	  (setcdr lis (cddr lis))
	(setq lis (cdr lis))
	(setq tmp (string-to-char tmp)
	      tmp (cons tmp (cons (skk-tankan-get-char-annotation tmp)
				  (skk-tankan-get-char-data tmp))))
	(setcar lis tmp)))
    ;; sort KOUHO by KAKUSUU(or BUSYU)
    (setq lis (sort (cdr top)
		    (lambda (x y)
		      (let ((xa (nth 2 x)) (xb (nth 3 x)) (xc (nth 4 x))
			    (ya (nth 2 y)) (yb (nth 3 y)) (yc (nth 4 y)))
			(if (= xc yc)
			    (if (= xa ya)
				(if (= xb yb)
				    (< (car x) (car y))
				  (< xb yb))
			      (< xa ya))
			  (< xc yc))))))
    ;; return list with annotation
    (mapcar (lambda (cell)
	      (let ((anno (if (zerop (nth 2 cell))
			      (nth 1 cell)
			    (format "%d$B2h(B(%s$BIt(B%d$B2h(B)%s"
				    (nth 4 cell)
				    (aref skk-tankan-radical-vector
					  (nth 2 cell))
				    (nth 3 cell)
				    (or (nth 1 cell) "")
				    ))))
		(if (zerop (length anno))
		    (char-to-string (car cell))
		  (concat (char-to-string (car cell)) ";" anno))))
	    lis)))

;;;###autoload
(defun skk-search-tankanji (&optional jisyo)
  (let ((skk-henkan-key (concat skk-henkan-key
				(char-to-string skk-tankan-search-key)))
	(server-prog (if skk-server-host
			 (assq 'skk-search-server skk-search-prog-list)
		       nil)))
    (or (cond
	 ((and (stringp jisyo) (file-readable-p jisyo))
	  (skk-tankan-search 'skk-search-jisyo-file jisyo 10000))
	 ((and (stringp skk-cdb-large-jisyo)
	       (file-readable-p skk-cdb-large-jisyo))
	  (skk-tankan-search 'skk-search-cdb-jisyo skk-cdb-large-jisyo))
	 ((and (stringp skk-large-jisyo)
	       (file-readable-p skk-large-jisyo))
	  (skk-tankan-search 'skk-search-jisyo-file skk-large-jisyo 10000))
	 (t
	  (skk-tankan-search 'skk-search-ja-dic-maybe)))
	(if server-prog
	    (apply #'skk-tankan-search server-prog)
	  nil))))


;;; annotation data for japanese-jisx0208
(when skk-tankan-annotation-table
  (let ((l '(

(?$B!!(B "$BOB;z4V3V(B,IDEOGRAPHIC SPACE")
(?$B!"(B "$BFIE@(B,IDEOGRAPHIC COMMA")
(?$B!#(B "$B6gE@(B,IDEOGRAPHIC FULL STOP")
(?$B!$(B "$B%3%s%^(B,COMMA")
(?$B!%(B "$B%T%j%*%I(B,FULL STOP")
(?$B!&(B "$BCfE@(B,KATAKANA MIDDLE DOT")
(?$B!'(B "$B%3%m%s(B,COLON")
(?$B!((B "$B%;%_%3%m%s(B,SEMICOLON")
(?$B!)(B "$B5?LdId(B,QUESTION MARK")
(?$B!*(B "$B46C2Id(B,EXCLAMATION MARK")
(?$B!+(B "$BByE@(B,KATAKANA-HIRAGANA VOICED SOUND MARK")
(?$B!,(B "$BH>ByE@(B,KATAKANA-HIRAGANA SEMI-VOICED SOUND MARK")
(?$B!-(B "$B%"%/%5%s%F%.%e(B,$B%"%-%e!<%H%"%/%;%s%H(B,$B%W%i%$%`5-9f(B,ACUTE ACCENT")
(?$B!.(B "$B%"%/%5%s%0%i!<%V(B,$B%0%l!<%V%"%/%;%s%H(B,GRAVE ACCENT")
(?$B!/(B "$B%&%`%i%&%H(B,$B%@%$%(%l%7%9(B,DIAERESIS")
(?$B!0(B "$B%"%/%5%s%7%k%3%s%U%l%C%/%9(B,$B%5!<%+%`%U%l%C%/%9%"%/%;%s%H(B,CIRCUMFLEX ACCENT")
(?$B!1(B "$B%*!<%P!<%i%$%s(B,$BO@M}H]Dj5-9f(B,OVERLINE")
(?$B!2(B "$B%"%s%@!<%i%$%s(B,LOW LINE")
(?$B!3(B "$BJR2>L>7+JV$75-9f(B,KATAKANA ITERATION MARK")
(?$B!4(B "$BJR2>L>7+JV$75-9f(B($BByE@(B),KATAKANA VOICED ITERATION MARK")
(?$B!5(B "$BJ?2>L>7+JV$75-9f(B,HIRAGANA ITERATION MARK")
(?$B!6(B "$BJ?2>L>7+JV$75-9f(B($BByE@(B),HIRAGANA VOICED ITERATION MARK")
(?$B!7(B "$BF1$8$/5-9f(B,DITTO MARK")
(?$B!8(B "$BF1>e5-9f(B,CJK UNIFIED IDEOGRAPH-4EDD")
(?$B!9(B "$B7+JV$75-9f(B,IDEOGRAPHIC ITERATION MARK")
(?$B!:(B "$B$7$a(B,IDEOGRAPHIC CLOSING MARK")
(?$B!;(B "$B4A?t;z%<%m(B,IDEOGRAPHIC NUMBER ZERO")
(?$B!<(B "$BD92;5-9f(B,KATAKANA-HIRAGANA PROLONGED SOUND MARK")
(?$B!=(B "$B%@%C%7%e(B($BA43Q(B),EM DASH")
(?$B!>(B "$B%O%$%U%s(B($B;MJ,(B),HYPHEN")
(?$B!?(B "$B<P@~(B,SOLIDUS")
(?$B!@(B "$B5U<P@~(B,REVERSE SOLIDUS")
(?$B!A(B "$BGH%@%C%7%e(B,WAVE DASH")
(?$B!B(B "$BAPCl(B,DOUBLE VERTICAL LINE")
(?$B!C(B "$B=D@~(B,VERTICAL LINE")
(?$B!D(B "$B;0E@%j!<%@(B,HORIZONTAL ELLIPSIS")
(?$B!E(B "$BFsE@%j!<%@(B,TWO DOT LEADER")
(?$B!F(B "$B:8%7%s%0%k0zMQId(B,$B:8%7%s%0%k%/%)!<%F!<%7%g%s%^!<%/(B,LEFT SINGLE QUOTATION MARK")
(?$B!G(B "$B1&%7%s%0%k0zMQId(B,$B1&%7%s%0%k%/%)!<%F!<%7%g%s%^!<%/(B,RIGHT SINGLE QUOTATION MARK")
(?$B!H(B "$B:8%@%V%k0zMQId(B,$B:8%@%V%k%/%)!<%F!<%7%g%s%^!<%/(B,LEFT DOUBLE QUOTATION MARK")
(?$B!I(B "$B1&%@%V%k0zMQId(B,$B1&%@%V%k%/%)!<%F!<%7%g%s%^!<%/(B,RIGHT DOUBLE QUOTATION MARK")
(?$B!J(B "$B;O$a>.3g8L(B,$B;O$a4]3g8L(B,LEFT PARENTHESIS")
(?$B!K(B "$B=*$o$j>.3g8L(B,$B=*$o$j4]3g8L(B,RIGHT PARENTHESIS")
(?$B!L(B "$B;O$a$-$C$3$&(B($B559C(B)$B3g8L(B,LEFT TORTOISE SHELL BRACKET")
(?$B!M(B "$B=*$o$j$-$C$3$&(B($B559C(B)$B3g8L(B,RIGHT TORTOISE SHELL BRACKET")
(?$B!N(B "$B;O$aBg3g8L(B,$B;O$a3Q3g8L(B,LEFT SQUARE BRACKET")
(?$B!O(B "$B=*$o$jBg3g8L(B,$B=*$o$j3Q3g8L(B,RIGHT SQUARE BRACKET")
(?$B!P(B "$B;O$aCf3g8L(B,$B;O$aGH3g8L(B,LEFT CURLY BRACKET")
(?$B!Q(B "$B=*$o$jCf3g8L(B,$B=*$o$jGH3g8L(B,RIGHT CURLY BRACKET")
(?$B!R(B "$B;O$a;33g8L(B,LEFT ANGLE BRACKET")
(?$B!S(B "$B=*$o$j;33g8L(B,RIGHT ANGLE BRACKET")
(?$B!T(B "$B;O$aFs=E;33g8L(B,LEFT DOUBLE ANGLE BRACKET")
(?$B!U(B "$B=*$o$jFs=E;33g8L(B,RIGHT DOUBLE ANGLE BRACKET")
(?$B!V(B "$B;O$a$+$.3g8L(B,LEFT CORNER BRACKET")
(?$B!W(B "$B=*$o$j$+$.3g8L(B,RIGHT CORNER BRACKET")
(?$B!X(B "$B;O$aFs=E$+$.3g8L(B,LEFT WHITE CORNER BRACKET")
(?$B!Y(B "$B=*$o$jFs=E$+$.3g8L(B,RIGHT WHITE CORNER BRACKET")
(?$B!Z(B "$B;O$a$9$_IU$-3g8L(B,LEFT BLACK LENTICULAR BRACKET")
(?$B![(B "$B=*$o$j$9$_IU$-3g8L(B,RIGHT BLACK LENTICULAR BRACKET")
(?$B!\(B "$B@5Id9f(B,$B2C;;5-9f(B,PLUS SIGN")
(?$B!](B "$BIiId9f(B,$B8:;;5-9f(B,MINUS SIGN")
(?$B!^(B "$B@5Kt$OIiId9f(B,PLUS-MINUS SIGN")
(?$B!_(B "$B>h;;5-9f(B,MULTIPLICATION SIGN")
(?$B!`(B "$B=|;;5-9f(B,DIVISION SIGN")
(?$B!a(B "$BEy9f(B,EQUALS SIGN")
(?$B!b(B "$BEy9fH]Dj(B,NOT EQUAL TO")
(?$B!c(B "$BITEy9f(B($B$h$j>.(B),LESS-THAN SIGN")
(?$B!d(B "$BITEy9f(B($B$h$jBg(B),GREATER-THAN SIGN")
(?$B!e(B "$B$h$j>.$5$$$+Kt$OEy$7$$(B,LESS-THAN OVER EQUAL TO")
(?$B!f(B "$B$h$jBg$-$$$+Kt$OEy$7$$(B,GREATER-THAN OVER EQUAL TO")
(?$B!g(B "$BL58BBg(B,INFINITY")
(?$B!h(B "$B$f$($K(B,THEREFORE")
(?$B!i(B "$BM:5-9f(B,MALE SIGN")
(?$B!j(B "$B;s5-9f(B,FEMALE SIGN")
(?$B!k(B "$BEY(B,DEGREE SIGN")
(?$B!l(B "$BJ,(B,PRIME")
(?$B!m(B "$BIC(B,DOUBLE PRIME")
(?$B!n(B "$B%;;aEY5-9f(B,DEGREE CELSIUS")
(?$B!o(B "$B1_5-9f(B,YEN SIGN")
(?$B!p(B "$B%I%k5-9f(B,DOLLAR SIGN")
(?$B!q(B "$B%;%s%H5-9f(B,CENT SIGN")
(?$B!r(B "$B%]%s%I5-9f(B,POUND SIGN")
(?$B!s(B "$B%Q!<%;%s%H5-9f(B,PERCENT SIGN")
(?$B!t(B "$BHV9f5-9f(B,$B0f$2$?(B,NUMBER SIGN")
(?$B!u(B "$B%"%s%Q%5%s%I(B,AMPERSAND")
(?$B!v(B "$B@10u(B,$B%"%9%F%j%9%/(B,ASTERISK")
(?$B!w(B "$BC12A5-9f(B,COMMERCIAL AT")
(?$B!x(B "$B@a5-9f(B,SECTION SIGN")
(?$B!y(B "$BGr@1(B,WHITE STAR")
(?$B!z(B "$B9u@1(B,BLACK STAR")
(?$B!{(B "$B4]0u(B,$BGr4](B,WHITE CIRCLE")
(?$B!|(B "$B9u4](B,BLACK CIRCLE")
(?$B!}(B "$BFs=E4](B,BULLSEYE")
(?$B!~(B "$B$R$77A(B,WHITE DIAMOND")
(?$B"!(B "$B9u$R$77A(B,BLACK DIAMOND")
(?$B""(B "$B;M3Q(B,WHITE SQUARE")
(?$B"#(B "$B9u;M3Q(B,BLACK SQUARE")
(?$B"$(B "$B;03Q(B,WHITE UP-POINTING TRIANGLE")
(?$B"%(B "$B9u;03Q(B,BLACK UP-POINTING TRIANGLE")
(?$B"&(B "$B5U;03Q(B,WHITE DOWN-POINTING TRIANGLE")
(?$B"'(B "$B5U9u;03Q(B,BLACK DOWN-POINTING TRIANGLE")
(?$B"((B "$BJF0u(B,REFERENCE MARK")
(?$B")(B "$BM9JX5-9f(B,POSTAL MARK")
(?$B"*(B "$B1&Lp0u(B,RIGHTWARDS ARROW")
(?$B"+(B "$B:8Lp0u(B,LEFTWARDS ARROW")
(?$B",(B "$B>eLp0u(B,UPWARDS ARROW")
(?$B"-(B "$B2<Lp0u(B,DOWNWARDS ARROW")
(?$B".(B "$B$2$?5-9f(B,GETA MARK")
(?$B":(B "$BB0$9$k(B,ELEMENT OF")
(?$B";(B "$B85$H$7$F4^$`(B,CONTAINS AS MEMBER")
(?$B"<(B "$BItJ,=89g(B,SUBSET OF OR EQUAL TO")
(?$B"=(B "$BItJ,=89g(B($B5UJ}8~(B),SUPERSET OF OR EQUAL TO")
(?$B">(B "$B??ItJ,=89g(B,SUBSET OF")
(?$B"?(B "$B??ItJ,=89g(B($B5UJ}8~(B),SUPERSET OF")
(?$B"@(B "$B9gJ;=89g(B,UNION")
(?$B"A(B "$B6&DL=89g(B,INTERSECTION")
(?$B"J(B "$B5Z$S(B($B9g@\(B),LOGICAL AND")
(?$B"K(B "$BKt$O(B($BN%@\(B),LOGICAL OR")
(?$B"L(B "$BH]Dj(B,NOT SIGN")
(?$B"M(B "$B$J$i$P(B($B4^0U(B),RIGHTWARDS DOUBLE ARROW")
(?$B"N(B "$BF1CM(B,LEFT RIGHT DOUBLE ARROW")
(?$B"O(B "$B$9$Y$F$N(B($BIaDL8BDj;R(B),FOR ALL")
(?$B"P(B "$BB8:_$9$k(B($BB8:_8BDj;R(B),THERE EXISTS")
(?$B"\(B "$B3Q(B,ANGLE")
(?$B"](B "$B?bD>(B,UP TACK")
(?$B"^(B "$B8L(B,ARC")
(?$B"_(B "$B%G%k(B,$B%i%&%s%I%G%#!<(B,PARTIAL DIFFERENTIAL")
(?$B"`(B "$B%J%V%i(B,NABLA")
(?$B"a(B "$B>o$KEy$7$$(B,$B9gF1(B,IDENTICAL TO")
(?$B"b(B "$B$[$H$s$IEy$7$$(B,APPROXIMATELY EQUAL TO OR THE IMAGE OF")
(?$B"c(B "$BHs>o$K>.$5$$(B,MUCH LESS-THAN")
(?$B"d(B "$BHs>o$KBg$-$$(B,MUCH GREATER-THAN")
(?$B"e(B "$B:,9f(B,SQUARE ROOT")
(?$B"f(B "$BAj;w(B,REVERSED TILDE")
(?$B"g(B "$BHfNc(B,PROPORTIONAL TO")
(?$B"h(B "$B$J$<$J$i$P(B,BECAUSE")
(?$B"i(B "$B@QJ,5-9f(B,INTEGRAL")
(?$B"j(B "2$B=E@QJ,5-9f(B,DOUBLE INTEGRAL")
(?$B"r(B "$B%*%s%0%9%H%m!<%`(B,ANGSTROM SIGN")
(?$B"s(B "$B%Q!<%_%k(B,PER MILLE SIGN")
(?$B"t(B "$B%7%c!<%W(B,MUSIC SHARP SIGN")
(?$B"u(B "$B%U%i%C%H(B,MUSIC FLAT SIGN")
(?$B"v(B "$B2;Id(B,EIGHTH NOTE")
(?$B"w(B "$B%@%,!<(B,DAGGER")
(?$B"x(B "$B%@%V%k%@%,!<(B,DOUBLE DAGGER")
(?$B"y(B "$BCJMn5-9f(B,PILCROW SIGN")
(?$B"~(B "$BBg$-$J4](B,LARGE CIRCLE")
(?$B#0(B "0,DIGIT ZERO")
(?$B#1(B "1,DIGIT ONE")
(?$B#2(B "2,DIGIT TWO")
(?$B#3(B "3,DIGIT THREE")
(?$B#4(B "4,DIGIT FOUR")
(?$B#5(B "5,DIGIT FIVE")
(?$B#6(B "6,DIGIT SIX")
(?$B#7(B "7,DIGIT SEVEN")
(?$B#8(B "8,DIGIT EIGHT")
(?$B#9(B "9,DIGIT NINE")
(?$B#A(B "$B%i%F%sBgJ8;z(BA,LATIN CAPITAL LETTER A")
(?$B#B(B "$B%i%F%sBgJ8;z(BB,LATIN CAPITAL LETTER B")
(?$B#C(B "$B%i%F%sBgJ8;z(BC,LATIN CAPITAL LETTER C")
(?$B#D(B "$B%i%F%sBgJ8;z(BD,LATIN CAPITAL LETTER D")
(?$B#E(B "$B%i%F%sBgJ8;z(BE,LATIN CAPITAL LETTER E")
(?$B#F(B "$B%i%F%sBgJ8;z(BF,LATIN CAPITAL LETTER F")
(?$B#G(B "$B%i%F%sBgJ8;z(BG,LATIN CAPITAL LETTER G")
(?$B#H(B "$B%i%F%sBgJ8;z(BH,LATIN CAPITAL LETTER H")
(?$B#I(B "$B%i%F%sBgJ8;z(BI,LATIN CAPITAL LETTER I")
(?$B#J(B "$B%i%F%sBgJ8;z(BJ,LATIN CAPITAL LETTER J")
(?$B#K(B "$B%i%F%sBgJ8;z(BK,LATIN CAPITAL LETTER K")
(?$B#L(B "$B%i%F%sBgJ8;z(BL,LATIN CAPITAL LETTER L")
(?$B#M(B "$B%i%F%sBgJ8;z(BM,LATIN CAPITAL LETTER M")
(?$B#N(B "$B%i%F%sBgJ8;z(BN,LATIN CAPITAL LETTER N")
(?$B#O(B "$B%i%F%sBgJ8;z(BO,LATIN CAPITAL LETTER O")
(?$B#P(B "$B%i%F%sBgJ8;z(BP,LATIN CAPITAL LETTER P")
(?$B#Q(B "$B%i%F%sBgJ8;z(BQ,LATIN CAPITAL LETTER Q")
(?$B#R(B "$B%i%F%sBgJ8;z(BR,LATIN CAPITAL LETTER R")
(?$B#S(B "$B%i%F%sBgJ8;z(BS,LATIN CAPITAL LETTER S")
(?$B#T(B "$B%i%F%sBgJ8;z(BT,LATIN CAPITAL LETTER T")
(?$B#U(B "$B%i%F%sBgJ8;z(BU,LATIN CAPITAL LETTER U")
(?$B#V(B "$B%i%F%sBgJ8;z(BV,LATIN CAPITAL LETTER V")
(?$B#W(B "$B%i%F%sBgJ8;z(BW,LATIN CAPITAL LETTER W")
(?$B#X(B "$B%i%F%sBgJ8;z(BX,LATIN CAPITAL LETTER X")
(?$B#Y(B "$B%i%F%sBgJ8;z(BY,LATIN CAPITAL LETTER Y")
(?$B#Z(B "$B%i%F%sBgJ8;z(BZ,LATIN CAPITAL LETTER Z")
(?$B#a(B "$B%i%F%s>.J8;z(BA,LATIN SMALL LETTER A")
(?$B#b(B "$B%i%F%s>.J8;z(BB,LATIN SMALL LETTER B")
(?$B#c(B "$B%i%F%s>.J8;z(BC,LATIN SMALL LETTER C")
(?$B#d(B "$B%i%F%s>.J8;z(BD,LATIN SMALL LETTER D")
(?$B#e(B "$B%i%F%s>.J8;z(BE,LATIN SMALL LETTER E")
(?$B#f(B "$B%i%F%s>.J8;z(BF,LATIN SMALL LETTER F")
(?$B#g(B "$B%i%F%s>.J8;z(BG,LATIN SMALL LETTER G")
(?$B#h(B "$B%i%F%s>.J8;z(BH,LATIN SMALL LETTER H")
(?$B#i(B "$B%i%F%s>.J8;z(BI,LATIN SMALL LETTER I")
(?$B#j(B "$B%i%F%s>.J8;z(BJ,LATIN SMALL LETTER J")
(?$B#k(B "$B%i%F%s>.J8;z(BK,LATIN SMALL LETTER K")
(?$B#l(B "$B%i%F%s>.J8;z(BL,LATIN SMALL LETTER L")
(?$B#m(B "$B%i%F%s>.J8;z(BM,LATIN SMALL LETTER M")
(?$B#n(B "$B%i%F%s>.J8;z(BN,LATIN SMALL LETTER N")
(?$B#o(B "$B%i%F%s>.J8;z(BO,LATIN SMALL LETTER O")
(?$B#p(B "$B%i%F%s>.J8;z(BP,LATIN SMALL LETTER P")
(?$B#q(B "$B%i%F%s>.J8;z(BQ,LATIN SMALL LETTER Q")
(?$B#r(B "$B%i%F%s>.J8;z(BR,LATIN SMALL LETTER R")
(?$B#s(B "$B%i%F%s>.J8;z(BS,LATIN SMALL LETTER S")
(?$B#t(B "$B%i%F%s>.J8;z(BT,LATIN SMALL LETTER T")
(?$B#u(B "$B%i%F%s>.J8;z(BU,LATIN SMALL LETTER U")
(?$B#v(B "$B%i%F%s>.J8;z(BV,LATIN SMALL LETTER V")
(?$B#w(B "$B%i%F%s>.J8;z(BW,LATIN SMALL LETTER W")
(?$B#x(B "$B%i%F%s>.J8;z(BX,LATIN SMALL LETTER X")
(?$B#y(B "$B%i%F%s>.J8;z(BY,LATIN SMALL LETTER Y")
(?$B#z(B "$B%i%F%s>.J8;z(BZ,LATIN SMALL LETTER Z")
(?$B$!(B "$B>.=q$-J?2>L>$"(B,HIRAGANA LETTER SMALL A")
(?$B$"(B "$BJ?2>L>$"(B,HIRAGANA LETTER A")
(?$B$#(B "$B>.=q$-J?2>L>$$(B,HIRAGANA LETTER SMALL I")
(?$B$$(B "$BJ?2>L>$$(B,HIRAGANA LETTER I")
(?$B$%(B "$B>.=q$-J?2>L>$&(B,HIRAGANA LETTER SMALL U")
(?$B$&(B "$BJ?2>L>$&(B,HIRAGANA LETTER U")
(?$B$'(B "$B>.=q$-J?2>L>$((B,HIRAGANA LETTER SMALL E")
(?$B$((B "$BJ?2>L>$((B,HIRAGANA LETTER E")
(?$B$)(B "$B>.=q$-J?2>L>$*(B,HIRAGANA LETTER SMALL O")
(?$B$*(B "$BJ?2>L>$*(B,HIRAGANA LETTER O")
(?$B$+(B "$BJ?2>L>$+(B,HIRAGANA LETTER KA")
(?$B$,(B "$BByE@IU$-J?2>L>$+(B,HIRAGANA LETTER GA")
(?$B$-(B "$BJ?2>L>$-(B,HIRAGANA LETTER KI")
(?$B$.(B "$BByE@IU$-J?2>L>$-(B,HIRAGANA LETTER GI")
(?$B$/(B "$BJ?2>L>$/(B,HIRAGANA LETTER KU")
(?$B$0(B "$BByE@IU$-J?2>L>$/(B,HIRAGANA LETTER GU")
(?$B$1(B "$BJ?2>L>$1(B,HIRAGANA LETTER KE")
(?$B$2(B "$BByE@IU$-J?2>L>$1(B,HIRAGANA LETTER GE")
(?$B$3(B "$BJ?2>L>$3(B,HIRAGANA LETTER KO")
(?$B$4(B "$BByE@IU$-J?2>L>$3(B,HIRAGANA LETTER GO")
(?$B$5(B "$BJ?2>L>$5(B,HIRAGANA LETTER SA")
(?$B$6(B "$BByE@IU$-J?2>L>$5(B,HIRAGANA LETTER ZA")
(?$B$7(B "$BJ?2>L>$7(B,HIRAGANA LETTER SI")
(?$B$8(B "$BByE@IU$-J?2>L>$7(B,HIRAGANA LETTER ZI")
(?$B$9(B "$BJ?2>L>$9(B,HIRAGANA LETTER SU")
(?$B$:(B "$BByE@IU$-J?2>L>$9(B,HIRAGANA LETTER ZU")
(?$B$;(B "$BJ?2>L>$;(B,HIRAGANA LETTER SE")
(?$B$<(B "$BByE@IU$-J?2>L>$;(B,HIRAGANA LETTER ZE")
(?$B$=(B "$BJ?2>L>$=(B,HIRAGANA LETTER SO")
(?$B$>(B "$BByE@IU$-J?2>L>$=(B,HIRAGANA LETTER ZO")
(?$B$?(B "$BJ?2>L>$?(B,HIRAGANA LETTER TA")
(?$B$@(B "$BByE@IU$-J?2>L>$?(B,HIRAGANA LETTER DA")
(?$B$A(B "$BJ?2>L>$A(B,HIRAGANA LETTER TI")
(?$B$B(B "$BByE@IU$-J?2>L>$A(B,HIRAGANA LETTER DI")
(?$B$C(B "$B>.=q$-J?2>L>$D(B,HIRAGANA LETTER SMALL TU")
(?$B$D(B "$BJ?2>L>$D(B,HIRAGANA LETTER TU")
(?$B$E(B "$BByE@IU$-J?2>L>$D(B,HIRAGANA LETTER DU")
(?$B$F(B "$BJ?2>L>$F(B,HIRAGANA LETTER TE")
(?$B$G(B "$BByE@IU$-J?2>L>$F(B,HIRAGANA LETTER DE")
(?$B$H(B "$BJ?2>L>$H(B,HIRAGANA LETTER TO")
(?$B$I(B "$BByE@IU$-J?2>L>$H(B,HIRAGANA LETTER DO")
(?$B$J(B "$BJ?2>L>$J(B,HIRAGANA LETTER NA")
(?$B$K(B "$BJ?2>L>$K(B,HIRAGANA LETTER NI")
(?$B$L(B "$BJ?2>L>$L(B,HIRAGANA LETTER NU")
(?$B$M(B "$BJ?2>L>$M(B,HIRAGANA LETTER NE")
(?$B$N(B "$BJ?2>L>$N(B,HIRAGANA LETTER NO")
(?$B$O(B "$BJ?2>L>$O(B,HIRAGANA LETTER HA")
(?$B$P(B "$BByE@IU$-J?2>L>$O(B,HIRAGANA LETTER BA")
(?$B$Q(B "$BH>ByE@IU$-J?2>L>$O(B,HIRAGANA LETTER PA")
(?$B$R(B "$BJ?2>L>$R(B,HIRAGANA LETTER HI")
(?$B$S(B "$BByE@IU$-J?2>L>$R(B,HIRAGANA LETTER BI")
(?$B$T(B "$BH>ByE@IU$-J?2>L>$R(B,HIRAGANA LETTER PI")
(?$B$U(B "$BJ?2>L>$U(B,HIRAGANA LETTER HU")
(?$B$V(B "$BByE@IU$-J?2>L>$U(B,HIRAGANA LETTER BU")
(?$B$W(B "$BH>ByE@IU$-J?2>L>$U(B,HIRAGANA LETTER PU")
(?$B$X(B "$BJ?2>L>$X(B,HIRAGANA LETTER HE")
(?$B$Y(B "$BByE@IU$-J?2>L>$X(B,HIRAGANA LETTER BE")
(?$B$Z(B "$BH>ByE@IU$-J?2>L>$X(B,HIRAGANA LETTER PE")
(?$B$[(B "$BJ?2>L>$[(B,HIRAGANA LETTER HO")
(?$B$\(B "$BByE@IU$-J?2>L>$[(B,HIRAGANA LETTER BO")
(?$B$](B "$BH>ByE@IU$-J?2>L>$[(B,HIRAGANA LETTER PO")
(?$B$^(B "$BJ?2>L>$^(B,HIRAGANA LETTER MA")
(?$B$_(B "$BJ?2>L>$_(B,HIRAGANA LETTER MI")
(?$B$`(B "$BJ?2>L>$`(B,HIRAGANA LETTER MU")
(?$B$a(B "$BJ?2>L>$a(B,HIRAGANA LETTER ME")
(?$B$b(B "$BJ?2>L>$b(B,HIRAGANA LETTER MO")
(?$B$c(B "$B>.=q$-J?2>L>$d(B,HIRAGANA LETTER SMALL YA")
(?$B$d(B "$BJ?2>L>$d(B,HIRAGANA LETTER YA")
(?$B$e(B "$B>.=q$-J?2>L>$f(B,HIRAGANA LETTER SMALL YU")
(?$B$f(B "$BJ?2>L>$f(B,HIRAGANA LETTER YU")
(?$B$g(B "$B>.=q$-J?2>L>$h(B,HIRAGANA LETTER SMALL YO")
(?$B$h(B "$BJ?2>L>$h(B,HIRAGANA LETTER YO")
(?$B$i(B "$BJ?2>L>$i(B,HIRAGANA LETTER RA")
(?$B$j(B "$BJ?2>L>$j(B,HIRAGANA LETTER RI")
(?$B$k(B "$BJ?2>L>$k(B,HIRAGANA LETTER RU")
(?$B$l(B "$BJ?2>L>$l(B,HIRAGANA LETTER RE")
(?$B$m(B "$BJ?2>L>$m(B,HIRAGANA LETTER RO")
(?$B$n(B "$B>.=q$-J?2>L>$o(B,HIRAGANA LETTER SMALL WA")
(?$B$o(B "$BJ?2>L>$o(B,HIRAGANA LETTER WA")
(?$B$p(B "$BJ?2>L>$p(B,HIRAGANA LETTER WI")
(?$B$q(B "$BJ?2>L>$q(B,HIRAGANA LETTER WE")
(?$B$r(B "$BJ?2>L>$r(B,HIRAGANA LETTER WO")
(?$B$s(B "$BJ?2>L>$s(B,HIRAGANA LETTER N")
(?$B%!(B "$B>.=q$-JR2>L>%"(B,KATAKANA LETTER SMALL A")
(?$B%"(B "$BJR2>L>%"(B,KATAKANA LETTER A")
(?$B%#(B "$B>.=q$-JR2>L>%$(B,KATAKANA LETTER SMALL I")
(?$B%$(B "$BJR2>L>%$(B,KATAKANA LETTER I")
(?$B%%(B "$B>.=q$-JR2>L>%&(B,KATAKANA LETTER SMALL U")
(?$B%&(B "$BJR2>L>%&(B,KATAKANA LETTER U")
(?$B%'(B "$B>.=q$-JR2>L>%((B,KATAKANA LETTER SMALL E")
(?$B%((B "$BJR2>L>%((B,KATAKANA LETTER E")
(?$B%)(B "$B>.=q$-JR2>L>%*(B,KATAKANA LETTER SMALL O")
(?$B%*(B "$BJR2>L>%*(B,KATAKANA LETTER O")
(?$B%+(B "$BJR2>L>%+(B,KATAKANA LETTER KA")
(?$B%,(B "$BByE@IU$-JR2>L>%+(B,KATAKANA LETTER GA")
(?$B%-(B "$BJR2>L>%-(B,KATAKANA LETTER KI")
(?$B%.(B "$BByE@IU$-JR2>L>%-(B,KATAKANA LETTER GI")
(?$B%/(B "$BJR2>L>%/(B,KATAKANA LETTER KU")
(?$B%0(B "$BByE@IU$-JR2>L>%/(B,KATAKANA LETTER GU")
(?$B%1(B "$BJR2>L>%1(B,KATAKANA LETTER KE")
(?$B%2(B "$BByE@IU$-JR2>L>%1(B,KATAKANA LETTER GE")
(?$B%3(B "$BJR2>L>%3(B,KATAKANA LETTER KO")
(?$B%4(B "$BByE@IU$-JR2>L>%3(B,KATAKANA LETTER GO")
(?$B%5(B "$BJR2>L>%5(B,KATAKANA LETTER SA")
(?$B%6(B "$BByE@IU$-JR2>L>%5(B,KATAKANA LETTER ZA")
(?$B%7(B "$BJR2>L>%7(B,KATAKANA LETTER SI")
(?$B%8(B "$BByE@IU$-JR2>L>%7(B,KATAKANA LETTER ZI")
(?$B%9(B "$BJR2>L>%9(B,KATAKANA LETTER SU")
(?$B%:(B "$BByE@IU$-JR2>L>%9(B,KATAKANA LETTER ZU")
(?$B%;(B "$BJR2>L>%;(B,KATAKANA LETTER SE")
(?$B%<(B "$BByE@IU$-JR2>L>%;(B,KATAKANA LETTER ZE")
(?$B%=(B "$BJR2>L>%=(B,KATAKANA LETTER SO")
(?$B%>(B "$BByE@IU$-JR2>L>%=(B,KATAKANA LETTER ZO")
(?$B%?(B "$BJR2>L>%?(B,KATAKANA LETTER TA")
(?$B%@(B "$BByE@IU$-JR2>L>%?(B,KATAKANA LETTER DA")
(?$B%A(B "$BJR2>L>%A(B,KATAKANA LETTER TI")
(?$B%B(B "$BByE@IU$-JR2>L>%A(B,KATAKANA LETTER DI")
(?$B%C(B "$B>.=q$-JR2>L>%D(B,KATAKANA LETTER SMALL TU")
(?$B%D(B "$BJR2>L>%D(B,KATAKANA LETTER TU")
(?$B%E(B "$BByE@IU$-JR2>L>%D(B,KATAKANA LETTER DU")
(?$B%F(B "$BJR2>L>%F(B,KATAKANA LETTER TE")
(?$B%G(B "$BByE@IU$-JR2>L>%F(B,KATAKANA LETTER DE")
(?$B%H(B "$BJR2>L>%H(B,KATAKANA LETTER TO")
(?$B%I(B "$BByE@IU$-JR2>L>%H(B,KATAKANA LETTER DO")
(?$B%J(B "$BJR2>L>%J(B,KATAKANA LETTER NA")
(?$B%K(B "$BJR2>L>%K(B,KATAKANA LETTER NI")
(?$B%L(B "$BJR2>L>%L(B,KATAKANA LETTER NU")
(?$B%M(B "$BJR2>L>%M(B,KATAKANA LETTER NE")
(?$B%N(B "$BJR2>L>%N(B,KATAKANA LETTER NO")
(?$B%O(B "$BJR2>L>%O(B,KATAKANA LETTER HA")
(?$B%P(B "$BByE@IU$-JR2>L>%O(B,KATAKANA LETTER BA")
(?$B%Q(B "$BH>ByE@IU$-JR2>L>%O(B,KATAKANA LETTER PA")
(?$B%R(B "$BJR2>L>%R(B,KATAKANA LETTER HI")
(?$B%S(B "$BByE@IU$-JR2>L>%R(B,KATAKANA LETTER BI")
(?$B%T(B "$BH>ByE@IU$-JR2>L>%R(B,KATAKANA LETTER PI")
(?$B%U(B "$BJR2>L>%U(B,KATAKANA LETTER HU")
(?$B%V(B "$BByE@IU$-JR2>L>%U(B,KATAKANA LETTER BU")
(?$B%W(B "$BH>ByE@IU$-JR2>L>%U(B,KATAKANA LETTER PU")
(?$B%X(B "$BJR2>L>%X(B,KATAKANA LETTER HE")
(?$B%Y(B "$BByE@IU$-JR2>L>%X(B,KATAKANA LETTER BE")
(?$B%Z(B "$BH>ByE@IU$-JR2>L>%X(B,KATAKANA LETTER PE")
(?$B%[(B "$BJR2>L>%[(B,KATAKANA LETTER HO")
(?$B%\(B "$BByE@IU$-JR2>L>%[(B,KATAKANA LETTER BO")
(?$B%](B "$BH>ByE@IU$-JR2>L>%[(B,KATAKANA LETTER PO")
(?$B%^(B "$BJR2>L>%^(B,KATAKANA LETTER MA")
(?$B%_(B "$BJR2>L>%_(B,KATAKANA LETTER MI")
(?$B%`(B "$BJR2>L>%`(B,KATAKANA LETTER MU")
(?$B%a(B "$BJR2>L>%a(B,KATAKANA LETTER ME")
(?$B%b(B "$BJR2>L>%b(B,KATAKANA LETTER MO")
(?$B%c(B "$B>.=q$-JR2>L>%d(B,KATAKANA LETTER SMALL YA")
(?$B%d(B "$BJR2>L>%d(B,KATAKANA LETTER YA")
(?$B%e(B "$B>.=q$-JR2>L>%f(B,KATAKANA LETTER SMALL YU")
(?$B%f(B "$BJR2>L>%f(B,KATAKANA LETTER YU")
(?$B%g(B "$B>.=q$-JR2>L>%h(B,KATAKANA LETTER SMALL YO")
(?$B%h(B "$BJR2>L>%h(B,KATAKANA LETTER YO")
(?$B%i(B "$BJR2>L>%i(B,KATAKANA LETTER RA")
(?$B%j(B "$BJR2>L>%j(B,KATAKANA LETTER RI")
(?$B%k(B "$BJR2>L>%k(B,KATAKANA LETTER RU")
(?$B%l(B "$BJR2>L>%l(B,KATAKANA LETTER RE")
(?$B%m(B "$BJR2>L>%m(B,KATAKANA LETTER RO")
(?$B%n(B "$B>.=q$-JR2>L>%o(B,KATAKANA LETTER SMALL WA")
(?$B%o(B "$BJR2>L>%o(B,KATAKANA LETTER WA")
(?$B%p(B "$BJR2>L>%p(B,KATAKANA LETTER WI")
(?$B%q(B "$BJR2>L>%q(B,KATAKANA LETTER WE")
(?$B%r(B "$BJR2>L>%r(B,KATAKANA LETTER WO")
(?$B%s(B "$BJR2>L>%s(B,KATAKANA LETTER N")
(?$B%t(B "$BByE@IU$-JR2>L>%&(B,KATAKANA LETTER VU")
(?$B%u(B "$B>.=q$-JR2>L>%+(B,KATAKANA LETTER SMALL KA")
(?$B%v(B "$B>.=q$-JR2>L>%1(B,KATAKANA LETTER SMALL KE")
(?$B&!(B "$B%.%j%7%"BgJ8;z(BALPHA,GREEK CAPITAL LETTER ALPHA")
(?$B&"(B "$B%.%j%7%"BgJ8;z(BBETA,GREEK CAPITAL LETTER BETA")
(?$B&#(B "$B%.%j%7%"BgJ8;z(BGAMMA,GREEK CAPITAL LETTER GAMMA")
(?$B&$(B "$B%.%j%7%"BgJ8;z(BDELTA,GREEK CAPITAL LETTER DELTA")
(?$B&%(B "$B%.%j%7%"BgJ8;z(BEPSILON,GREEK CAPITAL LETTER EPSILON")
(?$B&&(B "$B%.%j%7%"BgJ8;z(BZETA,GREEK CAPITAL LETTER ZETA")
(?$B&'(B "$B%.%j%7%"BgJ8;z(BETA,GREEK CAPITAL LETTER ETA")
(?$B&((B "$B%.%j%7%"BgJ8;z(BTHETA,GREEK CAPITAL LETTER THETA")
(?$B&)(B "$B%.%j%7%"BgJ8;z(BIOTA,GREEK CAPITAL LETTER IOTA")
(?$B&*(B "$B%.%j%7%"BgJ8;z(BKAPPA,GREEK CAPITAL LETTER KAPPA")
(?$B&+(B "$B%.%j%7%"BgJ8;z(BLAMBDA,GREEK CAPITAL LETTER LAMBDA")
(?$B&,(B "$B%.%j%7%"BgJ8;z(BMU,GREEK CAPITAL LETTER MU")
(?$B&-(B "$B%.%j%7%"BgJ8;z(BNU,GREEK CAPITAL LETTER NU")
(?$B&.(B "$B%.%j%7%"BgJ8;z(BXI,GREEK CAPITAL LETTER XI")
(?$B&/(B "$B%.%j%7%"BgJ8;z(BOMICRON,GREEK CAPITAL LETTER OMICRON")
(?$B&0(B "$B%.%j%7%"BgJ8;z(BPI,GREEK CAPITAL LETTER PI")
(?$B&1(B "$B%.%j%7%"BgJ8;z(BRHO,GREEK CAPITAL LETTER RHO")
(?$B&2(B "$B%.%j%7%"BgJ8;z(BSIGMA,GREEK CAPITAL LETTER SIGMA")
(?$B&3(B "$B%.%j%7%"BgJ8;z(BTAU,GREEK CAPITAL LETTER TAU")
(?$B&4(B "$B%.%j%7%"BgJ8;z(BUPSILON,GREEK CAPITAL LETTER UPSILON")
(?$B&5(B "$B%.%j%7%"BgJ8;z(BPHI,GREEK CAPITAL LETTER PHI")
(?$B&6(B "$B%.%j%7%"BgJ8;z(BCHI,GREEK CAPITAL LETTER CHI")
(?$B&7(B "$B%.%j%7%"BgJ8;z(BPSI,GREEK CAPITAL LETTER PSI")
(?$B&8(B "$B%.%j%7%"BgJ8;z(BOMEGA,GREEK CAPITAL LETTER OMEGA")
(?$B&A(B "$B%.%j%7%">.J8;z(BALPHA,GREEK SMALL LETTER ALPHA")
(?$B&B(B "$B%.%j%7%">.J8;z(BBETA,GREEK SMALL LETTER BETA")
(?$B&C(B "$B%.%j%7%">.J8;z(BGAMMA,GREEK SMALL LETTER GAMMA")
(?$B&D(B "$B%.%j%7%">.J8;z(BDELTA,GREEK SMALL LETTER DELTA")
(?$B&E(B "$B%.%j%7%">.J8;z(BEPSILON,GREEK SMALL LETTER EPSILON")
(?$B&F(B "$B%.%j%7%">.J8;z(BZETA,GREEK SMALL LETTER ZETA")
(?$B&G(B "$B%.%j%7%">.J8;z(BETA,GREEK SMALL LETTER ETA")
(?$B&H(B "$B%.%j%7%">.J8;z(BTHETA,GREEK SMALL LETTER THETA")
(?$B&I(B "$B%.%j%7%">.J8;z(BIOTA,GREEK SMALL LETTER IOTA")
(?$B&J(B "$B%.%j%7%">.J8;z(BKAPPA,GREEK SMALL LETTER KAPPA")
(?$B&K(B "$B%.%j%7%">.J8;z(BLAMBDA,GREEK SMALL LETTER LAMBDA")
(?$B&L(B "$B%.%j%7%">.J8;z(BMU,GREEK SMALL LETTER MU")
(?$B&M(B "$B%.%j%7%">.J8;z(BNU,GREEK SMALL LETTER NU")
(?$B&N(B "$B%.%j%7%">.J8;z(BXI,GREEK SMALL LETTER XI")
(?$B&O(B "$B%.%j%7%">.J8;z(BOMICRON,GREEK SMALL LETTER OMICRON")
(?$B&P(B "$B%.%j%7%">.J8;z(BPI,GREEK SMALL LETTER PI")
(?$B&Q(B "$B%.%j%7%">.J8;z(BRHO,GREEK SMALL LETTER RHO")
(?$B&R(B "$B%.%j%7%">.J8;z(BSIGMA,GREEK SMALL LETTER SIGMA")
(?$B&S(B "$B%.%j%7%">.J8;z(BTAU,GREEK SMALL LETTER TAU")
(?$B&T(B "$B%.%j%7%">.J8;z(BUPSILON,GREEK SMALL LETTER UPSILON")
(?$B&U(B "$B%.%j%7%">.J8;z(BPHI,GREEK SMALL LETTER PHI")
(?$B&V(B "$B%.%j%7%">.J8;z(BCHI,GREEK SMALL LETTER CHI")
(?$B&W(B "$B%.%j%7%">.J8;z(BPSI,GREEK SMALL LETTER PSI")
(?$B&X(B "$B%.%j%7%">.J8;z(BOMEGA,GREEK SMALL LETTER OMEGA")
(?$B'!(B "$B%-%j!<%kBgJ8;z(BA,CYRILLIC CAPITAL LETTER A")
(?$B'"(B "$B%-%j!<%kBgJ8;z(BBE,CYRILLIC CAPITAL LETTER BE")
(?$B'#(B "$B%-%j!<%kBgJ8;z(BVE,CYRILLIC CAPITAL LETTER VE")
(?$B'$(B "$B%-%j!<%kBgJ8;z(BGHE,CYRILLIC CAPITAL LETTER GHE")
(?$B'%(B "$B%-%j!<%kBgJ8;z(BDE,CYRILLIC CAPITAL LETTER DE")
(?$B'&(B "$B%-%j!<%kBgJ8;z(BIE,CYRILLIC CAPITAL LETTER IE")
(?$B''(B "$B%-%j!<%kBgJ8;z(BIO,CYRILLIC CAPITAL LETTER IO")
(?$B'((B "$B%-%j!<%kBgJ8;z(BZHE,CYRILLIC CAPITAL LETTER ZHE")
(?$B')(B "$B%-%j!<%kBgJ8;z(BZE,CYRILLIC CAPITAL LETTER ZE")
(?$B'*(B "$B%-%j!<%kBgJ8;z(BI,CYRILLIC CAPITAL LETTER I")
(?$B'+(B "$B%-%j!<%kBgJ8;z(BSHORT I,CYRILLIC CAPITAL LETTER SHORT I")
(?$B',(B "$B%-%j!<%kBgJ8;z(BKA,CYRILLIC CAPITAL LETTER KA")
(?$B'-(B "$B%-%j!<%kBgJ8;z(BEL,CYRILLIC CAPITAL LETTER EL")
(?$B'.(B "$B%-%j!<%kBgJ8;z(BEM,CYRILLIC CAPITAL LETTER EM")
(?$B'/(B "$B%-%j!<%kBgJ8;z(BEN,CYRILLIC CAPITAL LETTER EN")
(?$B'0(B "$B%-%j!<%kBgJ8;z(BO,CYRILLIC CAPITAL LETTER O")
(?$B'1(B "$B%-%j!<%kBgJ8;z(BPE,CYRILLIC CAPITAL LETTER PE")
(?$B'2(B "$B%-%j!<%kBgJ8;z(BER,CYRILLIC CAPITAL LETTER ER")
(?$B'3(B "$B%-%j!<%kBgJ8;z(BES,CYRILLIC CAPITAL LETTER ES")
(?$B'4(B "$B%-%j!<%kBgJ8;z(BTE,CYRILLIC CAPITAL LETTER TE")
(?$B'5(B "$B%-%j!<%kBgJ8;z(BU,CYRILLIC CAPITAL LETTER U")
(?$B'6(B "$B%-%j!<%kBgJ8;z(BEF,CYRILLIC CAPITAL LETTER EF")
(?$B'7(B "$B%-%j!<%kBgJ8;z(BHA,CYRILLIC CAPITAL LETTER HA")
(?$B'8(B "$B%-%j!<%kBgJ8;z(BTSE,CYRILLIC CAPITAL LETTER TSE")
(?$B'9(B "$B%-%j!<%kBgJ8;z(BCHE,CYRILLIC CAPITAL LETTER CHE")
(?$B':(B "$B%-%j!<%kBgJ8;z(BSHA,CYRILLIC CAPITAL LETTER SHA")
(?$B';(B "$B%-%j!<%kBgJ8;z(BSHCHA,CYRILLIC CAPITAL LETTER SHCHA")
(?$B'<(B "$B%-%j!<%kBgJ8;z(BHARD SIGN,CYRILLIC CAPITAL LETTER HARD SIGN")
(?$B'=(B "$B%-%j!<%kBgJ8;z(BYERU,CYRILLIC CAPITAL LETTER YERU")
(?$B'>(B "$B%-%j!<%kBgJ8;z(BSOFT SIGN,CYRILLIC CAPITAL LETTER SOFT SIGN")
(?$B'?(B "$B%-%j!<%kBgJ8;z(BE,CYRILLIC CAPITAL LETTER E")
(?$B'@(B "$B%-%j!<%kBgJ8;z(BYU,CYRILLIC CAPITAL LETTER YU")
(?$B'A(B "$B%-%j!<%kBgJ8;z(BYA,CYRILLIC CAPITAL LETTER YA")
(?$B'Q(B "$B%-%j!<%k>.J8;z(BA,CYRILLIC SMALL LETTER A")
(?$B'R(B "$B%-%j!<%k>.J8;z(BBE,CYRILLIC SMALL LETTER BE")
(?$B'S(B "$B%-%j!<%k>.J8;z(BVE,CYRILLIC SMALL LETTER VE")
(?$B'T(B "$B%-%j!<%k>.J8;z(BGHE,CYRILLIC SMALL LETTER GHE")
(?$B'U(B "$B%-%j!<%k>.J8;z(BDE,CYRILLIC SMALL LETTER DE")
(?$B'V(B "$B%-%j!<%k>.J8;z(BIE,CYRILLIC SMALL LETTER IE")
(?$B'W(B "$B%-%j!<%k>.J8;z(BIO,CYRILLIC SMALL LETTER IO")
(?$B'X(B "$B%-%j!<%k>.J8;z(BZHE,CYRILLIC SMALL LETTER ZHE")
(?$B'Y(B "$B%-%j!<%k>.J8;z(BZE,CYRILLIC SMALL LETTER ZE")
(?$B'Z(B "$B%-%j!<%k>.J8;z(BI,CYRILLIC SMALL LETTER I")
(?$B'[(B "$B%-%j!<%k>.J8;z(BSHORT I,CYRILLIC SMALL LETTER SHORT I")
(?$B'\(B "$B%-%j!<%k>.J8;z(BKA,CYRILLIC SMALL LETTER KA")
(?$B'](B "$B%-%j!<%k>.J8;z(BEL,CYRILLIC SMALL LETTER EL")
(?$B'^(B "$B%-%j!<%k>.J8;z(BEM,CYRILLIC SMALL LETTER EM")
(?$B'_(B "$B%-%j!<%k>.J8;z(BEN,CYRILLIC SMALL LETTER EN")
(?$B'`(B "$B%-%j!<%k>.J8;z(BO,CYRILLIC SMALL LETTER O")
(?$B'a(B "$B%-%j!<%k>.J8;z(BPE,CYRILLIC SMALL LETTER PE")
(?$B'b(B "$B%-%j!<%k>.J8;z(BER,CYRILLIC SMALL LETTER ER")
(?$B'c(B "$B%-%j!<%k>.J8;z(BES,CYRILLIC SMALL LETTER ES")
(?$B'd(B "$B%-%j!<%k>.J8;z(BTE,CYRILLIC SMALL LETTER TE")
(?$B'e(B "$B%-%j!<%k>.J8;z(BU,CYRILLIC SMALL LETTER U")
(?$B'f(B "$B%-%j!<%k>.J8;z(BEF,CYRILLIC SMALL LETTER EF")
(?$B'g(B "$B%-%j!<%k>.J8;z(BHA,CYRILLIC SMALL LETTER HA")
(?$B'h(B "$B%-%j!<%k>.J8;z(BTSE,CYRILLIC SMALL LETTER TSE")
(?$B'i(B "$B%-%j!<%k>.J8;z(BCHE,CYRILLIC SMALL LETTER CHE")
(?$B'j(B "$B%-%j!<%k>.J8;z(BSHA,CYRILLIC SMALL LETTER SHA")
(?$B'k(B "$B%-%j!<%k>.J8;z(BSHCHA,CYRILLIC SMALL LETTER SHCHA")
(?$B'l(B "$B%-%j!<%k>.J8;z(BHARD SIGN,CYRILLIC SMALL LETTER HARD SIGN")
(?$B'm(B "$B%-%j!<%k>.J8;z(BYERU,CYRILLIC SMALL LETTER YERU")
(?$B'n(B "$B%-%j!<%k>.J8;z(BSOFT SIGN,CYRILLIC SMALL LETTER SOFT SIGN")
(?$B'o(B "$B%-%j!<%k>.J8;z(BE,CYRILLIC SMALL LETTER E")
(?$B'p(B "$B%-%j!<%k>.J8;z(BYU,CYRILLIC SMALL LETTER YU")
(?$B'q(B "$B%-%j!<%k>.J8;z(BYA,CYRILLIC SMALL LETTER YA")
(?$B(!(B "$B2#:Y@~AGJR(B,BOX DRAWINGS LIGHT HORIZONTAL")
(?$B("(B "$B=D:Y@~AGJR(B,BOX DRAWINGS LIGHT VERTICAL")
(?$B(#(B "$B:Y@~AGJR:8>e(B,BOX DRAWINGS LIGHT DOWN AND RIGHT")
(?$B($(B "$B:Y@~AGJR1&>e(B,BOX DRAWINGS LIGHT DOWN AND LEFT")
(?$B(%(B "$B:Y@~AGJR1&2<(B,BOX DRAWINGS LIGHT UP AND LEFT")
(?$B(&(B "$B:Y@~AGJR:82<(B,BOX DRAWINGS LIGHT UP AND RIGHT")
(?$B('(B "$B:Y@~AGJR:8(B,BOX DRAWINGS LIGHT VERTICAL AND RIGHT")
(?$B(((B "$B:Y@~AGJR>e(B,BOX DRAWINGS LIGHT DOWN AND HORIZONTAL")
(?$B()(B "$B:Y@~AGJR1&(B,BOX DRAWINGS LIGHT VERTICAL AND LEFT")
(?$B(*(B "$B:Y@~AGJR2<(B,BOX DRAWINGS LIGHT UP AND HORIZONTAL")
(?$B(+(B "$B:Y@~AGJRCf1{(B,BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL")
(?$B(,(B "$B2#B@@~AGJR(B,BOX DRAWINGS HEAVY HORIZONTAL")
(?$B(-(B "$B=DB@@~AGJR(B,BOX DRAWINGS HEAVY VERTICAL")
(?$B(.(B "$BB@@~AGJR:8>e(B,BOX DRAWINGS HEAVY DOWN AND RIGHT")
(?$B(/(B "$BB@@~AGJR1&>e(B,BOX DRAWINGS HEAVY DOWN AND LEFT")
(?$B(0(B "$BB@@~AGJR1&2<(B,BOX DRAWINGS HEAVY UP AND LEFT")
(?$B(1(B "$BB@@~AGJR:82<(B,BOX DRAWINGS HEAVY UP AND RIGHT")
(?$B(2(B "$BB@@~AGJR:8(B,BOX DRAWINGS HEAVY VERTICAL AND RIGHT")
(?$B(3(B "$BB@@~AGJR>e(B,BOX DRAWINGS HEAVY DOWN AND HORIZONTAL")
(?$B(4(B "$BB@@~AGJR1&(B,BOX DRAWINGS HEAVY VERTICAL AND LEFT")
(?$B(5(B "$BB@@~AGJR2<(B,BOX DRAWINGS HEAVY UP AND HORIZONTAL")
(?$B(6(B "$BB@@~AGJRCf1{(B,BOX DRAWINGS HEAVY VERTICAL AND HORIZONTAL")
(?$B(7(B "$B=DB@@~2#:Y@~AGJR:8(B,BOX DRAWINGS VERTICAL HEAVY AND RIGHT LIGHT")
(?$B(8(B "$B2#B@@~=D:Y@~AGJR>e(B,BOX DRAWINGS DOWN LIGHT AND HORIZONTAL HEAVY")
(?$B(9(B "$B=DB@@~2#:Y@~AGJR1&(B,BOX DRAWINGS VERTICAL HEAVY AND LEFT LIGHT")
(?$B(:(B "$B2#B@@~=D:Y@~AGJR2<(B,BOX DRAWINGS UP LIGHT AND HORIZONTAL HEAVY")
(?$B(;(B "$B=D:Y@~2#B@@~AGJRCf1{(B,BOX DRAWINGS VERTICAL LIGHT AND HORIZONTAL HEAVY")
(?$B(<(B "$B=D:Y@~2#B@@~AGJR:8(B,BOX DRAWINGS VERTICAL LIGHT AND RIGHT HEAVY")
(?$B(=(B "$B2#:Y@~=DB@@~AGJR>e(B,BOX DRAWINGS DOWN HEAVY AND HORIZONTAL LIGHT")
(?$B(>(B "$B=D:Y@~2#B@@~AGJR1&(B,BOX DRAWINGS VERTICAL LIGHT AND LEFT HEAVY")
(?$B(?(B "$B2#:Y@~=DB@@~AGJR2<(B,BOX DRAWINGS UP HEAVY AND HORIZONTAL LIGHT")
(?$B(@(B "$B2#:Y@~=DB@@~AGJRCf1{(B,BOX DRAWINGS VERTICAL HEAVY AND HORIZONTAL LIGHT")
(?$B0"(B "83$B;zBNJQ99(B")
(?$B03(B "83$BF~BX$((B($BrM(B)")
(?$B1<(B "$B$&$k$&!#o`(B($BE55rIT>\(B)$B$OJL;z(B")
(?$B1k(B "83$B;zBNJQ99(B")
(?$B2)(B "83$BF~BX$((B($Brt(B)$B!#rt(B($B$&$0$$$9(B)$B$NN,;z!#s?(B($B$&$=(B)$B$OJL;z(B")
(?$B2*(B "83$B;zBNJQ99(B")
(?$B3>(B "$BG[Ns$NMp$l!#(B19$B6h(B 29$B3=(B($B$+$$$j(B) 30$B3>(B($B$+$*$k(B) 31$B3?(B($B$+$($k(B)")
(?$B3B(B "83$BF~BX$((B($BiZ(B)")
(?$B3I(B "83$BF~BX$((B($BYx(B)")
(?$B3v(B "83$BF~BX$((B($Bc^(B)")
(?$B3z(B "83$B;zBNJQ99(B")
(?$B4C(B "83$BF~BX$((B($B^u(B)")
(?$B4R(B "83$BF~BX$((B($Bk](B)")
(?$B6"(B "83$B;zBNJQ99(B")
(?$B6F(B "83$BDI2CF~BX$((B($Bt!(B)")
(?$B6m(B "83$B;zBNJQ99(B")
(?$B7[(B "83$BF~BX$((B($Bpt(B)")
(?$B84(B "83$B;zBNJQ99(B")
(?$B9\(B "83$BF~BX$((B($Bbh(B)")
(?$B9m(B "83$B;zBNJQ99(B")
(?$B<H(B "83$B;zBNJQ99(B")
(?$B<I(B "83$BF~BX$((B($Bi"(B)")
(?$B=+(B "83$B;zBNJQ99(B")
(?$B>U(B "83$B;zBNJQ99(B")
(?$B>_(B "83$B;zBNJQ99(B")
(?$B?Y(B "83$BF~BX$((B($BpW(B)")
(?$B@f(B "83$B;zBNJQ99(B")
(?$BA((B "83$BF~BX$((B($BlM(B)")
(?$BA_(B "83$B;zBNJQ99(B")
(?$BBM(B "83$B;zBNJQ99(B")
(?$BC=(B "83$B;zBNJQ99(B")
(?$BDO(B "83$B;zBNJQ99(B")
(?$BD[(B "83$BF~BX$((B($BTd(B)$B!#Td(B($B$D$\(B)$B$NN,;z!#Tg(B($B%3%s(B)$B$OJL;z(B")
(?$BE6(B "83$B;zBNJQ99(B")
(?$BE?(B "83$B;zBNJQ99(B")
(?$BEW(B "83$BF~BX$((B($Bbj(B)")
(?$BEn(B "83$BF~BX$((B($B[m(B)")
(?$BEs(B "83$BF~BX$((B($B^9(B)")
(?$BEx(B "83$B;zBNJQ99(B")
(?$BFB(B "83$B;zBNJQ99(B")
(?$BFv(B "83$BF~BX$((B($Bmn(B)")
(?$BG*(B "$BG)(B($B%M(B)$B$NN,;z!#jY(B($BE55rIT>\(B)$B$OJL;z(B")
(?$BG9(B "83$B;zBNJQ99(B")
(?$BGh(B "83$BF~BX$((B($Bj$(B)")
(?$BH.(B "83$B;zBNJQ99(B")
(?$BH0(B "83$B;zBNJQ99(B")
(?$BI0(B "83$BF~BX$((B($B[X(B)")
(?$BJj(B "$B$D$A$N$(!#Xz(B($B$^$5$+$j(B)$B$OJL;z(B")
(?$BKK(B "83$B;zBNJQ99(B")
(?$BKj(B "83$BDI2CF~BX$((B($Bt"(B)")
(?$BKy(B "83$BF~BX$((B($BPV(B)")
(?$BLM(B "83$B;zBNJQ99(B")
(?$BLy(B "83$BF~BX$((B($Bi.(B)")
(?$BMZ(B "83$BDI2CF~BX$((B($Bt#(B)")
(?$BMi(B "83$B;zBNJQ99(B")
(?$BNB(B "$B$d$J!#dm(B($B$"$o(B)$B$OJL;z(B")
(?$BO6(B "83$BF~BX$((B($BdF(B)")
(?$BO9(B "83$B;zBNJQ99(B")
(?$BPG(B "$BJ)(B($B$[$H$1(B)$B$N5l;z!#WJ(B($B%U%D(B)$B$OJL;z(B")
(?$BPV(B "83$BF~BX$((B($BKy(B)")
(?$BQI(B "$B$+$V$H!#ft(B($B%A%e%&(B)$B$OJL;z(B")
(?$BR9(B "$B$O$3$,$^$(!#R>(B($B$+$/$7$,$^$((B)$B$OJL;z(B")
(?$BR>(B "$B$+$/$7$,$^$(!#R9(B($B$O$3$,$^$((B)$B$OJL;z(B")
(?$BTW(B "$BE55rITL@(B")
(?$BT_(B "$BE55rITL@(B")
(?$BTd(B "83$BF~BX$((B($BD[(B)$B!#$D$\!#Tg(B($B%3%s(B)$B$OJL;z(B")
(?$BTg(B "$B%3%s!#Td(B($B$D$\(B)$B$OJL;z(B")
(?$BTi(B "$B%A!#Tj(B($B%9%$(B)$B$OJL;z$@$,:.F1$5$l$k(B")
(?$BTj(B "$B%9%$!#Ti(B($B%A(B)$B$OJL;z$@$,:.F1$5$l$k(B")
(?$BV,(B "$BE55rIT>\!#$"$1$S$N8m;z$+(B")
(?$BW;(B "$BF1DjITG=(B")
(?$BWJ(B "$B%U%D!#PG(B($B$[$H$1(B)$B$OJL;z(B")
(?$BXz(B "$B$^$5$+$j!#Jj(B($B$D$A$N$((B)$B$OJL;z(B")
(?$BX{(B "$B$^$b$k!#X|(B($B$$$L(B)$B$OJL;z(B")
(?$BX|(B "$B$$$L!#X{(B($B$^$b$k(B)$B$OJL;z(B")
(?$BYK(B "$BE55rIT>\(B")
(?$BYx(B "83$BF~BX$((B($BYx(B)")
(?$BZ9(B "83$B;zBNJQ99(B")
(?$BZH(B "$B%7%g%&!#ZI(B($B%X%$(B)$B$OJL;z(B")
(?$BZI(B "$B%X%$!#ZH(B($B%7%g%&(B)$B$OJL;z(B")
(?$BZl(B "$BCk(B($B$R$k(B)$B$N5l;z!#aA(B($B%+%/(B)$B$OJL;z(B")
(?$BZs(B "$BE55rIT>\(B")
(?$B[6(B "$B$*$&$4!#[7(B($B%H%&(B)$B$OJL;z(B")
(?$B[7(B "$B%H%&!#[6(B($B$*$&$4(B)$B$OJL;z(B")
(?$B[X(B "83$BF~BX$((B($BI0(B)")
(?$B[m(B "83$BF~BX$((B($BEn(B)")
(?$B[{(B "$BE55rIT>\!#$L$GEg$N$L$G$N8m;z$+(B")
(?$B\Y(B "$BE55rIT>\(B")
(?$B^9(B "83$BF~BX$((B($BEs(B)")
(?$B^u(B "83$BF~BX$((B($B4C(B)")
(?$B`v(B "83$BDI2CF~BX$((B($Bt$(B)")
(?$BaA(B "$B2h(B($B%+%/(B)$B$N5l;z!#Zl(B($B$R$k(B)$B$OJL;z(B")
(?$Bad(B "$B%^!#ae(B($B%j%s(B)$B$OJL;z(B")
(?$Bae(B "$B%j%s!#ad(B($B%^(B)$B$OJL;z(B")
(?$Bbh(B "83$BF~BX$((B($B9\(B)")
(?$Bbj(B "83$BF~BX$((B($BEW(B)")
(?$Bc^(B "83$BF~BX$((B($B3v(B)")
(?$BdF(B "83$BF~BX$((B($BO6(B)")
(?$Bdm(B "$B$"$o!#NB(B($B$d$J(B)$B$OJL;z(B")
(?$Bft(B "$B%A%e%&!#QI(B($B$+$V$H(B)$B$OJL;z(B")
(?$Bi"(B "83$BF~BX$((B($B<I(B)")
(?$Bi.(B "83$BF~BX$((B($BLy(B)")
(?$BiZ(B "83$BF~BX$((B($B3B(B)")
(?$Bin(B "$B$H$+$2!#j#(B($B%H%&(B)$B$OJL;z(B")
(?$Bj#(B "$B%H%&!#in(B($B$H$+$2(B)$B$OJL;z(B")
(?$Bj$(B "83$BF~BX$((B($BGh(B)")
(?$Bj,(B "$BE55rIT>\(B")
(?$BjY(B "$BE55rIT>\!#G*(B($B%M(B)$B$OJL;z(B")
(?$Bk](B "83$BF~BX$((B($B4R(B)")
(?$BlM(B "83$BF~BX$((B($BA((B)")
(?$Bmn(B "83$BF~BX$((B($BFv(B)")
(?$Bmr(B "$B$9$J$o$A!#n%(B($B%7%e%&(B)$B$OJL;z(B")
(?$Bn%(B "$Bn$(B($B%7%e%&(B)$B$N0[BN;z!#mr(B($B$9$J$o$A(B)$B$OJL;z(B")
(?$Bn[(B "$B$+$?$J!#n^(B($B%3%/(B)$B$OJL;z(B")
(?$Bn^(B "$B%3%/!#n[(B($B$+$?$J(B)$B$OJL;z(B")
(?$BoL(B "$B$d$9$j!#oN(B($B%m(B)$B$OJL;z(B")
(?$BoN(B "$B%m!#oL(B($B$d$9$j(B)$B$OJL;z(B")
(?$Bo`(B "$BE55rIT>\!#1<(B($B$&$k$&(B)$B$OJL;z(B")
(?$Bo}(B "$B%-%g%&!#p!(B($B%;%s(B)$B$OJL;z(B")
(?$Bp!(B "$B%;%s!#o}(B($B%-%g%&(B)$B$OJL;z(B")
(?$BpW(B "83$BF~BX$((B($B?Y(B)")
(?$Bpt(B "83$BF~BX$((B($B7[(B)")
(?$BqR(B "$BE55rIT>\(B")
(?$BrM(B "83$BF~BX$((B($B03(B)")
(?$Brt(B "83$BF~BX$((B($B2)(B)$B!#$&$0$$$9!#s?(B($B$&$=(B)$B$OJL;z(B")
(?$Bs?(B "$B$&$=!#rt(B($B$&$0$$$9(B)$B$OJL;z(B")
(?$Bt!(B "83$BDI2CF~BX$((B($B6F(B)")
(?$Bt"(B "83$BDI2CF~BX$((B($BKj(B)")
(?$Bt#(B "83$BDI2CF~BX$((B($BMZ(B)")
(?$Bt$(B "83$BDI2CF~BX$((B($B`v(B)")
(?$Bt%(B "90$BDI2C(B")
(?$Bt&(B "90$BDI2C(B")

)))
    (dolist (x l)
      (skk-tankan-set-char-annotaion (car x) (nth 1 x)))))

;;; annotation data for japanese-jisx0213-1
(when (and skk-tankan-annotation-table
	   (charsetp 'japanese-jisx0213-1))
  (let ((l '(

(2 15 "$B%"%]%9%H%m%U%#(B,APOSTROPHE")
(2 16 "$B0zMQId(B,$B%/%)!<%F!<%7%g%s%^!<%/(B,QUOTATION MARK")
(2 17 "$B%O%$%U%s%^%$%J%9(B,HYPHEN-MINUS")
(2 18 "$B%A%k%I(B,TILDE")
(2 19 "$B$/$N;zE@>e(B,VERTICAL KANA REPEAT MARK UPPER HALF")
(2 20 "$B$/$N;zE@>e(B($BByE@(B),VERTICAL KANA REPEAT WITH VOICED SOUND MARK UPPER HALF")
(2 21 "$B$/$N;zE@2<(B,VERTICAL KANA REPEAT MARK LOWER HALF")
(2 22 "$BFs$N;zE@(B,$B$f$9$jE@(B,VERTICAL IDEOGRAPHIC ITERATION MARK")
(2 23 "$B$^$95-9f(B,MASU MARK")
(2 24 "$B%3%H(B,KATAKANA DIGRAPH KOTO")
(2 25 "$B$h$j(B,HIRAGANA DIGRAPH YORI")
(2 34 "$BItJ,=89g$NH]Dj(B,NOT A SUBSET OF")
(2 35 "$BItJ,=89g$NH]Dj(B($B5UJ}8~(B),NOT A SUPERSET OF")
(2 36 "$B??ItJ,=89g(B2,SUBSET OF WITH NOT EQUAL TO")
(2 37 "$B??ItJ,=89g(B2($B5UJ}8~(B),SUPERSET OF WITH NOT EQUAL TO")
(2 38 "$BMWAG$NH]Dj(B,$B85$NH]Dj(B,NOT AN ELEMENT OF")
(2 39 "$B6u=89g(B,EMPTY SET")
(2 40 "$B<M1FE*4X78(B,PROJECTIVE")
(2 41 "$BGX7JE*4X78(B,PERSPECTIVE")
(2 49 "$BD>OB(B,CIRCLED PLUS")
(2 50 "$B4]IU$-%^%$%J%9(B,CIRCLED MINUS")
(2 51 "$B%F%s%=%k@Q(B,CIRCLED TIMES")
(2 52 "$BJ?9T(B,PARALLEL TO")
(2 53 "$BJ?9T$NH]Dj(B,NOT PARALLEL TO")
(2 54 "$B;O$aFs=E%Q!<%l%s(B,$B;O$aFs=E3g8L(B,FULLWIDTH LEFT WHITE PARENTHESIS")
(2 55 "$B=*$o$jFs=E%Q!<%l%s(B,$B=*$o$jFs=E3g8L(B,FULLWIDTH RIGHT WHITE PARENTHESIS")
(2 56 "$B;O$aFs=E$-$C$3$&(B($B559C(B)$B3g8L(B,LEFT WHITE TORTOISE SHELL BRACKET")
(2 57 "$B=*$o$jFs=E$-$C$3$&(B($B559C(B)$B3g8L(B,RIGHT WHITE TORTOISE SHELL BRACKET")
(2 58 "$B;O$a$9$_IU$-3g8L(B($BGr(B),LEFT WHITE LENTICULAR BRACKET")
(2 59 "$B=*$o$j$9$_IU$-3g8L(B($BGr(B),RIGHT WHITE LENTICULAR BRACKET")
(2 75 "$B9gF1H]Dj(B,NOT IDENTICAL TO")
(2 76 "$BA2?JE*$KEy$7$$(B,$B%[%b%H!<%W(B,ASYMPTOTICALLY EQUAL TO")
(2 77 "$BF17A(B,APPROXIMATELY EQUAL TO")
(2 78 "$B6a;wE*$KEy$7$$(B,$BF1Aj(B,ALMOST EQUAL TO")
(2 79 "$B>.$5$$$+Bg$-$$(B,LESS-THAN OR GREATER-THAN")
(2 80 "$BBg$-$$$+>.$5$$(B,GREATER-THAN OR LESS-THAN")
(2 81 "$BF1Ey(B,LEFT RIGHT ARROW")
(2 90 "$B%J%A%e%i%k(B,MUSIC NATURAL SIGN")
(2 91 "$BO"$3$&(B($B7e(B)$BIU$-H,J,2;Id(B,BEAMED EIGHTH NOTES")
(2 92 "$BO"$3$&(B($B7e(B)$BIU$-==O;J,2;Id(B,BEAMED SIXTEENTH NOTES")
(2 93 "$B;MJ,2;Id(B,QUARTER NOTE")
(3 1 "$B1&8~;03Q(B,WHITE RIGHT-POINTING TRIANGLE")
(3 2 "$B1&8~9u;03Q(B,BLACK RIGHT-POINTING TRIANGLE")
(3 3 "$B:88~;03Q(B,WHITE LEFT-POINTING TRIANGLE")
(3 4 "$B:88~9u;03Q(B,BLACK LEFT-POINTING TRIANGLE")
(3 5 "$B1&>e8~Lp0u(B,NORTH EAST ARROW")
(3 6 "$B1&2<8~Lp0u(B,SOUTH EAST ARROW")
(3 7 "$B:8>e8~Lp0u(B,NORTH WEST ARROW")
(3 8 "$B:82<8~Lp0u(B,SOUTH WEST ARROW")
(3 9 "$B1&Lp0u:8Lp0u(B,RIGHTWARDS ARROW OVER LEFTWARDS ARROW")
(3 10 "$B1&8~GrLp0u(B,RIGHTWARDS WHITE ARROW")
(3 11 "$B:88~GrLp0u(B,LEFTWARDS WHITE ARROW")
(3 12 "$B>e8~GrLp0u(B,UPWARDS WHITE ARROW")
(3 13 "$B2<8~GrLp0u(B,DOWNWARDS WHITE ARROW")
(3 14 "$B6J$,$jLp0u>e$,$k(B,ARROW POINTING RIGHTWARDS THEN CURVING UPWARDS")
(3 15 "$B6J$,$jLp0u2<$,$k(B,ARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDS")
(3 26 "$B4]Cf9u(B,CIRCLED BULLET")
(3 27 "$B<X$NL\(B,FISHEYE")
(3 28 "$B2N5-9f(B,$B$$$*$j(B($B0C(B)$BE@(B,PART ALTERNATION MARK")
(3 29 "$BGr%4%^(B,WHITE SESAME DOT")
(3 30 "$B%4%^(B,SESAME DOT")
(3 31 "$BGr%S%e%l%C%H(B,WHITE BULLET")
(3 32 "$B%S%e%l%C%H(B,BULLET")
(3 59 "$BIiKt$O@5Id9f(B,MINUS-OR-PLUS SIGN")
(3 60 "$B%"%l%U(B,ALEF SYMBOL")
(3 61 "$B%(%$%A%P!<(B,PLANCK CONSTANT OVER TWO PI")
(3 62 "HP,$B%[!<%9%Q%o!<(B($BGONO(B),SQUARE HP")
(3 63 "$B%j%C%H%k(B,SCRIPT SMALL L")
(3 64 "$B%b!<(B,INVERTED OHM SIGN")
(3 91 "$BFs=E%O%$%U%s(B,$BFsJ,Fs=E%@%C%7%e(B,KATAKANA-HIRAGANA DOUBLE HYPHEN")
(3 92 "$BFsJ,%@!<%7(B,$B%@%C%7%e(B($BFsJ,(B),EN DASH")
(3 93 "2$B%W%i%9(B,DOUBLE PLUS")
(3 94 "3$B%W%i%9(B,TRIPLE PLUS")
(4 84 "$BByE@IU$-J?2>L>$&(B,HIRAGANA LETTER VU")
(4 85 "$B>.=q$-J?2>L>$+(B,HIRAGANA LETTER SMALL KA")
(4 86 "$B>.=q$-J?2>L>$1(B,HIRAGANA LETTER SMALL KE")
(4 87 "$BH>ByE@IU$-J?2>L>$+(B,[HIRAGANA LETTER BIDAKUON NGA]")
(4 88 "$BH>ByE@IU$-J?2>L>$-(B,[HIRAGANA LETTER BIDAKUON NGI]")
(4 89 "$BH>ByE@IU$-J?2>L>$/(B,[HIRAGANA LETTER BIDAKUON NGU]")
(4 90 "$BH>ByE@IU$-J?2>L>$1(B,[HIRAGANA LETTER BIDAKUON NGE]")
(4 91 "$BH>ByE@IU$-J?2>L>$3(B,[HIRAGANA LETTER BIDAKUON NGO]")
(5 87 "$BH>ByE@IU$-JR2>L>%+(B,[KATAKANA LETTER BIDAKUON NGA]")
(5 88 "$BH>ByE@IU$-JR2>L>%-(B,[KATAKANA LETTER BIDAKUON NGI]")
(5 89 "$BH>ByE@IU$-JR2>L>%/(B,[KATAKANA LETTER BIDAKUON NGU]")
(5 90 "$BH>ByE@IU$-JR2>L>%1(B,[KATAKANA LETTER BIDAKUON NGE]")
(5 91 "$BH>ByE@IU$-JR2>L>%3(B,[KATAKANA LETTER BIDAKUON NGO]")
(5 92 "$BH>ByE@IU$-JR2>L>%;(B,[KATAKANA LETTER AINU CE]")
(5 93 "$BH>ByE@IU$-JR2>L>%D(B,[KATAKANA LETTER AINU TU]")
(5 94 "$BH>ByE@IU$-JR2>L>%H(B,[KATAKANA LETTER AINU TO]")
(6 25 "$B%9%Z!<%I(B($BGr(B),WHITE SPADE SUIT")
(6 26 "$B%9%Z!<%I(B,BLACK SPADE SUIT")
(6 27 "$B%@%$%d(B($BGr(B),WHITE DIAMOND SUIT")
(6 28 "$B%@%$%d(B,BLACK DIAMOND SUIT")
(6 29 "$B%O!<%H(B($BGr(B),WHITE HEART SUIT")
(6 30 "$B%O!<%H(B,BLACK HEART SUIT")
(6 31 "$B%/%i%V(B($BGr(B),WHITE CLUB SUIT")
(6 32 "$B%/%i%V(B,BLACK CLUB SUIT")
(6 57 "$B%.%j%7%">.J8;z%U%!%$%J%k(BSIGMA,GREEK SMALL LETTER FINAL SIGMA")
(6 58 "$BFs=E4](B1,DOUBLE CIRCLED DIGIT ONE")
(6 59 "$BFs=E4](B2,DOUBLE CIRCLED DIGIT TWO")
(6 60 "$BFs=E4](B3,DOUBLE CIRCLED DIGIT THREE")
(6 61 "$BFs=E4](B4,DOUBLE CIRCLED DIGIT FOUR")
(6 62 "$BFs=E4](B5,DOUBLE CIRCLED DIGIT FIVE")
(6 63 "$BFs=E4](B6,DOUBLE CIRCLED DIGIT SIX")
(6 64 "$BFs=E4](B7,DOUBLE CIRCLED DIGIT SEVEN")
(6 65 "$BFs=E4](B8,DOUBLE CIRCLED DIGIT EIGHT")
(6 66 "$BFs=E4](B9,DOUBLE CIRCLED DIGIT NINE")
(6 67 "$BFs=E4](B10,DOUBLE CIRCLED NUMBER TEN")
(6 68 "$BGr>-4}6p(B,WHITE SHOGI PIECE")
(6 69 "$B9u>-4}6p(B,BLACK SHOGI PIECE")
(6 70 "$BM9JX%^!<%/(B,POSTAL MARK FACE")
(6 71 "$BEEOC%^!<%/(B,BLACK TELEPHONE")
(6 72 "$B@2%^!<%/(B,BLACK SUN WITH RAYS")
(6 73 "$BF^%^!<%/(B,CLOUD")
(6 74 "$B1+%^!<%/(B,UMBRELLA")
(6 75 "$B@c%^!<%/(B,SNOWMAN")
(6 76 "$B29@t%^!<%/(B,HOT SPRINGS")
(6 77 "$BJ?9T;MJU7A(B,WHITE PARALLELOGRAM")
(6 78 "$B>.=q$-JR2>L>%/(B,KATAKANA LETTER SMALL KU")
(6 79 "$B>.=q$-JR2>L>%7(B,KATAKANA LETTER SMALL SI")
(6 80 "$B>.=q$-JR2>L>%9(B,KATAKANA LETTER SMALL SU")
(6 81 "$B>.=q$-JR2>L>%H(B,KATAKANA LETTER SMALL TO")
(6 82 "$B>.=q$-JR2>L>%L(B,KATAKANA LETTER SMALL NU")
(6 83 "$B>.=q$-JR2>L>%O(B,KATAKANA LETTER SMALL HA")
(6 84 "$B>.=q$-JR2>L>%R(B,KATAKANA LETTER SMALL HI")
(6 85 "$B>.=q$-JR2>L>%U(B,KATAKANA LETTER SMALL HU")
(6 86 "$B>.=q$-JR2>L>%X(B,KATAKANA LETTER SMALL HE")
(6 87 "$B>.=q$-JR2>L>%[(B,KATAKANA LETTER SMALL HO")
(6 88 "$B>.=q$-H>ByE@IU$-JR2>L>%U(B,[KATAKANA LETTER AINU P]")
(6 89 "$B>.=q$-JR2>L>%`(B,KATAKANA LETTER SMALL MU")
(6 90 "$B>.=q$-JR2>L>%i(B,KATAKANA LETTER SMALL RA")
(6 91 "$B>.=q$-JR2>L>%j(B,KATAKANA LETTER SMALL RI")
(6 92 "$B>.=q$-JR2>L>%k(B,KATAKANA LETTER SMALL RU")
(6 93 "$B>.=q$-JR2>L>%l(B,KATAKANA LETTER SMALL RE")
(6 94 "$B>.=q$-JR2>L>%m(B,KATAKANA LETTER SMALL RO")
(7 34 "$B:8>e3QAGJR(B,DENTISTRY SYMBOL LIGHT VERTICAL AND TOP RIGHT")
(7 35 "$B:82<3QAGJR(B,DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM RIGHT")
(7 36 "$B4]IU$-=D@~AGJR(B,DENTISTRY SYMBOL LIGHT VERTICAL WITH CIRCLE")
(7 37 "$B4]IU$->e2#=D@~AGJR(B,DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH CIRCLE")
(7 38 "$B4]IU$-2<2#=D@~AGJR(B,DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH CIRCLE")
(7 39 "$B;03QIU$-=D@~AGJR(B,DENTISTRY SYMBOL LIGHT VERTICAL WITH TRIANGLE")
(7 40 "$B;03QIU$->e2#=D@~AGJR(B,DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH TRIANGLE")
(7 41 "$B;03QIU$-2<2#=D@~AGJR(B,DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH TRIANGLE")
(7 42 "$BGHIU$-=D@~AGJR(B,DENTISTRY SYMBOL LIGHT VERTICAL WITH WAVE")
(7 43 "$BGHIU$->e2#=D@~AGJR(B,DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL WITH WAVE")
(7 44 "$BGHIU$-2<2#=D@~AGJR(B,DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL WITH WAVE")
(7 45 "$B>e2#=D@~AGJR(B,DENTISTRY SYMBOL LIGHT DOWN AND HORIZONTAL")
(7 46 "$B2<2#=D@~AGJR(B,DENTISTRY SYMBOL LIGHT UP AND HORIZONTAL")
(7 47 "$B1&>e3QAGJR(B,DENTISTRY SYMBOL LIGHT VERTICAL AND TOP LEFT")
(7 48 "$B1&2<3QAGJR(B,DENTISTRY SYMBOL LIGHT VERTICAL AND BOTTOM LEFT")
(7 82 "$BByE@IU$-JR2>L>%o(B,KATAKANA LETTER VA")
(7 83 "$BByE@IU$-JR2>L>%p(B,KATAKANA LETTER VI")
(7 84 "$BByE@IU$-JR2>L>%q(B,KATAKANA LETTER VE")
(7 85 "$BByE@IU$-JR2>L>%r(B,KATAKANA LETTER VO")
(7 86 "$B>.$5$$$+Ey$7$$$+Bg$-$$(B,LESS-THAN EQUAL TO OR GREATER-THAN")
(7 87 "$BBg$-$$$+Ey$7$$$+>.$5$$(B,GREATER-THAN EQUAL TO OR LESS-THAN")
(7 88 "3$BJ,$N(B1,VULGAR FRACTION ONE THIRD")
(7 89 "3$BJ,$N(B2,VULGAR FRACTION TWO THIRDS")
(7 90 "5$BJ,$N(B1,VULGAR FRACTION ONE FIFTH")
(7 91 "$B%A%'%C%/%^!<%/(B,CHECK MARK")
(7 92 "$B%3%^%s%I5-9f(B,PLACE OF INTEREST SIGN")
(7 93 "$B6uGr5-9f(B,OPEN BOX")
(7 94 "$B%j%?!<%s5-9f(B,RETURN SYMBOL")
(8 33 "$B4](B21,CIRCLED NUMBER TWENTY ONE")
(8 34 "$B4](B22,CIRCLED NUMBER TWENTY TWO")
(8 35 "$B4](B23,CIRCLED NUMBER TWENTY THREE")
(8 36 "$B4](B24,CIRCLED NUMBER TWENTY FOUR")
(8 37 "$B4](B25,CIRCLED NUMBER TWENTY FIVE")
(8 38 "$B4](B26,CIRCLED NUMBER TWENTY SIX")
(8 39 "$B4](B27,CIRCLED NUMBER TWENTY SEVEN")
(8 40 "$B4](B28,CIRCLED NUMBER TWENTY EIGHT")
(8 41 "$B4](B29,CIRCLED NUMBER TWENTY NINE")
(8 42 "$B4](B30,CIRCLED NUMBER THIRTY")
(8 43 "$B4](B31,CIRCLED NUMBER THIRTY ONE")
(8 44 "$B4](B32,CIRCLED NUMBER THIRTY TWO")
(8 45 "$B4](B33,CIRCLED NUMBER THIRTY THREE")
(8 46 "$B4](B34,CIRCLED NUMBER THIRTY FOUR")
(8 47 "$B4](B35,CIRCLED NUMBER THIRTY FIVE")
(8 48 "$B4](B36,CIRCLED NUMBER THIRTY SIX")
(8 49 "$B4](B37,CIRCLED NUMBER THIRTY SEVEN")
(8 50 "$B4](B38,CIRCLED NUMBER THIRTY EIGHT")
(8 51 "$B4](B39,CIRCLED NUMBER THIRTY NINE")
(8 52 "$B4](B40,CIRCLED NUMBER FORTY")
(8 53 "$B4](B41,CIRCLED NUMBER FORTY ONE")
(8 54 "$B4](B42,CIRCLED NUMBER FORTY TWO")
(8 55 "$B4](B43,CIRCLED NUMBER FORTY THREE")
(8 56 "$B4](B44,CIRCLED NUMBER FORTY FOUR")
(8 57 "$B4](B45,CIRCLED NUMBER FORTY FIVE")
(8 58 "$B4](B46,CIRCLED NUMBER FORTY SIX")
(8 59 "$B4](B47,CIRCLED NUMBER FORTY SEVEN")
(8 60 "$B4](B48,CIRCLED NUMBER FORTY EIGHT")
(8 61 "$B4](B49,CIRCLED NUMBER FORTY NINE")
(8 62 "$B4](B50,CIRCLED NUMBER FIFTY")
(8 71 "$B:8H>9u4](B,CIRCLE WITH LEFT HALF BLACK")
(8 72 "$B1&H>9u4](B,CIRCLE WITH RIGHT HALF BLACK")
(8 73 "$B2<H>9u4](B,CIRCLE WITH LOWER HALF BLACK")
(8 74 "$B>eH>9u4](B,CIRCLE WITH UPPER HALF BLACK")
(8 75 "$B46C2IdFs$D(B,DOUBLE EXCLAMATION MARK")
(8 76 "$B5?LdIdFs$D(B,DOUBLE QUESTION MARK")
(8 77 "$B5?LdId46C2Id(B,QUESTION EXCLAMATION MARK")
(8 78 "$B46C2Id5?LdId(B,EXCLAMATION QUESTION MARK")
(8 79 "$B%-%c%m%sIU$-(BA,LATIN CAPITAL LETTER A WITH CARON")
(8 80 "$B%-%c%m%sIU$-(BA$B>.J8;z(B,LATIN SMALL LETTER A WITH CARON")
(8 81 "$B%-%c%m%sIU$-(BI$B>.J8;z(B,LATIN SMALL LETTER I WITH CARON")
(8 82 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BM,LATIN CAPITAL LETTER M WITH ACUTE")
(8 83 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BM$B>.J8;z(B,LATIN SMALL LETTER M WITH ACUTE")
(8 84 "$B%0%l!<%V%"%/%;%s%HIU$-(BN,LATIN CAPITAL LETTER N WITH GRAVE")
(8 85 "$B%0%l!<%V%"%/%;%s%HIU$-(BN$B>.J8;z(B,LATIN SMALL LETTER N WITH GRAVE")
(8 86 "$B%-%c%m%sIU$-(BO,LATIN CAPITAL LETTER O WITH CARON")
(8 87 "$B%-%c%m%sIU$-(BO$B>.J8;z(B,LATIN SMALL LETTER O WITH CARON")
(8 88 "$B%-%c%m%sIU$-(BU$B>.J8;z(B,LATIN SMALL LETTER U WITH CARON")
(8 89 "$B%^%/%m%s$H%@%$%(%l%7%9IU$-(BU$B>.J8;z(B,LATIN SMALL LETTER U WITH DIAERESIS AND MACRON")
(8 90 "$B%"%-%e!<%H%"%/%;%s%H$H%@%$%(%l%7%9IU$-(BU$B>.J8;z(B,LATIN SMALL LETTER U WITH DIAERESIS AND ACUTE")
(8 91 "$B%-%c%m%s$H%@%$%(%l%7%9IU$-(BU$B>.J8;z(B,LATIN SMALL LETTER U WITH DIAERESIS AND CARON")
(8 92 "$B%0%l!<%V%"%/%;%s%H$H%@%$%(%l%7%9IU$-(BU$B>.J8;z(B,LATIN SMALL LETTER U WITH DIAERESIS AND GRAVE")
(9 1 "$B%f!<%m5-9f(B,EURO SIGN")
(9 2 "$B%N!<%V%l!<%/%9%Z!<%9(B,NO-BREAK SPACE")
(9 3 "$B5U46C2Id(B,INVERTED EXCLAMATION MARK")
(9 4 "$BITFCDjDL2_5-9f(B,CURRENCY SIGN")
(9 5 "$BGKCG@~(B,BROKEN BAR")
(9 6 "$BCx:n8"I=<(5-9f(B,COPYRIGHT SIGN")
(9 7 "$B=w@-=x?tI8<1(B,FEMININE ORDINAL INDICATOR")
(9 8 "$B;O$aFs=E;33g8L0zMQ5-9f(B,$B;O$a%.%e%a(B,LEFT-POINTING DOUBLE ANGLE QUOTATION MARK")
(9 9 "$B%=%U%H%O%$%U%s(B,SOFT HYPHEN")
(9 10 "$BEPO?>&I85-9f(B,REGISTERED SIGN")
(9 11 "$B%^%/%m%s(B,MACRON")
(9 12 "$B>eIU$-(B2,SUPERSCRIPT TWO")
(9 13 "$B>eIU$-(B3,SUPERSCRIPT THREE")
(9 14 "$BCfE@(B($B%i%F%s(B),MIDDLE DOT")
(9 15 "$B%;%G%#%i(B,CEDILLA")
(9 16 "$B>eIU$-(B1,SUPERSCRIPT ONE")
(9 17 "$BCK@-=x?tI8<1(B,MASCULINE ORDINAL INDICATOR")
(9 18 "$B=*$o$jFs=E;33g8L0zMQ5-9f(B,$B=*$o$j%.%e%a(B,RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK")
(9 19 "4$BJ,$N(B1,VULGAR FRACTION ONE QUARTER")
(9 20 "2$BJ,$N(B1,VULGAR FRACTION ONE HALF")
(9 21 "4$BJ,$N(B3,VULGAR FRACTION THREE QUARTERS")
(9 22 "$B5U5?LdId(B,INVERTED QUESTION MARK")
(9 23 "$B%0%l!<%V%"%/%;%s%HIU$-(BA,LATIN CAPITAL LETTER A WITH GRAVE")
(9 24 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BA,LATIN CAPITAL LETTER A WITH ACUTE")
(9 25 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BA,LATIN CAPITAL LETTER A WITH CIRCUMFLEX")
(9 26 "$B%A%k%IIU$-(BA,LATIN CAPITAL LETTER A WITH TILDE")
(9 27 "$B%@%$%(%l%7%9IU$-(BA,LATIN CAPITAL LETTER A WITH DIAERESIS")
(9 28 "$B>e%j%s%0IU$-(BA,LATIN CAPITAL LETTER A WITH RING ABOVE")
(9 29 "AE,LATIN CAPITAL LETTER AE")
(9 30 "$B%;%G%#%iIU$-(BC,LATIN CAPITAL LETTER C WITH CEDILLA")
(9 31 "$B%0%l!<%V%"%/%;%s%HIU$-(BE,LATIN CAPITAL LETTER E WITH GRAVE")
(9 32 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BE,LATIN CAPITAL LETTER E WITH ACUTE")
(9 33 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BE,LATIN CAPITAL LETTER E WITH CIRCUMFLEX")
(9 34 "$B%@%$%(%l%7%9IU$-(BE,LATIN CAPITAL LETTER E WITH DIAERESIS")
(9 35 "$B%0%l!<%V%"%/%;%s%HIU$-(BI,LATIN CAPITAL LETTER I WITH GRAVE")
(9 36 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BI,LATIN CAPITAL LETTER I WITH ACUTE")
(9 37 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BI,LATIN CAPITAL LETTER I WITH CIRCUMFLEX")
(9 38 "$B%@%$%(%l%7%9IU$-(BI,LATIN CAPITAL LETTER I WITH DIAERESIS")
(9 39 "$B%"%$%9%i%s%I8l(BETH,LATIN CAPITAL LETTER ETH(Icelandic)")
(9 40 "$B%A%k%IIU$-(BN,LATIN CAPITAL LETTER N WITH TILDE")
(9 41 "$B%0%l!<%V%"%/%;%s%HIU$-(BO,LATIN CAPITAL LETTER O WITH GRAVE")
(9 42 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BO,LATIN CAPITAL LETTER O WITH ACUTE")
(9 43 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BO,LATIN CAPITAL LETTER O WITH CIRCUMFLEX")
(9 44 "$B%A%k%IIU$-(BO,LATIN CAPITAL LETTER O WITH TILDE")
(9 45 "$B%@%$%(%l%7%9IU$-(BO,LATIN CAPITAL LETTER O WITH DIAERESIS")
(9 46 "$B%9%H%m!<%/IU$-(BO,LATIN CAPITAL LETTER O WITH STROKE")
(9 47 "$B%0%l!<%V%"%/%;%s%HIU$-(BU,LATIN CAPITAL LETTER U WITH GRAVE")
(9 48 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BU,LATIN CAPITAL LETTER U WITH ACUTE")
(9 49 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BU,LATIN CAPITAL LETTER U WITH CIRCUMFLEX")
(9 50 "$B%@%$%(%l%7%9IU$-(BU,LATIN CAPITAL LETTER U WITH DIAERESIS")
(9 51 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BY,LATIN CAPITAL LETTER Y WITH ACUTE")
(9 52 "$B%"%$%9%i%s%I8l(BTHORN,LATIN CAPITAL LETTER THORN(Icelandic)")
(9 53 "$B%I%$%D8l%(%9%D%'%C%H(B,LATIN SMALL LETTER SHARP S(German)")
(9 54 "$B%0%l!<%V%"%/%;%s%HIU$-(BA$B>.J8;z(B,LATIN SMALL LETTER A WITH GRAVE")
(9 55 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BA$B>.J8;z(B,LATIN SMALL LETTER A WITH ACUTE")
(9 56 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BA$B>.J8;z(B,LATIN SMALL LETTER A WITH CIRCUMFLEX")
(9 57 "$B%A%k%IIU$-(BA$B>.J8;z(B,LATIN SMALL LETTER A WITH TILDE")
(9 58 "$B%@%$%(%l%7%9IU$-(BA$B>.J8;z(B,LATIN SMALL LETTER A WITH DIAERESIS")
(9 59 "$B>e%j%s%0IU$-(BA$B>.J8;z(B,LATIN SMALL LETTER A WITH RING ABOVE")
(9 60 "AE$B>.J8;z(B,LATIN SMALL LETTER AE")
(9 61 "$B%;%G%#%iIU$-(BC$B>.J8;z(B,LATIN SMALL LETTER C WITH CEDILLA")
(9 62 "$B%0%l!<%V%"%/%;%s%HIU$-(BE$B>.J8;z(B,LATIN SMALL LETTER E WITH GRAVE")
(9 63 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BE$B>.J8;z(B,LATIN SMALL LETTER E WITH ACUTE")
(9 64 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BE$B>.J8;z(B,LATIN SMALL LETTER E WITH CIRCUMFLEX")
(9 65 "$B%@%$%(%l%7%9IU$-(BE$B>.J8;z(B,LATIN SMALL LETTER E WITH DIAERESIS")
(9 66 "$B%0%l!<%V%"%/%;%s%HIU$-(BI$B>.J8;z(B,LATIN SMALL LETTER I WITH GRAVE")
(9 67 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BI$B>.J8;z(B,LATIN SMALL LETTER I WITH ACUTE")
(9 68 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BI$B>.J8;z(B,LATIN SMALL LETTER I WITH CIRCUMFLEX")
(9 69 "$B%@%$%(%l%7%9IU$-(BI$B>.J8;z(B,LATIN SMALL LETTER I WITH DIAERESIS")
(9 70 "$B%"%$%9%i%s%I8l(BETH$B>.J8;z(B,LATIN SMALL LETTER ETH(Icelandic)")
(9 71 "$B%A%k%IIU$-(BN$B>.J8;z(B,LATIN SMALL LETTER N WITH TILDE")
(9 72 "$B%0%l!<%V%"%/%;%s%HIU$-(BO$B>.J8;z(B,LATIN SMALL LETTER O WITH GRAVE")
(9 73 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BO$B>.J8;z(B,LATIN SMALL LETTER O WITH ACUTE")
(9 74 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BO$B>.J8;z(B,LATIN SMALL LETTER O WITH CIRCUMFLEX")
(9 75 "$B%A%k%IIU$-(BO$B>.J8;z(B,LATIN SMALL LETTER O WITH TILDE")
(9 76 "$B%@%$%(%l%7%9IU$-(BO$B>.J8;z(B,LATIN SMALL LETTER O WITH DIAERESIS")
(9 77 "$B%9%H%m!<%/IU$-(BO$B>.J8;z(B,LATIN SMALL LETTER O WITH STROKE")
(9 78 "$B%0%l!<%V%"%/%;%s%HIU$-(BU$B>.J8;z(B,LATIN SMALL LETTER U WITH GRAVE")
(9 79 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BU$B>.J8;z(B,LATIN SMALL LETTER U WITH ACUTE")
(9 80 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BU$B>.J8;z(B,LATIN SMALL LETTER U WITH CIRCUMFLEX")
(9 81 "$B%@%$%(%l%7%9IU$-(BU$B>.J8;z(B,LATIN SMALL LETTER U WITH DIAERESIS")
(9 82 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BY$B>.J8;z(B,LATIN SMALL LETTER Y WITH ACUTE")
(9 83 "$B%"%$%9%i%s%I8l(BTHORN$B>.J8;z(B,LATIN SMALL LETTER THORN(Icelandic)")
(9 84 "$B%@%$%(%l%7%9IU$-(BY$B>.J8;z(B,LATIN SMALL LETTER Y WITH DIAERESIS")
(9 85 "$B%^%/%m%sIU$-(BA,LATIN CAPITAL LETTER A WITH MACRON")
(9 86 "$B%^%/%m%sIU$-(BI,LATIN CAPITAL LETTER I WITH MACRON")
(9 87 "$B%^%/%m%sIU$-(BU,LATIN CAPITAL LETTER U WITH MACRON")
(9 88 "$B%^%/%m%sIU$-(BE,LATIN CAPITAL LETTER E WITH MACRON")
(9 89 "$B%^%/%m%sIU$-(BO,LATIN CAPITAL LETTER O WITH MACRON")
(9 90 "$B%^%/%m%sIU$-(BA$B>.J8;z(B,LATIN SMALL LETTER A WITH MACRON")
(9 91 "$B%^%/%m%sIU$-(BI$B>.J8;z(B,LATIN SMALL LETTER I WITH MACRON")
(9 92 "$B%^%/%m%sIU$-(BU$B>.J8;z(B,LATIN SMALL LETTER U WITH MACRON")
(9 93 "$B%^%/%m%sIU$-(BE$B>.J8;z(B,LATIN SMALL LETTER E WITH MACRON")
(9 94 "$B%^%/%m%sIU$-(BO$B>.J8;z(B,LATIN SMALL LETTER O WITH MACRON")
(10 1 "$B%*%4%M%/IU$-(BA,LATIN CAPITAL LETTER A WITH OGONEK")
(10 2 "$B%V%j!<%V(B,BREVE")
(10 3 "$B%9%H%m!<%/IU$-(BL,LATIN CAPITAL LETTER L WITH STROKE")
(10 4 "$B%-%c%m%sIU$-(BL,LATIN CAPITAL LETTER L WITH CARON")
(10 5 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BS,LATIN CAPITAL LETTER S WITH ACUTE")
(10 6 "$B%-%c%m%sIU$-(BS,LATIN CAPITAL LETTER S WITH CARON")
(10 7 "$B%;%G%#%iIU$-(BS,LATIN CAPITAL LETTER S WITH CEDILLA")
(10 8 "$B%-%c%m%sIU$-(BT,LATIN CAPITAL LETTER T WITH CARON")
(10 9 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BZ,LATIN CAPITAL LETTER Z WITH ACUTE")
(10 10 "$B%-%c%m%sIU$-(BZ,LATIN CAPITAL LETTER Z WITH CARON")
(10 11 "$B>e%I%C%HIU$-(BZ,LATIN CAPITAL LETTER Z WITH DOT ABOVE")
(10 12 "$B%*%4%M%/IU$-(BA$B>.J8;z(B,LATIN SMALL LETTER A WITH OGONEK")
(10 13 "$B%*%4%M%/(B,OGONEK")
(10 14 "$B%9%H%m!<%/IU$-(BL$B>.J8;z(B,LATIN SMALL LETTER L WITH STROKE")
(10 15 "$B%-%c%m%sIU$-(BL$B>.J8;z(B,LATIN SMALL LETTER L WITH CARON")
(10 16 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BS$B>.J8;z(B,LATIN SMALL LETTER S WITH ACUTE")
(10 17 "$B%-%c%m%s(B,CARON(Mandarin Chinese third tone)")
(10 18 "$B%-%c%m%sIU$-(BS$B>.J8;z(B,LATIN SMALL LETTER S WITH CARON")
(10 19 "$B%;%G%#%iIU$-(BS$B>.J8;z(B,LATIN SMALL LETTER S WITH CEDILLA")
(10 20 "$B%-%c%m%sIU$-(BT$B>.J8;z(B,LATIN SMALL LETTER T WITH CARON")
(10 21 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BZ$B>.J8;z(B,LATIN SMALL LETTER Z WITH ACUTE")
(10 22 "$B%@%V%k%"%-%e!<%H%"%/%;%s%H(B,DOUBLE ACUTE ACCENT")
(10 23 "$B%-%c%m%sIU$-(BZ$B>.J8;z(B,LATIN SMALL LETTER Z WITH CARON")
(10 24 "$B>e%I%C%HIU$-(BZ$B>.J8;z(B,LATIN SMALL LETTER Z WITH DOT ABOVE")
(10 25 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BR,LATIN CAPITAL LETTER R WITH ACUTE")
(10 26 "$B%V%j!<%VIU$-(BA,LATIN CAPITAL LETTER A WITH BREVE")
(10 27 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BL,LATIN CAPITAL LETTER L WITH ACUTE")
(10 28 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BC,LATIN CAPITAL LETTER C WITH ACUTE")
(10 29 "$B%-%c%m%sIU$-(BC,LATIN CAPITAL LETTER C WITH CARON")
(10 30 "$B%*%4%M%/IU$-(BE,LATIN CAPITAL LETTER E WITH OGONEK")
(10 31 "$B%-%c%m%sIU$-(BE,LATIN CAPITAL LETTER E WITH CARON")
(10 32 "$B%-%c%m%sIU$-(BD,LATIN CAPITAL LETTER D WITH CARON")
(10 33 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BN,LATIN CAPITAL LETTER N WITH ACUTE")
(10 34 "$B%-%c%m%sIU$-(BN,LATIN CAPITAL LETTER N WITH CARON")
(10 35 "$B%@%V%k%"%-%e!<%H%"%/%;%s%HIU$-(BO,LATIN CAPITAL LETTER O WITH DOUBLE ACUTE")
(10 36 "$B%-%c%m%sIU$-(BR,LATIN CAPITAL LETTER R WITH CARON")
(10 37 "$B>e%j%s%0IU$-(BU,LATIN CAPITAL LETTER U WITH RING ABOVE")
(10 38 "$B%@%V%k%"%-%e!<%H%"%/%;%s%HIU$-(BU,LATIN CAPITAL LETTER U WITH DOUBLE ACUTE")
(10 39 "$B%;%G%#%iIU$-(BT,LATIN CAPITAL LETTER T WITH CEDILLA")
(10 40 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BR$B>.J8;z(B,LATIN SMALL LETTER R WITH ACUTE")
(10 41 "$B%V%j!<%VIU$-(BA$B>.J8;z(B,LATIN SMALL LETTER A WITH BREVE")
(10 42 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BL$B>.J8;z(B,LATIN SMALL LETTER L WITH ACUTE")
(10 43 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BC$B>.J8;z(B,LATIN SMALL LETTER C WITH ACUTE")
(10 44 "$B%-%c%m%sIU$-(BC$B>.J8;z(B,LATIN SMALL LETTER C WITH CARON")
(10 45 "$B%*%4%M%/IU$-(BE$B>.J8;z(B,LATIN SMALL LETTER E WITH OGONEK")
(10 46 "$B%-%c%m%sIU$-(BE$B>.J8;z(B,LATIN SMALL LETTER E WITH CARON")
(10 47 "$B%-%c%m%sIU$-(BD$B>.J8;z(B,LATIN SMALL LETTER D WITH CARON")
(10 48 "$B%9%H%m!<%/IU$-(BD$B>.J8;z(B,LATIN SMALL LETTER D WITH STROKE")
(10 49 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BN$B>.J8;z(B,LATIN SMALL LETTER N WITH ACUTE")
(10 50 "$B%-%c%m%sIU$-(BN$B>.J8;z(B,LATIN SMALL LETTER N WITH CARON")
(10 51 "$B%@%V%k%"%-%e!<%H%"%/%;%s%HIU$-(BO$B>.J8;z(B,LATIN SMALL LETTER O WITH DOUBLE ACUTE")
(10 52 "$B%-%c%m%sIU$-(BR$B>.J8;z(B,LATIN SMALL LETTER R WITH CARON")
(10 53 "$B>e%j%s%0IU$-(BU$B>.J8;z(B,LATIN SMALL LETTER U WITH RING ABOVE")
(10 54 "$B%@%V%k%"%-%e!<%H%"%/%;%s%HIU$-(BU$B>.J8;z(B,LATIN SMALL LETTER U WITH DOUBLE ACUTE")
(10 55 "$B%;%G%#%iIU$-(BT$B>.J8;z(B,LATIN SMALL LETTER T WITH CEDILLA")
(10 56 "$B>e%I%C%H(B,DOT ABOVE(Mandarin Chinese light tone)")
(10 57 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BC,LATIN CAPITAL LETTER C WITH CIRCUMFLEX")
(10 58 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BG,LATIN CAPITAL LETTER G WITH CIRCUMFLEX")
(10 59 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BH,LATIN CAPITAL LETTER H WITH CIRCUMFLEX")
(10 60 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BJ,LATIN CAPITAL LETTER J WITH CIRCUMFLEX")
(10 61 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BS,LATIN CAPITAL LETTER S WITH CIRCUMFLEX")
(10 62 "$B%V%j!<%VIU$-(BU,LATIN CAPITAL LETTER U WITH BREVE")
(10 63 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BC$B>.J8;z(B,LATIN SMALL LETTER C WITH CIRCUMFLEX")
(10 64 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BG$B>.J8;z(B,LATIN SMALL LETTER G WITH CIRCUMFLEX")
(10 65 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BH$B>.J8;z(B,LATIN SMALL LETTER H WITH CIRCUMFLEX")
(10 66 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BJ$B>.J8;z(B,LATIN SMALL LETTER J WITH CIRCUMFLEX")
(10 67 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%HIU$-(BS$B>.J8;z(B,LATIN SMALL LETTER S WITH CIRCUMFLEX")
(10 68 "$B%V%j!<%VIU$-(BU$B>.J8;z(B,LATIN SMALL LETTER U WITH BREVE")
(10 69 "$B%U%C%/IU$-(BM$B>.J8;z(B,$BM-@<?0;uI!2;(B,LATIN SMALL LETTER M WITH HOOK")
(10 70 "$B%U%C%/IU$-(BV$B>.J8;z(B,$BM-@<?0;u@\6a2;(B,LATIN SMALL LETTER V WITH HOOK")
(10 71 "$B%U%#%C%7%e%U%C%/IU$-(BR$B>.J8;z(B,$BM-@<;u7TCF$-2;(B,LATIN SMALL LETTER R WITH FISHHOOK")
(10 72 "ESH$B>.J8;z(B,$BL5@<8eIt;u7TK`;$2;(B,LATIN SMALL LETTER ESH")
(10 73 "EZH$B>.J8;z(B,$BM-@<8eIt;u7TK`;$2;(B,LATIN SMALL LETTER EZH")
(10 74 "$B%Y%k%HIU$-(BL$B>.J8;z(B,$BL5@<;u7TB&LLK`;$2;(B,LATIN SMALL LETTER L WITH BELT")
(10 75 "LEZH$B>.J8;z(B,$BM-@<;u7TB&LLK`;$2;(B,LATIN SMALL LETTER LEZH")
(10 76 "$B%?!<%s%I(BR$B>.J8;z(B,$BL5@<;u7T@\6a2;(B,LATIN SMALL LETTER TURNED R")
(10 77 "$B%l%H%m%U%l%C%/%9%U%C%/IU$-(BT$B>.J8;z(B,$BL5@<$=$j@eGKNv2;(B,LATIN SMALL LETTER T WITH RETROFLEX HOOK")
(10 78 "$B%F!<%kIU$-(BD$B>.J8;z(B,$BM-@<$=$j@eGKNv2;(B,LATIN SMALL LETTER D WITH TAIL")
(10 79 "$B%l%H%m%U%l%C%/%9%U%C%/IU$-(BN$B>.J8;z(B,$BM-@<$=$j@eI!2;(B,LATIN SMALL LETTER N WITH RETROFLEX HOOK")
(10 80 "$B%F!<%kIU$-(BR$B>.J8;z(B,$BM-@<$=$j@eCF$-2;(B,LATIN SMALL LETTER R WITH TAIL")
(10 81 "$B%U%C%/IU$-(BS$B>.J8;z(B,$BL5@<$=$j@eK`;$2;(B,LATIN SMALL LETTER S WITH HOOK")
(10 82 "$B%l%H%m%U%l%C%/%9%U%C%/IU$-(BZ$B>.J8;z(B,$BM-@<$=$j@eK`;$2;(B,LATIN SMALL LETTER Z WITH RETROFLEX HOOK")
(10 83 "$B%U%C%/IU$-%?!<%s%I(BR$B>.J8;z(B,$BM-@<$=$j@e@\6a2;(B,LATIN SMALL LETTER TURNED R WITH HOOK")
(10 84 "$B%l%H%m%U%l%C%/%9%U%C%/IU$-(BL$B>.J8;z(B,$BM-@<$=$j@eB&LL@\6a2;(B,LATIN SMALL LETTER L WITH RETROFLEX HOOK")
(10 85 "$B%9%H%m!<%/IU$-%I%C%H$J$7(BJ$B>.J8;z(B,$BM-@<9E8}38GKNv2;(B,LATIN SMALL LETTER DOTLESS J WITH STROKE")
(10 86 "$B:8%U%C%/IU$-(BN$B>.J8;z(B,$BM-@<9E8}38I!2;(B,LATIN SMALL LETTER N WITH LEFT HOOK")
(10 87 "$B%/%m%9%I%F!<%kIU$-(BJ$B>.J8;z(B,$BM-@<9E8}38K`;$2;(B,LATIN SMALL LETTER J WITH CROSSED-TAIL")
(10 88 "$B%?!<%s%I(BY$B>.J8;z(B,$BM-@<9E8}38B&LL@\6a2;(B,LATIN SMALL LETTER TURNED Y")
(10 89 "$B%9%/%j%W%H(BG$B>.J8;z(B,$BM-@<Fp8}38GKNv2;(B,LATIN SMALL LETTER SCRIPT G")
(10 90 "ENG$B>.J8;z(B,$BM-@<Fp8}38I!2;(B,LATIN SMALL LETTER ENG(Sami)")
(10 91 "$B%m%s%0%l%C%0IU$-%?!<%s%I(BM$B>.J8;z(B,$BM-@<Fp8}38@\6a2;(B,LATIN SMALL LETTER TURNED M WITH LONG LEG")
(10 92 "$B%$%s%P!<%F%C%I(BR$B%9%b!<%k%-%c%T%?%k(B,$BM-@<8}38?bK`;$2;(B,LATIN LETTER SMALL CAPITAL INVERTED R")
(10 93 "$B%9%H%m!<%/IU$-(BH$B>.J8;z(B,$BL5@<0vF,K`;$2;(B,LATIN SMALL LETTER H WITH STROKE")
(10 94 "$B%j%P!<%9%I%0%m%C%?%k%9%H%C%W(B,$BM-@<0vF,K`;$2;(B,LATIN LETTER PHARYNGEAL VOICED FRICATIVE")
(11 1 "$B%0%m%C%?%k%9%H%C%W(B,$BL5@<@<LgGKNv2;(B,LATIN LETTER GLOTTAL STOP")
(11 2 "$B%U%C%/IU$-(BH$B>.J8;z(B,$BM-@<@<LgK`;$2;(B,LATIN SMALL LETTER H WITH HOOK")
(11 3 "$BN>?05[Ce2;(B,LATIN LETTER BILABIAL CLICK")
(11 4 "$B9E8}38;u7T5[Ce2;(B,LATIN LETTER ALVEOLAR CLICK")
(11 5 "$B%U%C%/IU$-(BB$B>.J8;z(B,$BM-@<N>?0FbGK2;(B,LATIN SMALL LETTER B WITH HOOK")
(11 6 "$B%U%C%/IU$-(BD$B>.J8;z(B,$BM-@<;u7TFbGK2;(B,LATIN SMALL LETTER D WITH HOOK")
(11 7 "$B%U%C%/$H%9%H%m!<%/IU$-%I%C%H$J$7(BJ$B>.J8;z(B,$BM-@<9E8}38FbGK2;(B,LATIN SMALL LETTER DOTLESS J WITH STROKE AND HOOK")
(11 8 "$B%U%C%/IU$-(BG$B>.J8;z(B,$BM-@<Fp8}38FbGK2;(B,LATIN SMALL LETTER G WITH HOOK")
(11 9 "$B%U%C%/IU$-(BG$BBgJ8;z(B,$BM-@<8}38?bFbGK2;(B,LATIN CAPITAL LETTER G WITH HOOK")
(11 10 "$B%j%,%A%c(BOE$B>.J8;z(B,$B1_?0A0@e9-!&CfCJJl2;(B,LATIN SMALL LIGATURE OE")
(11 11 "$B%j%,%A%c(BOE$BBgJ8;z(B,$B1_?0A0@e9-Jl2;(B,LATIN CAPITAL LIGATURE OE")
(11 12 "$B%9%H%m!<%/IU$-(BI$B>.J8;z(B,$BHs1_?0Cf@e69Jl2;(B,LATIN SMALL LETTER I WITH STROKE")
(11 13 "$B%P!<IU$-(BU$B>.J8;z(B,$B1_?0Cf@e69Jl2;(B,LATIN SMALL LETTER U BAR")
(11 14 "$B%j%P!<%9%I(BE$B>.J8;z(B,$BHs1_?0Cf@e69!&CfCJJl2;(B,LATIN SMALL LETTER REVERSED E")
(11 15 "$B%P!<IU$-(BO$B>.J8;z(B,$B1_?0Cf@e69!&CfCJJl2;(B,LATIN SMALL LETTER BARRED O")
(11 16 "SCHWA$B>.J8;z(B,$BHs1_?0Cf@eCf1{Jl2;(B,LATIN SMALL LETTER SCHWA")
(11 17 "$B%j%P!<%9%I%*!<%W%s(BE$B>.J8;z(B,$BHs1_?0Cf@e9-!&CfCJJl2;(B,LATIN SMALL LETTER REVERSED OPEN E")
(11 18 "$B%/%m!<%:%I%j%P!<%9%I%*!<%W%s(BE$B>.J8;z(B,$B1_?0Cf@e9-!&CfCJJl2;(B,LATIN SMALL LETTER CLOSED REVERSED OPEN E")
(11 19 "$B%?!<%s%I(BA$B>.J8;z(B,$BHs1_?0Cf@e69$a$N9-Jl2;(B,LATIN SMALL LETTER TURNED A")
(11 20 "$B%?!<%s%I(BM$B>.J8;z(B,$BHs1_?08e@e69Jl2;(B,LATIN SMALL LETTER TURNED M")
(11 21 "UPSILON$B>.J8;z(B,$B1_?08e@e9-$a$N69Jl2;(B,LATIN SMALL LETTER UPSILON")
(11 22 "$B%Y%S!<%,%s%^(B,$BHs1_?08e@e69CfCJJl2;(B,LATIN SMALL LETTER RAMS HORN")
(11 23 "$B%?!<%s%I(BV$B>.J8;z(B,$BHs1_?08e@e9-!&CfCJJl2;(B,LATIN SMALL LETTER TURNED V")
(11 24 "$B%*!<%W%s(BO$B>.J8;z(B,$B1_?08e@e9-!&CfCJJl2;(B,LATIN SMALL LETTER OPEN O")
(11 25 "$B%9%/%j%W%H(BA$B>.J8;z(B,$BHs1_?08e@e9-Jl2;(B,LATIN SMALL LETTER ALPHA")
(11 26 "$B%?!<%s%I(BALPHA$B>.J8;z(B,$B1_?08e@e9-Jl2;(B,LATIN SMALL LETTER TURNED ALPHA")
(11 27 "$B%?!<%s%I(BW$B>.J8;z(B,$BL5@<N>?0!&Fp8}38K`;$2;(B,LATIN SMALL LETTER TURNED W")
(11 28 "$B%?!<%s%I(BH$B>.J8;z(B,$BM-@<N>?0!&9E8}38@\6a2;(B,LATIN SMALL LETTER TURNED H")
(11 29 "$B%9%H%m!<%/IU$-%j%P!<%9%I%0%m%C%?%k%9%H%C%W(B,$BM-@<0vF,38K`;$2;(B,LATIN LETTER REVERSED GLOTTAL STOP WITH STROKE")
(11 30 "$B%9%H%m!<%/IU$-%0%m%C%?%k%9%H%C%W(B,$B0vF,38GKNv2;(B,LATIN LETTER GLOTTAL STOP WITH STROKE")
(11 31 "$B%+!<%kIU$-(BC$B>.J8;z(B,$B;u7T!&9E8}38K`;$2;(B,LATIN SMALL LETTER C WITH CURL")
(11 32 "$B%+!<%kIU$-(BZ$B>.J8;z(B,$B;u7T!&9E8}38K`;$2;(B,LATIN SMALL LETTER Z WITH CURL")
(11 33 "$B%m%s%0%l%C%0IU$-%?!<%s%I(BR$B>.J8;z(B,$B;u7TB&LLCF$-2;(B,LATIN SMALL LETTER TURNED R WITH LONG LEG")
(11 34 "$B%U%C%/IU$-(BHENG$B>.J8;z(B,$BL5@<8eIt;u7TFp8}38K`;$2;(B,LATIN SMALL LETTER HENG WITH HOOK")
(11 35 "$B%U%C%/IU$-(BSCHWA,LATIN SMALL LETTER SCHWA WITH HOOK")
(11 36 "$B%0%l!<%V%"%/%;%s%HIU$-(BAE$B>.J8;z(B,[LATIN SMALL LETTER AE WITH GRAVE]")
(11 37 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BAE$B>.J8;z(B,LATIN SMALL LETTER AE WITH ACUTE")
(11 38 "$B%0%l!<%V%"%/%;%s%HIU$-%9%/%j%W%H(BA$B>.J8;z(B,GREEK SMALL LETTER ALPHA WITH VARIA")
(11 39 "$B%"%-%e!<%H%"%/%;%s%HIU$-%9%/%j%W%H(BA$B>.J8;z(B,GREEK SMALL LETTER ALPHA WITH OXIA")
(11 40 "$B%0%l!<%V%"%/%;%s%HIU$-%*!<%W%s(BO$B>.J8;z(B,[LATIN SMALL LETTER OPEN O WITH GRAVE]")
(11 41 "$B%"%-%e!<%H%"%/%;%s%HIU$-%*!<%W%s(BO$B>.J8;z(B,[LATIN SMALL LETTER OPEN O WITH ACUTE]")
(11 42 "$B%0%l!<%V%"%/%;%s%HIU$-%?!<%s%I(BV$B>.J8;z(B,[LATIN SMALL LETTER TURNED V WITH GRAVE]")
(11 43 "$B%"%-%e!<%H%"%/%;%s%HIU$-%?!<%s%I(BV$B>.J8;z(B,[LATIN SMALL LETTER TURNED V WITH ACUTE]")
(11 44 "$B%0%l!<%V%"%/%;%s%HIU$-(BSCHWA$B>.J8;z(B,[LATIN SMALL LETTER SCHWA WITH GRAVE]")
(11 45 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BSCHWA$B>.J8;z(B,[LATIN SMALL LETTER SCHWA WITH ACUTE]")
(11 46 "$B%0%l!<%V%"%/%;%s%H$H%U%C%/IU$-(BSCHWA$B>.J8;z(B,[LATIN SMALL LETTER HOOKED SCHWA WITH GRAVE]")
(11 47 "$B%"%-%e!<%H%"%/%;%s%H$H%U%C%/IU$-(BSCHWA$B>.J8;z(B,[LATIN SMALL LETTER HOOKED SCHWA WITH ACUTE]")
(11 48 "$B%0%l!<%V%"%/%;%s%HIU$-(BEPSILON$B>.J8;z(B,GREEK SMALL LETTER EPSILON WITH VARIA")
(11 49 "$B%"%-%e!<%H%"%/%;%s%HIU$-(BEPSILON$B>.J8;z(B,GREEK SMALL LETTER EPSILON WITH OXIA")
(11 50 "$B%@%V%k%$%s%P!<%F%C%I%V%j!<%V(B($B9g@.2DG=(B),$BGK;$2;Kt$OFs=ED42;5-9f(B,COMBINING DOUBLE INVERTED BREVE")
(11 51 "$B>.=D@~(B,$BBh0l6/@*(B,MODIFIER LETTER VERTICAL LINE")
(11 52 "$B2<>.=D@~(B,$BBhFs6/@*(B,MODIFIER LETTER LOW VERTICAL LINE")
(11 53 "$BD9(B,MODIFIER LETTER TRIANGULAR COLON")
(11 54 "$BH>D9(B,MODIFIER LETTER HALF TRIANGULAR COLON")
(11 55 "$B%V%j!<%V(B($B9g@.2DG=(B),$BD6C;(B,COMBINING BREVE(Vrachy)")
(11 56 "$BO"7k$7$F$$$k(B,UNDERTIE(Enotikon)")
(11 57 "$B%@%V%k%"%-%e!<%H%"%/%;%s%H(B($B9g@.2DG=(B),$B@<D4D69b(B,COMBINING DOUBLE ACUTE ACCENT")
(11 58 "$B%"%-%e!<%H%"%/%;%s%H(B($B9g@.2DG=(B),$B@<D49b(B,COMBINING ACUTE ACCENT(Oxia)")
(11 59 "$B%^%/%m%s(B($B9g@.2DG=(B),$B@<D4Cf(B,COMBINING MACRON")
(11 60 "$B%0%l!<%V%"%/%;%s%H(B($B9g@.2DG=(B),$B@<D4Dc(B,COMBINING GRAVE ACCENT(Varia)")
(11 61 "$B%@%V%k%0%l!<%V%"%/%;%s%H(B($B9g@.2DG=(B),$B@<D4D6Dc(B,COMBINING DOUBLE GRAVE ACCENT")
(11 62 "$B%-%c%m%s(B($B9g@.2DG=(B),$B@<D4>e>:D4(B,COMBINING CARON")
(11 63 "$B%5!<%+%`%U%l%C%/%9%"%/%;%s%H(B($B9g@.2DG=(B),$B@<D42<9_D4(B,COMBINING CIRCUMFLEX ACCENT")
(11 64 "$B@<D45-9fD69b(B,MODIFIER LETTER EXTRA-HIGH TONE BAR")
(11 65 "$B@<D45-9f9b(B,MODIFIER LETTER HIGH TONE BAR")
(11 66 "$B@<D45-9fCf(B,MODIFIER LETTER MID TONE BAR")
(11 67 "$B@<D45-9fDc(B,MODIFIER LETTER LOW TONE BAR")
(11 68 "$B@<D45-9fD6Dc(B,MODIFIER LETTER EXTRA-LOW TONE BAR")
(11 69 "$B@<D45-9f>e>:D4(B,[RISING SYMBOL]")
(11 70 "$B@<D45-9f2<9_D4(B,[FALLING SYMBOL]")
(11 71 "$B2<%j%s%0(B($B9g@.2DG=(B),$BL5@<(B,COMBINING RING BELOW")
(11 72 "$B2<%-%c%m%s(B($B9g@.2DG=(B),$BM-@<(B,COMBINING CARON BELOW")
(11 73 "$B2<%i%$%H%O!<%U%j%s%0(B($B9g@.2DG=(B),$B$h$j1_?0@-$N6/$$(B,COMBINING RIGHT HALF RING BELOW")
(11 74 "$B2<%l%U%H%O!<%U%j%s%0(B($B9g@.2DG=(B),$B$h$j1_?0@-$N<e$$(B,COMBINING LEFT HALF RING BELOW")
(11 75 "$B2<%W%i%9(B($B9g@.2DG=(B),$BA04s$j$N(B,COMBINING PLUS SIGN BELOW")
(11 76 "$B2<%^%$%J%9(B($B9g@.2DG=(B),$B8e$m4s$j$N(B,COMBINING MINUS SIGN BELOW")
(11 77 "$B%@%$%(%l%7%9(B($B9g@.2DG=(B),$BCf@eJl2;2=(B,COMBINING DIAERESIS(Dialytika)")
(11 78 "$B>e(BX($B9g@.2DG=(B),$BCfCJCf@eJl2;2=(B,COMBINING X ABOVE")
(11 79 "$B2<=D@~(B($B9g@.2DG=(B),$B2;@a<g2;E*(B,COMBINING VERTICAL LINE BELOW")
(11 80 "$B2<%$%s%P!<%F%C%I%V%j!<%V(B($B9g@.2DG=(B),$B2;@aI{2;E*(B,COMBINING INVERTED BREVE BELOW")
(11 81 "r$B$N2;?'(B,MODIFIER LETTER RHOTIC HOOK")
(11 82 "$B2<%@%$%(%l%7%9(B($B9g@.2DG=(B),$B$+$9$l2;(B,COMBINING DIAERESIS BELOW")
(11 83 "$B2<%A%k%I(B($B9g@.2DG=(B),$B$-$7$_2;(B,COMBINING TILDE BELOW")
(11 84 "$B2<%7!<%,%k(B($B9g@.2DG=(B),$B@e@hC<?02;(B,COMBINING SEAGULL BELOW")
(11 85 "$B%A%k%I%*!<%P%l%$(B($B9g@.2DG=(B),$BFp8}382=$"$k$$$O0vF,2=(B,COMBINING TILDE OVERLAY")
(11 86 "$B2<%"%C%W%?%C%/(B($B9g@.2DG=(B),$B9b@e$N(B,COMBINING UP TACK BELOW")
(11 87 "$B2<%@%&%s%?%C%/(B($B9g@.2DG=(B),$BDc@e$N(B,COMBINING DOWN TACK BELOW")
(11 88 "$B2<%l%U%H%?%C%/(B($B9g@.2DG=(B),$BA0J}@e:,@-(B,COMBINING LEFT TACK BELOW")
(11 89 "$B2<%i%$%H%?%C%/(B($B9g@.2DG=(B),$B8eJ}@e:,@-(B,COMBINING RIGHT TACK BELOW")
(11 90 "$B2<%V%j%C%8(B($B9g@.2DG=(B),$B;u(B,COMBINING BRIDGE BELOW")
(11 91 "$B2<%$%s%P!<%F%C%I%V%j%C%8(B($B9g@.2DG=(B),$B@e@hE*(B,COMBINING INVERTED BRIDGE BELOW")
(11 92 "$B2<%9%/%(%"(B($B9g@.2DG=(B),$B@eC<E*(B,COMBINING SQUARE BELOW")
(11 93 "$B%A%k%I(B($B9g@.2DG=(B),$BI!2;2=(B,COMBINING TILDE")
(11 94 "$B>e%l%U%H%"%s%0%k(B($B9g@.2DG=(B),$B3+J|$,J9$3$($J$$(B,COMBINING LEFT ANGLE ABOVE")
(12 1 "$B9u4](B1,DINGBAT NEGATIVE CIRCLED DIGIT ONE")
(12 2 "$B9u4](B2,DINGBAT NEGATIVE CIRCLED DIGIT TWO")
(12 3 "$B9u4](B3,DINGBAT NEGATIVE CIRCLED DIGIT THREE")
(12 4 "$B9u4](B4,DINGBAT NEGATIVE CIRCLED DIGIT FOUR")
(12 5 "$B9u4](B5,DINGBAT NEGATIVE CIRCLED DIGIT FIVE")
(12 6 "$B9u4](B6,DINGBAT NEGATIVE CIRCLED DIGIT SIX")
(12 7 "$B9u4](B7,DINGBAT NEGATIVE CIRCLED DIGIT SEVEN")
(12 8 "$B9u4](B8,DINGBAT NEGATIVE CIRCLED DIGIT EIGHT")
(12 9 "$B9u4](B9,DINGBAT NEGATIVE CIRCLED DIGIT NINE")
(12 10 "$B9u4](B10,DINGBAT NEGATIVE CIRCLED NUMBER TEN")
(12 11 "$B9u4](B11,NEGATIVE CIRCLED NUMBER ELEVEN")
(12 12 "$B9u4](B12,NEGATIVE CIRCLED NUMBER TWELVE")
(12 13 "$B9u4](B13,NEGATIVE CIRCLED NUMBER THIRTEEN")
(12 14 "$B9u4](B14,NEGATIVE CIRCLED NUMBER FOURTEEN")
(12 15 "$B9u4](B15,NEGATIVE CIRCLED NUMBER FIFTEEN")
(12 16 "$B9u4](B16,NEGATIVE CIRCLED NUMBER SIXTEEN")
(12 17 "$B9u4](B17,NEGATIVE CIRCLED NUMBER SEVENTEEN")
(12 18 "$B9u4](B18,NEGATIVE CIRCLED NUMBER EIGHTEEN")
(12 19 "$B9u4](B19,NEGATIVE CIRCLED NUMBER NINETEEN")
(12 20 "$B9u4](B20,NEGATIVE CIRCLED NUMBER TWENTY")
(12 21 "$B%m!<%^?t;z(B1$B>.J8;z(B,SMALL ROMAN NUMERAL ONE")
(12 22 "$B%m!<%^?t;z(B2$B>.J8;z(B,SMALL ROMAN NUMERAL TWO")
(12 23 "$B%m!<%^?t;z(B3$B>.J8;z(B,SMALL ROMAN NUMERAL THREE")
(12 24 "$B%m!<%^?t;z(B4$B>.J8;z(B,SMALL ROMAN NUMERAL FOUR")
(12 25 "$B%m!<%^?t;z(B5$B>.J8;z(B,SMALL ROMAN NUMERAL FIVE")
(12 26 "$B%m!<%^?t;z(B6$B>.J8;z(B,SMALL ROMAN NUMERAL SIX")
(12 27 "$B%m!<%^?t;z(B7$B>.J8;z(B,SMALL ROMAN NUMERAL SEVEN")
(12 28 "$B%m!<%^?t;z(B8$B>.J8;z(B,SMALL ROMAN NUMERAL EIGHT")
(12 29 "$B%m!<%^?t;z(B9$B>.J8;z(B,SMALL ROMAN NUMERAL NINE")
(12 30 "$B%m!<%^?t;z(B10$B>.J8;z(B,SMALL ROMAN NUMERAL TEN")
(12 31 "$B%m!<%^?t;z(B11$B>.J8;z(B,SMALL ROMAN NUMERAL ELEVEN")
(12 32 "$B%m!<%^?t;z(B12$B>.J8;z(B,SMALL ROMAN NUMERAL TWELVE")
(12 33 "$B4](BA$B>.J8;z(B,CIRCLED LATIN SMALL LETTER A")
(12 34 "$B4](BB$B>.J8;z(B,CIRCLED LATIN SMALL LETTER B")
(12 35 "$B4](BC$B>.J8;z(B,CIRCLED LATIN SMALL LETTER C")
(12 36 "$B4](BD$B>.J8;z(B,CIRCLED LATIN SMALL LETTER D")
(12 37 "$B4](BE$B>.J8;z(B,CIRCLED LATIN SMALL LETTER E")
(12 38 "$B4](BF$B>.J8;z(B,CIRCLED LATIN SMALL LETTER F")
(12 39 "$B4](BG$B>.J8;z(B,CIRCLED LATIN SMALL LETTER G")
(12 40 "$B4](BH$B>.J8;z(B,CIRCLED LATIN SMALL LETTER H")
(12 41 "$B4](BI$B>.J8;z(B,CIRCLED LATIN SMALL LETTER I")
(12 42 "$B4](BJ$B>.J8;z(B,CIRCLED LATIN SMALL LETTER J")
(12 43 "$B4](BK$B>.J8;z(B,CIRCLED LATIN SMALL LETTER K")
(12 44 "$B4](BL$B>.J8;z(B,CIRCLED LATIN SMALL LETTER L")
(12 45 "$B4](BM$B>.J8;z(B,CIRCLED LATIN SMALL LETTER M")
(12 46 "$B4](BN$B>.J8;z(B,CIRCLED LATIN SMALL LETTER N")
(12 47 "$B4](BO$B>.J8;z(B,CIRCLED LATIN SMALL LETTER O")
(12 48 "$B4](BP$B>.J8;z(B,CIRCLED LATIN SMALL LETTER P")
(12 49 "$B4](BQ$B>.J8;z(B,CIRCLED LATIN SMALL LETTER Q")
(12 50 "$B4](BR$B>.J8;z(B,CIRCLED LATIN SMALL LETTER R")
(12 51 "$B4](BS$B>.J8;z(B,CIRCLED LATIN SMALL LETTER S")
(12 52 "$B4](BT$B>.J8;z(B,CIRCLED LATIN SMALL LETTER T")
(12 53 "$B4](BU$B>.J8;z(B,CIRCLED LATIN SMALL LETTER U")
(12 54 "$B4](BV$B>.J8;z(B,CIRCLED LATIN SMALL LETTER V")
(12 55 "$B4](BW$B>.J8;z(B,CIRCLED LATIN SMALL LETTER W")
(12 56 "$B4](BX$B>.J8;z(B,CIRCLED LATIN SMALL LETTER X")
(12 57 "$B4](BY$B>.J8;z(B,CIRCLED LATIN SMALL LETTER Y")
(12 58 "$B4](BZ$B>.J8;z(B,CIRCLED LATIN SMALL LETTER Z")
(12 59 "$B4]%"(B,CIRCLED KATAKANA A")
(12 60 "$B4]%$(B,CIRCLED KATAKANA I")
(12 61 "$B4]%&(B,CIRCLED KATAKANA U")
(12 62 "$B4]%((B,CIRCLED KATAKANA E")
(12 63 "$B4]%*(B,CIRCLED KATAKANA O")
(12 64 "$B4]%+(B,CIRCLED KATAKANA KA")
(12 65 "$B4]%-(B,CIRCLED KATAKANA KI")
(12 66 "$B4]%/(B,CIRCLED KATAKANA KU")
(12 67 "$B4]%1(B,CIRCLED KATAKANA KE")
(12 68 "$B4]%3(B,CIRCLED KATAKANA KO")
(12 69 "$B4]%5(B,CIRCLED KATAKANA SA")
(12 70 "$B4]%7(B,CIRCLED KATAKANA SI")
(12 71 "$B4]%9(B,CIRCLED KATAKANA SU")
(12 72 "$B4]%;(B,CIRCLED KATAKANA SE")
(12 73 "$B4]%=(B,CIRCLED KATAKANA SO")
(12 74 "$B4]%?(B,CIRCLED KATAKANA TA")
(12 75 "$B4]%A(B,CIRCLED KATAKANA TI")
(12 76 "$B4]%D(B,CIRCLED KATAKANA TU")
(12 77 "$B4]%F(B,CIRCLED KATAKANA TE")
(12 78 "$B4]%H(B,CIRCLED KATAKANA TO")
(12 79 "$B4]%m(B,CIRCLED KATAKANA RO")
(12 80 "$B4]%O(B,CIRCLED KATAKANA HA")
(12 81 "$B4]%K(B,CIRCLED KATAKANA NI")
(12 82 "$B4]%[(B,CIRCLED KATAKANA HO")
(12 83 "$B4]%X(B,CIRCLED KATAKANA HE")
(12 93 "$B%@%V%k%"%9%F(B,TWO ASTERISKS ALIGNED VERTICALLY")
(12 94 "$B%"%9%F%j%:%`(B,ASTERISM")
(13 1 "$B4](B1,CIRCLED DIGIT ONE")
(13 2 "$B4](B2,CIRCLED DIGIT TWO")
(13 3 "$B4](B3,CIRCLED DIGIT THREE")
(13 4 "$B4](B4,CIRCLED DIGIT FOUR")
(13 5 "$B4](B5,CIRCLED DIGIT FIVE")
(13 6 "$B4](B6,CIRCLED DIGIT SIX")
(13 7 "$B4](B7,CIRCLED DIGIT SEVEN")
(13 8 "$B4](B8,CIRCLED DIGIT EIGHT")
(13 9 "$B4](B9,CIRCLED DIGIT NINE")
(13 10 "$B4](B10,CIRCLED NUMBER TEN")
(13 11 "$B4](B11,CIRCLED NUMBER ELEVEN")
(13 12 "$B4](B12,CIRCLED NUMBER TWELVE")
(13 13 "$B4](B13,CIRCLED NUMBER THIRTEEN")
(13 14 "$B4](B14,CIRCLED NUMBER FOURTEEN")
(13 15 "$B4](B15,CIRCLED NUMBER FIFTEEN")
(13 16 "$B4](B16,CIRCLED NUMBER SIXTEEN")
(13 17 "$B4](B17,CIRCLED NUMBER SEVENTEEN")
(13 18 "$B4](B18,CIRCLED NUMBER EIGHTEEN")
(13 19 "$B4](B19,CIRCLED NUMBER NINETEEN")
(13 20 "$B4](B20,CIRCLED NUMBER TWENTY")
(13 21 "$B%m!<%^?t;z(B1,ROMAN NUMERAL ONE")
(13 22 "$B%m!<%^?t;z(B2,ROMAN NUMERAL TWO")
(13 23 "$B%m!<%^?t;z(B3,ROMAN NUMERAL THREE")
(13 24 "$B%m!<%^?t;z(B4,ROMAN NUMERAL FOUR")
(13 25 "$B%m!<%^?t;z(B5,ROMAN NUMERAL FIVE")
(13 26 "$B%m!<%^?t;z(B6,ROMAN NUMERAL SIX")
(13 27 "$B%m!<%^?t;z(B7,ROMAN NUMERAL SEVEN")
(13 28 "$B%m!<%^?t;z(B8,ROMAN NUMERAL EIGHT")
(13 29 "$B%m!<%^?t;z(B9,ROMAN NUMERAL NINE")
(13 30 "$B%m!<%^?t;z(B10,ROMAN NUMERAL TEN")
(13 31 "$B%m!<%^?t;z(B11,ROMAN NUMERAL ELEVEN")
(13 32 "$BA43Q%_%j(B,SQUARE MIRI")
(13 33 "$BA43Q%-%m(B,SQUARE KIRO")
(13 34 "$BA43Q%;%s%A(B,SQUARE SENTI")
(13 35 "$BA43Q%a!<%H%k(B,SQUARE MEETORU")
(13 36 "$BA43Q%0%i%`(B,SQUARE GURAMU")
(13 37 "$BA43Q%H%s(B,SQUARE TON")
(13 38 "$BA43Q%"!<%k(B,SQUARE AARU")
(13 39 "$BA43Q%X%/%?!<%k(B,SQUARE HEKUTAARU")
(13 40 "$BA43Q%j%C%H%k(B,SQUARE RITTORU")
(13 41 "$BA43Q%o%C%H(B,SQUARE WATTO")
(13 42 "$BA43Q%+%m%j!<(B,SQUARE KARORII")
(13 43 "$BA43Q%I%k(B,SQUARE DORU")
(13 44 "$BA43Q%;%s%H(B,SQUARE SENTO")
(13 45 "$BA43Q%Q!<%;%s%H(B,SQUARE PAASENTO")
(13 46 "$BA43Q%_%j%P!<%k(B,SQUARE MIRIBAARU")
(13 47 "$BA43Q%Z!<%8(B,SQUARE PEEZI")
(13 48 "$BA43Q(BMM,SQUARE MM")
(13 49 "$BA43Q(BCM,SQUARE CM")
(13 50 "$BA43Q(BKM,SQUARE KM")
(13 51 "$BA43Q(BMG,SQUARE MG")
(13 52 "$BA43Q(BKG,SQUARE KG")
(13 53 "$BA43Q(BCC,SQUARE CC")
(13 54 "$BA43Q(BM2,SQUARE M SQUARED")
(13 55 "$B%m!<%^?t;z(B12,ROMAN NUMERAL TWELVE")
(13 63 "$BA43Q859fJ?@.(B,SQUARE ERA NAME HEISEI")
(13 64 "$B;O$a%@%V%k%_%K%e!<%H(B,REVERSED DOUBLE PRIME QUOTATION MARK")
(13 65 "$B=*$o$j%@%V%k%_%K%e!<%H(B,LOW DOUBLE PRIME QUOTATION MARK")
(13 66 "$BA43Q(BNO,NUMERO SIGN")
(13 67 "$BA43Q(BKK,SQUARE KK")
(13 68 "$BA43Q(BTEL,TELEPHONE SIGN")
(13 69 "$B4]IU$->e(B,CIRCLED IDEOGRAPH HIGH")
(13 70 "$B4]IU$-Cf(B,CIRCLED IDEOGRAPH CENTRE")
(13 71 "$B4]IU$-2<(B,CIRCLED IDEOGRAPH LOW")
(13 72 "$B4]IU$-:8(B,CIRCLED IDEOGRAPH LEFT")
(13 73 "$B4]IU$-1&(B,CIRCLED IDEOGRAPH RIGHT")
(13 74 "$BA43Q3g8LIU$-3t(B,PARENTHESIZED IDEOGRAPH STOCK")
(13 75 "$BA43Q3g8LIU$-M-(B,PARENTHESIZED IDEOGRAPH HAVE")
(13 76 "$BA43Q3g8LIU$-Be(B,PARENTHESIZED IDEOGRAPH REPRESENT")
(13 77 "$BA43Q859fL@<#(B,SQUARE ERA NAME MEIZI")
(13 78 "$BA43Q859fBg@5(B,SQUARE ERA NAME TAISYOU")
(13 79 "$BA43Q859f><OB(B,SQUARE ERA NAME SYOUWA")
(13 83 "$B7PO)@QJ,5-9f(B,CONTOUR INTEGRAL")
(13 88 "$B%U%!%/%H%j%"%k(B,$BD>3Q(B,RIGHT ANGLE")
(13 89 "$BD>3Q;03Q(B,RIGHT TRIANGLE")
(13 93 "$B;M$DI)(B,BLACK DIAMOND MINUS WHITE X")
(13 94 "$B;X<(%^!<%/(B,WHITE RIGHT POINTING INDEX")

(14 1 "2003$BDI(B")
(15 94 "2003$BDI2C(B")
(47 52 "2003$BDI2C(B")
(47 94 "2003$BDI2C(B")
(84 7 "2003$BDI2C(B")
(94 90 "2003$BDI2C(B")
(94 91 "2003$BDI2C(B")
(94 92 "2003$BDI2C(B")
(94 93 "2003$BDI2C(B")
(94 94 "2003$BDI2C(B")

)))
    (dolist (x l)
      (skk-tankan-set-char-annotaion
       (make-char 'japanese-jisx0213-1
		  (+ 32 (car x))
		  (+ 32 (nth 1 x)))
		  (nth 2 x)))))

(provide 'skk-tankan)

;;; skk-tankan.el ends here
