/* MountOperationAssistant.c generated by valac 0.12.1, the Vala compiler
 * generated from MountOperationAssistant.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Xutil.h>
#include <X11/Xregion.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdkx.h>
#include <widgets.h>
#include <float.h>
#include <math.h>


#define TYPE_MOUNT_OPERATION_ASSISTANT (mount_operation_assistant_get_type ())
#define MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistant))
#define MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))
#define IS_MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_OPERATION_ASSISTANT))
#define IS_MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_OPERATION_ASSISTANT))
#define MOUNT_OPERATION_ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))

typedef struct _MountOperationAssistant MountOperationAssistant;
typedef struct _MountOperationAssistantClass MountOperationAssistantClass;
typedef struct _MountOperationAssistantPrivate MountOperationAssistantPrivate;

#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;

#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())

struct _MountOperationAssistant {
	GMountOperation parent_instance;
	MountOperationAssistantPrivate * priv;
};

struct _MountOperationAssistantClass {
	GMountOperationClass parent_class;
};

struct _MountOperationAssistantPrivate {
	gchar* _label_button;
	gchar* _label_help;
	gchar* _label_title;
	gchar* _label_username;
	gchar* _label_password;
	gchar* _label_show_password;
	gchar* _label_remember_password;
	Window _xid;
	gboolean _go_forward;
	AssistantOperation* _assist;
	GtkBin* password_page;
	GtkBox* layout;
	GtkGrid* table;
	GtkRadioButton* anonymous_w;
	GtkCheckButton* remember_w;
	GtkEntry* username_w;
	GtkEntry* domain_w;
	GtkEntry* password_w;
	gboolean looping;
};

typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_SUMMARY,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;


static gpointer mount_operation_assistant_parent_class = NULL;

GType mount_operation_assistant_get_type (void) G_GNUC_CONST;
GType assistant_get_type (void) G_GNUC_CONST;
GType assistant_operation_get_type (void) G_GNUC_CONST;
#define MOUNT_OPERATION_ASSISTANT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantPrivate))
enum  {
	MOUNT_OPERATION_ASSISTANT_DUMMY_PROPERTY,
	MOUNT_OPERATION_ASSISTANT_LABEL_BUTTON,
	MOUNT_OPERATION_ASSISTANT_LABEL_HELP,
	MOUNT_OPERATION_ASSISTANT_LABEL_TITLE,
	MOUNT_OPERATION_ASSISTANT_LABEL_USERNAME,
	MOUNT_OPERATION_ASSISTANT_LABEL_PASSWORD,
	MOUNT_OPERATION_ASSISTANT_LABEL_SHOW_PASSWORD,
	MOUNT_OPERATION_ASSISTANT_LABEL_REMEMBER_PASSWORD,
	MOUNT_OPERATION_ASSISTANT_XID,
	MOUNT_OPERATION_ASSISTANT_GO_FORWARD,
	MOUNT_OPERATION_ASSISTANT_ASSIST
};
MountOperationAssistant* mount_operation_assistant_new (AssistantOperation* assist);
MountOperationAssistant* mount_operation_assistant_construct (GType object_type, AssistantOperation* assist);
static void mount_operation_assistant_do_prepare (MountOperationAssistant* self, Assistant* assist, GtkWidget* page);
static void _mount_operation_assistant_do_prepare_assistant_prepare (Assistant* _sender, GtkWidget* page, gpointer self);
static void mount_operation_assistant_do_backward (MountOperationAssistant* self, Assistant* assist);
static void _mount_operation_assistant_do_backward_assistant_backward (Assistant* _sender, gpointer self);
static void mount_operation_assistant_do_forward (MountOperationAssistant* self, Assistant* assist);
static void _mount_operation_assistant_do_forward_assistant_forward (Assistant* _sender, gpointer self);
static void mount_operation_assistant_do_close (MountOperationAssistant* self, AssistantOperation* op, gboolean success);
static void _mount_operation_assistant_do_close_assistant_operation_closing (AssistantOperation* _sender, gboolean success, gpointer self);
static void mount_operation_assistant_add_password_page (MountOperationAssistant* self);
static void mount_operation_assistant_set_xid (MountOperationAssistant* self, Window value);
static void mount_operation_assistant_go_forward_changed (MountOperationAssistant* mop);
gboolean mount_operation_assistant_get_go_forward (MountOperationAssistant* self);
AssistantOperation* mount_operation_assistant_get_assist (MountOperationAssistant* self);
void assistant_go_forward (Assistant* self);
static void mount_operation_assistant_real_aborted (GMountOperation* base);
void assistant_operation_show_error (AssistantOperation* self, const gchar* _error_, const gchar* detail);
static void mount_operation_assistant_real_ask_password (GMountOperation* base, const gchar* message, const gchar* default_user, const gchar* default_domain, GAskPasswordFlags flags);
static void mount_operation_assistant_flesh_out_password_page (MountOperationAssistant* self, const gchar* message, const gchar* default_user, const gchar* default_domain, GAskPasswordFlags flags);
void assistant_interrupt (Assistant* self, GtkWidget* page, gboolean can_continue);
static void mount_operation_assistant_check_valid_inputs (MountOperationAssistant* self);
void assistant_set_header_icon (Assistant* self, const gchar* name);
void assistant_operation_force_visible (AssistantOperation* self, gboolean user_click);
static void mount_operation_assistant_real_ask_question (GMountOperation* base, const gchar* message, gchar** choices);
static void _lambda23_ (GMountOperation* t, GMountOperationResult r, MountOperationAssistant* self);
static void mount_operation_assistant_send_reply (MountOperationAssistant* self, GMountOperationResult _result_);
static void __lambda23__g_mount_operation_reply (GMountOperation* _sender, GMountOperationResult _result_, gpointer self);
GType assistant_type_get_type (void) G_GNUC_CONST;
void assistant_append_page (Assistant* self, GtkWidget* page, AssistantType type);
void assistant_set_page_title (Assistant* self, GtkWidget* page, const gchar* title);
const gchar* mount_operation_assistant_get_label_title (MountOperationAssistant* self);
const gchar* mount_operation_assistant_get_label_help (MountOperationAssistant* self);
const gchar* mount_operation_assistant_get_label_button (MountOperationAssistant* self);
static void _lambda17_ (MountOperationAssistant* self);
static void __lambda17__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda18_ (GtkToggleButton* b, MountOperationAssistant* self);
static void __lambda18__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _lambda19_ (GtkToggleButton* b, MountOperationAssistant* self);
static void __lambda19__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _lambda20_ (GtkEditable* e, MountOperationAssistant* self);
static void __lambda20__gtk_editable_changed (GtkEditable* _sender, gpointer self);
const gchar* mount_operation_assistant_get_label_username (MountOperationAssistant* self);
static void _lambda21_ (GtkEditable* e, MountOperationAssistant* self);
static void __lambda21__gtk_editable_changed (GtkEditable* _sender, gpointer self);
const gchar* mount_operation_assistant_get_label_password (MountOperationAssistant* self);
const gchar* mount_operation_assistant_get_label_show_password (MountOperationAssistant* self);
static void _lambda22_ (GtkToggleButton* button, MountOperationAssistant* self);
static void __lambda22__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
const gchar* mount_operation_assistant_get_label_remember_password (MountOperationAssistant* self);
static gboolean mount_operation_assistant_is_valid_entry (MountOperationAssistant* self, GtkEntry* e);
static gboolean mount_operation_assistant_is_anonymous (MountOperationAssistant* self);
void assistant_allow_forward (Assistant* self, gboolean allow);
void mount_operation_assistant_set_label_button (MountOperationAssistant* self, const gchar* value);
void mount_operation_assistant_set_label_help (MountOperationAssistant* self, const gchar* value);
void mount_operation_assistant_set_label_title (MountOperationAssistant* self, const gchar* value);
void mount_operation_assistant_set_label_username (MountOperationAssistant* self, const gchar* value);
void mount_operation_assistant_set_label_password (MountOperationAssistant* self, const gchar* value);
void mount_operation_assistant_set_label_show_password (MountOperationAssistant* self, const gchar* value);
void mount_operation_assistant_set_label_remember_password (MountOperationAssistant* self, const gchar* value);
Window mount_operation_assistant_get_xid (MountOperationAssistant* self);
void mount_operation_assistant_set_go_forward (MountOperationAssistant* self, gboolean value);
static void mount_operation_assistant_set_assist (MountOperationAssistant* self, AssistantOperation* value);
static GObject * mount_operation_assistant_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void mount_operation_assistant_finalize (GObject* obj);
static void _vala_mount_operation_assistant_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_mount_operation_assistant_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _mount_operation_assistant_do_prepare_assistant_prepare (Assistant* _sender, GtkWidget* page, gpointer self) {
	mount_operation_assistant_do_prepare (self, _sender, page);
}


static void _mount_operation_assistant_do_backward_assistant_backward (Assistant* _sender, gpointer self) {
	mount_operation_assistant_do_backward (self, _sender);
}


static void _mount_operation_assistant_do_forward_assistant_forward (Assistant* _sender, gpointer self) {
	mount_operation_assistant_do_forward (self, _sender);
}


static void _mount_operation_assistant_do_close_assistant_operation_closing (AssistantOperation* _sender, gboolean success, gpointer self) {
	mount_operation_assistant_do_close (self, _sender, success);
}


MountOperationAssistant* mount_operation_assistant_construct (GType object_type, AssistantOperation* assist) {
	MountOperationAssistant * self = NULL;
	GdkWindow* _tmp0_ = NULL;
	Window _tmp1_;
	g_return_val_if_fail (assist != NULL, NULL);
	self = (MountOperationAssistant*) g_object_new (object_type, "assist", assist, NULL);
	g_signal_connect_object ((Assistant*) assist, "prepare", (GCallback) _mount_operation_assistant_do_prepare_assistant_prepare, self, 0);
	g_signal_connect_object ((Assistant*) assist, "backward", (GCallback) _mount_operation_assistant_do_backward_assistant_backward, self, 0);
	g_signal_connect_object ((Assistant*) assist, "forward", (GCallback) _mount_operation_assistant_do_forward_assistant_forward, self, 0);
	g_signal_connect_object (assist, "closing", (GCallback) _mount_operation_assistant_do_close_assistant_operation_closing, self, 0);
	mount_operation_assistant_add_password_page (self);
	gtk_widget_realize ((GtkWidget*) assist);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) assist);
	_tmp1_ = gdk_x11_window_get_xid (_tmp0_);
	mount_operation_assistant_set_xid (self, _tmp1_);
	return self;
}


MountOperationAssistant* mount_operation_assistant_new (AssistantOperation* assist) {
	return mount_operation_assistant_construct (TYPE_MOUNT_OPERATION_ASSISTANT, assist);
}


static void mount_operation_assistant_go_forward_changed (MountOperationAssistant* mop) {
	g_return_if_fail (mop != NULL);
	if (mop->priv->_go_forward) {
		assistant_go_forward ((Assistant*) mop->priv->_assist);
	}
}


static void mount_operation_assistant_real_aborted (GMountOperation* base) {
	MountOperationAssistant * self;
	const gchar* _tmp0_ = NULL;
	self = (MountOperationAssistant*) base;
	_tmp0_ = _ ("Location not available");
	assistant_operation_show_error (self->priv->_assist, _tmp0_, NULL);
}


static void mount_operation_assistant_real_ask_password (GMountOperation* base, const gchar* message, const gchar* default_user, const gchar* default_domain, GAskPasswordFlags flags) {
	MountOperationAssistant * self;
	self = (MountOperationAssistant*) base;
	g_return_if_fail (message != NULL);
	g_return_if_fail (default_user != NULL);
	g_return_if_fail (default_domain != NULL);
	mount_operation_assistant_flesh_out_password_page (self, message, default_user, default_domain, flags);
	assistant_interrupt ((Assistant*) self->priv->_assist, (GtkWidget*) self->priv->password_page, TRUE);
	self->priv->looping = TRUE;
	mount_operation_assistant_check_valid_inputs (self);
	assistant_set_header_icon ((Assistant*) self->priv->_assist, GTK_STOCK_DIALOG_AUTHENTICATION);
	assistant_operation_force_visible (self->priv->_assist, FALSE);
	gtk_main ();
}


static void _lambda23_ (GMountOperation* t, GMountOperationResult r, MountOperationAssistant* self) {
	gint _tmp0_;
	g_return_if_fail (t != NULL);
	_tmp0_ = g_mount_operation_get_choice (t);
	g_mount_operation_set_choice ((GMountOperation*) self, _tmp0_);
	mount_operation_assistant_send_reply (self, r);
}


static void __lambda23__g_mount_operation_reply (GMountOperation* _sender, GMountOperationResult _result_, gpointer self) {
	_lambda23_ (_sender, _result_, self);
}


static void mount_operation_assistant_real_ask_question (GMountOperation* base, const gchar* message, gchar** choices) {
	MountOperationAssistant * self;
	GtkMountOperation* _tmp0_ = NULL;
	GtkMountOperation* t;
	self = (MountOperationAssistant*) base;
	g_return_if_fail (message != NULL);
	_tmp0_ = (GtkMountOperation*) gtk_mount_operation_new ((GtkWindow*) self->priv->_assist);
	t = _tmp0_;
	g_signal_connect_object ((GMountOperation*) t, "reply", (GCallback) __lambda23__g_mount_operation_reply, self, 0);
	self->priv->looping = TRUE;
	g_signal_emit_by_name ((GMountOperation*) t, "ask-question", message, choices, -1);
	gtk_main ();
	_g_object_unref0 (t);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void mount_operation_assistant_add_password_page (MountOperationAssistant* self) {
	GtkEventBox* _tmp0_ = NULL;
	GtkEventBox* page;
	GtkBin* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkEventBox*) gtk_event_box_new ();
	page = g_object_ref_sink (_tmp0_);
	assistant_append_page ((Assistant*) self->priv->_assist, (GtkWidget*) page, ASSISTANT_TYPE_INTERRUPT);
	_tmp1_ = _g_object_ref0 ((GtkBin*) page);
	_g_object_unref0 (self->priv->password_page);
	self->priv->password_page = _tmp1_;
	_g_object_unref0 (page);
}


static void _lambda17_ (MountOperationAssistant* self) {
	g_signal_emit_by_name (self, "button-clicked");
}


static void __lambda17__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda17_ (self);
}


static void _lambda18_ (GtkToggleButton* b, MountOperationAssistant* self) {
	g_return_if_fail (b != NULL);
	mount_operation_assistant_check_valid_inputs (self);
}


static void __lambda18__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda18_ (_sender, self);
}


static void _lambda19_ (GtkToggleButton* b, MountOperationAssistant* self) {
	gboolean _tmp0_;
	g_return_if_fail (b != NULL);
	_tmp0_ = gtk_toggle_button_get_active (b);
	gtk_widget_set_sensitive ((GtkWidget*) self->priv->table, !_tmp0_);
}


static void __lambda19__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda19_ (_sender, self);
}


static void _lambda20_ (GtkEditable* e, MountOperationAssistant* self) {
	g_return_if_fail (e != NULL);
	mount_operation_assistant_check_valid_inputs (self);
}


static void __lambda20__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	_lambda20_ (_sender, self);
}


static void _lambda21_ (GtkEditable* e, MountOperationAssistant* self) {
	g_return_if_fail (e != NULL);
	mount_operation_assistant_check_valid_inputs (self);
}


static void __lambda21__gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	_lambda21_ (_sender, self);
}


static void _lambda22_ (GtkToggleButton* button, MountOperationAssistant* self) {
	gboolean _tmp0_;
	g_return_if_fail (button != NULL);
	_tmp0_ = gtk_toggle_button_get_active (button);
	gtk_entry_set_visibility (self->priv->password_w, _tmp0_);
}


static void __lambda22__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda22_ (_sender, self);
}


static void mount_operation_assistant_flesh_out_password_page (MountOperationAssistant* self, const gchar* message, const gchar* default_user, const gchar* default_domain, GAskPasswordFlags flags) {
	GtkBox* _tmp0_ = NULL;
	GtkGrid* _tmp1_ = NULL;
	gint rows;
	gint ucol;
	GtkLabel* label = NULL;
	GtkLabel* _tmp2_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (default_user != NULL);
	g_return_if_fail (default_domain != NULL);
	if (self->priv->layout != NULL) {
		deja_dup_destroy_widget ((GtkWidget*) self->priv->layout);
	}
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	_g_object_unref0 (self->priv->layout);
	self->priv->layout = g_object_ref_sink (_tmp0_);
	g_object_set ((GObject*) self->priv->layout, "border-width", 12, NULL);
	_tmp1_ = (GtkGrid*) gtk_grid_new ();
	_g_object_unref0 (self->priv->table);
	self->priv->table = g_object_ref_sink (_tmp1_);
	g_object_set ((GObject*) self->priv->table, "row-spacing", 6, "column-spacing", 6, NULL);
	gtk_container_add ((GtkContainer*) self->priv->password_page, (GtkWidget*) self->priv->layout);
	rows = 0;
	ucol = 0;
	assistant_set_page_title ((Assistant*) self->priv->_assist, (GtkWidget*) self->priv->password_page, self->priv->_label_title);
	_tmp2_ = (GtkLabel*) gtk_label_new (message);
	_g_object_unref0 (label);
	label = g_object_ref_sink (_tmp2_);
	g_object_set ((GtkMisc*) label, "xalign", 0.0f, NULL);
	gtk_box_pack_start (self->priv->layout, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	if (self->priv->_label_help != NULL) {
		GtkLabel* _tmp3_ = NULL;
		_tmp3_ = (GtkLabel*) gtk_label_new (self->priv->_label_help);
		_g_object_unref0 (label);
		label = g_object_ref_sink (_tmp3_);
		gtk_label_set_use_markup (label, TRUE);
		gtk_label_set_track_visited_links (label, FALSE);
		g_object_set ((GObject*) label, "xalign", 0.f, NULL);
		gtk_box_pack_start (self->priv->layout, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	}
	_tmp4_ = (GtkLabel*) gtk_label_new ("");
	_g_object_unref0 (label);
	label = g_object_ref_sink (_tmp4_);
	gtk_box_pack_start (self->priv->layout, (GtkWidget*) label, FALSE, FALSE, (guint) 0);
	if (self->priv->_label_button != NULL) {
		GtkAlignment* _tmp5_ = NULL;
		GtkAlignment* alignment;
		GtkButton* _tmp6_ = NULL;
		GtkButton* button;
		_tmp5_ = (GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, (gfloat) 0, (gfloat) 0);
		alignment = g_object_ref_sink (_tmp5_);
		_tmp6_ = (GtkButton*) gtk_button_new_with_mnemonic (self->priv->_label_button);
		button = g_object_ref_sink (_tmp6_);
		g_signal_connect_object (button, "clicked", (GCallback) __lambda17__gtk_button_clicked, self, 0);
		gtk_container_add ((GtkContainer*) alignment, (GtkWidget*) button);
		gtk_box_pack_start (self->priv->layout, (GtkWidget*) alignment, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (button);
		_g_object_unref0 (alignment);
	}
	if ((flags & G_ASK_PASSWORD_ANONYMOUS_SUPPORTED) != 0) {
		const gchar* _tmp7_ = NULL;
		GtkRadioButton* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		GtkRadioButton* _tmp10_ = NULL;
		GtkRadioButton* w;
		GtkBox* _tmp11_ = NULL;
		GtkBox* hbox;
		GtkLabel* _tmp12_ = NULL;
		GtkLabel* _tmp13_;
		_tmp7_ = _ ("Connect _anonymously");
		_tmp8_ = (GtkRadioButton*) gtk_radio_button_new_with_mnemonic (NULL, _tmp7_);
		_g_object_unref0 (self->priv->anonymous_w);
		self->priv->anonymous_w = g_object_ref_sink (_tmp8_);
		g_signal_connect_object ((GtkToggleButton*) self->priv->anonymous_w, "toggled", (GCallback) __lambda18__gtk_toggle_button_toggled, self, 0);
		gtk_box_pack_start (self->priv->layout, (GtkWidget*) self->priv->anonymous_w, FALSE, FALSE, (guint) 0);
		_tmp9_ = _ ("Connect as u_ser");
		_tmp10_ = (GtkRadioButton*) gtk_radio_button_new_with_mnemonic_from_widget (self->priv->anonymous_w, _tmp9_);
		w = g_object_ref_sink (_tmp10_);
		g_signal_connect_object ((GtkToggleButton*) self->priv->anonymous_w, "toggled", (GCallback) __lambda19__gtk_toggle_button_toggled, self, 0);
		gtk_widget_set_sensitive ((GtkWidget*) self->priv->table, FALSE);
		gtk_box_pack_start (self->priv->layout, (GtkWidget*) w, FALSE, FALSE, (guint) 0);
		_tmp11_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
		hbox = g_object_ref_sink (_tmp11_);
		_tmp12_ = (GtkLabel*) gtk_label_new ("    ");
		_tmp13_ = g_object_ref_sink (_tmp12_);
		gtk_box_pack_start (hbox, (GtkWidget*) _tmp13_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (_tmp13_);
		gtk_box_pack_start (hbox, (GtkWidget*) self->priv->table, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start (self->priv->layout, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
		ucol = 1;
		_g_object_unref0 (hbox);
		_g_object_unref0 (w);
	} else {
		_g_object_unref0 (self->priv->anonymous_w);
		self->priv->anonymous_w = NULL;
		gtk_box_pack_start (self->priv->layout, (GtkWidget*) self->priv->table, FALSE, FALSE, (guint) 0);
	}
	if ((flags & G_ASK_PASSWORD_NEED_USERNAME) != 0) {
		GtkEntry* _tmp14_ = NULL;
		GtkLabel* _tmp15_ = NULL;
		_tmp14_ = (GtkEntry*) gtk_entry_new ();
		_g_object_unref0 (self->priv->username_w);
		self->priv->username_w = g_object_ref_sink (_tmp14_);
		g_object_set ((GObject*) self->priv->username_w, "activates-default", TRUE, "text", default_user, NULL);
		gtk_widget_set_hexpand ((GtkWidget*) self->priv->username_w, TRUE);
		g_signal_connect_object ((GtkEditable*) self->priv->username_w, "changed", (GCallback) __lambda20__gtk_editable_changed, self, 0);
		_tmp15_ = (GtkLabel*) gtk_label_new (self->priv->_label_username);
		_g_object_unref0 (label);
		label = g_object_ref_sink (_tmp15_);
		g_object_set ((GObject*) label, "mnemonic-widget", self->priv->username_w, "use-underline", TRUE, "xalign", 1.0f, NULL);
		gtk_grid_attach (self->priv->table, (GtkWidget*) label, ucol, rows, 1, 1);
		gtk_grid_attach (self->priv->table, (GtkWidget*) self->priv->username_w, ucol + 1, rows, 2 - ucol, 1);
		rows = rows + 1;
	} else {
		_g_object_unref0 (self->priv->username_w);
		self->priv->username_w = NULL;
	}
	if ((flags & G_ASK_PASSWORD_NEED_DOMAIN) != 0) {
		GtkEntry* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		GtkLabel* _tmp18_ = NULL;
		_tmp16_ = (GtkEntry*) gtk_entry_new ();
		_g_object_unref0 (self->priv->domain_w);
		self->priv->domain_w = g_object_ref_sink (_tmp16_);
		g_object_set ((GObject*) self->priv->domain_w, "activates-default", TRUE, "text", default_domain, NULL);
		gtk_widget_set_hexpand ((GtkWidget*) self->priv->domain_w, TRUE);
		g_signal_connect_object ((GtkEditable*) self->priv->domain_w, "changed", (GCallback) __lambda21__gtk_editable_changed, self, 0);
		_tmp17_ = _ ("_Domain");
		_tmp18_ = (GtkLabel*) gtk_label_new (_tmp17_);
		_g_object_unref0 (label);
		label = g_object_ref_sink (_tmp18_);
		g_object_set ((GObject*) label, "mnemonic-widget", self->priv->domain_w, "use-underline", TRUE, "xalign", 1.0f, NULL);
		gtk_grid_attach (self->priv->table, (GtkWidget*) label, ucol, rows, 1, 1);
		gtk_grid_attach (self->priv->table, (GtkWidget*) self->priv->domain_w, ucol + 1, rows, 2 - ucol, 1);
		rows = rows + 1;
	} else {
		_g_object_unref0 (self->priv->domain_w);
		self->priv->domain_w = NULL;
	}
	if ((flags & G_ASK_PASSWORD_NEED_PASSWORD) != 0) {
		GtkEntry* _tmp19_ = NULL;
		GtkLabel* _tmp20_ = NULL;
		GtkCheckButton* _tmp21_ = NULL;
		GtkCheckButton* w;
		_tmp19_ = (GtkEntry*) gtk_entry_new ();
		_g_object_unref0 (self->priv->password_w);
		self->priv->password_w = g_object_ref_sink (_tmp19_);
		g_object_set ((GObject*) self->priv->password_w, "visibility", FALSE, "activates-default", TRUE, NULL);
		gtk_widget_set_hexpand ((GtkWidget*) self->priv->password_w, TRUE);
		_tmp20_ = (GtkLabel*) gtk_label_new (self->priv->_label_password);
		_g_object_unref0 (label);
		label = g_object_ref_sink (_tmp20_);
		g_object_set ((GObject*) label, "mnemonic-widget", self->priv->password_w, "use-underline", TRUE, "xalign", 1.0f, NULL);
		gtk_grid_attach (self->priv->table, (GtkWidget*) label, ucol, rows, 1, 1);
		gtk_grid_attach (self->priv->table, (GtkWidget*) self->priv->password_w, ucol + 1, rows, 2 - ucol, 1);
		rows = rows + 1;
		_tmp21_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (self->priv->_label_show_password);
		w = g_object_ref_sink (_tmp21_);
		g_signal_connect_object ((GtkToggleButton*) GTK_CHECK_BUTTON (w), "toggled", (GCallback) __lambda22__gtk_toggle_button_toggled, self, 0);
		gtk_grid_attach (self->priv->table, (GtkWidget*) w, ucol + 1, rows, 2 - ucol, 1);
		rows = rows + 1;
		_g_object_unref0 (w);
	} else {
		_g_object_unref0 (self->priv->password_w);
		self->priv->password_w = NULL;
	}
	if ((flags & G_ASK_PASSWORD_SAVING_SUPPORTED) != 0) {
		GtkCheckButton* _tmp22_ = NULL;
		_tmp22_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (self->priv->_label_remember_password);
		_g_object_unref0 (self->priv->remember_w);
		self->priv->remember_w = g_object_ref_sink (_tmp22_);
		gtk_grid_attach (self->priv->table, (GtkWidget*) self->priv->remember_w, ucol + 1, rows, 2 - ucol, 1);
		rows = rows + 1;
	} else {
		_g_object_unref0 (self->priv->remember_w);
		self->priv->remember_w = NULL;
	}
	gtk_widget_show_all ((GtkWidget*) self->priv->password_page);
	_g_object_unref0 (label);
}


static gboolean mount_operation_assistant_is_valid_entry (MountOperationAssistant* self, GtkEntry* e) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (e == NULL) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		const gchar* _tmp2_ = NULL;
		_tmp2_ = gtk_entry_get_text (e);
		if (_tmp2_ != NULL) {
			const gchar* _tmp3_ = NULL;
			_tmp3_ = gtk_entry_get_text (e);
			_tmp1_ = g_strcmp0 (_tmp3_, "") != 0;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	result = _tmp0_;
	return result;
}


static gboolean mount_operation_assistant_is_anonymous (MountOperationAssistant* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->anonymous_w != NULL) {
		gboolean _tmp1_;
		_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->anonymous_w);
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void mount_operation_assistant_check_valid_inputs (MountOperationAssistant* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean valid;
	g_return_if_fail (self != NULL);
	_tmp1_ = mount_operation_assistant_is_anonymous (self);
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		_tmp3_ = mount_operation_assistant_is_valid_entry (self, self->priv->username_w);
		if (_tmp3_) {
			gboolean _tmp4_;
			_tmp4_ = mount_operation_assistant_is_valid_entry (self, self->priv->domain_w);
			_tmp2_ = _tmp4_;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	valid = _tmp0_;
	if (self->priv->_label_button != NULL) {
		valid = FALSE;
	}
	assistant_allow_forward ((Assistant*) self->priv->_assist, valid);
}


static void mount_operation_assistant_send_reply (MountOperationAssistant* self, GMountOperationResult _result_) {
	g_return_if_fail (self != NULL);
	if (self->priv->looping) {
		gtk_main_quit ();
		self->priv->looping = FALSE;
		g_mount_operation_reply ((GMountOperation*) self, _result_);
	}
}


static void mount_operation_assistant_do_close (MountOperationAssistant* self, AssistantOperation* op, gboolean success) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	mount_operation_assistant_send_reply (self, G_MOUNT_OPERATION_ABORTED);
}


static void mount_operation_assistant_do_backward (MountOperationAssistant* self, Assistant* assist) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (assist != NULL);
	mount_operation_assistant_send_reply (self, G_MOUNT_OPERATION_ABORTED);
}


static void mount_operation_assistant_do_forward (MountOperationAssistant* self, Assistant* assist) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (assist != NULL);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void mount_operation_assistant_do_prepare (MountOperationAssistant* self, Assistant* assist, GtkWidget* page) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	if (self->priv->looping) {
		if (self->priv->username_w != NULL) {
			const gchar* _tmp0_ = NULL;
			gchar* _tmp1_;
			gchar* txt;
			gchar* _tmp2_ = NULL;
			gchar* _tmp3_;
			_tmp0_ = gtk_entry_get_text (self->priv->username_w);
			_tmp1_ = g_strdup (_tmp0_);
			txt = _tmp1_;
			_tmp2_ = string_strip (txt);
			_tmp3_ = _tmp2_;
			g_mount_operation_set_username ((GMountOperation*) self, _tmp3_);
			_g_free0 (_tmp3_);
			_g_free0 (txt);
		}
		if (self->priv->domain_w != NULL) {
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_;
			gchar* txt;
			gchar* _tmp6_ = NULL;
			gchar* _tmp7_;
			_tmp4_ = gtk_entry_get_text (self->priv->domain_w);
			_tmp5_ = g_strdup (_tmp4_);
			txt = _tmp5_;
			_tmp6_ = string_strip (txt);
			_tmp7_ = _tmp6_;
			g_mount_operation_set_domain ((GMountOperation*) self, _tmp7_);
			_g_free0 (_tmp7_);
			_g_free0 (txt);
		}
		if (self->priv->password_w != NULL) {
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* txt;
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			_tmp8_ = gtk_entry_get_text (self->priv->password_w);
			_tmp9_ = g_strdup (_tmp8_);
			txt = _tmp9_;
			_tmp10_ = string_strip (txt);
			_tmp11_ = _tmp10_;
			g_mount_operation_set_password ((GMountOperation*) self, _tmp11_);
			_g_free0 (_tmp11_);
			_g_free0 (txt);
		}
		if (self->priv->anonymous_w != NULL) {
			gboolean _tmp12_;
			_tmp12_ = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->anonymous_w);
			g_mount_operation_set_anonymous ((GMountOperation*) self, _tmp12_);
		}
		if (self->priv->remember_w != NULL) {
			GPasswordSave _tmp13_ = 0;
			gboolean _tmp14_;
			_tmp14_ = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->remember_w);
			if (_tmp14_) {
				_tmp13_ = G_PASSWORD_SAVE_PERMANENTLY;
			} else {
				_tmp13_ = G_PASSWORD_SAVE_NEVER;
			}
			g_mount_operation_set_password_save ((GMountOperation*) self, _tmp13_);
		}
		mount_operation_assistant_send_reply (self, G_MOUNT_OPERATION_HANDLED);
	}
}


const gchar* mount_operation_assistant_get_label_button (MountOperationAssistant* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_label_button;
	return result;
}


void mount_operation_assistant_set_label_button (MountOperationAssistant* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_label_button);
	self->priv->_label_button = _tmp0_;
	g_object_notify ((GObject *) self, "label-button");
}


const gchar* mount_operation_assistant_get_label_help (MountOperationAssistant* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_label_help;
	return result;
}


void mount_operation_assistant_set_label_help (MountOperationAssistant* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_label_help);
	self->priv->_label_help = _tmp0_;
	g_object_notify ((GObject *) self, "label-help");
}


const gchar* mount_operation_assistant_get_label_title (MountOperationAssistant* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_label_title;
	return result;
}


void mount_operation_assistant_set_label_title (MountOperationAssistant* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_label_title);
	self->priv->_label_title = _tmp0_;
	g_object_notify ((GObject *) self, "label-title");
}


const gchar* mount_operation_assistant_get_label_username (MountOperationAssistant* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_label_username;
	return result;
}


void mount_operation_assistant_set_label_username (MountOperationAssistant* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_label_username);
	self->priv->_label_username = _tmp0_;
	g_object_notify ((GObject *) self, "label-username");
}


const gchar* mount_operation_assistant_get_label_password (MountOperationAssistant* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_label_password;
	return result;
}


void mount_operation_assistant_set_label_password (MountOperationAssistant* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_label_password);
	self->priv->_label_password = _tmp0_;
	g_object_notify ((GObject *) self, "label-password");
}


const gchar* mount_operation_assistant_get_label_show_password (MountOperationAssistant* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_label_show_password;
	return result;
}


void mount_operation_assistant_set_label_show_password (MountOperationAssistant* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_label_show_password);
	self->priv->_label_show_password = _tmp0_;
	g_object_notify ((GObject *) self, "label-show-password");
}


const gchar* mount_operation_assistant_get_label_remember_password (MountOperationAssistant* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_label_remember_password;
	return result;
}


void mount_operation_assistant_set_label_remember_password (MountOperationAssistant* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_label_remember_password);
	self->priv->_label_remember_password = _tmp0_;
	g_object_notify ((GObject *) self, "label-remember-password");
}


Window mount_operation_assistant_get_xid (MountOperationAssistant* self) {
	Window result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_xid;
	return result;
}


static void mount_operation_assistant_set_xid (MountOperationAssistant* self, Window value) {
	g_return_if_fail (self != NULL);
	self->priv->_xid = value;
	g_object_notify ((GObject *) self, "xid");
}


gboolean mount_operation_assistant_get_go_forward (MountOperationAssistant* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_go_forward;
	return result;
}


void mount_operation_assistant_set_go_forward (MountOperationAssistant* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_go_forward = value;
	g_object_notify ((GObject *) self, "go-forward");
}


AssistantOperation* mount_operation_assistant_get_assist (MountOperationAssistant* self) {
	AssistantOperation* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_assist;
	return result;
}


static void mount_operation_assistant_set_assist (MountOperationAssistant* self, AssistantOperation* value) {
	AssistantOperation* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_assist);
	self->priv->_assist = _tmp0_;
	g_object_notify ((GObject *) self, "assist");
}


static GObject * mount_operation_assistant_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	MountOperationAssistant * self;
	parent_class = G_OBJECT_CLASS (mount_operation_assistant_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = MOUNT_OPERATION_ASSISTANT (obj);
	g_signal_connect (self, "notify::go-forward", (GCallback) mount_operation_assistant_go_forward_changed, self);
	return obj;
}


static void mount_operation_assistant_class_init (MountOperationAssistantClass * klass) {
	mount_operation_assistant_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MountOperationAssistantPrivate));
	G_MOUNT_OPERATION_CLASS (klass)->aborted = mount_operation_assistant_real_aborted;
	G_MOUNT_OPERATION_CLASS (klass)->ask_password = mount_operation_assistant_real_ask_password;
	G_MOUNT_OPERATION_CLASS (klass)->ask_question = mount_operation_assistant_real_ask_question;
	G_OBJECT_CLASS (klass)->get_property = _vala_mount_operation_assistant_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_mount_operation_assistant_set_property;
	G_OBJECT_CLASS (klass)->constructor = mount_operation_assistant_constructor;
	G_OBJECT_CLASS (klass)->finalize = mount_operation_assistant_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_LABEL_BUTTON, g_param_spec_string ("label-button", "label-button", "label-button", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_LABEL_HELP, g_param_spec_string ("label-help", "label-help", "label-help", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_LABEL_TITLE, g_param_spec_string ("label-title", "label-title", "label-title", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_LABEL_USERNAME, g_param_spec_string ("label-username", "label-username", "label-username", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_LABEL_PASSWORD, g_param_spec_string ("label-password", "label-password", "label-password", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_LABEL_SHOW_PASSWORD, g_param_spec_string ("label-show-password", "label-show-password", "label-show-password", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_LABEL_REMEMBER_PASSWORD, g_param_spec_string ("label-remember-password", "label-remember-password", "label-remember-password", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_XID, g_param_spec_int ("xid", "xid", "xid", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_GO_FORWARD, g_param_spec_boolean ("go-forward", "go-forward", "go-forward", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MOUNT_OPERATION_ASSISTANT_ASSIST, g_param_spec_object ("assist", "assist", "assist", TYPE_ASSISTANT_OPERATION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_signal_new ("button_clicked", TYPE_MOUNT_OPERATION_ASSISTANT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void mount_operation_assistant_instance_init (MountOperationAssistant * self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	self->priv = MOUNT_OPERATION_ASSISTANT_GET_PRIVATE (self);
	_tmp0_ = _ ("Connect to Server");
	_tmp1_ = g_strdup (_tmp0_);
	self->priv->_label_title = _tmp1_;
	_tmp2_ = _ ("_Username");
	_tmp3_ = g_strdup (_tmp2_);
	self->priv->_label_username = _tmp3_;
	_tmp4_ = _ ("_Password");
	_tmp5_ = g_strdup (_tmp4_);
	self->priv->_label_password = _tmp5_;
	_tmp6_ = _ ("S_how password");
	_tmp7_ = g_strdup (_tmp6_);
	self->priv->_label_show_password = _tmp7_;
	_tmp8_ = _ ("_Remember password");
	_tmp9_ = g_strdup (_tmp8_);
	self->priv->_label_remember_password = _tmp9_;
	self->priv->_go_forward = FALSE;
	self->priv->looping = FALSE;
}


static void mount_operation_assistant_finalize (GObject* obj) {
	MountOperationAssistant * self;
	self = MOUNT_OPERATION_ASSISTANT (obj);
	_g_free0 (self->priv->_label_button);
	_g_free0 (self->priv->_label_help);
	_g_free0 (self->priv->_label_title);
	_g_free0 (self->priv->_label_username);
	_g_free0 (self->priv->_label_password);
	_g_free0 (self->priv->_label_show_password);
	_g_free0 (self->priv->_label_remember_password);
	_g_object_unref0 (self->priv->_assist);
	_g_object_unref0 (self->priv->password_page);
	_g_object_unref0 (self->priv->layout);
	_g_object_unref0 (self->priv->table);
	_g_object_unref0 (self->priv->anonymous_w);
	_g_object_unref0 (self->priv->remember_w);
	_g_object_unref0 (self->priv->username_w);
	_g_object_unref0 (self->priv->domain_w);
	_g_object_unref0 (self->priv->password_w);
	G_OBJECT_CLASS (mount_operation_assistant_parent_class)->finalize (obj);
}


/**
 * This class can be used by backends in one of two ways:
 * 1) Traditional way, by having this ask the user for info and then sending
 *    a reply signal.
 * 2) Or by driving the authentication themselves in some secret way.  If so,
 *    they will ask for a button to be shown to start the authentication.
 *    When they are done, they will set the 'go_forward' property to true.
 *    This is used by the U1 backend.
 */
GType mount_operation_assistant_get_type (void) {
	static volatile gsize mount_operation_assistant_type_id__volatile = 0;
	if (g_once_init_enter (&mount_operation_assistant_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MountOperationAssistantClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) mount_operation_assistant_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MountOperationAssistant), 0, (GInstanceInitFunc) mount_operation_assistant_instance_init, NULL };
		GType mount_operation_assistant_type_id;
		mount_operation_assistant_type_id = g_type_register_static (G_TYPE_MOUNT_OPERATION, "MountOperationAssistant", &g_define_type_info, 0);
		g_once_init_leave (&mount_operation_assistant_type_id__volatile, mount_operation_assistant_type_id);
	}
	return mount_operation_assistant_type_id__volatile;
}


static void _vala_mount_operation_assistant_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MountOperationAssistant * self;
	self = MOUNT_OPERATION_ASSISTANT (object);
	switch (property_id) {
		case MOUNT_OPERATION_ASSISTANT_LABEL_BUTTON:
		g_value_set_string (value, mount_operation_assistant_get_label_button (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_HELP:
		g_value_set_string (value, mount_operation_assistant_get_label_help (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_TITLE:
		g_value_set_string (value, mount_operation_assistant_get_label_title (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_USERNAME:
		g_value_set_string (value, mount_operation_assistant_get_label_username (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_PASSWORD:
		g_value_set_string (value, mount_operation_assistant_get_label_password (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_SHOW_PASSWORD:
		g_value_set_string (value, mount_operation_assistant_get_label_show_password (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_REMEMBER_PASSWORD:
		g_value_set_string (value, mount_operation_assistant_get_label_remember_password (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_XID:
		g_value_set_int (value, mount_operation_assistant_get_xid (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_GO_FORWARD:
		g_value_set_boolean (value, mount_operation_assistant_get_go_forward (self));
		break;
		case MOUNT_OPERATION_ASSISTANT_ASSIST:
		g_value_set_object (value, mount_operation_assistant_get_assist (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_mount_operation_assistant_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MountOperationAssistant * self;
	self = MOUNT_OPERATION_ASSISTANT (object);
	switch (property_id) {
		case MOUNT_OPERATION_ASSISTANT_LABEL_BUTTON:
		mount_operation_assistant_set_label_button (self, g_value_get_string (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_HELP:
		mount_operation_assistant_set_label_help (self, g_value_get_string (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_TITLE:
		mount_operation_assistant_set_label_title (self, g_value_get_string (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_USERNAME:
		mount_operation_assistant_set_label_username (self, g_value_get_string (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_PASSWORD:
		mount_operation_assistant_set_label_password (self, g_value_get_string (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_SHOW_PASSWORD:
		mount_operation_assistant_set_label_show_password (self, g_value_get_string (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_LABEL_REMEMBER_PASSWORD:
		mount_operation_assistant_set_label_remember_password (self, g_value_get_string (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_XID:
		mount_operation_assistant_set_xid (self, g_value_get_int (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_GO_FORWARD:
		mount_operation_assistant_set_go_forward (self, g_value_get_boolean (value));
		break;
		case MOUNT_OPERATION_ASSISTANT_ASSIST:
		mount_operation_assistant_set_assist (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



