/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __PLAY
#define __PLAY

#include "note.h"
#include "solver.h"
#include "audio.h"

//
// plays a tone
//

struct play {

  solver* get_wave; // solver linked to multi_curve

  float x; // current x on the waveform; x usually goes from 0 to 1. 0 = waveform start, 1 = waveform end ie 1 cycle.
  float dx; // change of x every audio buffer; determines how fast the waveform is sampled and hence the frequency of tone (equivalent to variable step in note.h)

  float left, right; // stereo volume of tone

  play (solver* s);
  play ();

  void init ();

  inline void set_step (float xd) {
    dx = xd;
  }

  inline void set (float xd, float l, float r) {
    dx = xd;
    left = l; right = r;
  }

  inline void set_wave (solver* w) {
    get_wave = w;
  }

  inline void set_volume (float l, float r) {
    left = l;
    right = r;
  }

  inline void solve (float* wav, int n) {
    (*get_wave)(x, dx, n, wav);
  }

  inline void solve_fm (float* wav, float* fm, int n) {
    (*get_wave) (x, dx, n, fm, wav);
  }

  inline void operator() (float* out, int n, float* wav, float chan) {
    // no modulation audio output
    for (int i = 0; i < n; ++i) out[i] += (chan * wav[i]);
  }

  inline void operator() (float* out, int n, float* wav, float* chan) {
    // no modulation audio output with chan array
    for (int i = 0; i < n; ++i) out[i] += (chan[i] * wav[i]);
  }


  inline void operator() (float* out, int n, float* wav, float* am, float chan) {
    // AM and FM modulation in audio output
    for (int i = 0; i < n; ++i) out[i] += ((chan + am[i]) * wav[i]);
  }

};

#endif
