"""Python script to build the OSX universal binaries.

Stolen with thankfulness from the numpy distribution

This is a simple script, most of the heavy lifting is done in bdist_mpkg.

To run this script:  'python build.py'

Installer is built using sudo so file permissions are correct when installed on
user system.  Script will prompt for sudo pwd.

"""

import os
import sys
import shutil
import subprocess
from optparse import OptionParser
from getpass import getuser

#USER_README = 'docs/README.txt'
#DEV_README = SRC_DIR + 'README.txt'

BUILD_DIR = 'build'
DIST_DIR = 'dist'
DIST_DMG_DIR = 'dist-dmg'

def remove_dirs(sudo):
    print 'Removing old build and distribution directories...'
    print """The distribution is built as root, so the files have the correct
    permissions when installed by the user.  Chown them to user for removal."""
    if os.path.exists(BUILD_DIR):
        cmd = 'chown -R %s %s' % (getuser(), BUILD_DIR)
        if sudo:
            cmd = 'sudo ' + cmd
        shellcmd(cmd)
        shutil.rmtree(BUILD_DIR)
    if os.path.exists(DIST_DIR):
        cmd = 'sudo chown -R %s %s' % (getuser(), DIST_DIR)
        if sudo:
            cmd = 'sudo ' + cmd
        shellcmd(cmd)
        shutil.rmtree(DIST_DIR)


def build_dist(readme, python_exe, sudo):
    print 'Building distribution... (using sudo)'
    cmd = '%s setup_egg.py bdist_mpkg --readme=%s' % (
        python_exe, readme)
    if sudo:
        cmd = 'sudo ' + cmd
    shellcmd(cmd)


def build_dmg(sudo):
    print 'Building disk image...'
    # Since we removed the dist directory at the start of the script,
    # our pkg should be the only file there.
    pkg = os.listdir(DIST_DIR)[0]
    fn, ext = os.path.splitext(pkg)
    dmg = fn + '.dmg'
    srcfolder = os.path.join(DIST_DIR, pkg)
    dstfolder = os.path.join(DIST_DMG_DIR, dmg)
    # build disk image
    try:
        os.mkdir(DIST_DMG_DIR)
    except OSError:
        pass
    try:
        os.unlink(dstfolder)
    except OSError:
        pass
    cmd = 'hdiutil create -srcfolder %s %s' % (srcfolder, dstfolder)
    if sudo:
        cmd = 'sudo ' + cmd
    shellcmd(cmd)

def copy_readme():
    """Copy a user README with info regarding the website, instead of
    the developer README which tells one how to build the source.
    """
    print 'Copy user README.txt for installer.'
    shutil.copy(USER_README, DEV_README)

def revert_readme():
    """Revert the developer README."""
    print 'Reverting README.txt...'
    cmd = 'svn revert %s' % DEV_README
    shellcmd(cmd)

def shellcmd(cmd, verbose=True):
    """Call a shell command."""
    if verbose:
        print cmd
    try:
        subprocess.check_call(cmd, shell=True)
    except subprocess.CalledProcessError, err:
        msg = """
        Error while executing a shell command.
        %s
        """ % str(err)
        raise Exception(msg)

def build():
    parser = OptionParser()
    parser.add_option("-p", "--python", dest="python",
                      default=sys.executable,
                      help="python interpreter executable",
                      metavar="PYTHON_EXE")
    parser.add_option("-r", "--readme", dest="readme",
                      default='README.txt',
                      help="README file",
                      metavar="README")
    parser.add_option("-s", "--sudo", dest="sudo",
                      default=False,
                      help="Run as sudo or no",
                      metavar="SUDO")
    (options, args) = parser.parse_args()
    try:
        src_dir = args[0]
    except IndexError:
        src_dir = '.'
    # Check source directory
    if not os.path.isfile(os.path.join(src_dir, 'setup.py')):
        raise RuntimeError('Run this script from directory '
                           'with setup.py, or pass in this '
                           'directory on command line')
    # update end-user documentation
    #copy_readme()
    #shellcmd("svn stat %s"%DEV_README)

    # change to source directory
    cwd = os.getcwd()
    os.chdir(src_dir)

    # build distribution
    remove_dirs(options.sudo)
    build_dist(options.readme, options.python, options.sudo)
    build_dmg(options.sudo)

    # change back to original directory
    os.chdir(cwd)
    # restore developer documentation
    #revert_readme()

if __name__ == '__main__':
    build()
