.\" dpkg manual page - dpkg-genchanges(1)
.\"
.\" Copyright © 1995-1996 Ian Jackson <ijackson@chiark.greenend.org.uk>
.\" Copyright © 2000 Wichert Akkerman <wakkerma@debian.org>
.\" Copyright © 2006-2016 Guillem Jover <guillem@debian.org>
.\" Copyright © 2008-2010 Raphaël Hertzog <hertzog@debian.org>
.\"
.\" This is free software; you can redistribute it and/or modify
.\" it under the terms of the GNU General Public License as published by
.\" the Free Software Foundation; either version 2 of the License, or
.\" (at your option) any later version.
.\"
.\" This is distributed in the hope that it will be useful,
.\" but WITHOUT ANY WARRANTY; without even the implied warranty of
.\" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\" GNU General Public License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see <https://www.gnu.org/licenses/>.
.
.TH dpkg\-genchanges 1 "%RELEASE_DATE%" "%VERSION%" "dpkg suite"
.nh
.SH NAME
dpkg\-genchanges \- generate Debian .changes files
.
.SH SYNOPSIS
.B dpkg\-genchanges
.RI [ option ...]
.br
.
.SH DESCRIPTION
.B dpkg\-genchanges
reads information from an unpacked and built Debian source tree and
from the files it has generated and generates a Debian upload control
file
.RB ( .changes " file)."
.
.SH OPTIONS
.TP
.BI \-\-build= type
Specifies the build \fItype\fP from a comma-separated list of components
(since dpkg 1.18.5).

The allowed values are:
.RS
.TP
.B source
Upload the source package.
.TP
.B any
Upload the architecture specific binary packages.
.TP
.B all
Upload the architecture independent binary packages.
.TP
.B binary
Upload the architecture specific and independent binary packages.
This is an alias for \fBany,all\fP.
.TP
.B full
Upload everything.
This is alias for \fBsource,any,all\fP, and the same as the default case
when no build option is specified.
.RE
.TP
.B \-g
Equivalent to \fB\-\-build=source,all\fP (since dpkg 1.17.11).
.TP
.B \-G
Equivalent to \fB\-\-build=source,any\fP (since dpkg 1.17.11).
.TP
.B \-b
Equivalent to \fB\-\-build=binary\fP or \fB\-\-build=any,all\fP.
.TP
.B \-B
Equivalent to \fB\-\-build=any\fP.
.TP
.B \-A
Equivalent to \fB\-\-build=all\fP.
.TP
.B \-S
Equivalent to \fB\-\-build=source\fP.
.PP
The \fB\-s\fP\fIx\fP options control whether the original source archive is
included in the upload if any source is being generated (i.e.
.BR \-b " or " \-B
haven't been used).
.TP
.B \-si
By default, or if specified, the original source will be included only if
the upstream version number (the version without epoch and without Debian
revision) differs from the upstream version number of the previous
changelog entry.
.TP
.B \-sa
Forces the inclusion of the original source.
.TP
.B \-sd
Forces the exclusion of the original source and includes only the diff.
.fi
.TP
.BI \-v version
Causes changelog information from all versions strictly later than
.I version
to be used.
.TP
.BI \-C changes-description
Read the description of the changes from the file
.I changes-description
rather than using the information from the source tree's changelog
file.
.TP
.BI \-m maintainer-address
Use
.I maintainer-address
as the name and email address of the maintainer for this package,
rather than using the information from the source tree's control file.
.TP
.BI \-e maintainer-address
Use
.I maintainer-address
as the name and email address of the maintainer for this upload,
rather than using the information from the source tree's changelog.
.TP
.BI \-V name = value
Set an output substitution variable.
See \fBdeb\-substvars\fP(5) for a discussion of output substitution.
.TP
.BI \-T substvars-file
Read substitution variables in
.IR substvars-file ;
the default is
.BR debian/substvars .
No variable substitution is done on any of the fields that are output,
however the special variable \fIFormat\fR will override the field of the
same name. This option can be used multiple times to read substitution
variables from multiple files (since dpkg 1.15.6).

.TP
.BI \-D field = value
Override or add an output control file field.
.TP
.BI \-U field
Remove an output control file field.
.TP
.BI \-c controlfile
Specifies the main source control file to read information from. The
default is
.BR debian/control .
.TP
.BI \-l changelog-file
Specifies the changelog file to read information from. The
default is
.BR debian/changelog .
.TP
.BI \-f files-list-file
Read the list of files to be uploaded here, rather than using
.BR debian/files .
.TP
.BI \-F changelog-format
Specifies the format of the changelog. See \fBdpkg\-parsechangelog\fP(1)
for information about alternative formats.
.TP
.BI \-u upload-files-dir
Look for the files to be uploaded in
.I upload-files-dir
rather than
.B ..
.RB ( dpkg\-genchanges
needs to find these files so that it can include their sizes and
checksums in the
.B .changes
file).
.TP
.B \-q
Usually
.B dpkg\-genchanges
will produce informative messages on standard error, for example about
how many of the package's source files are being uploaded.
.B \-q
suppresses these messages.
.TP
.BR \-O [\fIfilename\fP]
Print the changes file to standard output (the default) or to \fIfilename\fP
if specified (since dpkg 1.18.5).
.TP
.BR \-? ", " \-\-help
Show the usage message and exit.
.TP
.BR \-\-version
Show the version and exit.
.
.SH FILES
.TP
.B debian/files
The list of generated files which are part of the upload being
prepared.
.B dpkg\-genchanges
reads the data here when producing a
.B .changes
file.
.
.SH SEE ALSO
.ad l
.BR deb\-substvars (5),
.BR deb\-src\-control (5),
.BR deb\-src\-files (5),
.BR deb\-changelog (5),
.BR deb\-changes (5).
