/*******************************************************************************
 * Copyright (c) 2007, 2008 David Green and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     David Green - initial API and implementation
 *******************************************************************************/

package org.eclipse.mylyn.wikitext.textile.core;

import org.eclipse.mylyn.wikitext.tests.AbstractMarkupGenerationTest;
import org.junit.Test;

public class TextileCommentBlockTest extends AbstractMarkupGenerationTest<TextileLanguage> {

	@Test
	public void testSimpleComment() {
		assertMarkup("<p>one two</p><p>three</p>", "one two\n\n###. comment\n\nthree");
	}

	@Test
	public void testMultiLineComment() {
		assertMarkup("<p>one two</p><p>three</p>", "one two\n\n###. comment\nline two\nline three\n\nthree");
	}

	@Test
	public void testNotAComment() {
		assertMarkup("<p>one two</p><p>###.nocomment</p><p>three</p>", "one two\n\n###.nocomment\n\nthree");
	}

	@Test
	public void testNotAComment2() {
		assertMarkup("<p>one two<br/>###.nocomment</p><p>three</p>", "one two\n###.nocomment\n\nthree");
	}

	@Test
	public void testExtendedComment() {
		assertMarkup("<p>para</p>", "###.. extended comment\n\n\nwith more\n\np. para");
	}

	@Override
	protected TextileLanguage createMarkupLanguage() {
		return new TextileLanguage();
	}
}
