C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

#define INT_MISSING -2147483647

      SUBROUTINE CLEAR_C( )
C
C---->
C**** CLEAR_C
C
C     Purpose
C     -------
C
C     Sets start values for parameters in common block.
C
C
C     Interface
C     ---------
C
C     CALL CLEAR_C()
C
C
C     Method
C     ------
C
C     Hard coded defaults.
C
C
C     Externals
C     ---------
C
C     None.
C
C
C     Author
C     ------
C
C     J.D.Chambers       ECMWF        August 1994.
C
C----<
C
      IMPLICIT NONE
C
C
#include "parim.h"
#include "nifld.common"
#include "nofld.common"
#include "grfixed.h"
#include "current.h"
C
C     Local variables
C
      INTEGER IRET, LOOP
C
C     ------------------------------------------------------------------
C*    Section 1.   Initialise
C     ------------------------------------------------------------------
C
  100 CONTINUE
C
C     Set default processing flag settings.
C
      LCHANGE   = .TRUE.
      LSMCHNG   = .TRUE.
      LSM       = .TRUE.
      LPREC     = .FALSE.
      LWIND     = .FALSE.
C
C     Set default area indexes.
C
      NINS  = 0
      NIWE  = 0
      NO1NS = 0
      NO1WE = 0
      NONS  = 0
      NOWE  = 0
C
C     Defaults for output GRIB record ..
C     .. ECMWF local code table 128
C     .. level 500 hPa
C
      NOPARAM = 0
      NOTABLE = 128
      NOLEVT  = 100
      NOLEVEL = 500
      NOHFUNC = 'A'
C
C     Turn off all flags indicating that user has given a value.
C
      LSMPARSET = .FALSE.
      LSMSET    = .FALSE.
      LPRECSET  = .FALSE.
      LWINDSET  = .FALSE.
      LNIGAUS   = .FALSE.
      LNGSPEC   = .FALSE.
      LIGIVEL   = .FALSE.
      LIGIVEP   = .FALSE.
      LOGIVEL   = .FALSE.
      LOGIVEP   = .FALSE.
      LNOAREA   = .FALSE.
      LNORESO   = .FALSE.
      LNOGAUS   = .FALSE.
      LNOACC    = .FALSE.
      LNOREPR   = .FALSE.
      LNOTABL   = .FALSE.
      LNOPARA   = .FALSE.
      LNOLEVL   = .FALSE.
      LNOLEVT   = .FALSE.
      LNOGRID   = .FALSE.
      LNOFRAME  = .FALSE.
      LNOSTYLE  = .FALSE.
      LARESOL   = .FALSE.
      LINTOUT   = .FALSE.
      LIMISSV   = .FALSE.
cs double interpolation
      LDOUBLE   = .FALSE.
C
      RMISSGV   = REAL(INT_MISSING)
C
C     Clear input and output gaussian grid definitions
C
      NIGAUSS = 0
      NOGAUSS = 0
      DO 110 LOOP = 1, JPLAT
        RIGAUSS(LOOP) = 0.0
        MILLEN(LOOP) = 0
  110 CONTINUE
C
      DO 120 LOOP = 1, JPLAT
        ROGAUSS(LOOP) = 0.0
        NOLPTS(LOOP) = 0
  120 CONTINUE
C
C     Clear information about gaussian field definitions
C
      NGSPEC  = 0
      NIGAUSO = 0
      NOGAUSO = 0
      HIGAUST = 'X'
      HOGAUST = 'X'
C
C     Clear rotation angle values.
C
      NOROTA(1) = 0
      NOROTA(2) = 0
      LNOROTA   = .FALSE.
      LO12PT = .TRUE.
      LMETHOD = .FALSE.
C
C     Clear style and frame values
C
      NOFRAME = 0
      NOSTYLE = JPSMARS
C
C     Clear flags showing how to deal with legendre coefficients
C
      LFILEIO = .FALSE.
      LMEMORY = .FALSE.
      LSHARED = .FALSE.
      LON_FLY = .FALSE.
      LMAPPED = .FALSE.
      LIFIRST = .TRUE.
C
C     Clear fields for ISLSCP processing
C
      IF( LNIISCL ) THEN
        CALL JFREE(NIPOGRB)
        CALL JFREE(NIPNGRB) 
      ENDIF
      LNIISCL = .FALSE.
C
C     ------------------------------------------------------------------
C*    Section 9.   Closedown.
C     ------------------------------------------------------------------
C
  900 CONTINUE
C
      RETURN
      END
