C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      LOGICAL FUNCTION LSMFLD()
C
C---->
C**** LSMFLD
C
C     Purpose
C     -------
C
C     Determines whether or not the current field is to be
C     considered for 'land-sea mask' treatment.
C
C
C     Interface
C     ---------
C
C     LLSMFLD = LSMFLD()
C
C     Input
C     -----
C
C     None
C
C
C     Output
C     ------
C
C     Function returns .TRUE. if the field is to be treated with
C     land-sea mask.
C
C
C     Method
C     ------
C
C     Uses a set of hardcoded rules.
C
C
C     Externals
C     ---------
C
C     INTLOG  - Logs messages
C
C     Uses common blocks nifld.common and nofld.common.
C
C
C     Author
C     ------
C
C     J.D.Chambers     ECMWF     April 2001
C
C----<
C
      IMPLICIT NONE
C
#include "parim.h"
#include "nifld.common"
#include "nofld.common"
C
C     Local variables
C
      LOGICAL LIKELY
C
C     -----------------------------------------------------------------|
C*    Section 1. Initialise
C     -----------------------------------------------------------------|
C
  100 CONTINUE
C
C     If 'uselsm' has been forced to 'yes' ...
C
      IF( LSMSET ) THEN
        LSMFLD = LSM
        GOTO 900
      ENDIF
C
C     WMO International table 001 for meteorological parameters
C
      IF ( NITABLE.EQ.1 ) THEN
        LIKELY = ( NIPARAM.NE.2 )
C
C     ECMWF local code table 128 for meteorological parameters
C
      ELSEIF ( (NITABLE.EQ.128).OR.(NITABLE.EQ.129) ) THEN
        LIKELY = ( NIPARAM.NE.151 ).AND.
     X           ( NIPARAM.NE.172 )
      ELSE
        LIKELY = .FALSE.
      ENDIF
C
      IF( .NOT.LIKELY ) THEN
        LSMFLD = .FALSE.
        GOTO 900
      ENDIF
C
C     -----------------------------------------------------------------|
C*    Section 2. Work through the special cases
C     -----------------------------------------------------------------|
C
  200 CONTINUE
C
C     -----------------------------------------------------------------|
C*    Section 9.   Return
C     -----------------------------------------------------------------|
C
  900 CONTINUE
C
      IF( .NOT.LSMFLD ) THEN
        CALL INTLOG(JP_DEBUG,
     X    'LSMFLD: Do not handle field with land-sea mask', JPQUIET)
      ELSE
        CALL INTLOG(JP_DEBUG,
     X    'LSMFLD: Handle field with land-sea mask', JPQUIET)
      ENDIF
C
      RETURN
      END
