/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>

#include "glue.h"

#include "sinusgen.h"

struct cpssp{
	struct sig_std_logic *port_output;

	unsigned int state;
};

static void
sinusgen_tick(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	unsigned int mV;
	unsigned int mA;

	mV = (unsigned int) (2500.0 + 2000.0 * sin(2.0 * M_PI * (double) cpssp->state / 100.0));
	mA = mV * 0.5;

	sig_std_logic_set(cpssp->port_output, cpssp, SIG_COMB(mV, mA));

	cpssp->state = (cpssp->state + 1) % 100;

	/* In */
	time_call_at(time_virt() + TIME_HZ / 1000000, sinusgen_tick, cpssp);
	/*time_call_after(TIME_HZ / 10000, sinusgen_tick, cpssp);*/

}

void *
sinusgen_create(
	const char *name,
	struct sig_manage *port_manage,
	struct sig_std_logic *port_gnd,
	struct sig_std_logic *port_vcc,
	struct sig_std_logic *port_output
)
{

	struct cpssp *cpssp;

	cpssp = malloc(sizeof(*cpssp));
	assert(cpssp);

	cpssp->state = 0;

	/* Out */
	cpssp->port_output = port_output;
	sig_std_logic_connect_out(cpssp->port_output, cpssp, SIG_STD_LOGIC_0);

	/* In */
	time_call_at(time_virt() + TIME_HZ / 1000000, sinusgen_tick, cpssp);
	/*time_call_after(TIME_HZ / 100, sinusgen_tick, cpssp);*/

	return cpssp;
}


void
sinusgen_destroy(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;
	free(cpssp);
}

void
sinusgen_suspend(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_suspend(cpssp, sizeof(*cpssp), fp);
}

void
sinusgen_resume(void *_cpssp, FILE *fp)
{
	struct cpssp *cpssp = _cpssp;

	generic_resume(cpssp, sizeof(*cpssp), fp);
}
