/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.util;

import java.io.BufferedOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import nom.tam.util.BufferedDataInputStream;

public class BufferedDataOutputStream
extends BufferedOutputStream
implements DataOutput {
    public BufferedDataOutputStream(OutputStream o) {
        super(o);
    }

    public BufferedDataOutputStream(OutputStream o, int bufLength) {
        super(o, bufLength);
    }

    public void writeBoolean(boolean b) throws IOException {
        if (b) {
            this.write(1);
        } else {
            this.write(0);
        }
    }

    public void writeByte(int b) throws IOException {
        this.write((byte)b);
    }

    public void writeInt(int i) throws IOException {
        byte[] b = new byte[]{(byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)i};
        this.write(b, 0, 4);
    }

    public void writeShort(int s) throws IOException {
        byte[] b = new byte[]{(byte)(s >>> 8), (byte)s};
        this.write(b, 0, 2);
    }

    public void writeChar(int c) throws IOException {
        byte[] b = new byte[]{(byte)(c >>> 8), (byte)c};
        this.write(b, 0, 2);
    }

    public void writeLong(long l) throws IOException {
        byte[] b = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
        this.write(b, 0, 8);
    }

    public void writeFloat(float f) throws IOException {
        int i = Float.floatToIntBits(f);
        byte[] b = new byte[]{(byte)(i >>> 24), (byte)(i >>> 16), (byte)(i >>> 8), (byte)i};
        this.write(b, 0, 4);
    }

    public void writeDouble(double d) throws IOException {
        long l = Double.doubleToLongBits(d);
        byte[] b = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
        this.write(b, 0, 8);
    }

    public void writeBytes(String s) throws IOException {
        this.write(s.getBytes(), 0, s.length());
    }

    public void writeChars(String s) throws IOException {
        int len = s.length();
        byte[] b = new byte[2 * len];
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            b[2 * i] = (byte)(c >> 8);
            b[2 * i + 1] = (byte)c;
        }
        this.write(b, 0, 2 * len);
    }

    public void writeUTF(String s) throws IOException {
        DataOutputStream d = new DataOutputStream(this);
        d.writeUTF(s);
        d.flush();
    }

    public void writePrimitiveArray(Object o) throws IOException {
        String className = o.getClass().getName();
        if (className.charAt(0) != '[') {
            throw new IOException("Invalid object passed to BufferedDataOutputStream.writeArray:" + className);
        }
        if (className.charAt(1) == '[') {
            for (int i = 0; i < ((Object[])o).length; ++i) {
                this.writePrimitiveArray(((Object[])o)[i]);
            }
        } else {
            switch (className.charAt(1)) {
                case 'Z': {
                    this.writeBooleanArray((boolean[])o);
                    break;
                }
                case 'B': {
                    this.write((byte[])o, 0, ((byte[])o).length);
                    break;
                }
                case 'C': {
                    this.writeCharArray((char[])o);
                    break;
                }
                case 'S': {
                    this.writeShortArray((short[])o);
                    break;
                }
                case 'I': {
                    this.writeIntArray((int[])o);
                    break;
                }
                case 'J': {
                    this.writeLongArray((long[])o);
                    break;
                }
                case 'F': {
                    this.writeFloatArray((float[])o);
                    break;
                }
                case 'D': {
                    this.writeDoubleArray((double[])o);
                    break;
                }
                case 'L': {
                    if (className.equals("[Ljava.lang.String;")) {
                        this.writeStringArray((String[])o);
                        break;
                    }
                    if (className.equals("[Ljava.lang.Object;")) {
                        for (int i = 0; i < ((Object[])o).length; ++i) {
                            this.writePrimitiveArray(((Object[])o)[i]);
                        }
                        break;
                    }
                    throw new IOException("Invalid object passed to BufferedDataOutputStream.writeArray: " + className);
                }
                default: {
                    throw new IOException("Invalid object passed to BufferedDataOutputStream.writeArray: " + className);
                }
            }
        }
    }

    protected void writeBooleanArray(boolean[] b) throws IOException {
        byte[] bx = new byte[b.length];
        for (int i = 0; i < b.length; ++i) {
            bx[i] = b[i] ? (byte)1 : 0;
        }
        this.write(bx, 0, bx.length);
    }

    protected void writeShortArray(short[] s) throws IOException {
        byte[] b = new byte[2 * s.length];
        for (int i = 0; i < s.length; ++i) {
            short t = s[i];
            b[2 * i] = (byte)(t >> 8);
            b[2 * i + 1] = (byte)t;
        }
        this.write(b, 0, b.length);
    }

    protected void writeCharArray(char[] c) throws IOException {
        byte[] b = new byte[2 * c.length];
        for (int i = 0; i < c.length; ++i) {
            char t = c[i];
            b[2 * i] = (byte)(t >> 8);
            b[2 * i + 1] = (byte)t;
        }
        this.write(b, 0, b.length);
    }

    protected void writeIntArray(int[] i) throws IOException {
        byte[] b = new byte[4 * i.length];
        for (int ii = 0; ii < i.length; ++ii) {
            int t = i[ii];
            b[4 * ii] = (byte)(t >>> 24);
            b[4 * ii + 1] = (byte)(t >>> 16);
            b[4 * ii + 2] = (byte)(t >>> 8);
            b[4 * ii + 3] = (byte)t;
        }
        this.write(b, 0, b.length);
    }

    protected void writeLongArray(long[] l) throws IOException {
        byte[] b = new byte[8 * l.length];
        for (int i = 0; i < l.length; ++i) {
            long t = l[i];
            b[8 * i] = (byte)(t >>> 56);
            b[8 * i + 1] = (byte)(t >>> 48);
            b[8 * i + 2] = (byte)(t >>> 40);
            b[8 * i + 3] = (byte)(t >>> 32);
            b[8 * i + 4] = (byte)(t >>> 24);
            b[8 * i + 5] = (byte)(t >>> 16);
            b[8 * i + 6] = (byte)(t >>> 8);
            b[8 * i + 7] = (byte)t;
        }
        this.write(b, 0, b.length);
    }

    protected void writeFloatArray(float[] f) throws IOException {
        byte[] b = new byte[4 * f.length];
        for (int i = 0; i < f.length; ++i) {
            int t = Float.floatToIntBits(f[i]);
            b[4 * i] = (byte)(t >>> 24);
            b[4 * i + 1] = (byte)(t >>> 16);
            b[4 * i + 2] = (byte)(t >>> 8);
            b[4 * i + 3] = (byte)t;
        }
        this.write(b, 0, b.length);
    }

    protected void writeDoubleArray(double[] d) throws IOException {
        byte[] b = new byte[8 * d.length];
        for (int i = 0; i < d.length; ++i) {
            long t = Double.doubleToLongBits(d[i]);
            b[8 * i] = (byte)(t >>> 56);
            b[8 * i + 1] = (byte)(t >>> 48);
            b[8 * i + 2] = (byte)(t >>> 40);
            b[8 * i + 3] = (byte)(t >>> 32);
            b[8 * i + 4] = (byte)(t >>> 24);
            b[8 * i + 5] = (byte)(t >>> 16);
            b[8 * i + 6] = (byte)(t >>> 8);
            b[8 * i + 7] = (byte)t;
        }
        this.write(b, 0, b.length);
    }

    protected void writeStringArray(String[] s) throws IOException {
        for (int i = 0; i < s.length; ++i) {
            this.writeBytes(s[i]);
        }
    }

    public static void main(String[] args) throws Exception {
        BufferedDataInputStream.main(args);
    }
}

