/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import thredds.ui.BAMutil;
import thredds.ui.IndependentWindow;
import thredds.ui.PopupMenu;
import thredds.ui.TextHistoryPane;
import thredds.wcs.Request;
import thredds.wcs.v1_0_0_1.DescribeCoverage;
import thredds.wcs.v1_0_0_1.DescribeCoverageBuilder;
import thredds.wcs.v1_0_0_1.WcsException;
import thredds.wcs.v1_0_0_1.WcsRequestBuilder;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridCoordSys;
import ucar.nc2.dt.grid.GridDataset;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.util.prefs.PreferencesExt;
import ucar.util.prefs.ui.BeanTableSorted;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoGridTable
extends JPanel {
    private PreferencesExt prefs;
    private NetcdfDataset ds;
    private ucar.nc2.dt.GridDataset gridDataset;
    private BeanTableSorted varTable;
    private BeanTableSorted csTable = null;
    private BeanTableSorted axisTable = null;
    private JSplitPane split = null;
    private JSplitPane split2 = null;
    private TextHistoryPane infoTA;
    private IndependentWindow infoWindow;

    public GeoGridTable(PreferencesExt prefs, boolean showCS) {
        this.prefs = prefs;
        this.varTable = new BeanTableSorted(GeogridBean.class, (PreferencesExt)prefs.node("GeogridBeans"), false);
        JTable jtable = this.varTable.getJTable();
        PopupMenu csPopup = new PopupMenu(jtable, "Options");
        csPopup.addAction("Show Declaration", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                GeogridBean vb = (GeogridBean)GeoGridTable.this.varTable.getSelectedBean();
                Variable v = GeoGridTable.this.ds.findVariable(vb.getName());
                GeoGridTable.this.infoTA.clear();
                if (v == null) {
                    GeoGridTable.this.infoTA.appendLine("Cant find variable " + vb.getName() + " escaped= (" + NetcdfFile.escapeName(vb.getName()) + ")");
                } else {
                    GeoGridTable.this.infoTA.appendLine("Variable " + v.getName() + " :");
                    GeoGridTable.this.infoTA.appendLine(v.toString());
                }
                GeoGridTable.this.infoTA.gotoTop();
                GeoGridTable.this.infoWindow.showIfNotIconified();
            }
        });
        csPopup.addAction("WCS DescribeCoverage", new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                GeogridBean vb = (GeogridBean)GeoGridTable.this.varTable.getSelectedBean();
                if (GeoGridTable.this.gridDataset.findGridDatatype(vb.getName()) != null) {
                    List<String> coverageIdList = Collections.singletonList(vb.getName());
                    try {
                        DescribeCoverage descCov = ((DescribeCoverageBuilder)WcsRequestBuilder.newWcsRequestBuilder("1.0.0", Request.Operation.DescribeCoverage, GeoGridTable.this.gridDataset, "")).setCoverageIdList(coverageIdList).buildDescribeCoverage();
                        String dc = descCov.writeDescribeCoverageDocAsString();
                        GeoGridTable.this.infoTA.clear();
                        GeoGridTable.this.infoTA.appendLine(dc);
                        GeoGridTable.this.infoTA.gotoTop();
                        GeoGridTable.this.infoWindow.showIfNotIconified();
                    }
                    catch (WcsException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        this.infoTA = new TextHistoryPane();
        this.infoWindow = new IndependentWindow("Variable Information", BAMutil.getImage("netcdfUI"), this.infoTA);
        this.infoWindow.setBounds((Rectangle)prefs.getBean("InfoWindowBounds", new Rectangle(300, 300, 500, 300)));
        JComponent comp = this.varTable;
        if (showCS) {
            this.csTable = new BeanTableSorted(GeoCoordinateSystemBean.class, (PreferencesExt)prefs.node("GeoCoordinateSystemBean"), false);
            this.axisTable = new BeanTableSorted(GeoAxisBean.class, (PreferencesExt)prefs.node("GeoCoordinateAxisBean"), false);
            this.split = new JSplitPane(0, false, this.varTable, this.csTable);
            this.split.setDividerLocation(prefs.getInt("splitPos", 500));
            this.split2 = new JSplitPane(0, false, this.split, this.axisTable);
            this.split2.setDividerLocation(prefs.getInt("splitPos2", 500));
            comp = this.split2;
        }
        this.setLayout(new BorderLayout());
        this.add((Component)comp, "Center");
    }

    public PreferencesExt getPrefs() {
        return this.prefs;
    }

    public void save() {
        this.varTable.saveState(false);
        this.prefs.putBeanObject("InfoWindowBounds", this.infoWindow.getBounds());
        if (this.split != null) {
            this.prefs.putInt("splitPos", this.split.getDividerLocation());
        }
        if (this.split2 != null) {
            this.prefs.putInt("splitPos2", this.split2.getDividerLocation());
        }
        if (this.csTable != null) {
            this.csTable.saveState(false);
        }
        if (this.axisTable != null) {
            this.axisTable.saveState(false);
        }
    }

    public void setDataset(NetcdfDataset ds) throws IOException {
        this.ds = ds;
        this.gridDataset = new GridDataset(ds);
        ArrayList<GeogridBean> beanList = new ArrayList<GeogridBean>();
        List<GridDatatype> list = this.gridDataset.getGrids();
        for (GridDatatype g : list) {
            beanList.add(new GeogridBean(g));
        }
        this.varTable.setBeans(beanList);
        if (this.csTable != null) {
            ArrayList<GeoCoordinateSystemBean> csList = new ArrayList<GeoCoordinateSystemBean>();
            ArrayList<GeoAxisBean> axisList = new ArrayList<GeoAxisBean>();
            for (GridDataset.Gridset gset : this.gridDataset.getGridsets()) {
                csList.add(new GeoCoordinateSystemBean(gset));
                GridCoordSystem gsys = gset.getGeoCoordSystem();
                List<CoordinateAxis> axes = gsys.getCoordinateAxes();
                for (int i = 0; i < axes.size(); ++i) {
                    CoordinateAxis axis = axes.get(i);
                    GeoAxisBean axisBean = new GeoAxisBean(axis);
                    if (this.contains(axisList, axisBean.getName())) continue;
                    axisList.add(axisBean);
                }
            }
            this.csTable.setBeans(csList);
            this.axisTable.setBeans(axisList);
        }
    }

    private boolean contains(List<GeoAxisBean> axisList, String name) {
        for (GeoAxisBean axis : axisList) {
            if (!axis.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public ucar.nc2.dt.GridDataset getGridDataset() {
        return this.gridDataset;
    }

    public GridDatatype getGrid() {
        GeogridBean vb = (GeogridBean)this.varTable.getSelectedBean();
        if (vb == null) {
            List<GridDatatype> grids = this.gridDataset.getGrids();
            if (grids.size() > 0) {
                return grids.get(0);
            }
            return null;
        }
        return this.gridDataset.findGridDatatype(vb.getName());
    }

    public JDialog makeDialog(RootPaneContainer parent, String title, boolean modal) {
        return new Dialog(parent, title, modal);
    }

    private class Dialog
    extends JDialog {
        private Dialog(RootPaneContainer parent, String title, boolean modal) {
            super(parent instanceof Frame ? (Frame)((Object)parent) : null, title, modal);
            UIManager.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getPropertyName().equals("lookAndFeel")) {
                        SwingUtilities.updateComponentTreeUI(Dialog.this);
                    }
                }
            });
            Container cp = this.getContentPane();
            cp.setLayout(new BorderLayout());
            cp.add((Component)GeoGridTable.this, "Center");
            this.pack();
        }
    }

    public class GeoAxisBean {
        CoordinateAxis axis;
        CoordinateSystem firstCoordSys = null;
        String name;
        String desc;
        String units;
        String axisType = "";
        String positive = "";
        String incr = "";
        String dims;
        String shape;
        String csNames;
        boolean isCoordVar;

        public GeoAxisBean() {
        }

        public GeoAxisBean(CoordinateAxis v) {
            CoordinateAxis1D v1;
            String p;
            this.axis = v;
            this.setName(v.getName());
            this.setCoordVar(v.isCoordinateVariable());
            this.setDescription(v.getDescription());
            this.setUnits(v.getUnitsString());
            StringBuffer lens = new StringBuffer();
            StringBuffer names = new StringBuffer();
            List<Dimension> dims = v.getDimensions();
            for (int j = 0; j < dims.size(); ++j) {
                Dimension dim = dims.get(j);
                if (j > 0) {
                    lens.append(",");
                    names.append(",");
                }
                String name = dim.isShared() ? dim.getName() : "anon";
                names.append(name);
                lens.append(dim.getLength());
            }
            this.setDims(names.toString());
            this.setShape(lens.toString());
            AxisType at = v.getAxisType();
            if (at != null) {
                this.setAxisType(at.toString());
            }
            if ((p = v.getPositive()) != null) {
                this.setPositive(p);
            }
            if (v instanceof CoordinateAxis1D && (v1 = (CoordinateAxis1D)v).isRegular()) {
                this.setRegular(Double.toString(v1.getIncrement()));
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isCoordVar() {
            return this.isCoordVar;
        }

        public void setCoordVar(boolean isCoordVar) {
            this.isCoordVar = isCoordVar;
        }

        public String getShape() {
            return this.shape;
        }

        public void setShape(String shape) {
            this.shape = shape;
        }

        public String getAxisType() {
            return this.axisType;
        }

        public void setAxisType(String axisType) {
            this.axisType = axisType;
        }

        public String getDims() {
            return this.dims;
        }

        public void setDims(String dims) {
            this.dims = dims;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units == null ? "null" : units;
        }

        public String getPositive() {
            return this.positive;
        }

        public void setPositive(String positive) {
            this.positive = positive;
        }

        public String getRegular() {
            return this.incr;
        }

        public void setRegular(String incr) {
            this.incr = incr;
        }
    }

    public class GeoCoordinateSystemBean {
        private GridCoordSystem gcs;
        private String proj;
        private String coordTrans;
        private int ngrids = -1;

        public GeoCoordinateSystemBean() {
        }

        public GeoCoordinateSystemBean(GridDataset.Gridset gset) {
            this.gcs = gset.getGeoCoordSystem();
            this.setNGrids(gset.getGrids().size());
            ProjectionImpl proj = this.gcs.getProjection();
            if (proj != null) {
                this.setProjection(proj.getClassName());
            }
            int count = 0;
            StringBuffer buff = new StringBuffer();
            List<CoordinateTransform> ctList = this.gcs.getCoordinateTransforms();
            for (int i = 0; i < ctList.size(); ++i) {
                ProjectionCT pct;
                CoordinateTransform ct = ctList.get(i);
                if (count > 0) {
                    buff.append("; ");
                }
                if (ct instanceof VerticalCT) {
                    buff.append(((VerticalCT)ct).getVerticalTransformType());
                    ++count;
                }
                if (!(ct instanceof ProjectionCT) || (pct = (ProjectionCT)ct).getProjection() != null) continue;
                buff.append("-").append(pct.getName());
                ++count;
            }
            this.setCoordTransforms(buff.toString());
        }

        public String getName() {
            return this.gcs.getName();
        }

        public boolean isRegularSpatial() {
            return this.gcs.isRegularSpatial();
        }

        public boolean isLatLon() {
            return this.gcs.isLatLon();
        }

        public boolean isGeoXY() {
            return ((GridCoordSys)this.gcs).isGeoXY();
        }

        public int getDomainRank() {
            return this.gcs.getDomain().size();
        }

        public int getRangeRank() {
            return this.gcs.getCoordinateAxes().size();
        }

        public int getNGrids() {
            return this.ngrids;
        }

        public void setNGrids(int ngrids) {
            this.ngrids = ngrids;
        }

        public String getProjection() {
            return this.proj;
        }

        public void setProjection(String proj) {
            this.proj = proj;
        }

        public String getCoordTransforms() {
            return this.coordTrans;
        }

        public void setCoordTransforms(String coordTrans) {
            this.coordTrans = coordTrans;
        }
    }

    public class GeogridBean {
        private String name;
        private String desc;
        private String units;
        private String csys;
        private String dims;
        private String x;
        private String y;
        private String z;
        private String t;
        private String ens;
        private String rt;

        public GeogridBean() {
        }

        public GeogridBean(GridDatatype geogrid) {
            this.setName(geogrid.getName());
            this.setDescription(geogrid.getDescription());
            this.setUnits(geogrid.getUnitsString());
            this.setCoordSystem(geogrid.getCoordinateSystem().getName());
            StringBuffer buff = new StringBuffer();
            List<Dimension> dims = geogrid.getDimensions();
            for (int j = 0; j < dims.size(); ++j) {
                Dimension dim = dims.get(j);
                if (j > 0) {
                    buff.append(",");
                }
                buff.append(dim.getLength());
            }
            this.setShape(buff.toString());
            Dimension d = geogrid.getXDimension();
            if (d != null) {
                this.setX(d.getName());
            }
            if ((d = geogrid.getYDimension()) != null) {
                this.setY(d.getName());
            }
            if ((d = geogrid.getZDimension()) != null) {
                this.setZ(d.getName());
            }
            GridCoordSystem gcs = geogrid.getCoordinateSystem();
            d = geogrid.getTimeDimension();
            if (d != null) {
                this.setT(d.getName());
            } else {
                CoordinateAxis taxis = gcs.getTimeAxis();
                if (taxis != null) {
                    this.setT(taxis.getName());
                }
            }
            CoordinateAxis1D axis = gcs.getEnsembleAxis();
            if (axis != null) {
                this.setEns(axis.getDimension(0).getName());
            }
            if ((axis = gcs.getRunTimeAxis()) != null) {
                this.setRt(axis.getDimension(0).getName());
            }
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getUnits() {
            return this.units;
        }

        public void setUnits(String units) {
            this.units = units;
        }

        public String getCoordSystem() {
            return this.csys;
        }

        public void setCoordSystem(String csys) {
            this.csys = csys;
        }

        public String getX() {
            return this.x;
        }

        public void setX(String x) {
            this.x = x;
        }

        public String getY() {
            return this.y;
        }

        public void setY(String y) {
            this.y = y;
        }

        public String getZ() {
            return this.z;
        }

        public void setZ(String z) {
            this.z = z;
        }

        public String getT() {
            return this.t;
        }

        public void setT(String t) {
            this.t = t;
        }

        public String getEns() {
            return this.ens;
        }

        public void setEns(String ens) {
            this.ens = ens;
        }

        public String getRt() {
            return this.rt;
        }

        public void setRt(String rt) {
            this.rt = rt;
        }

        public String getShape() {
            return this.dims;
        }

        public void setShape(String dims) {
            this.dims = dims;
        }
    }
}

