/*
 * Decompiled with CFR 0.152.
 */
package visad;

import visad.CoordinateSystem;
import visad.MathType;
import visad.Set;
import visad.SetException;
import visad.SimpleSet;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;

public class List1DSet
extends SimpleSet {
    float[] data;

    public List1DSet(float[] d, MathType type, CoordinateSystem coord_sys, Unit[] units) throws VisADException {
        super(type, coord_sys, units, null);
        if (this.DomainDimension != 1) {
            throw new SetException("List1DSet: type must be 1-D");
        }
        this.data = d;
        this.Length = d.length;
    }

    public boolean isMissing() {
        return this.data == null;
    }

    public float[][] indexToValue(int[] index) throws VisADException {
        int length = index.length;
        float[][] value = new float[1][length];
        for (int i = 0; i < length; ++i) {
            if (index[i] < 0 || index[i] >= this.Length) {
                for (int k = 0; k < this.DomainDimension; ++k) {
                    value[k][i] = Float.NaN;
                }
                continue;
            }
            value[0][i] = this.data[index[i]];
        }
        return value;
    }

    public int[] valueToIndex(float[][] value) throws VisADException {
        throw new UnimplementedException("List1DSet.valueToIndex");
    }

    public void valueToInterp(float[][] value, int[][] indices, float[][] weights) throws VisADException {
        throw new UnimplementedException("List1DSet.valueToInterpx");
    }

    public boolean equals(Object set) {
        if (!(set instanceof List1DSet) || set == null) {
            return false;
        }
        if (this == set) {
            return true;
        }
        if (!this.equalUnitAndCS((Set)set)) {
            return false;
        }
        if (this.Length != ((Set)set).Length) {
            return false;
        }
        for (int i = 0; i < this.Length; ++i) {
            if (Float.floatToIntBits(this.data[i]) == Float.floatToIntBits(((List1DSet)set).data[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (!this.hashCodeSet) {
            this.hashCode = this.unitAndCSHashCode() ^ this.Length;
            for (int i = 0; i < this.Length; ++i) {
                this.hashCode ^= Float.floatToIntBits(this.data[i]);
            }
            this.hashCodeSet = true;
        }
        return this.hashCode;
    }

    public Object cloneButType(MathType type) throws VisADException {
        return new List1DSet(this.data, type, this.DomainCoordinateSystem, this.SetUnits);
    }

    public String longString(String pre) throws VisADException {
        return pre + "List1DSet";
    }
}

