/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.DisplayTupleType;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.RealVectorType;
import visad.Set;
import visad.TypeException;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryDisplayTupleType;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryMathType;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryRealType;
import visad.data.visad.object.BinaryRealVectorType;
import visad.data.visad.object.BinarySerializedObject;

public class BinaryRealTupleType
implements BinaryObject {
    public static final int computeBytes(RealTupleType rtt) {
        return 9 + rtt.getDimension() * 4 + (rtt.getCoordinateSystem() == null ? 0 : 5) + (rtt.getDefaultSet() == null ? 0 : 1) + 1;
    }

    public static final RealTupleType read(BinaryReader reader, int index) throws IOException, VisADException {
        BinaryObjectCache cSysCache = reader.getCoordinateSystemCache();
        BinaryObjectCache typeCache = reader.getTypeCache();
        DataInput file = reader.getInput();
        int dim = file.readInt();
        MathType[] mtList = BinaryMathType.readList(reader, dim);
        RealType[] list = new RealType[mtList.length];
        for (int i = 0; i < mtList.length; ++i) {
            list[i] = (RealType)mtList[i];
        }
        CoordinateSystem cs = null;
        boolean setFollowsType = false;
        boolean reading = true;
        block10: while (reading) {
            byte directive;
            try {
                directive = file.readByte();
            }
            catch (EOFException eofe) {
                return null;
            }
            switch (directive) {
                case 32: {
                    int csIndex = file.readInt();
                    cs = (CoordinateSystem)cSysCache.get(csIndex);
                    continue block10;
                }
                case 70: {
                    setFollowsType = true;
                    continue block10;
                }
                case 80: {
                    reading = false;
                    continue block10;
                }
            }
            throw new IOException("Unknown RealTupleType directive " + directive);
        }
        RealTupleType rtt = new RealTupleType(list, cs, null);
        typeCache.add(index, rtt);
        if (setFollowsType) {
            Set set = (Set)BinaryGeneric.read(reader);
            try {
                rtt.setDefaultSet(set);
            }
            catch (TypeException te) {
                // empty catch block
            }
        }
        return rtt;
    }

    public static final int write(BinaryWriter writer, RealTupleType rtt, Object token) throws IOException {
        BinaryObjectCache cache = writer.getTypeCache();
        if (rtt instanceof DisplayTupleType) {
            return BinaryDisplayTupleType.write(writer, (DisplayTupleType)rtt, token);
        }
        if (rtt instanceof RealVectorType) {
            return BinaryRealVectorType.write(writer, (RealVectorType)rtt, token);
        }
        int index = cache.getIndex(rtt);
        if (index < 0) {
            index = cache.add(rtt);
            if (index < 0) {
                throw new IOException("Couldn't cache RealTupleType " + rtt);
            }
            if (!(rtt.getClass().equals(RealTupleType.class) || rtt instanceof RealTupleType && rtt instanceof Saveable)) {
                BinarySerializedObject.write(writer, (byte)6, rtt, token);
                return index;
            }
            int dim = rtt.getDimension();
            Set dfltSet = rtt.getDefaultSet();
            int[] types = new int[dim];
            for (int i = 0; i < dim; ++i) {
                RealType comp;
                try {
                    comp = (RealType)rtt.getComponent(i);
                }
                catch (VisADException ve) {
                    throw new IOException("Couldn't get RealTupleType component #" + i + ": " + ve.getMessage());
                }
                types[i] = BinaryRealType.write(writer, comp, token);
            }
            CoordinateSystem cs = rtt.getCoordinateSystem();
            int csIndex = -1;
            if (cs != null) {
                csIndex = BinaryCoordinateSystem.write(writer, cs, token);
            }
            int objLen = BinaryRealTupleType.computeBytes(rtt);
            DataOutput file = writer.getOutput();
            file.writeByte(5);
            file.writeInt(objLen);
            file.writeInt(index);
            file.writeByte(3);
            file.writeInt(dim);
            for (int i = 0; i < dim; ++i) {
                file.writeInt(types[i]);
            }
            if (csIndex >= 0) {
                file.writeByte(32);
                file.writeInt(csIndex);
            }
            if (dfltSet != null) {
                file.writeByte(70);
            }
            file.writeByte(80);
            if (dfltSet != null) {
                Object dependToken = token == SAVE_DEPEND_BIG ? token : SAVE_DEPEND;
                BinaryGeneric.write(writer, dfltSet, dependToken);
                BinaryGeneric.write(writer, dfltSet, SAVE_DATA);
            }
        }
        return index;
    }
}

