--TEST--
ffmpeg getFrames forward test
--SKIPIF--
<?php 
extension_loaded('ffmpeg') or die("skip ffmpeg extension not loaded"); 
extension_loaded('gd') or die("skip gd extension not avaliable.");
function_exists("imagecreatetruecolor") or die("skip function imagecreatetruecolor unavailable");
?>
--FILE--
<?php
$mov = new ffmpeg_movie(dirname(__FILE__) . '/test_media/robot.avi');

$framecount = $mov->getFrameCount();
for($i = 1; $i <= $framecount; $i++) {
    $img = sprintf("%s/test-%04d.png", dirname(__FILE__), $i);
    $frame = $mov->getFrame($i);
    $image = $frame->toGDImage();
    imagepng($image, $img);
    printf("ffmpeg getFramesForward($i): md5 = %s\n", md5(file_get_contents($img)));
    imagedestroy($image);
    unlink($img);
}
?>
--EXPECT--
ffmpeg getFramesForward(1): md5 = abdf9f281de68cef4b77a5a7a899b60a
ffmpeg getFramesForward(2): md5 = abdf9f281de68cef4b77a5a7a899b60a
ffmpeg getFramesForward(3): md5 = abdf9f281de68cef4b77a5a7a899b60a
ffmpeg getFramesForward(4): md5 = 9770f3afe55297ea35c9f06a0e4334ea
ffmpeg getFramesForward(5): md5 = 9770f3afe55297ea35c9f06a0e4334ea
ffmpeg getFramesForward(6): md5 = 9770f3afe55297ea35c9f06a0e4334ea
ffmpeg getFramesForward(7): md5 = 157cf8c54851ee90bda8b2398b077c28
ffmpeg getFramesForward(8): md5 = 157cf8c54851ee90bda8b2398b077c28
ffmpeg getFramesForward(9): md5 = 157cf8c54851ee90bda8b2398b077c28
ffmpeg getFramesForward(10): md5 = 966a1fb1d649d8fdc6552ce6fa0e735f
ffmpeg getFramesForward(11): md5 = 966a1fb1d649d8fdc6552ce6fa0e735f
ffmpeg getFramesForward(12): md5 = 966a1fb1d649d8fdc6552ce6fa0e735f
ffmpeg getFramesForward(13): md5 = 5415f831017e32afa73e5ceb32344f4d
ffmpeg getFramesForward(14): md5 = 5415f831017e32afa73e5ceb32344f4d
ffmpeg getFramesForward(15): md5 = 5415f831017e32afa73e5ceb32344f4d
ffmpeg getFramesForward(16): md5 = 337873cd3a4b8529dae4da4aac38874c
ffmpeg getFramesForward(17): md5 = 337873cd3a4b8529dae4da4aac38874c
ffmpeg getFramesForward(18): md5 = 337873cd3a4b8529dae4da4aac38874c
ffmpeg getFramesForward(19): md5 = 3411d97fd52b27b7105a4cf91a7b181e
ffmpeg getFramesForward(20): md5 = 3411d97fd52b27b7105a4cf91a7b181e
ffmpeg getFramesForward(21): md5 = 3411d97fd52b27b7105a4cf91a7b181e
ffmpeg getFramesForward(22): md5 = 74c553e7c88fd2479610cd2093d75717
ffmpeg getFramesForward(23): md5 = 74c553e7c88fd2479610cd2093d75717
ffmpeg getFramesForward(24): md5 = 74c553e7c88fd2479610cd2093d75717
ffmpeg getFramesForward(25): md5 = c9ec47e51edb4a58c1c76a2202d7147f
ffmpeg getFramesForward(26): md5 = c9ec47e51edb4a58c1c76a2202d7147f
ffmpeg getFramesForward(27): md5 = c9ec47e51edb4a58c1c76a2202d7147f
ffmpeg getFramesForward(28): md5 = 0f54b4e8a9e3cbbc6c5e1729f4793b2f
ffmpeg getFramesForward(29): md5 = 0f54b4e8a9e3cbbc6c5e1729f4793b2f
ffmpeg getFramesForward(30): md5 = 0f54b4e8a9e3cbbc6c5e1729f4793b2f
ffmpeg getFramesForward(31): md5 = 30f0dff87230a9f3b1ebdc08b40aa0a7
ffmpeg getFramesForward(32): md5 = 30f0dff87230a9f3b1ebdc08b40aa0a7
ffmpeg getFramesForward(33): md5 = 30f0dff87230a9f3b1ebdc08b40aa0a7
ffmpeg getFramesForward(34): md5 = f614e07399921150044dfdaf880afa17
ffmpeg getFramesForward(35): md5 = f614e07399921150044dfdaf880afa17
ffmpeg getFramesForward(36): md5 = f614e07399921150044dfdaf880afa17
ffmpeg getFramesForward(37): md5 = ae68f48c14a76e4dc2f9c7f2183c7787
ffmpeg getFramesForward(38): md5 = ae68f48c14a76e4dc2f9c7f2183c7787
ffmpeg getFramesForward(39): md5 = ae68f48c14a76e4dc2f9c7f2183c7787
ffmpeg getFramesForward(40): md5 = b8ae52b0bd25ff1ccddfffd61c2aee5a
ffmpeg getFramesForward(41): md5 = b8ae52b0bd25ff1ccddfffd61c2aee5a
ffmpeg getFramesForward(42): md5 = b8ae52b0bd25ff1ccddfffd61c2aee5a
ffmpeg getFramesForward(43): md5 = 1560e32dc970140780155a3b9b8a5458
ffmpeg getFramesForward(44): md5 = 1560e32dc970140780155a3b9b8a5458
ffmpeg getFramesForward(45): md5 = 1560e32dc970140780155a3b9b8a5458
ffmpeg getFramesForward(46): md5 = 9d6241b89b0320d045c81564ae392df1
ffmpeg getFramesForward(47): md5 = 9d6241b89b0320d045c81564ae392df1
ffmpeg getFramesForward(48): md5 = 9d6241b89b0320d045c81564ae392df1
ffmpeg getFramesForward(49): md5 = ac35fe74cc8150970d6b8d6b6615ee7d
ffmpeg getFramesForward(50): md5 = ac35fe74cc8150970d6b8d6b6615ee7d
ffmpeg getFramesForward(51): md5 = ac35fe74cc8150970d6b8d6b6615ee7d
ffmpeg getFramesForward(52): md5 = e256491e34893b935d9a3839536d2587
ffmpeg getFramesForward(53): md5 = e256491e34893b935d9a3839536d2587
ffmpeg getFramesForward(54): md5 = e256491e34893b935d9a3839536d2587
ffmpeg getFramesForward(55): md5 = 1c72b33fd6f829b293a83acd9dd6ba3e
ffmpeg getFramesForward(56): md5 = 1c72b33fd6f829b293a83acd9dd6ba3e
ffmpeg getFramesForward(57): md5 = 1c72b33fd6f829b293a83acd9dd6ba3e
ffmpeg getFramesForward(58): md5 = 954c1013975c1fc29ab8bbaf9208069a
ffmpeg getFramesForward(59): md5 = 954c1013975c1fc29ab8bbaf9208069a
ffmpeg getFramesForward(60): md5 = 954c1013975c1fc29ab8bbaf9208069a
ffmpeg getFramesForward(61): md5 = 86d1330ec92bb2c672db8cfacef7c128
ffmpeg getFramesForward(62): md5 = 86d1330ec92bb2c672db8cfacef7c128
ffmpeg getFramesForward(63): md5 = 86d1330ec92bb2c672db8cfacef7c128
ffmpeg getFramesForward(64): md5 = 3b8248dcafbc02ecab8f5a3065e61f03
ffmpeg getFramesForward(65): md5 = 3b8248dcafbc02ecab8f5a3065e61f03
ffmpeg getFramesForward(66): md5 = 3b8248dcafbc02ecab8f5a3065e61f03
ffmpeg getFramesForward(67): md5 = db77eae1c1395ba1c794ae1281d68868
ffmpeg getFramesForward(68): md5 = db77eae1c1395ba1c794ae1281d68868
ffmpeg getFramesForward(69): md5 = db77eae1c1395ba1c794ae1281d68868
ffmpeg getFramesForward(70): md5 = afe384b15e07ea544fa7a1cdada288c0
ffmpeg getFramesForward(71): md5 = afe384b15e07ea544fa7a1cdada288c0
ffmpeg getFramesForward(72): md5 = afe384b15e07ea544fa7a1cdada288c0
ffmpeg getFramesForward(73): md5 = 8c9cbc1183504e1d1fee262e83775e01
ffmpeg getFramesForward(74): md5 = 8c9cbc1183504e1d1fee262e83775e01
ffmpeg getFramesForward(75): md5 = 8c9cbc1183504e1d1fee262e83775e01
ffmpeg getFramesForward(76): md5 = d502f1afe81ec69de3222d3b56b3d516
ffmpeg getFramesForward(77): md5 = d502f1afe81ec69de3222d3b56b3d516
ffmpeg getFramesForward(78): md5 = d502f1afe81ec69de3222d3b56b3d516
ffmpeg getFramesForward(79): md5 = 8004f62b065a0d55150220972821be96
ffmpeg getFramesForward(80): md5 = 8004f62b065a0d55150220972821be96
ffmpeg getFramesForward(81): md5 = 8004f62b065a0d55150220972821be96
ffmpeg getFramesForward(82): md5 = 92ecabfab41f2715a05f3847e2484b60
ffmpeg getFramesForward(83): md5 = 92ecabfab41f2715a05f3847e2484b60
ffmpeg getFramesForward(84): md5 = 92ecabfab41f2715a05f3847e2484b60
ffmpeg getFramesForward(85): md5 = ceafeaf93812d8f5fd48f6fa242d5e36
ffmpeg getFramesForward(86): md5 = ceafeaf93812d8f5fd48f6fa242d5e36
ffmpeg getFramesForward(87): md5 = ceafeaf93812d8f5fd48f6fa242d5e36
ffmpeg getFramesForward(88): md5 = 41b5423e725b29fdacc5ee40faa4776c
ffmpeg getFramesForward(89): md5 = 41b5423e725b29fdacc5ee40faa4776c
ffmpeg getFramesForward(90): md5 = 41b5423e725b29fdacc5ee40faa4776c
ffmpeg getFramesForward(91): md5 = afa2f0bab3ba2b34806b2a52aea98bce
ffmpeg getFramesForward(92): md5 = afa2f0bab3ba2b34806b2a52aea98bce
ffmpeg getFramesForward(93): md5 = afa2f0bab3ba2b34806b2a52aea98bce
ffmpeg getFramesForward(94): md5 = c8ed36df36fb8cea156212a5d5952d33
ffmpeg getFramesForward(95): md5 = c8ed36df36fb8cea156212a5d5952d33
ffmpeg getFramesForward(96): md5 = c8ed36df36fb8cea156212a5d5952d33
ffmpeg getFramesForward(97): md5 = c97ea8a480b98c52f8b726b811f9714d
ffmpeg getFramesForward(98): md5 = c97ea8a480b98c52f8b726b811f9714d
ffmpeg getFramesForward(99): md5 = c97ea8a480b98c52f8b726b811f9714d
ffmpeg getFramesForward(100): md5 = a98e967bbda4b6dcaa19fd52d9fdef12
ffmpeg getFramesForward(101): md5 = a98e967bbda4b6dcaa19fd52d9fdef12
ffmpeg getFramesForward(102): md5 = a98e967bbda4b6dcaa19fd52d9fdef12
ffmpeg getFramesForward(103): md5 = 395b50b5c8615cdb4b905aa0b3b2e669
ffmpeg getFramesForward(104): md5 = 395b50b5c8615cdb4b905aa0b3b2e669
ffmpeg getFramesForward(105): md5 = 395b50b5c8615cdb4b905aa0b3b2e669
ffmpeg getFramesForward(106): md5 = 86f50526473282524be5c092f77950a5
ffmpeg getFramesForward(107): md5 = 86f50526473282524be5c092f77950a5
ffmpeg getFramesForward(108): md5 = 86f50526473282524be5c092f77950a5
ffmpeg getFramesForward(109): md5 = 9e5e0b70bfc1c90f2c5092428bc384ee
ffmpeg getFramesForward(110): md5 = 9e5e0b70bfc1c90f2c5092428bc384ee
ffmpeg getFramesForward(111): md5 = 9e5e0b70bfc1c90f2c5092428bc384ee
ffmpeg getFramesForward(112): md5 = 5f9109436658f422ec1841247acf835e
ffmpeg getFramesForward(113): md5 = 5f9109436658f422ec1841247acf835e
ffmpeg getFramesForward(114): md5 = 5f9109436658f422ec1841247acf835e
ffmpeg getFramesForward(115): md5 = 80e13931ccc6ace3a5a7ae256e048a61
ffmpeg getFramesForward(116): md5 = 80e13931ccc6ace3a5a7ae256e048a61
ffmpeg getFramesForward(117): md5 = 80e13931ccc6ace3a5a7ae256e048a61
ffmpeg getFramesForward(118): md5 = 21f287b5f3334a7aaed0aeeb55230621
ffmpeg getFramesForward(119): md5 = 21f287b5f3334a7aaed0aeeb55230621
ffmpeg getFramesForward(120): md5 = 21f287b5f3334a7aaed0aeeb55230621
ffmpeg getFramesForward(121): md5 = 22caa03aaa35e0aed2f0a3d4a3375b24
ffmpeg getFramesForward(122): md5 = 22caa03aaa35e0aed2f0a3d4a3375b24
ffmpeg getFramesForward(123): md5 = 22caa03aaa35e0aed2f0a3d4a3375b24
ffmpeg getFramesForward(124): md5 = 36cbf250ecf8c5a5538bd0a5f2eb9333
ffmpeg getFramesForward(125): md5 = 36cbf250ecf8c5a5538bd0a5f2eb9333
ffmpeg getFramesForward(126): md5 = 36cbf250ecf8c5a5538bd0a5f2eb9333
ffmpeg getFramesForward(127): md5 = ffdc385768b0b1fcbb9908c9c9bffe21
ffmpeg getFramesForward(128): md5 = ffdc385768b0b1fcbb9908c9c9bffe21
ffmpeg getFramesForward(129): md5 = ffdc385768b0b1fcbb9908c9c9bffe21
ffmpeg getFramesForward(130): md5 = 3ead3c1a402a7e26ee248cd8f9c96647
ffmpeg getFramesForward(131): md5 = 3ead3c1a402a7e26ee248cd8f9c96647
ffmpeg getFramesForward(132): md5 = 3ead3c1a402a7e26ee248cd8f9c96647
ffmpeg getFramesForward(133): md5 = 3445a37f0effaef1a9c4e788f5ce54e5
ffmpeg getFramesForward(134): md5 = 3445a37f0effaef1a9c4e788f5ce54e5
ffmpeg getFramesForward(135): md5 = 3445a37f0effaef1a9c4e788f5ce54e5
ffmpeg getFramesForward(136): md5 = 948fd5fd379679006c2ca2ba3bc52048
ffmpeg getFramesForward(137): md5 = 948fd5fd379679006c2ca2ba3bc52048
ffmpeg getFramesForward(138): md5 = 948fd5fd379679006c2ca2ba3bc52048
ffmpeg getFramesForward(139): md5 = 814b8a64a6a08093b3a81063bffffed4
ffmpeg getFramesForward(140): md5 = 814b8a64a6a08093b3a81063bffffed4
ffmpeg getFramesForward(141): md5 = 814b8a64a6a08093b3a81063bffffed4
ffmpeg getFramesForward(142): md5 = 51a73cbaf315c9faf8263627455fd5d5
ffmpeg getFramesForward(143): md5 = 51a73cbaf315c9faf8263627455fd5d5
ffmpeg getFramesForward(144): md5 = 51a73cbaf315c9faf8263627455fd5d5
ffmpeg getFramesForward(145): md5 = 31038504cc4c1e664de89c257b1fa1b0
ffmpeg getFramesForward(146): md5 = 31038504cc4c1e664de89c257b1fa1b0
ffmpeg getFramesForward(147): md5 = 31038504cc4c1e664de89c257b1fa1b0
ffmpeg getFramesForward(148): md5 = c76afdadc9099d8bd173f0e08807ee3d
ffmpeg getFramesForward(149): md5 = c76afdadc9099d8bd173f0e08807ee3d
ffmpeg getFramesForward(150): md5 = c76afdadc9099d8bd173f0e08807ee3d
ffmpeg getFramesForward(151): md5 = cd42cff504053e23c5db378119a40b3f
ffmpeg getFramesForward(152): md5 = cd42cff504053e23c5db378119a40b3f
ffmpeg getFramesForward(153): md5 = cd42cff504053e23c5db378119a40b3f
ffmpeg getFramesForward(154): md5 = 7862bd022cc4e9c3976b2f4758e5cd30
ffmpeg getFramesForward(155): md5 = 7862bd022cc4e9c3976b2f4758e5cd30
ffmpeg getFramesForward(156): md5 = 7862bd022cc4e9c3976b2f4758e5cd30
ffmpeg getFramesForward(157): md5 = 7dee4d143138fce530917488cc337c8c
ffmpeg getFramesForward(158): md5 = 7dee4d143138fce530917488cc337c8c
ffmpeg getFramesForward(159): md5 = 7dee4d143138fce530917488cc337c8c
ffmpeg getFramesForward(160): md5 = 254d01500e3ec7f6ae402747761c0a95
ffmpeg getFramesForward(161): md5 = 254d01500e3ec7f6ae402747761c0a95
ffmpeg getFramesForward(162): md5 = 254d01500e3ec7f6ae402747761c0a95
ffmpeg getFramesForward(163): md5 = fe0cdb9314d1628af56e6c3662deb24f
ffmpeg getFramesForward(164): md5 = fe0cdb9314d1628af56e6c3662deb24f
ffmpeg getFramesForward(165): md5 = fe0cdb9314d1628af56e6c3662deb24f
ffmpeg getFramesForward(166): md5 = c790f8cc0f715ca0ec31845c9ef7397a
ffmpeg getFramesForward(167): md5 = c790f8cc0f715ca0ec31845c9ef7397a
ffmpeg getFramesForward(168): md5 = c790f8cc0f715ca0ec31845c9ef7397a
ffmpeg getFramesForward(169): md5 = bab883284018046ddfa2e638785615aa
ffmpeg getFramesForward(170): md5 = bab883284018046ddfa2e638785615aa
ffmpeg getFramesForward(171): md5 = bab883284018046ddfa2e638785615aa
ffmpeg getFramesForward(172): md5 = a469093f43c0fdd6016ee5ef932b7ca4
ffmpeg getFramesForward(173): md5 = a469093f43c0fdd6016ee5ef932b7ca4
ffmpeg getFramesForward(174): md5 = a469093f43c0fdd6016ee5ef932b7ca4
ffmpeg getFramesForward(175): md5 = 50d636deb9cdca5c88842653d3e62463
ffmpeg getFramesForward(176): md5 = 50d636deb9cdca5c88842653d3e62463
ffmpeg getFramesForward(177): md5 = 50d636deb9cdca5c88842653d3e62463
ffmpeg getFramesForward(178): md5 = 7def27ec8a2136e344b24b12337f3a0c
ffmpeg getFramesForward(179): md5 = 7def27ec8a2136e344b24b12337f3a0c
ffmpeg getFramesForward(180): md5 = 7def27ec8a2136e344b24b12337f3a0c
ffmpeg getFramesForward(181): md5 = 93bdda9b26422cf7791154d54667812e
ffmpeg getFramesForward(182): md5 = 93bdda9b26422cf7791154d54667812e
ffmpeg getFramesForward(183): md5 = 93bdda9b26422cf7791154d54667812e
ffmpeg getFramesForward(184): md5 = 965909c3829a19aa301ff7dc98f1ca90
ffmpeg getFramesForward(185): md5 = 965909c3829a19aa301ff7dc98f1ca90
ffmpeg getFramesForward(186): md5 = 965909c3829a19aa301ff7dc98f1ca90
ffmpeg getFramesForward(187): md5 = a53b0c4d2c023f1019b3190b35216c60
ffmpeg getFramesForward(188): md5 = a53b0c4d2c023f1019b3190b35216c60
ffmpeg getFramesForward(189): md5 = a53b0c4d2c023f1019b3190b35216c60
ffmpeg getFramesForward(190): md5 = b900f912fbe898801a4c8356638dcf54
ffmpeg getFramesForward(191): md5 = b900f912fbe898801a4c8356638dcf54
ffmpeg getFramesForward(192): md5 = b900f912fbe898801a4c8356638dcf54
ffmpeg getFramesForward(193): md5 = 5221475c9ea8970258feb9dab1392049
ffmpeg getFramesForward(194): md5 = 5221475c9ea8970258feb9dab1392049
ffmpeg getFramesForward(195): md5 = 5221475c9ea8970258feb9dab1392049
ffmpeg getFramesForward(196): md5 = 6851e0793856841f31acc6a5f704650c
ffmpeg getFramesForward(197): md5 = 6851e0793856841f31acc6a5f704650c
ffmpeg getFramesForward(198): md5 = 6851e0793856841f31acc6a5f704650c
ffmpeg getFramesForward(199): md5 = 35335bb3cbc1cb75aff8416a26df8f39
ffmpeg getFramesForward(200): md5 = 35335bb3cbc1cb75aff8416a26df8f39
ffmpeg getFramesForward(201): md5 = 35335bb3cbc1cb75aff8416a26df8f39
ffmpeg getFramesForward(202): md5 = c9584d3d2c2480fb480953e9bc317cb0
ffmpeg getFramesForward(203): md5 = c9584d3d2c2480fb480953e9bc317cb0
ffmpeg getFramesForward(204): md5 = c9584d3d2c2480fb480953e9bc317cb0
ffmpeg getFramesForward(205): md5 = 3081db2af3ff5bc76f938f9b80ec72bb
ffmpeg getFramesForward(206): md5 = 3081db2af3ff5bc76f938f9b80ec72bb
ffmpeg getFramesForward(207): md5 = 3081db2af3ff5bc76f938f9b80ec72bb
ffmpeg getFramesForward(208): md5 = 10230400f9cdb8a4785082ed133f4c40
ffmpeg getFramesForward(209): md5 = 10230400f9cdb8a4785082ed133f4c40
ffmpeg getFramesForward(210): md5 = 10230400f9cdb8a4785082ed133f4c40
ffmpeg getFramesForward(211): md5 = ccc8aa4b659a072ef3e94005e982e197
ffmpeg getFramesForward(212): md5 = ccc8aa4b659a072ef3e94005e982e197
ffmpeg getFramesForward(213): md5 = ccc8aa4b659a072ef3e94005e982e197
ffmpeg getFramesForward(214): md5 = 916130d3a9a0b5291dd80c3f905f3cfe
ffmpeg getFramesForward(215): md5 = 916130d3a9a0b5291dd80c3f905f3cfe
ffmpeg getFramesForward(216): md5 = 916130d3a9a0b5291dd80c3f905f3cfe
ffmpeg getFramesForward(217): md5 = c9b92c3b3043cadf83b634aaa9967af2
ffmpeg getFramesForward(218): md5 = c9b92c3b3043cadf83b634aaa9967af2
ffmpeg getFramesForward(219): md5 = c9b92c3b3043cadf83b634aaa9967af2
ffmpeg getFramesForward(220): md5 = d60ad82118cc3d82d61380e8c1c35821
ffmpeg getFramesForward(221): md5 = d60ad82118cc3d82d61380e8c1c35821
ffmpeg getFramesForward(222): md5 = d60ad82118cc3d82d61380e8c1c35821
ffmpeg getFramesForward(223): md5 = bb894534f0fbb93ae13effea4ae7778c
ffmpeg getFramesForward(224): md5 = bb894534f0fbb93ae13effea4ae7778c
ffmpeg getFramesForward(225): md5 = bb894534f0fbb93ae13effea4ae7778c
ffmpeg getFramesForward(226): md5 = 03fe855c91fbaabe9e260a23ca4fa6cd
ffmpeg getFramesForward(227): md5 = 03fe855c91fbaabe9e260a23ca4fa6cd
ffmpeg getFramesForward(228): md5 = 03fe855c91fbaabe9e260a23ca4fa6cd
ffmpeg getFramesForward(229): md5 = 92b0f153f17e6a387535ba873c245ef2
ffmpeg getFramesForward(230): md5 = 92b0f153f17e6a387535ba873c245ef2
ffmpeg getFramesForward(231): md5 = 92b0f153f17e6a387535ba873c245ef2
ffmpeg getFramesForward(232): md5 = f513c73faf87cbfe1fff854d97f8f492
ffmpeg getFramesForward(233): md5 = f513c73faf87cbfe1fff854d97f8f492
ffmpeg getFramesForward(234): md5 = f513c73faf87cbfe1fff854d97f8f492
ffmpeg getFramesForward(235): md5 = 972e660b84a02fb883809c93f1ffdbf8
ffmpeg getFramesForward(236): md5 = 972e660b84a02fb883809c93f1ffdbf8
ffmpeg getFramesForward(237): md5 = 972e660b84a02fb883809c93f1ffdbf8
ffmpeg getFramesForward(238): md5 = 7e80bfd9c95b8f46e4ffcc1acacd478d
ffmpeg getFramesForward(239): md5 = 7e80bfd9c95b8f46e4ffcc1acacd478d
ffmpeg getFramesForward(240): md5 = 7e80bfd9c95b8f46e4ffcc1acacd478d
