/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2011 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IFIELDVIEWSUBJECT_H
#define IFIELDVIEWSUBJECT_H


#include "isolidviewsubject.h"


class iMergeDataFilter;


class iFieldViewSubject : public iSolidViewSubject
{
	
public:
	
	vtkTypeMacro(iFieldViewSubject,iSolidViewSubject);
	static const iObjectType& Type();

	virtual const iObjectType& RealType();
		
	virtual void SetColorBy(int q);
	inline int GetColorBy() const { return mColorBy; }
	
	virtual void SetGlyphSize(const iDistance &q);
	inline const iDistance& GetGlyphSize() const { return mGlyphSize; }
	
	virtual void SetGlyphSampleRate(int q);
	inline int GetGlyphSampleRate() const { return mGlyphSampleRate; }
	
	virtual int GetDataOffset() const = 0;

	const iDataType& GetScalarDataType() const { return mScalarDataType; }

protected:
	
	iFieldViewSubject(iViewModule *vm, const iDataType &type, const iDataType &scalarType, const iString &name, int numActors, unsigned int flags);
	virtual ~iFieldViewSubject();

	virtual void UpdateGlyphSize() = 0;
	virtual void UpdateGlyphSampleRate() = 0;
	virtual void ResetPipelineInput(vtkDataSet *input) = 0;

	virtual void UpdateColorByExtra(){}

	virtual void FieldViewSubjectPackStateBody(iString &s) const = 0;
	virtual void FieldViewSubjectUnPackStateBody(const iString &s) = 0;
	virtual void FieldViewSubjectSyncWithData(const iDataSyncRequest &r) = 0;

	virtual void SolidViewSubjectPackStateBody(iString &s) const;
	virtual void SolidViewSubjectUnPackStateBody(const iString &s);
	virtual void ViewSubjectSyncWithData(const iDataSyncRequest &r);
	virtual void ShowColorBarsBody(bool);

	virtual bool IsConnectedToScalars() const;
	virtual bool IsColoredByScalars() const;

	iDistance mGlyphSize;
	int mColorBy, mColorByOffset, mGlyphSampleRate;

	const iDataType &mScalarDataType;
	iMergeDataFilter *mMergeDataFilter;

private:

	static const iObjectKey& KeyColorBy();
	static const iObjectKey& KeyGlyphSize(bool opengl = false);
	static const iObjectKey& KeyGlyphSampleRate();
	static const iObjectKey& KeyConnectedToScalars();
	static const iObjectKey& KeyDataOffset();
};

//
//  Re-define SolidViewSubject macros
//
#define IFIELDVIEWSUBJECT_DECLARE_INHERITED_KEYS \
	ISOLIDVIEWSUBJECT_DECLARE_INHERITED_KEYS; \
	static const iObjectKey& KeyColorBy(); \
	static const iObjectKey& KeyGlyphSize(bool opengl = false); \
	static const iObjectKey& KeyGlyphSampleRate(); \
	static const iObjectKey& KeyConnectedToScalars(); \
	static const iObjectKey& KeyDataOffset()


#define IFIELDVIEWSUBJECT_DECLARE_INHERITED_MEMBERS \
	virtual int GetDataOffset() const; \
	virtual bool CanBeShown() const; \
	protected: \
	virtual void ResetPipelineInput(vtkDataSet *input); \
	virtual void ResetPipeline(); \
	virtual void FieldViewSubjectPackStateBody(iString &s) const; \
	virtual void FieldViewSubjectUnPackStateBody(const iString &s); \
	virtual void FieldViewSubjectSyncWithData(const iDataSyncRequest &r); \
	virtual void UpdateGlyphSize(); \
	virtual void UpdateGlyphSampleRate(); \
	virtual void ShowBody(bool s); \
	public: \
	virtual const iObjectType& RealType()


#define IVIEWSUBJECT_DEFINE_INHERITED_KEYS_FIELD(_type_) \
	IOBJECT_DEFINE_INHERITED_KEY(iFieldViewSubject,_type_,ColorBy,cb,OffsetInt,1); \
	IOBJECT_DEFINE_INHERITED_KEY(iFieldViewSubject,_type_,GlyphSampleRate,gr,Int,1); \
	IOBJECT_DEFINE_INHERITED_KEY(iFieldViewSubject,_type_,ConnectedToScalars,cs,Bool,1); \
	IOBJECT_DEFINE_INHERITED_KEY(iFieldViewSubject,_type_,DataOffset,-off,OffsetInt,1); \
	IOBJECT_DEFINE_INHERITED_DISTANCE_KEY(iFieldViewSubject,_type_,GlyphSize,gs)

#endif // IFIELDVIEWSUBJECT_H

