/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2011 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef IGGWIDGETKEYLINEEDIT_H
#define IGGWIDGETKEYLINEEDIT_H

//
//  Non-abstract classes defined in this file
//
// iggWidgetKeyTextLineEdit;
// iggWidgetKeyFloatLineEdit;
// iggWidgetKeyPositionLineEdit;
// iggWidgetKeySizeLineEdit;
//
#include "iggwidgetkeyhandler.h"


#include "istring.h"

class ibgWidgetEntrySubject;


template<class T> 
class iggWidgetKeyLineEdit : public iggWidgetKeyHandler<T>
{

public:

	iggWidgetKeyLineEdit(bool numeric, bool readonly, const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index, const iObjectKey *indkey);

	virtual void SetRenderMode(int m);

	virtual void Enable(bool s);
	void SetText(const iString &text);

	virtual void QueryValue(T &val) const;

protected:

	virtual void UpdateValue(T val);

	virtual void OnString1Body(const iString &);
	virtual void OnVoid1Body();

	virtual void ConvertToString(T val, iString &s) const = 0;
	virtual bool ConvertFromString(const iString &s, T &val) const = 0;

	ibgWidgetEntrySubject *mSubject;
};


class iggWidgetKeyTextLineEdit : public iggWidgetKeyLineEdit<iString>
{

public:

	iggWidgetKeyTextLineEdit(bool readonly, const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);

protected:

	virtual void ConvertToString(iString val, iString &s) const;
	virtual bool ConvertFromString(const iString &s, iString &val) const;
};


class iggWidgetKeyFloatLineEdit : public iggWidgetKeyLineEdit<float>
{

public:

	iggWidgetKeyFloatLineEdit(const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);

protected:

	virtual void ConvertToString(float val, iString &s) const;
	virtual bool ConvertFromString(const iString &s, float &val) const;
};


class iggWidgetKeyGenericPositionLineEdit : public iggWidgetKeyLineEdit<double>
{

public:

	iggWidgetKeyGenericPositionLineEdit(bool issize, const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index, const iObjectKey *indkey);
	virtual ~iggWidgetKeyGenericPositionLineEdit();

protected:

	virtual void ConvertToString(double val, iString &s) const;
	virtual bool ConvertFromString(const iString &s, double &val) const;

	bool mIsSize;
};


class iggWidgetKeyPositionLineEdit : public iggWidgetKeyGenericPositionLineEdit
{

public:

	iggWidgetKeyPositionLineEdit(const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);
};


class iggWidgetKeySizeLineEdit : public iggWidgetKeyGenericPositionLineEdit
{

public:

	iggWidgetKeySizeLineEdit(const iString &label, const iObjectKey &key, int rm, iggFrame *parent, int index = -1, const iObjectKey *indkey = 0);
};

#endif  // IGGWIDGETKEYLINEEDIT_H

