\ testrandom.4th
\
\ Generate random samples to check the probability distribution 
\   of the random numbers generated by ran0 and gauss in noise.4th. 
\
\ K. Myneni, 7-30-2001
\
\ Requires:
\	matrix.4th
\	noise.4th
\

include matrix
include noise

8192 3 fmatrix samples

: go ( -- | generate the samples matrix)
	\ column 1 contains running index
	\ column 2 contains samples returned successively from ran0
	\ column 3 contains samples returned successively from gauss

	\ initialize IDUM

	time&date drop 30 * 24 * 3600 * swap 24 * 3600 * +
	swap 3600 * + swap 60 * + + 
	negate idum !

	8193 1 do
	  i s>f i 1 samples fmat! 
	  ran0 i 2 samples fmat!
	  gauss i 3 samples fmat!
	loop ;

." The word 'go' generates the floating point matrix 'samples'" cr
." Column 1 is a running index" cr
." Column 2 are samples from a uniform distribution over the interval (0,1)" cr
." Column 3 are samples from a gaussian distribution (normal distribution)" cr
."   with zero mean and unit variance." cr cr
." You may write the samples matrix to a file called"
."   samples.dat by typing:" cr cr
." >file samples.dat samples fmat. console" cr cr

go

  






