\
\ curvefit.4th
\
\ Nonlinear least-squares curve fitting routine from P.R. Bevington,
\   "Data Reduction and Error Analysis for the Physical Sciences",
\   translated to kForth by K. Myneni, 9-21-1998
\
\ Requires the following files:
\
\	matrix.4th
\
\ Usage:
\
\  First include the source file for the matrix words
\  (matrix.4th), then the source file containing the definition of
\  the fitting function,
\
\	functn
\
\  The stack diagram for functn is
\
\	fx a -- fy
\
\  where fx is the x value at which the function is to be
\  evaluated and 'a' is the address of the 1 column floating
\  point matrix containing the parameter values. The computed
\  value for y is returned on the stack.
\
\  Read in the data to two 1D fmatrices, one containing the x values,
\  the other containing the y values. 
\
\  Next, set the values of the fmatrix 'a' to the buest guess
\  initial parameters. Also initialize an fmatrix, deltaa, which
\  contains the initial increments for the corresponding parameters.
\  The fit convergence time will depend on the magnitude of the
\  parameter increments. A parameter can be held fixed for the
\  curve fit by setting its increment to zero.
\
\  Finally, execute curfit. 
\
\  Revised:
\
\	2003-12-17  fix problem with using zero parameter increment.  KM
\  

16 constant MAX_PARAMETERS
1024 constant MAX_POINTS

MAX_PARAMETERS MAX_PARAMETERS  fmatrix  alpha
MAX_PARAMETERS MAX_PARAMETERS  fmatrix  alph2
MAX_PARAMETERS 1  fmatrix  beta
MAX_PARAMETERS 1  fmatrix  bet2
MAX_PARAMETERS 1  fmatrix  deriv
MAX_PARAMETERS 1  fmatrix  sigmaa
MAX_POINTS 1      fmatrix  yfit			\ array of fit data

variable xa		\ holds the address of x array (npts x 1)
variable ya		\ holds address of y array (npts x 1)
variable aa		\ holds address of parameter array (nterms x 1)
variable adel		\  "       "    of increment array (nterms x 1)
variable npts
variable nterms
variable nfree
fvariable flamda 0.001e flamda f!
fvariable chisq1
fvariable chisqr

fvariable aj
fvariable delta

\ Evaluate reduced chi-square for fit to data

: fchisq ( -- chi-square)
	0e
	nfree @ 0>
	if

\ Accumulate chi-square
	  
	  npts @ 1+ 1 do
	    i 1 ya a@ fmat@
	    i 1 yfit fmat@
	    f- fdup f* f+
	  loop

	  nfree @ s>f f/		\ divide by nfree 	  
	then	  
;



\ non-analytical derivative routine

: fderiv ( n -- |evaluate derivative of function at x_n )
	1 xa a@ fmat@
	nterms @ 1+ 1 DO
	  i 1 aa a@ fmat@ aj f!
	  i 1 adel a@ fmat@ fdup 
	  F0= IF 
	    fdrop 0e i 1 deriv fmat!	\ set derivative to zero if parameter inc is zero
	  ELSE
	    delta f!
            aj f@ delta f@ f+ 
	    i 1 aa a@ fmat!
	    fdup aa a@ functn
	    aj f@ delta f@ f-
	    i 1 aa a@ fmat!
	    fover aa a@ functn
	    f- delta f@ f/ 2e f/
	    i 1 deriv fmat!
	    aj f@ i 1 aa a@ fmat!
	  THEN
	LOOP
	fdrop
;	  
	    

: curfit ( x y a deltaa --- chisqr )

	adel !  \ store address of increment array
	aa !	\ store address of parameter array
	ya !	\ store address of y array
	xa !	\ "          "  of x array

	aa a@ mat_size@ drop nterms !
	ya a@ mat_size@ drop npts !
	
	npts @ MAX_POINTS >
	if
	  ." Too may points for curfit"
	  exit
	then

	npts @ nterms @ - nfree !

\ Set up sizes of alpha, alph2, beta, b2, deriv,
\ sigmaa, and yfit matrices

	nterms @ dup alpha mat_size!
	nterms @ dup alph2 mat_size!
	nterms @ 1 beta mat_size!
	nterms @ 1 bet2 mat_size!
	nterms @ 1 deriv mat_size!
	nterms @ 1 sigmaa mat_size!
	npts @ 1 yfit mat_size!

\ Evaluate alpha and beta matrices

	nterms @ 1+ 1 do
	  0e i 1 beta fmat!
	  i 1+ 1 do
	    0e j i alpha fmat!
	  loop
	loop

	npts @ 1+ 1 do
	  i fderiv			\ call fderiv
	  nterms @ 1+ 1 do
	    i 1 beta fmat@ 		\ beta(i)
	    j 1 ya a@ fmat@		\ y(j)
	    j 1 xa a@ fmat@		\ x(j)
	    aa a@ functn		\ call functn with x(j) and aa
	    f-
	    i 1 deriv fmat@ f*
	    f+
	    i 1 beta fmat!
	    
	    i 1+ 1 do
	      j i alpha fmat@	\ alpha(j, i)
	      j 1 deriv fmat@
	      i 1 deriv fmat@
	      f* f+
	      j i alpha fmat!
	    loop
	  loop
	loop

	nterms @ 1+ 1 do
	  i 1+ 1 do
	    j i alpha fmat@
	    i j alpha fmat!
	  loop
	loop


\ Evaluate chi square at starting point

	npts @ 1+ 1 do
	  i 1 xa a@ fmat@
	  aa a@ functn
	  i 1 yfit fmat!
	loop

	fchisq	chisq1 f!		\ call fchisq

\ Invert modified curvature matrix to find new parameters

	begin
	  nterms @ 1+ 1 do
	    nterms @ 1+ 1 do
	      j i alpha fmat@
	      j dup alpha fmat@
	      i dup alpha fmat@
	      f* fdup f0= IF fdrop fdrop 0e ELSE fsqrt f/ THEN
	      j i alph2 fmat!
	    loop
	    flamda f@ 1e f+
	    i dup alph2 fmat!
	  loop

	  alph2 matinv			\ call matinv
	  fdrop

	  nterms @ 1+ 1 do
	    i 1 aa a@ fmat@
	    i 1 bet2 fmat!
	    nterms @ 1+ 1 do
	      j 1 bet2 fmat@ 
	      i 1 beta fmat@
	      j i alph2 fmat@
	      f*
	      j dup alpha fmat@
	      i dup alpha fmat@
	      f* fdup f0= IF fdrop fdrop 0e ELSE fsqrt f/ THEN f+
	      j 1 bet2 fmat!
	    loop
	  loop

\ ." executed loop" cr

\ If chi-square increased, increase flamda and try again

	  npts @ 1+ 1 do
	    i 1 xa a@ fmat@ bet2 functn
	    i 1 yfit fmat!
	  loop
	  fchisq chisqr f!	
	  chisq1 f@ chisqr f@ f<
	while
	  flamda f@ 10e f* flamda f!
	repeat

\ Evaluate parameters and uncertainties


	nterms @ 1+ 1 do
	  i 1 bet2 fmat@
	  i 1 aa a@ fmat!
	  i dup alph2 fmat@ i dup alpha fmat@ f/ fsqrt
	  i 1 sigmaa fmat!
	loop

	flamda f@ 10e f/ flamda f!

	chisqr f@			\ return chi-square on stack
;
