/***************************************************************************
                         dockpopup.cpp
                       -------------------
  begin                : Nov 10 2001
  copyright            : (C) 2001 by Dimi Shahbaz
  email                : dshahbaz@ucla.edu
 ***************************************************************************/

#include <qwidget.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qbitmap.h>
#include <qpainter.h>
#include <qbrush.h>
#include <qtooltip.h>
#include <qpalette.h>
#include <qcursor.h>
#include "dockpopup.h"

DockPopup::DockLabel::DockLabel( QWidget *parent, const char *name )
	: QLabel(parent, name) {
}

void DockPopup::DockLabel::drawContents( QPainter *p ){
	QLabel::drawContents(p);
}

DockPopup::DockPopup( QWidget *parent, const char *name)
		: QWidget(parent,name, Qt::WStyle_StaysOnTop | Qt::WStyle_Customize | Qt::WStyle_NoBorder 
			| Qt::WStyle_Tool | Qt::WX11BypassWM ),
			mFont(QToolTip::font())
{
	resize(0, 0);

	mTextPixmap = new QPixmap( size() );
	/* XXX: Disabling the mask, since it is currently not necessary.
	mMask = new QBitmap( size() );
	**/

	//A QLabel holds our text so it can render any richtext we need
	mLabel = new DockLabel(0, "mLabel");
	mLabel->setAutoResize(TRUE);
	mLabel->hide();
	
	//We want to use the colors of tooltips for consistant look
	mPalette = QToolTip::palette();
	mLabel->setPalette( mPalette );
	mLabel->setMargin( 1 );

	//These are defaults. The class using this class should set the mAnchor and
	//mAnchorPosition immediately
	mAnchor.setX(20);
	mAnchor.setY(20);
	mAnchorPosition = BottomRight;
}

DockPopup::~DockPopup(){
	//Since these are all parentless, we have to manually delete them.

	/* XXX: Disabling the mask, since it is currently not necessary.
	delete mMask;
	**/
	delete mTextPixmap;
	delete mLabel;
}

void DockPopup::paintEvent(QPaintEvent *e){
	QPainter p;
	QColor mBackground = mPalette.active().background();
	QColor mForeground = mPalette.active().foreground();

	if(mText.isEmpty() || mText.isNull())
		return QWidget::paintEvent(e);

	//Use a mLabel to draw our stuff so that RichText will appear correctly
	mLabel->setText( mText );
	mLabel->resize( mLabel->width(), mLabel->height() );
	//QRect s = mLabel->contentsRect();
	//mLabel->resize( s.width(), s.height() );

	QRect bound = QRect( 0, 0, mLabel->width(), mLabel->height() );

	//Resize this to bound (on both sides/top/bottom)
	resize( bound.width() + 2, bound.height() + 2 );

	//Move this to the correct position, based on mAnchor and mAnchorPosition
	switch( mAnchorPosition ){
		case BottomRight:
			move( mAnchor.x( ) - width( ), mAnchor.y( ) - height( ) );
			break;
		case BottomLeft:
			move( mAnchor.x( ), mAnchor.y( ) - height( ) );
			break;
		case TopLeft:
			move( mAnchor.x( ), mAnchor.y( ) );
			break;
		case TopRight:
			move( mAnchor.x( ) - width( ), mAnchor.y( ) );
			break;
		default:
			//Shouldn't get here! Assume BottomRight.
			move( mAnchor.x( ) - width( ), mAnchor.y( ) - height( ) );
			qDebug( "dockPopup: mAnchorPosition not set\n" );
			break;
	}

	//The pixmap that holds the text:
	mTextPixmap->resize( bound.size() );
	p.begin( mTextPixmap );
	p.setBrush( mBackground );
	p.setPen( mBackground );
	p.drawRect( 0, 0, bound.width(), bound.height() );
	mLabel->drawContents( &p );
	p.end();

	//The actual roundRect and the text
	p.begin( this );
	p.setBrush( mBackground );
	p.drawRect(0, 0, width(), height() );
	p.drawPixmap( 1, 1, *mTextPixmap );
	p.end();

	//The little anchor indicator
	if(drawAnchorPosition){
		p.begin( this );
		//p.setPen( Qt::red );
		p.setPen( mForeground );
		p.setBrush( mForeground );
		int radius = 4;
		QPoint hDelta( radius, 0 );
		QPoint vDelta( 0, radius );

		//The four corners, clockwise order
		QPoint A( 0, 0 );
		QPoint B( width() -2, 0 );
		QPoint C( width() -2, height()-2  );
		QPoint D( 0, height()-2 );
		switch( mAnchorPosition ){
			case TopLeft:
				p.drawPie( QRect( A - hDelta - vDelta, A + hDelta + vDelta ), 0, -4*360 );
				break;
			case TopRight:
				p.drawPie( QRect( B + hDelta - vDelta, B - hDelta + vDelta ), 12*360, -4*360 );
				break;
			case BottomRight:
				p.drawPie( QRect( C + hDelta + vDelta, C - hDelta - vDelta ), 8*360, -4*360 );
				break;
			case BottomLeft:
				p.drawPie( QRect( D - hDelta + vDelta, D + hDelta - vDelta ), 4*360, -4*360 );
				break;
		}
		p.end();
	}

	/* XXX: This is mainly for if the shape requires an alpha mask, e.g. a round
	 * rect or something.  Right now it's just a regular rect, so I'm commenting
	 * it out.
	 
	mMask->resize( size() );
	mMask->fill( Qt::color0 ); //transparent
	p.begin( mMask );
	p.setPen( Qt::color1 );
	p.setBrush( Qt::color1 );
	p.drawRect(0, 0, width(), height() );
	p.end();
	setMask( *mMask );
	**/

	QWidget::paintEvent(e);
}

void DockPopup::mousePressEvent( QMouseEvent *e )
{
	if ( e->button() == LeftButton ){
		setCursor( QCursor( SizeAllCursor ) );

		mClickPos = e->pos();
		//TODO: draw anchor position depending on click location
		int x = mClickPos.x();
		int y = mClickPos.y();
		int h = height();
		int w = width();
		if( x < w/2 )
			if( y < h/2 )
				mAnchorPosition = TopLeft;
			else // y > h/2
				mAnchorPosition = BottomLeft;
		else // x > w/2
			if( y < h/2 )
				mAnchorPosition = TopRight;
			else // y > h/2
				mAnchorPosition = BottomRight;
			
		drawAnchorPosition = TRUE;
		repaint();
	}
}

void DockPopup::mouseReleaseEvent( QMouseEvent *e )
{
	drawAnchorPosition = FALSE;
	repaint();
	setCursor( QCursor( ArrowCursor ) );
}

void DockPopup::mouseMoveEvent( QMouseEvent *e )
{
	int oldX, oldY, newX, newY;

	oldX = x();
	oldY = y();

	if ( e->state() & LeftButton )
		move( e->globalPos() - mClickPos );
	
	newX = x();
	newY = y();
	
	QPoint delta( newX - oldX, newY - oldY );
	mAnchor += delta;

	emit anchorMoved( );
}

/* mAnchor is the global pixel position (x,y) that the popup will appear at.
 * The mAnchorPosition is where on the popup that point should be.  For example,
 * if mAnchor is (50, 50) and mAnchorPosition is BottomLeft, then the bottom left
 * corner of the popup will be set to the point (50,50).
 */
void DockPopup::setAnchor( QPoint p, Position o){
	mAnchor = p;
	mAnchorPosition = o;
}

void DockPopup::setText(QString s){
	mText = s;
}

// dockpopup.cpp

