/***************************************************************************
			   info.h
				 -------------------
		begin		: Mon Jul 31 2000
		copyright	: (C) 2000 by Benjamin Meyer
		email		: benjamin@csh.rit.edu
***************************************************************************/


#ifndef INFO_H
#define INFO_H

#include <kdialog.h>
#include <kio/jobclasses.h>

class QPushButton;
class KinkattaTextBrowser;

/**
 * User information dialog.
 * Dialog that presents a user's information.  Downloads the user's
 * profile, parses the HTML, and displays in a dialog.
 * @author Benjamin Meyer
 */

class Info : public KDialog	{

Q_OBJECT

public:

  /// Constructor.
  Info(QWidget *parent=0, const char *name=0);

  /// Text browser instance
  KinkattaTextBrowser *Information;

  /// User to lookup
  QString user;

public slots:

  /// Get the user's information page from the internet.
  void addToWindow(QString data);
	
private slots:

  /// Process the downloaded user information.
  void copyJobResult(KIO::Job*);

  /// Close the window
  void closeWindow();

  /// Open this mail URL
  void mailToClicked(const QString &name, const QString &address);

protected: 
  
  /// Resize the window.
  void resizeEvent( QResizeEvent *e );

  /// Create the GUI.
  void initDialog();

  /// Called to close the window.
  void closeEvent(QCloseEvent *e);

  /// The close button
  QPushButton *Close;

};

#endif

// info.h

