/***************************************************************************
                             soundconfigureimp.h
                             -------------------
    begin                : Thursday April 13 2001
    copyright            : (C) 2001 Benjamin Meyer 
    email                : ben@meyerhome.net
 ***************************************************************************/

#ifndef SOUNDCONFIGUREIMP_H
#define SOUNDCONFIGUREIMP_H

#include <soundconfigure.h>
#include <newpounceimp.h>

/**
 * Sound configuration code.
 * This class handles the SoundConfigure dialog.
 * @author Benjamin Meyer
 */

class SoundConfigureImp : public SoundConfigure  {

Q_OBJECT
	
signals:

  /// Called when a pounce is added or updated.
  void updateOrAddPounce(pounce newPounce);

public:

///  Constructor. 
  SoundConfigureImp(QWidget *parent=0, const char *name=0);

  /**
   * Destructor.
   */
  ~SoundConfigureImp();

  /**
   * Pounce information.
   */
  pounce internal;

public slots:
  /**
   * Sets a new pounce.
   * @param newpounce the new pounce
   * Sets the current settings to a new pounce.
   */
  void setPounce(pounce *newpounce);

  /**
   * Sets the default settings.
   * @param newpounce the new pounce
   * Sets the default settings as called by the default button.
   */
  void setDefault(pounce *newpounce);

private slots:
  /**
   * Called when the default button is hit
   */
  void defaultButtonHit();

  /**
   * Called when the OK button is hit
   */ 
  void buttonOkHit();	

  /**
   * Called to browse init sound files (?)
   */
  void browseInit();

  /**
   * Called to browse logout sound files (?)
   */
  void browseLogOut();

  /**
   * Called to browse login sound files (?)
   */
  void browseLoginClicked();

private:
  /**
   * The signon sound
   */
  QString signOnSound;

  /**
   * The signoff sound
   */
  QString signOffSound;

  /**
   * The init sound
   */
  QString initSound;

};

#endif

// SoundConfigureImp.h

